/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;

public class EntityDamageSource
extends DamageSource {
    @Nullable
    protected Entity damageSourceEntity;
    private boolean isThornsDamage;

    public EntityDamageSource(String p_i1567_1_, Entity p_i1567_2_) {
        super(p_i1567_1_);
        this.damageSourceEntity = p_i1567_2_;
    }

    public EntityDamageSource setIsThornsDamage() {
        this.isThornsDamage = true;
        return this;
    }

    public boolean getIsThornsDamage() {
        return this.isThornsDamage;
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return this.damageSourceEntity;
    }

    @Override
    public ITextComponent getDeathMessage(EntityLivingBase p_getDeathMessage_1_) {
        ItemStack lvt_2_1_ = this.damageSourceEntity instanceof EntityLivingBase ? ((EntityLivingBase)this.damageSourceEntity).getHeldItemMainhand() : ItemStack.EMPTY;
        String lvt_3_1_ = "death.attack." + this.damageType;
        String lvt_4_1_ = lvt_3_1_ + ".item";
        if (!lvt_2_1_.isEmpty() && lvt_2_1_.hasDisplayName() && I18n.canTranslate(lvt_4_1_)) {
            return new TextComponentTranslation(lvt_4_1_, p_getDeathMessage_1_.getDisplayName(), this.damageSourceEntity.getDisplayName(), lvt_2_1_.getTextComponent());
        }
        return new TextComponentTranslation(lvt_3_1_, p_getDeathMessage_1_.getDisplayName(), this.damageSourceEntity.getDisplayName());
    }

    @Override
    public boolean isDifficultyScaled() {
        return this.damageSourceEntity != null && this.damageSourceEntity instanceof EntityLivingBase && !(this.damageSourceEntity instanceof EntityPlayer);
    }

    @Override
    @Nullable
    public Vec3d getDamageLocation() {
        return new Vec3d(this.damageSourceEntity.posX, this.damageSourceEntity.posY, this.damageSourceEntity.posZ);
    }
}

