/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Team;

public final class EntitySelectors {
    public static final Predicate<Entity> IS_ALIVE = new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return p_apply_1_.isEntityAlive();
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((Entity)p_apply_1_);
        }
    };
    public static final Predicate<Entity> IS_STANDALONE = new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return p_apply_1_.isEntityAlive() && !p_apply_1_.isBeingRidden() && !p_apply_1_.isRiding();
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((Entity)p_apply_1_);
        }
    };
    public static final Predicate<Entity> HAS_INVENTORY = new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return p_apply_1_ instanceof IInventory && p_apply_1_.isEntityAlive();
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((Entity)p_apply_1_);
        }
    };
    public static final Predicate<Entity> CAN_AI_TARGET = new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return !(p_apply_1_ instanceof EntityPlayer) || !((EntityPlayer)p_apply_1_).isSpectator() && !((EntityPlayer)p_apply_1_).isCreative();
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((Entity)p_apply_1_);
        }
    };
    public static final Predicate<Entity> NOT_SPECTATING = new Predicate<Entity>(){

        public boolean apply(Entity p_apply_1_) {
            return !(p_apply_1_ instanceof EntityPlayer) || !((EntityPlayer)p_apply_1_).isSpectator();
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((Entity)p_apply_1_);
        }
    };

    public static <T extends Entity> Predicate<T> withinRange(final double p_withinRange_0_, final double p_withinRange_2_, final double p_withinRange_4_, double p_withinRange_6_) {
        final double lvt_8_1_ = p_withinRange_6_ * p_withinRange_6_;
        return new Predicate<T>(){

            public boolean apply(T p_apply_1_) {
                return p_apply_1_ != null && ((Entity)p_apply_1_).getDistanceSq(p_withinRange_0_, p_withinRange_2_, p_withinRange_4_) <= lvt_8_1_;
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((T)((Entity)p_apply_1_));
            }
        };
    }

    public static <T extends Entity> Predicate<T> getTeamCollisionPredicate(final Entity p_getTeamCollisionPredicate_0_) {
        Team.CollisionRule lvt_2_1_;
        final Team lvt_1_1_ = p_getTeamCollisionPredicate_0_.getTeam();
        Team.CollisionRule collisionRule = lvt_2_1_ = lvt_1_1_ == null ? Team.CollisionRule.ALWAYS : lvt_1_1_.getCollisionRule();
        if (lvt_2_1_ == Team.CollisionRule.NEVER) {
            return Predicates.alwaysFalse();
        }
        return Predicates.and(NOT_SPECTATING, (Predicate)new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                boolean lvt_4_1_;
                Team.CollisionRule lvt_3_1_;
                if (!p_apply_1_.canBePushed()) {
                    return false;
                }
                if (!(!p_getTeamCollisionPredicate_0_.world.isRemote || p_apply_1_ instanceof EntityPlayer && ((EntityPlayer)p_apply_1_).isUser())) {
                    return false;
                }
                Team lvt_2_1_2 = p_apply_1_.getTeam();
                Team.CollisionRule collisionRule = lvt_3_1_ = lvt_2_1_2 == null ? Team.CollisionRule.ALWAYS : lvt_2_1_2.getCollisionRule();
                if (lvt_3_1_ == Team.CollisionRule.NEVER) {
                    return false;
                }
                boolean bl = lvt_4_1_ = lvt_1_1_ != null && lvt_1_1_.isSameTeam(lvt_2_1_2);
                if ((lvt_2_1_ == Team.CollisionRule.HIDE_FOR_OWN_TEAM || lvt_3_1_ == Team.CollisionRule.HIDE_FOR_OWN_TEAM) && lvt_4_1_) {
                    return false;
                }
                return lvt_2_1_ != Team.CollisionRule.HIDE_FOR_OTHER_TEAMS && lvt_3_1_ != Team.CollisionRule.HIDE_FOR_OTHER_TEAMS || lvt_4_1_;
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((Entity)p_apply_1_);
            }
        });
    }

    public static Predicate<Entity> notRiding(final Entity p_notRiding_0_) {
        return new Predicate<Entity>(){

            public boolean apply(Entity p_apply_1_) {
                while (p_apply_1_.isRiding()) {
                    if ((p_apply_1_ = p_apply_1_.getRidingEntity()) != p_notRiding_0_) continue;
                    return false;
                }
                return true;
            }

            public /* synthetic */ boolean apply(Object p_apply_1_) {
                return this.apply((Entity)p_apply_1_);
            }
        };
    }

    public static class ArmoredMob
    implements Predicate<Entity> {
        private final ItemStack armor;

        public ArmoredMob(ItemStack p_i1584_1_) {
            this.armor = p_i1584_1_;
        }

        public boolean apply(Entity p_apply_1_) {
            if (!p_apply_1_.isEntityAlive()) {
                return false;
            }
            if (!(p_apply_1_ instanceof EntityLivingBase)) {
                return false;
            }
            EntityLivingBase lvt_2_1_ = (EntityLivingBase)p_apply_1_;
            if (!lvt_2_1_.getItemStackFromSlot(EntityLiving.getSlotForItemStack(this.armor)).isEmpty()) {
                return false;
            }
            if (lvt_2_1_ instanceof EntityLiving) {
                return ((EntityLiving)lvt_2_1_).canPickUpLoot();
            }
            if (lvt_2_1_ instanceof EntityArmorStand) {
                return true;
            }
            return lvt_2_1_ instanceof EntityPlayer;
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((Entity)p_apply_1_);
        }
    }
}

