/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FoodStats {
    private int foodLevel = 20;
    private float foodSaturationLevel = 5.0f;
    private float foodExhaustionLevel;
    private int foodTimer;
    private int prevFoodLevel = 20;

    public void addStats(int p_addStats_1_, float p_addStats_2_) {
        this.foodLevel = Math.min(p_addStats_1_ + this.foodLevel, 20);
        this.foodSaturationLevel = Math.min(this.foodSaturationLevel + (float)p_addStats_1_ * p_addStats_2_ * 2.0f, (float)this.foodLevel);
    }

    public void addStats(ItemFood p_addStats_1_, ItemStack p_addStats_2_) {
        this.addStats(p_addStats_1_.getHealAmount(p_addStats_2_), p_addStats_1_.getSaturationModifier(p_addStats_2_));
    }

    public void onUpdate(EntityPlayer p_onUpdate_1_) {
        boolean lvt_3_1_;
        EnumDifficulty lvt_2_1_ = p_onUpdate_1_.world.getDifficulty();
        this.prevFoodLevel = this.foodLevel;
        if (this.foodExhaustionLevel > 4.0f) {
            this.foodExhaustionLevel -= 4.0f;
            if (this.foodSaturationLevel > 0.0f) {
                this.foodSaturationLevel = Math.max(this.foodSaturationLevel - 1.0f, 0.0f);
            } else if (lvt_2_1_ != EnumDifficulty.PEACEFUL) {
                this.foodLevel = Math.max(this.foodLevel - 1, 0);
            }
        }
        if ((lvt_3_1_ = p_onUpdate_1_.world.getGameRules().getBoolean("naturalRegeneration")) && this.foodSaturationLevel > 0.0f && p_onUpdate_1_.shouldHeal() && this.foodLevel >= 20) {
            ++this.foodTimer;
            if (this.foodTimer >= 10) {
                float lvt_4_1_ = Math.min(this.foodSaturationLevel, 6.0f);
                p_onUpdate_1_.heal(lvt_4_1_ / 6.0f);
                this.addExhaustion(lvt_4_1_);
                this.foodTimer = 0;
            }
        } else if (lvt_3_1_ && this.foodLevel >= 18 && p_onUpdate_1_.shouldHeal()) {
            ++this.foodTimer;
            if (this.foodTimer >= 80) {
                p_onUpdate_1_.heal(1.0f);
                this.addExhaustion(6.0f);
                this.foodTimer = 0;
            }
        } else if (this.foodLevel <= 0) {
            ++this.foodTimer;
            if (this.foodTimer >= 80) {
                if (p_onUpdate_1_.getHealth() > 10.0f || lvt_2_1_ == EnumDifficulty.HARD || p_onUpdate_1_.getHealth() > 1.0f && lvt_2_1_ == EnumDifficulty.NORMAL) {
                    p_onUpdate_1_.attackEntityFrom(DamageSource.STARVE, 1.0f);
                }
                this.foodTimer = 0;
            }
        } else {
            this.foodTimer = 0;
        }
    }

    public void readNBT(NBTTagCompound p_readNBT_1_) {
        if (p_readNBT_1_.hasKey("foodLevel", 99)) {
            this.foodLevel = p_readNBT_1_.getInteger("foodLevel");
            this.foodTimer = p_readNBT_1_.getInteger("foodTickTimer");
            this.foodSaturationLevel = p_readNBT_1_.getFloat("foodSaturationLevel");
            this.foodExhaustionLevel = p_readNBT_1_.getFloat("foodExhaustionLevel");
        }
    }

    public void writeNBT(NBTTagCompound p_writeNBT_1_) {
        p_writeNBT_1_.setInteger("foodLevel", this.foodLevel);
        p_writeNBT_1_.setInteger("foodTickTimer", this.foodTimer);
        p_writeNBT_1_.setFloat("foodSaturationLevel", this.foodSaturationLevel);
        p_writeNBT_1_.setFloat("foodExhaustionLevel", this.foodExhaustionLevel);
    }

    public int getFoodLevel() {
        return this.foodLevel;
    }

    public boolean needFood() {
        return this.foodLevel < 20;
    }

    public void addExhaustion(float p_addExhaustion_1_) {
        this.foodExhaustionLevel = Math.min(this.foodExhaustionLevel + p_addExhaustion_1_, 40.0f);
    }

    public float getSaturationLevel() {
        return this.foodSaturationLevel;
    }

    public void setFoodLevel(int p_setFoodLevel_1_) {
        this.foodLevel = p_setFoodLevel_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void setFoodSaturationLevel(float p_setFoodSaturationLevel_1_) {
        this.foodSaturationLevel = p_setFoodSaturationLevel_1_;
    }
}

