/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import javax.annotation.Nullable;

public class IntHashMap<V> {
    private transient Entry<V>[] slots = new Entry[16];
    private transient int count;
    private int threshold = 12;
    private final float growFactor;

    public IntHashMap() {
        this.growFactor = 0.75f;
    }

    private static int computeHash(int p_computeHash_0_) {
        p_computeHash_0_ ^= p_computeHash_0_ >>> 20 ^ p_computeHash_0_ >>> 12;
        return p_computeHash_0_ ^ p_computeHash_0_ >>> 7 ^ p_computeHash_0_ >>> 4;
    }

    private static int getSlotIndex(int p_getSlotIndex_0_, int p_getSlotIndex_1_) {
        return p_getSlotIndex_0_ & p_getSlotIndex_1_ - 1;
    }

    @Nullable
    public V lookup(int p_lookup_1_) {
        int lvt_2_1_ = IntHashMap.computeHash(p_lookup_1_);
        Entry<V> lvt_3_1_ = this.slots[IntHashMap.getSlotIndex(lvt_2_1_, this.slots.length)];
        while (lvt_3_1_ != null) {
            if (lvt_3_1_.hashEntry == p_lookup_1_) {
                return lvt_3_1_.valueEntry;
            }
            lvt_3_1_ = lvt_3_1_.nextEntry;
        }
        return null;
    }

    public boolean containsItem(int p_containsItem_1_) {
        return this.lookupEntry(p_containsItem_1_) != null;
    }

    @Nullable
    final Entry<V> lookupEntry(int p_lookupEntry_1_) {
        int lvt_2_1_ = IntHashMap.computeHash(p_lookupEntry_1_);
        Entry<V> lvt_3_1_ = this.slots[IntHashMap.getSlotIndex(lvt_2_1_, this.slots.length)];
        while (lvt_3_1_ != null) {
            if (lvt_3_1_.hashEntry == p_lookupEntry_1_) {
                return lvt_3_1_;
            }
            lvt_3_1_ = lvt_3_1_.nextEntry;
        }
        return null;
    }

    public void addKey(int p_addKey_1_, V p_addKey_2_) {
        int lvt_3_1_ = IntHashMap.computeHash(p_addKey_1_);
        int lvt_4_1_ = IntHashMap.getSlotIndex(lvt_3_1_, this.slots.length);
        Entry<V> lvt_5_1_ = this.slots[lvt_4_1_];
        while (lvt_5_1_ != null) {
            if (lvt_5_1_.hashEntry == p_addKey_1_) {
                lvt_5_1_.valueEntry = p_addKey_2_;
                return;
            }
            lvt_5_1_ = lvt_5_1_.nextEntry;
        }
        this.insert(lvt_3_1_, p_addKey_1_, p_addKey_2_, lvt_4_1_);
    }

    private void grow(int p_grow_1_) {
        Entry<V>[] lvt_2_1_ = this.slots;
        int lvt_3_1_ = lvt_2_1_.length;
        if (lvt_3_1_ == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] lvt_4_1_ = new Entry[p_grow_1_];
        this.copyTo(lvt_4_1_);
        this.slots = lvt_4_1_;
        this.threshold = (int)((float)p_grow_1_ * this.growFactor);
    }

    private void copyTo(Entry<V>[] p_copyTo_1_) {
        Entry<V>[] lvt_2_1_ = this.slots;
        int lvt_3_1_ = p_copyTo_1_.length;
        for (int lvt_4_1_ = 0; lvt_4_1_ < lvt_2_1_.length; ++lvt_4_1_) {
            Entry lvt_6_1_;
            Entry<V> lvt_5_1_ = lvt_2_1_[lvt_4_1_];
            if (lvt_5_1_ == null) continue;
            lvt_2_1_[lvt_4_1_] = null;
            do {
                lvt_6_1_ = lvt_5_1_.nextEntry;
                int lvt_7_1_ = IntHashMap.getSlotIndex(lvt_5_1_.slotHash, lvt_3_1_);
                lvt_5_1_.nextEntry = p_copyTo_1_[lvt_7_1_];
                p_copyTo_1_[lvt_7_1_] = lvt_5_1_;
            } while ((lvt_5_1_ = lvt_6_1_) != null);
        }
    }

    @Nullable
    public V removeObject(int p_removeObject_1_) {
        Entry<V> lvt_2_1_ = this.removeEntry(p_removeObject_1_);
        return lvt_2_1_ == null ? null : (V)lvt_2_1_.valueEntry;
    }

    @Nullable
    final Entry<V> removeEntry(int p_removeEntry_1_) {
        Entry<V> lvt_4_1_;
        int lvt_2_1_ = IntHashMap.computeHash(p_removeEntry_1_);
        int lvt_3_1_ = IntHashMap.getSlotIndex(lvt_2_1_, this.slots.length);
        Entry<V> lvt_5_1_ = lvt_4_1_ = this.slots[lvt_3_1_];
        while (lvt_5_1_ != null) {
            Entry lvt_6_1_ = lvt_5_1_.nextEntry;
            if (lvt_5_1_.hashEntry == p_removeEntry_1_) {
                --this.count;
                if (lvt_4_1_ == lvt_5_1_) {
                    this.slots[lvt_3_1_] = lvt_6_1_;
                } else {
                    lvt_4_1_.nextEntry = lvt_6_1_;
                }
                return lvt_5_1_;
            }
            lvt_4_1_ = lvt_5_1_;
            lvt_5_1_ = lvt_6_1_;
        }
        return lvt_5_1_;
    }

    public void clearMap() {
        Entry<V>[] lvt_1_1_ = this.slots;
        for (int lvt_2_1_ = 0; lvt_2_1_ < lvt_1_1_.length; ++lvt_2_1_) {
            lvt_1_1_[lvt_2_1_] = null;
        }
        this.count = 0;
    }

    private void insert(int p_insert_1_, int p_insert_2_, V p_insert_3_, int p_insert_4_) {
        Entry<V> lvt_5_1_ = this.slots[p_insert_4_];
        this.slots[p_insert_4_] = new Entry<V>(p_insert_1_, p_insert_2_, p_insert_3_, lvt_5_1_);
        if (this.count++ >= this.threshold) {
            this.grow(2 * this.slots.length);
        }
    }

    static class Entry<V> {
        final int hashEntry;
        V valueEntry;
        Entry<V> nextEntry;
        final int slotHash;

        Entry(int p_i1552_1_, int p_i1552_2_, V p_i1552_3_, Entry<V> p_i1552_4_) {
            this.valueEntry = p_i1552_3_;
            this.nextEntry = p_i1552_4_;
            this.hashEntry = p_i1552_2_;
            this.slotHash = p_i1552_1_;
        }

        public final int getHash() {
            return this.hashEntry;
        }

        public final V getValue() {
            return this.valueEntry;
        }

        public final boolean equals(Object p_equals_1_) {
            V lvt_4_1_;
            V lvt_3_1_;
            if (!(p_equals_1_ instanceof Entry)) {
                return false;
            }
            Entry lvt_2_1_ = (Entry)p_equals_1_;
            return this.hashEntry == lvt_2_1_.hashEntry && ((lvt_3_1_ = this.getValue()) == (lvt_4_1_ = lvt_2_1_.getValue()) || lvt_3_1_ != null && lvt_3_1_.equals(lvt_4_1_));
        }

        public final int hashCode() {
            return IntHashMap.computeHash(this.hashEntry);
        }

        public final String toString() {
            return this.getHash() + "=" + this.getValue();
        }
    }
}

