/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    public static boolean isString(JsonObject p_isString_0_, String p_isString_1_) {
        if (!JsonUtils.isJsonPrimitive(p_isString_0_, p_isString_1_)) {
            return false;
        }
        return p_isString_0_.getAsJsonPrimitive(p_isString_1_).isString();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isString(JsonElement p_isString_0_) {
        if (!p_isString_0_.isJsonPrimitive()) {
            return false;
        }
        return p_isString_0_.getAsJsonPrimitive().isString();
    }

    public static boolean isNumber(JsonElement p_isNumber_0_) {
        if (!p_isNumber_0_.isJsonPrimitive()) {
            return false;
        }
        return p_isNumber_0_.getAsJsonPrimitive().isNumber();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBoolean(JsonObject p_isBoolean_0_, String p_isBoolean_1_) {
        if (!JsonUtils.isJsonPrimitive(p_isBoolean_0_, p_isBoolean_1_)) {
            return false;
        }
        return p_isBoolean_0_.getAsJsonPrimitive(p_isBoolean_1_).isBoolean();
    }

    public static boolean isJsonArray(JsonObject p_isJsonArray_0_, String p_isJsonArray_1_) {
        if (!JsonUtils.hasField(p_isJsonArray_0_, p_isJsonArray_1_)) {
            return false;
        }
        return p_isJsonArray_0_.get(p_isJsonArray_1_).isJsonArray();
    }

    public static boolean isJsonPrimitive(JsonObject p_isJsonPrimitive_0_, String p_isJsonPrimitive_1_) {
        if (!JsonUtils.hasField(p_isJsonPrimitive_0_, p_isJsonPrimitive_1_)) {
            return false;
        }
        return p_isJsonPrimitive_0_.get(p_isJsonPrimitive_1_).isJsonPrimitive();
    }

    public static boolean hasField(JsonObject p_hasField_0_, String p_hasField_1_) {
        if (p_hasField_0_ == null) {
            return false;
        }
        return p_hasField_0_.get(p_hasField_1_) != null;
    }

    public static String getString(JsonElement p_getString_0_, String p_getString_1_) {
        if (p_getString_0_.isJsonPrimitive()) {
            return p_getString_0_.getAsString();
        }
        throw new JsonSyntaxException("Expected " + p_getString_1_ + " to be a string, was " + JsonUtils.toString(p_getString_0_));
    }

    public static String getString(JsonObject p_getString_0_, String p_getString_1_) {
        if (p_getString_0_.has(p_getString_1_)) {
            return JsonUtils.getString(p_getString_0_.get(p_getString_1_), p_getString_1_);
        }
        throw new JsonSyntaxException("Missing " + p_getString_1_ + ", expected to find a string");
    }

    @SideOnly(value=Side.CLIENT)
    public static String getString(JsonObject p_getString_0_, String p_getString_1_, String p_getString_2_) {
        if (p_getString_0_.has(p_getString_1_)) {
            return JsonUtils.getString(p_getString_0_.get(p_getString_1_), p_getString_1_);
        }
        return p_getString_2_;
    }

    public static Item getItem(JsonElement p_getItem_0_, String p_getItem_1_) {
        if (p_getItem_0_.isJsonPrimitive()) {
            String lvt_2_1_ = p_getItem_0_.getAsString();
            Item lvt_3_1_ = Item.getByNameOrId(lvt_2_1_);
            if (lvt_3_1_ == null) {
                throw new JsonSyntaxException("Expected " + p_getItem_1_ + " to be an item, was unknown string '" + lvt_2_1_ + "'");
            }
            return lvt_3_1_;
        }
        throw new JsonSyntaxException("Expected " + p_getItem_1_ + " to be an item, was " + JsonUtils.toString(p_getItem_0_));
    }

    public static Item getItem(JsonObject p_getItem_0_, String p_getItem_1_) {
        if (p_getItem_0_.has(p_getItem_1_)) {
            return JsonUtils.getItem(p_getItem_0_.get(p_getItem_1_), p_getItem_1_);
        }
        throw new JsonSyntaxException("Missing " + p_getItem_1_ + ", expected to find an item");
    }

    public static boolean getBoolean(JsonElement p_getBoolean_0_, String p_getBoolean_1_) {
        if (p_getBoolean_0_.isJsonPrimitive()) {
            return p_getBoolean_0_.getAsBoolean();
        }
        throw new JsonSyntaxException("Expected " + p_getBoolean_1_ + " to be a Boolean, was " + JsonUtils.toString(p_getBoolean_0_));
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean getBoolean(JsonObject p_getBoolean_0_, String p_getBoolean_1_) {
        if (p_getBoolean_0_.has(p_getBoolean_1_)) {
            return JsonUtils.getBoolean(p_getBoolean_0_.get(p_getBoolean_1_), p_getBoolean_1_);
        }
        throw new JsonSyntaxException("Missing " + p_getBoolean_1_ + ", expected to find a Boolean");
    }

    public static boolean getBoolean(JsonObject p_getBoolean_0_, String p_getBoolean_1_, boolean p_getBoolean_2_) {
        if (p_getBoolean_0_.has(p_getBoolean_1_)) {
            return JsonUtils.getBoolean(p_getBoolean_0_.get(p_getBoolean_1_), p_getBoolean_1_);
        }
        return p_getBoolean_2_;
    }

    public static float getFloat(JsonElement p_getFloat_0_, String p_getFloat_1_) {
        if (p_getFloat_0_.isJsonPrimitive() && p_getFloat_0_.getAsJsonPrimitive().isNumber()) {
            return p_getFloat_0_.getAsFloat();
        }
        throw new JsonSyntaxException("Expected " + p_getFloat_1_ + " to be a Float, was " + JsonUtils.toString(p_getFloat_0_));
    }

    public static float getFloat(JsonObject p_getFloat_0_, String p_getFloat_1_) {
        if (p_getFloat_0_.has(p_getFloat_1_)) {
            return JsonUtils.getFloat(p_getFloat_0_.get(p_getFloat_1_), p_getFloat_1_);
        }
        throw new JsonSyntaxException("Missing " + p_getFloat_1_ + ", expected to find a Float");
    }

    public static float getFloat(JsonObject p_getFloat_0_, String p_getFloat_1_, float p_getFloat_2_) {
        if (p_getFloat_0_.has(p_getFloat_1_)) {
            return JsonUtils.getFloat(p_getFloat_0_.get(p_getFloat_1_), p_getFloat_1_);
        }
        return p_getFloat_2_;
    }

    public static int getInt(JsonElement p_getInt_0_, String p_getInt_1_) {
        if (p_getInt_0_.isJsonPrimitive() && p_getInt_0_.getAsJsonPrimitive().isNumber()) {
            return p_getInt_0_.getAsInt();
        }
        throw new JsonSyntaxException("Expected " + p_getInt_1_ + " to be a Int, was " + JsonUtils.toString(p_getInt_0_));
    }

    public static int getInt(JsonObject p_getInt_0_, String p_getInt_1_) {
        if (p_getInt_0_.has(p_getInt_1_)) {
            return JsonUtils.getInt(p_getInt_0_.get(p_getInt_1_), p_getInt_1_);
        }
        throw new JsonSyntaxException("Missing " + p_getInt_1_ + ", expected to find a Int");
    }

    public static int getInt(JsonObject p_getInt_0_, String p_getInt_1_, int p_getInt_2_) {
        if (p_getInt_0_.has(p_getInt_1_)) {
            return JsonUtils.getInt(p_getInt_0_.get(p_getInt_1_), p_getInt_1_);
        }
        return p_getInt_2_;
    }

    public static JsonObject getJsonObject(JsonElement p_getJsonObject_0_, String p_getJsonObject_1_) {
        if (p_getJsonObject_0_.isJsonObject()) {
            return p_getJsonObject_0_.getAsJsonObject();
        }
        throw new JsonSyntaxException("Expected " + p_getJsonObject_1_ + " to be a JsonObject, was " + JsonUtils.toString(p_getJsonObject_0_));
    }

    public static JsonObject getJsonObject(JsonObject p_getJsonObject_0_, String p_getJsonObject_1_) {
        if (p_getJsonObject_0_.has(p_getJsonObject_1_)) {
            return JsonUtils.getJsonObject(p_getJsonObject_0_.get(p_getJsonObject_1_), p_getJsonObject_1_);
        }
        throw new JsonSyntaxException("Missing " + p_getJsonObject_1_ + ", expected to find a JsonObject");
    }

    @SideOnly(value=Side.CLIENT)
    public static JsonObject getJsonObject(JsonObject p_getJsonObject_0_, String p_getJsonObject_1_, JsonObject p_getJsonObject_2_) {
        if (p_getJsonObject_0_.has(p_getJsonObject_1_)) {
            return JsonUtils.getJsonObject(p_getJsonObject_0_.get(p_getJsonObject_1_), p_getJsonObject_1_);
        }
        return p_getJsonObject_2_;
    }

    public static JsonArray getJsonArray(JsonElement p_getJsonArray_0_, String p_getJsonArray_1_) {
        if (p_getJsonArray_0_.isJsonArray()) {
            return p_getJsonArray_0_.getAsJsonArray();
        }
        throw new JsonSyntaxException("Expected " + p_getJsonArray_1_ + " to be a JsonArray, was " + JsonUtils.toString(p_getJsonArray_0_));
    }

    public static JsonArray getJsonArray(JsonObject p_getJsonArray_0_, String p_getJsonArray_1_) {
        if (p_getJsonArray_0_.has(p_getJsonArray_1_)) {
            return JsonUtils.getJsonArray(p_getJsonArray_0_.get(p_getJsonArray_1_), p_getJsonArray_1_);
        }
        throw new JsonSyntaxException("Missing " + p_getJsonArray_1_ + ", expected to find a JsonArray");
    }

    @SideOnly(value=Side.CLIENT)
    public static JsonArray getJsonArray(JsonObject p_getJsonArray_0_, String p_getJsonArray_1_, JsonArray p_getJsonArray_2_) {
        if (p_getJsonArray_0_.has(p_getJsonArray_1_)) {
            return JsonUtils.getJsonArray(p_getJsonArray_0_.get(p_getJsonArray_1_), p_getJsonArray_1_);
        }
        return p_getJsonArray_2_;
    }

    public static <T> T deserializeClass(JsonElement p_deserializeClass_0_, String p_deserializeClass_1_, JsonDeserializationContext p_deserializeClass_2_, Class<? extends T> p_deserializeClass_3_) {
        if (p_deserializeClass_0_ != null) {
            return (T)p_deserializeClass_2_.deserialize(p_deserializeClass_0_, p_deserializeClass_3_);
        }
        throw new JsonSyntaxException("Missing " + p_deserializeClass_1_);
    }

    public static <T> T deserializeClass(JsonObject p_deserializeClass_0_, String p_deserializeClass_1_, JsonDeserializationContext p_deserializeClass_2_, Class<? extends T> p_deserializeClass_3_) {
        if (p_deserializeClass_0_.has(p_deserializeClass_1_)) {
            return JsonUtils.deserializeClass(p_deserializeClass_0_.get(p_deserializeClass_1_), p_deserializeClass_1_, p_deserializeClass_2_, p_deserializeClass_3_);
        }
        throw new JsonSyntaxException("Missing " + p_deserializeClass_1_);
    }

    public static <T> T deserializeClass(JsonObject p_deserializeClass_0_, String p_deserializeClass_1_, T p_deserializeClass_2_, JsonDeserializationContext p_deserializeClass_3_, Class<? extends T> p_deserializeClass_4_) {
        if (p_deserializeClass_0_.has(p_deserializeClass_1_)) {
            return JsonUtils.deserializeClass(p_deserializeClass_0_.get(p_deserializeClass_1_), p_deserializeClass_1_, p_deserializeClass_3_, p_deserializeClass_4_);
        }
        return p_deserializeClass_2_;
    }

    public static String toString(JsonElement p_toString_0_) {
        String lvt_1_1_ = StringUtils.abbreviateMiddle((String)String.valueOf(p_toString_0_), (String)"...", (int)10);
        if (p_toString_0_ == null) {
            return "null (missing)";
        }
        if (p_toString_0_.isJsonNull()) {
            return "null (json)";
        }
        if (p_toString_0_.isJsonArray()) {
            return "an array (" + lvt_1_1_ + ")";
        }
        if (p_toString_0_.isJsonObject()) {
            return "an object (" + lvt_1_1_ + ")";
        }
        if (p_toString_0_.isJsonPrimitive()) {
            JsonPrimitive lvt_2_1_ = p_toString_0_.getAsJsonPrimitive();
            if (lvt_2_1_.isNumber()) {
                return "a number (" + lvt_1_1_ + ")";
            }
            if (lvt_2_1_.isBoolean()) {
                return "a boolean (" + lvt_1_1_ + ")";
            }
        }
        return lvt_1_1_;
    }

    public static <T> T gsonDeserialize(Gson p_gsonDeserialize_0_, Reader p_gsonDeserialize_1_, Class<T> p_gsonDeserialize_2_, boolean p_gsonDeserialize_3_) {
        try {
            JsonReader lvt_4_1_ = new JsonReader(p_gsonDeserialize_1_);
            lvt_4_1_.setLenient(p_gsonDeserialize_3_);
            return (T)p_gsonDeserialize_0_.getAdapter(p_gsonDeserialize_2_).read(lvt_4_1_);
        }
        catch (IOException lvt_4_2_) {
            throw new JsonParseException((Throwable)lvt_4_2_);
        }
    }

    public static <T> T gsonDeserialize(Gson p_gsonDeserialize_0_, String p_gsonDeserialize_1_, Class<T> p_gsonDeserialize_2_) {
        return JsonUtils.gsonDeserialize(p_gsonDeserialize_0_, p_gsonDeserialize_1_, p_gsonDeserialize_2_, false);
    }

    public static <T> T gsonDeserialize(Gson p_gsonDeserialize_0_, String p_gsonDeserialize_1_, Class<T> p_gsonDeserialize_2_, boolean p_gsonDeserialize_3_) {
        return JsonUtils.gsonDeserialize(p_gsonDeserialize_0_, new StringReader(p_gsonDeserialize_1_), p_gsonDeserialize_2_, p_gsonDeserialize_3_);
    }
}

