/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;

public enum Mirror {
    NONE("no_mirror"),
    LEFT_RIGHT("mirror_left_right"),
    FRONT_BACK("mirror_front_back");

    private final String name;
    private static final String[] mirrorNames;

    private Mirror(String p_i47090_3_) {
        this.name = p_i47090_3_;
    }

    public int mirrorRotation(int p_mirrorRotation_1_, int p_mirrorRotation_2_) {
        int lvt_3_1_ = p_mirrorRotation_2_ / 2;
        int lvt_4_1_ = p_mirrorRotation_1_ > lvt_3_1_ ? p_mirrorRotation_1_ - p_mirrorRotation_2_ : p_mirrorRotation_1_;
        switch (this) {
            case FRONT_BACK: {
                return (p_mirrorRotation_2_ - lvt_4_1_) % p_mirrorRotation_2_;
            }
            case LEFT_RIGHT: {
                return (lvt_3_1_ - lvt_4_1_ + p_mirrorRotation_2_) % p_mirrorRotation_2_;
            }
        }
        return p_mirrorRotation_1_;
    }

    public Rotation toRotation(EnumFacing p_toRotation_1_) {
        EnumFacing.Axis lvt_2_1_ = p_toRotation_1_.getAxis();
        return this == LEFT_RIGHT && lvt_2_1_ == EnumFacing.Axis.Z || this == FRONT_BACK && lvt_2_1_ == EnumFacing.Axis.X ? Rotation.CLOCKWISE_180 : Rotation.NONE;
    }

    public EnumFacing mirror(EnumFacing p_mirror_1_) {
        switch (this) {
            case FRONT_BACK: {
                if (p_mirror_1_ == EnumFacing.WEST) {
                    return EnumFacing.EAST;
                }
                if (p_mirror_1_ == EnumFacing.EAST) {
                    return EnumFacing.WEST;
                }
                return p_mirror_1_;
            }
            case LEFT_RIGHT: {
                if (p_mirror_1_ == EnumFacing.NORTH) {
                    return EnumFacing.SOUTH;
                }
                if (p_mirror_1_ == EnumFacing.SOUTH) {
                    return EnumFacing.NORTH;
                }
                return p_mirror_1_;
            }
        }
        return p_mirror_1_;
    }

    static {
        mirrorNames = new String[Mirror.values().length];
        int lvt_0_1_ = 0;
        for (Mirror lvt_4_1_ : Mirror.values()) {
            Mirror.mirrorNames[lvt_0_1_++] = lvt_4_1_.name;
        }
    }
}

