/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class NonNullList<E>
extends AbstractList<E> {
    private final List<E> delegate;
    private final E defaultElement;

    public static <E> NonNullList<E> create() {
        return new NonNullList<E>();
    }

    public static <E> NonNullList<E> withSize(int p_withSize_0_, E p_withSize_1_) {
        Validate.notNull(p_withSize_1_);
        Object[] lvt_2_1_ = new Object[p_withSize_0_];
        Arrays.fill(lvt_2_1_, p_withSize_1_);
        return new NonNullList<Object>(Arrays.asList(lvt_2_1_), p_withSize_1_);
    }

    protected NonNullList() {
        this(new ArrayList(), null);
    }

    protected NonNullList(List<E> p_i47327_1_, E p_i47327_2_) {
        this.delegate = p_i47327_1_;
        this.defaultElement = p_i47327_2_;
    }

    @Override
    @Nonnull
    public E get(int p_get_1_) {
        return this.delegate.get(p_get_1_);
    }

    @Override
    public E set(int p_set_1_, E p_set_2_) {
        Validate.notNull(p_set_2_);
        return this.delegate.set(p_set_1_, p_set_2_);
    }

    @Override
    public void add(int p_add_1_, E p_add_2_) {
        Validate.notNull(p_add_2_);
        this.delegate.add(p_add_1_, p_add_2_);
    }

    @Override
    public E remove(int p_remove_1_) {
        return this.delegate.remove(p_remove_1_);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void clear() {
        if (this.defaultElement == null) {
            super.clear();
        } else {
            for (int lvt_1_1_ = 0; lvt_1_1_ < this.size(); ++lvt_1_1_) {
                this.set(lvt_1_1_, this.defaultElement);
            }
        }
    }
}

