/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.IObjectIntIterable;

public class ObjectIntIdentityMap<T>
implements IObjectIntIterable<T> {
    protected final IdentityHashMap<T, Integer> identityMap;
    protected final List<T> objectList;

    public ObjectIntIdentityMap() {
        this(512);
    }

    public ObjectIntIdentityMap(int p_i46984_1_) {
        this.objectList = Lists.newArrayListWithExpectedSize((int)p_i46984_1_);
        this.identityMap = new IdentityHashMap(p_i46984_1_);
    }

    public void put(T p_put_1_, int p_put_2_) {
        this.identityMap.put(p_put_1_, p_put_2_);
        while (this.objectList.size() <= p_put_2_) {
            this.objectList.add(null);
        }
        this.objectList.set(p_put_2_, p_put_1_);
    }

    public int get(T p_get_1_) {
        Integer lvt_2_1_ = this.identityMap.get(p_get_1_);
        return lvt_2_1_ == null ? -1 : lvt_2_1_;
    }

    @Nullable
    public final T getByValue(int p_getByValue_1_) {
        if (p_getByValue_1_ >= 0 && p_getByValue_1_ < this.objectList.size()) {
            return this.objectList.get(p_getByValue_1_);
        }
        return null;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.filter(this.objectList.iterator(), (Predicate)Predicates.notNull());
    }

    public int size() {
        return this.identityMap.size();
    }
}

