/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.EnumFacing;

public enum Rotation {
    NONE("rotate_0"),
    CLOCKWISE_90("rotate_90"),
    CLOCKWISE_180("rotate_180"),
    COUNTERCLOCKWISE_90("rotate_270");

    private final String name;
    private static final String[] rotationNames;

    private Rotation(String p_i46680_3_) {
        this.name = p_i46680_3_;
    }

    public Rotation add(Rotation p_add_1_) {
        switch (p_add_1_) {
            case CLOCKWISE_180: {
                switch (this) {
                    case NONE: {
                        return CLOCKWISE_180;
                    }
                    case CLOCKWISE_90: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case CLOCKWISE_180: {
                        return NONE;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return CLOCKWISE_90;
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (this) {
                    case NONE: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case CLOCKWISE_90: {
                        return NONE;
                    }
                    case CLOCKWISE_180: {
                        return CLOCKWISE_90;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return CLOCKWISE_180;
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (this) {
                    case NONE: {
                        return CLOCKWISE_90;
                    }
                    case CLOCKWISE_90: {
                        return CLOCKWISE_180;
                    }
                    case CLOCKWISE_180: {
                        return COUNTERCLOCKWISE_90;
                    }
                    case COUNTERCLOCKWISE_90: {
                        return NONE;
                    }
                }
            }
        }
        return this;
    }

    public EnumFacing rotate(EnumFacing p_rotate_1_) {
        if (p_rotate_1_.getAxis() == EnumFacing.Axis.Y) {
            return p_rotate_1_;
        }
        switch (this) {
            case CLOCKWISE_180: {
                return p_rotate_1_.getOpposite();
            }
            case COUNTERCLOCKWISE_90: {
                return p_rotate_1_.rotateYCCW();
            }
            case CLOCKWISE_90: {
                return p_rotate_1_.rotateY();
            }
        }
        return p_rotate_1_;
    }

    public int rotate(int p_rotate_1_, int p_rotate_2_) {
        switch (this) {
            case CLOCKWISE_180: {
                return (p_rotate_1_ + p_rotate_2_ / 2) % p_rotate_2_;
            }
            case COUNTERCLOCKWISE_90: {
                return (p_rotate_1_ + p_rotate_2_ * 3 / 4) % p_rotate_2_;
            }
            case CLOCKWISE_90: {
                return (p_rotate_1_ + p_rotate_2_ / 4) % p_rotate_2_;
            }
        }
        return p_rotate_1_;
    }

    static {
        rotationNames = new String[Rotation.values().length];
        int lvt_0_1_ = 0;
        for (Rotation lvt_4_1_ : Rotation.values()) {
            Rotation.rotationNames[lvt_0_1_++] = lvt_4_1_.name;
        }
    }
}

