/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.IntBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;

@SideOnly(value=Side.CLIENT)
public class ScreenShotHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static IntBuffer pixelBuffer;
    private static int[] pixelValues;

    public static ITextComponent saveScreenshot(File p_saveScreenshot_0_, int p_saveScreenshot_1_, int p_saveScreenshot_2_, Framebuffer p_saveScreenshot_3_) {
        return ScreenShotHelper.saveScreenshot(p_saveScreenshot_0_, null, p_saveScreenshot_1_, p_saveScreenshot_2_, p_saveScreenshot_3_);
    }

    public static ITextComponent saveScreenshot(File p_saveScreenshot_0_, String p_saveScreenshot_1_, int p_saveScreenshot_2_, int p_saveScreenshot_3_, Framebuffer p_saveScreenshot_4_) {
        try {
            File file1 = new File(p_saveScreenshot_0_, "screenshots");
            file1.mkdir();
            BufferedImage bufferedimage = ScreenShotHelper.createScreenshot(p_saveScreenshot_2_, p_saveScreenshot_3_, p_saveScreenshot_4_);
            File file2 = p_saveScreenshot_1_ == null ? ScreenShotHelper.getTimestampedPNGFileForDirectory(file1) : new File(file1, p_saveScreenshot_1_);
            file2 = file2.getCanonicalFile();
            ScreenshotEvent event = ForgeHooksClient.onScreenshot(bufferedimage, file2);
            if (event.isCanceled()) {
                return event.getCancelMessage();
            }
            file2 = event.getScreenshotFile();
            ImageIO.write((RenderedImage)bufferedimage, "png", file2);
            TextComponentString itextcomponent = new TextComponentString(file2.getName());
            itextcomponent.getStyle().setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file2.getAbsolutePath()));
            itextcomponent.getStyle().setUnderlined(true);
            if (event.getResultMessage() != null) {
                return event.getResultMessage();
            }
            return new TextComponentTranslation("screenshot.success", itextcomponent);
        }
        catch (Exception exception) {
            LOGGER.warn("Couldn't save screenshot", (Throwable)exception);
            return new TextComponentTranslation("screenshot.failure", exception.getMessage());
        }
    }

    public static BufferedImage createScreenshot(int p_createScreenshot_0_, int p_createScreenshot_1_, Framebuffer p_createScreenshot_2_) {
        if (OpenGlHelper.isFramebufferEnabled()) {
            p_createScreenshot_0_ = p_createScreenshot_2_.framebufferTextureWidth;
            p_createScreenshot_1_ = p_createScreenshot_2_.framebufferTextureHeight;
        }
        int i = p_createScreenshot_0_ * p_createScreenshot_1_;
        if (pixelBuffer == null || pixelBuffer.capacity() < i) {
            pixelBuffer = BufferUtils.createIntBuffer((int)i);
            pixelValues = new int[i];
        }
        GlStateManager.glPixelStorei(3333, 1);
        GlStateManager.glPixelStorei(3317, 1);
        pixelBuffer.clear();
        if (OpenGlHelper.isFramebufferEnabled()) {
            GlStateManager.bindTexture(p_createScreenshot_2_.framebufferTexture);
            GlStateManager.glGetTexImage(3553, 0, 32993, 33639, pixelBuffer);
        } else {
            GlStateManager.glReadPixels(0, 0, p_createScreenshot_0_, p_createScreenshot_1_, 32993, 33639, pixelBuffer);
        }
        pixelBuffer.get(pixelValues);
        TextureUtil.processPixelValues(pixelValues, p_createScreenshot_0_, p_createScreenshot_1_);
        BufferedImage bufferedimage = new BufferedImage(p_createScreenshot_0_, p_createScreenshot_1_, 1);
        bufferedimage.setRGB(0, 0, p_createScreenshot_0_, p_createScreenshot_1_, pixelValues, 0, p_createScreenshot_0_);
        return bufferedimage;
    }

    private static File getTimestampedPNGFileForDirectory(File p_getTimestampedPNGFileForDirectory_0_) {
        String s = DATE_FORMAT.format(new Date()).toString();
        int i = 1;
        File file1;
        while ((file1 = new File(p_getTimestampedPNGFileForDirectory_0_, s + (i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file1;
    }
}

