/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.CLIENT)
public class Session {
    private final String username;
    private final String playerID;
    private final String token;
    private final Type sessionType;
    private PropertyMap properties;

    public Session(String p_i1098_1_, String p_i1098_2_, String p_i1098_3_, String p_i1098_4_) {
        if (p_i1098_1_ == null || p_i1098_1_.isEmpty()) {
            p_i1098_1_ = "MissingName";
            p_i1098_3_ = "NotValid";
            p_i1098_2_ = "NotValid";
            Logger logger = FMLLog.getLogger();
            logger.log(Level.WARN, "=========================================================");
            logger.log(Level.WARN, "WARNING!! the username was not set for this session, typically");
            logger.log(Level.WARN, "this means you installed Forge incorrectly. We have set your");
            logger.log(Level.WARN, "name to \"MissingName\" and your session to nothing. Please");
            logger.log(Level.WARN, "check your installation and post a console log from the launcher");
            logger.log(Level.WARN, "when asking for help!");
            logger.log(Level.WARN, "=========================================================");
        }
        this.username = p_i1098_1_;
        this.playerID = p_i1098_2_;
        this.token = p_i1098_3_;
        this.sessionType = Type.setSessionType(p_i1098_4_);
    }

    public String getSessionID() {
        return "token:" + this.token + ":" + this.playerID;
    }

    public String getPlayerID() {
        return this.playerID;
    }

    public String getUsername() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    public GameProfile getProfile() {
        try {
            UUID uuid = UUIDTypeAdapter.fromString((String)this.getPlayerID());
            GameProfile ret = new GameProfile(uuid, this.getUsername());
            if (this.properties != null) {
                ret.getProperties().putAll((Multimap)this.properties);
            }
            return ret;
        }
        catch (IllegalArgumentException var2) {
            return new GameProfile(EntityPlayer.getUUID(new GameProfile((UUID)null, this.getUsername())), this.getUsername());
        }
    }

    public void setProperties(PropertyMap p_setProperties_1_) {
        if (this.properties == null) {
            this.properties = p_setProperties_1_;
        }
    }

    public boolean hasCachedProperties() {
        return this.properties != null;
    }

    @SideOnly(value=Side.CLIENT)
    public static enum Type {
        LEGACY("legacy"),
        MOJANG("mojang");

        private static final Map<String, Type> SESSION_TYPES;
        private final String sessionType;

        private Type(String p_i1096_3_) {
            this.sessionType = p_i1096_3_;
        }

        @Nullable
        public static Type setSessionType(String p_setSessionType_0_) {
            return SESSION_TYPES.get(p_setSessionType_0_.toLowerCase(Locale.ROOT));
        }

        static {
            SESSION_TYPES = Maps.newHashMap();
            for (Type session$type : Type.values()) {
                SESSION_TYPES.put(session$type.sessionType, session$type);
            }
        }
    }
}

