/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public enum SoundCategory {
    MASTER("master"),
    MUSIC("music"),
    RECORDS("record"),
    WEATHER("weather"),
    BLOCKS("block"),
    HOSTILE("hostile"),
    NEUTRAL("neutral"),
    PLAYERS("player"),
    AMBIENT("ambient"),
    VOICE("voice");

    private static final Map<String, SoundCategory> SOUND_CATEGORIES;
    private final String name;

    private SoundCategory(String p_i46833_3_) {
        this.name = p_i46833_3_;
    }

    public String getName() {
        return this.name;
    }

    public static SoundCategory getByName(String p_getByName_0_) {
        return SOUND_CATEGORIES.get(p_getByName_0_);
    }

    public static Set<String> getSoundCategoryNames() {
        return SOUND_CATEGORIES.keySet();
    }

    static {
        SOUND_CATEGORIES = Maps.newHashMap();
        for (SoundCategory lvt_3_1_ : SoundCategory.values()) {
            if (SOUND_CATEGORIES.containsKey(lvt_3_1_.getName())) {
                throw new Error("Clash in Sound Category name pools! Cannot insert " + (Object)((Object)lvt_3_1_));
            }
            SOUND_CATEGORIES.put(lvt_3_1_.getName(), lvt_3_1_);
        }
    }
}

