/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Timer {
    public float ticksPerSecond;
    public double lastHRTime;
    public int elapsedTicks;
    public float renderPartialTicks;
    public float timerSpeed = 1.0f;
    public float elapsedPartialTicks;
    public long lastSyncSysClock;
    public long lastSyncHRClock;
    public long counter;
    public double timeSyncAdjustment = 1.0;

    public Timer(float p_i1018_1_) {
        this.ticksPerSecond = p_i1018_1_;
        this.lastSyncSysClock = Minecraft.getSystemTime();
        this.lastSyncHRClock = System.nanoTime() / 1000000L;
    }

    public void updateTimer() {
        long lvt_1_1_ = Minecraft.getSystemTime();
        long lvt_3_1_ = lvt_1_1_ - this.lastSyncSysClock;
        long lvt_5_1_ = System.nanoTime() / 1000000L;
        double lvt_7_1_ = (double)lvt_5_1_ / 1000.0;
        if (lvt_3_1_ > 1000L || lvt_3_1_ < 0L) {
            this.lastHRTime = lvt_7_1_;
        } else {
            this.counter += lvt_3_1_;
            if (this.counter > 1000L) {
                long lvt_9_1_ = lvt_5_1_ - this.lastSyncHRClock;
                double lvt_11_1_ = (double)this.counter / (double)lvt_9_1_;
                this.timeSyncAdjustment += (lvt_11_1_ - this.timeSyncAdjustment) * (double)0.2f;
                this.lastSyncHRClock = lvt_5_1_;
                this.counter = 0L;
            }
            if (this.counter < 0L) {
                this.lastSyncHRClock = lvt_5_1_;
            }
        }
        this.lastSyncSysClock = lvt_1_1_;
        double lvt_9_2_ = (lvt_7_1_ - this.lastHRTime) * this.timeSyncAdjustment;
        this.lastHRTime = lvt_7_1_;
        lvt_9_2_ = MathHelper.clamp(lvt_9_2_, 0.0, 1.0);
        this.elapsedPartialTicks = (float)((double)this.elapsedPartialTicks + lvt_9_2_ * (double)this.timerSpeed * (double)this.ticksPerSecond);
        this.elapsedTicks = (int)this.elapsedPartialTicks;
        this.elapsedPartialTicks -= (float)this.elapsedTicks;
        if (this.elapsedTicks > 10) {
            this.elapsedTicks = 10;
        }
        this.renderPartialTicks = this.elapsedPartialTicks;
    }
}

