/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataFixer
implements IDataFixer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<IFixType, List<IDataWalker>> walkerMap = Maps.newHashMap();
    private final Map<IFixType, List<IFixableData>> fixMap = Maps.newHashMap();
    public final int version;

    public DataFixer(int p_i46828_1_) {
        this.version = p_i46828_1_;
    }

    public NBTTagCompound process(IFixType p_process_1_, NBTTagCompound p_process_2_) {
        int lvt_3_1_;
        int n = lvt_3_1_ = p_process_2_.hasKey("DataVersion", 99) ? p_process_2_.getInteger("DataVersion") : -1;
        if (lvt_3_1_ >= 922) {
            return p_process_2_;
        }
        return this.process(p_process_1_, p_process_2_, lvt_3_1_);
    }

    @Override
    public NBTTagCompound process(IFixType p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
        if (p_process_3_ < this.version) {
            p_process_2_ = this.processFixes(p_process_1_, p_process_2_, p_process_3_);
            p_process_2_ = this.processWalkers(p_process_1_, p_process_2_, p_process_3_);
        }
        return p_process_2_;
    }

    private NBTTagCompound processFixes(IFixType p_processFixes_1_, NBTTagCompound p_processFixes_2_, int p_processFixes_3_) {
        List<IFixableData> lvt_4_1_ = this.fixMap.get(p_processFixes_1_);
        if (lvt_4_1_ != null) {
            for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_4_1_.size(); ++lvt_5_1_) {
                IFixableData lvt_6_1_ = lvt_4_1_.get(lvt_5_1_);
                if (lvt_6_1_.getFixVersion() <= p_processFixes_3_) continue;
                p_processFixes_2_ = lvt_6_1_.fixTagCompound(p_processFixes_2_);
            }
        }
        return p_processFixes_2_;
    }

    private NBTTagCompound processWalkers(IFixType p_processWalkers_1_, NBTTagCompound p_processWalkers_2_, int p_processWalkers_3_) {
        List<IDataWalker> lvt_4_1_ = this.walkerMap.get(p_processWalkers_1_);
        if (lvt_4_1_ != null) {
            for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_4_1_.size(); ++lvt_5_1_) {
                p_processWalkers_2_ = lvt_4_1_.get(lvt_5_1_).process(this, p_processWalkers_2_, p_processWalkers_3_);
            }
        }
        return p_processWalkers_2_;
    }

    public void registerWalker(FixTypes p_registerWalker_1_, IDataWalker p_registerWalker_2_) {
        this.registerVanillaWalker(p_registerWalker_1_, p_registerWalker_2_);
    }

    public void registerVanillaWalker(IFixType p_registerVanillaWalker_1_, IDataWalker p_registerVanillaWalker_2_) {
        this.getTypeList(this.walkerMap, p_registerVanillaWalker_1_).add(p_registerVanillaWalker_2_);
    }

    public void registerFix(IFixType p_registerFix_1_, IFixableData p_registerFix_2_) {
        List lvt_3_1_ = this.getTypeList(this.fixMap, p_registerFix_1_);
        int lvt_4_1_ = p_registerFix_2_.getFixVersion();
        if (lvt_4_1_ > this.version) {
            LOGGER.warn("Ignored fix registered for version: {} as the DataVersion of the game is: {}", new Object[]{lvt_4_1_, this.version});
            return;
        }
        if (lvt_3_1_.isEmpty() || ((IFixableData)Util.getLastElement(lvt_3_1_)).getFixVersion() <= lvt_4_1_) {
            lvt_3_1_.add(p_registerFix_2_);
        } else {
            for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_3_1_.size(); ++lvt_5_1_) {
                if (((IFixableData)lvt_3_1_.get(lvt_5_1_)).getFixVersion() <= lvt_4_1_) continue;
                lvt_3_1_.add(lvt_5_1_, p_registerFix_2_);
                break;
            }
        }
    }

    private <V> List<V> getTypeList(Map<IFixType, List<V>> p_getTypeList_1_, IFixType p_getTypeList_2_) {
        ArrayList lvt_3_1_ = p_getTypeList_1_.get(p_getTypeList_2_);
        if (lvt_3_1_ == null) {
            lvt_3_1_ = Lists.newArrayList();
            p_getTypeList_1_.put(p_getTypeList_2_, lvt_3_1_);
        }
        return lvt_3_1_;
    }
}

