/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class SignStrictJSON
implements IFixableData {
    public static final Gson GSON_INSTANCE = new GsonBuilder().registerTypeAdapter(ITextComponent.class, (Object)new JsonDeserializer<ITextComponent>(){

        public ITextComponent deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            if (p_deserialize_1_.isJsonPrimitive()) {
                return new TextComponentString(p_deserialize_1_.getAsString());
            }
            if (p_deserialize_1_.isJsonArray()) {
                JsonArray lvt_4_1_ = p_deserialize_1_.getAsJsonArray();
                ITextComponent lvt_5_1_ = null;
                for (JsonElement lvt_7_1_ : lvt_4_1_) {
                    ITextComponent lvt_8_1_ = this.deserialize(lvt_7_1_, lvt_7_1_.getClass(), p_deserialize_3_);
                    if (lvt_5_1_ == null) {
                        lvt_5_1_ = lvt_8_1_;
                        continue;
                    }
                    lvt_5_1_.appendSibling(lvt_8_1_);
                }
                return lvt_5_1_;
            }
            throw new JsonParseException("Don't know how to turn " + p_deserialize_1_ + " into a Component");
        }

        public /* synthetic */ Object deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return this.deserialize(p_deserialize_1_, p_deserialize_2_, p_deserialize_3_);
        }
    }).create();

    @Override
    public int getFixVersion() {
        return 101;
    }

    @Override
    public NBTTagCompound fixTagCompound(NBTTagCompound p_fixTagCompound_1_) {
        if ("Sign".equals(p_fixTagCompound_1_.getString("id"))) {
            this.updateLine(p_fixTagCompound_1_, "Text1");
            this.updateLine(p_fixTagCompound_1_, "Text2");
            this.updateLine(p_fixTagCompound_1_, "Text3");
            this.updateLine(p_fixTagCompound_1_, "Text4");
        }
        return p_fixTagCompound_1_;
    }

    private void updateLine(NBTTagCompound p_updateLine_1_, String p_updateLine_2_) {
        String lvt_3_1_ = p_updateLine_1_.getString(p_updateLine_2_);
        ITextComponent lvt_4_1_ = null;
        if ("null".equals(lvt_3_1_) || StringUtils.isNullOrEmpty(lvt_3_1_)) {
            lvt_4_1_ = new TextComponentString("");
        } else if (lvt_3_1_.charAt(0) == '\"' && lvt_3_1_.charAt(lvt_3_1_.length() - 1) == '\"' || lvt_3_1_.charAt(0) == '{' && lvt_3_1_.charAt(lvt_3_1_.length() - 1) == '}') {
            try {
                lvt_4_1_ = (ITextComponent)GSON_INSTANCE.fromJson(lvt_3_1_, ITextComponent.class);
                if (lvt_4_1_ == null) {
                    lvt_4_1_ = new TextComponentString("");
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
            if (lvt_4_1_ == null) {
                try {
                    lvt_4_1_ = ITextComponent.Serializer.jsonToComponent(lvt_3_1_);
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
            if (lvt_4_1_ == null) {
                try {
                    lvt_4_1_ = ITextComponent.Serializer.fromJsonLenient(lvt_3_1_);
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
            if (lvt_4_1_ == null) {
                lvt_4_1_ = new TextComponentString(lvt_3_1_);
            }
        } else {
            lvt_4_1_ = new TextComponentString(lvt_3_1_);
        }
        p_updateLine_1_.setString(p_updateLine_2_, ITextComponent.Serializer.componentToJson(lvt_4_1_));
    }
}

