/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.walkers;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockEntityTag
implements IDataWalker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, String> NEW_TO_OLD_ID_MAP = Maps.newHashMap();
    private static final Map<String, String> ITEM_ID_TO_BLOCK_ENTITY_ID = Maps.newHashMap();

    @Nullable
    private static String getBlockEntityID(int p_getBlockEntityID_0_, String p_getBlockEntityID_1_) {
        if (p_getBlockEntityID_0_ < 515) {
            return NEW_TO_OLD_ID_MAP.get(new ResourceLocation(p_getBlockEntityID_1_).toString());
        }
        return ITEM_ID_TO_BLOCK_ENTITY_ID.get(new ResourceLocation(p_getBlockEntityID_1_).toString());
    }

    @Override
    public NBTTagCompound process(IDataFixer p_process_1_, NBTTagCompound p_process_2_, int p_process_3_) {
        if (!p_process_2_.hasKey("tag", 10)) {
            return p_process_2_;
        }
        NBTTagCompound lvt_4_1_ = p_process_2_.getCompoundTag("tag");
        if (lvt_4_1_.hasKey("BlockEntityTag", 10)) {
            boolean lvt_8_2_;
            NBTTagCompound lvt_5_1_ = lvt_4_1_.getCompoundTag("BlockEntityTag");
            String lvt_6_1_ = p_process_2_.getString("id");
            String lvt_7_1_ = BlockEntityTag.getBlockEntityID(p_process_3_, lvt_6_1_);
            if (lvt_7_1_ == null) {
                LOGGER.warn("Unable to resolve BlockEntity for ItemInstance: {}", new Object[]{lvt_6_1_});
                boolean lvt_8_1_ = false;
            } else {
                lvt_8_2_ = !lvt_5_1_.hasKey("id");
                lvt_5_1_.setString("id", lvt_7_1_);
            }
            p_process_1_.process(FixTypes.BLOCK_ENTITY, lvt_5_1_, p_process_3_);
            if (lvt_8_2_) {
                lvt_5_1_.removeTag("id");
            }
        }
        return p_process_2_;
    }

    static {
        Map<String, String> lvt_0_1_ = NEW_TO_OLD_ID_MAP;
        lvt_0_1_.put("minecraft:furnace", "Furnace");
        lvt_0_1_.put("minecraft:lit_furnace", "Furnace");
        lvt_0_1_.put("minecraft:chest", "Chest");
        lvt_0_1_.put("minecraft:trapped_chest", "Chest");
        lvt_0_1_.put("minecraft:ender_chest", "EnderChest");
        lvt_0_1_.put("minecraft:jukebox", "RecordPlayer");
        lvt_0_1_.put("minecraft:dispenser", "Trap");
        lvt_0_1_.put("minecraft:dropper", "Dropper");
        lvt_0_1_.put("minecraft:sign", "Sign");
        lvt_0_1_.put("minecraft:mob_spawner", "MobSpawner");
        lvt_0_1_.put("minecraft:noteblock", "Music");
        lvt_0_1_.put("minecraft:brewing_stand", "Cauldron");
        lvt_0_1_.put("minecraft:enhanting_table", "EnchantTable");
        lvt_0_1_.put("minecraft:command_block", "CommandBlock");
        lvt_0_1_.put("minecraft:beacon", "Beacon");
        lvt_0_1_.put("minecraft:skull", "Skull");
        lvt_0_1_.put("minecraft:daylight_detector", "DLDetector");
        lvt_0_1_.put("minecraft:hopper", "Hopper");
        lvt_0_1_.put("minecraft:banner", "Banner");
        lvt_0_1_.put("minecraft:flower_pot", "FlowerPot");
        lvt_0_1_.put("minecraft:repeating_command_block", "CommandBlock");
        lvt_0_1_.put("minecraft:chain_command_block", "CommandBlock");
        lvt_0_1_.put("minecraft:standing_sign", "Sign");
        lvt_0_1_.put("minecraft:wall_sign", "Sign");
        lvt_0_1_.put("minecraft:piston_head", "Piston");
        lvt_0_1_.put("minecraft:daylight_detector_inverted", "DLDetector");
        lvt_0_1_.put("minecraft:unpowered_comparator", "Comparator");
        lvt_0_1_.put("minecraft:powered_comparator", "Comparator");
        lvt_0_1_.put("minecraft:wall_banner", "Banner");
        lvt_0_1_.put("minecraft:standing_banner", "Banner");
        lvt_0_1_.put("minecraft:structure_block", "Structure");
        lvt_0_1_.put("minecraft:end_portal", "Airportal");
        lvt_0_1_.put("minecraft:end_gateway", "EndGateway");
        lvt_0_1_.put("minecraft:shield", "Shield");
        Map<String, String> lvt_0_2_ = ITEM_ID_TO_BLOCK_ENTITY_ID;
        lvt_0_2_.put("minecraft:furnace", "minecraft:furnace");
        lvt_0_2_.put("minecraft:lit_furnace", "minecraft:furnace");
        lvt_0_2_.put("minecraft:chest", "minecraft:chest");
        lvt_0_2_.put("minecraft:trapped_chest", "minecraft:chest");
        lvt_0_2_.put("minecraft:ender_chest", "minecraft:enderchest");
        lvt_0_2_.put("minecraft:jukebox", "minecraft:jukebox");
        lvt_0_2_.put("minecraft:dispenser", "minecraft:dispenser");
        lvt_0_2_.put("minecraft:dropper", "minecraft:dropper");
        lvt_0_2_.put("minecraft:sign", "minecraft:sign");
        lvt_0_2_.put("minecraft:mob_spawner", "minecraft:mob_spawner");
        lvt_0_2_.put("minecraft:noteblock", "minecraft:noteblock");
        lvt_0_2_.put("minecraft:brewing_stand", "minecraft:brewing_stand");
        lvt_0_2_.put("minecraft:enhanting_table", "minecraft:enchanting_table");
        lvt_0_2_.put("minecraft:command_block", "minecraft:command_block");
        lvt_0_2_.put("minecraft:beacon", "minecraft:beacon");
        lvt_0_2_.put("minecraft:skull", "minecraft:skull");
        lvt_0_2_.put("minecraft:daylight_detector", "minecraft:daylight_detector");
        lvt_0_2_.put("minecraft:hopper", "minecraft:hopper");
        lvt_0_2_.put("minecraft:banner", "minecraft:banner");
        lvt_0_2_.put("minecraft:flower_pot", "minecraft:flower_pot");
        lvt_0_2_.put("minecraft:repeating_command_block", "minecraft:command_block");
        lvt_0_2_.put("minecraft:chain_command_block", "minecraft:command_block");
        lvt_0_2_.put("minecraft:shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:white_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:orange_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:magenta_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:light_blue_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:yellow_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:lime_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:pink_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:gray_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:silver_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:cyan_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:purple_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:blue_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:brown_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:green_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:red_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:black_shulker_box", "minecraft:shulker_box");
        lvt_0_2_.put("minecraft:standing_sign", "minecraft:sign");
        lvt_0_2_.put("minecraft:wall_sign", "minecraft:sign");
        lvt_0_2_.put("minecraft:piston_head", "minecraft:piston");
        lvt_0_2_.put("minecraft:daylight_detector_inverted", "minecraft:daylight_detector");
        lvt_0_2_.put("minecraft:unpowered_comparator", "minecraft:comparator");
        lvt_0_2_.put("minecraft:powered_comparator", "minecraft:comparator");
        lvt_0_2_.put("minecraft:wall_banner", "minecraft:banner");
        lvt_0_2_.put("minecraft:standing_banner", "minecraft:banner");
        lvt_0_2_.put("minecraft:structure_block", "minecraft:structure_block");
        lvt_0_2_.put("minecraft:end_portal", "minecraft:end_portal");
        lvt_0_2_.put("minecraft:end_gateway", "minecraft:end_gateway");
        lvt_0_2_.put("minecraft:shield", "minecraft:shield");
    }
}

