/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AxisAlignedBB {
    public final double minX;
    public final double minY;
    public final double minZ;
    public final double maxX;
    public final double maxY;
    public final double maxZ;

    public AxisAlignedBB(double p_i2300_1_, double p_i2300_3_, double p_i2300_5_, double p_i2300_7_, double p_i2300_9_, double p_i2300_11_) {
        this.minX = Math.min(p_i2300_1_, p_i2300_7_);
        this.minY = Math.min(p_i2300_3_, p_i2300_9_);
        this.minZ = Math.min(p_i2300_5_, p_i2300_11_);
        this.maxX = Math.max(p_i2300_1_, p_i2300_7_);
        this.maxY = Math.max(p_i2300_3_, p_i2300_9_);
        this.maxZ = Math.max(p_i2300_5_, p_i2300_11_);
    }

    public AxisAlignedBB(BlockPos p_i46612_1_) {
        this(p_i46612_1_.getX(), p_i46612_1_.getY(), p_i46612_1_.getZ(), p_i46612_1_.getX() + 1, p_i46612_1_.getY() + 1, p_i46612_1_.getZ() + 1);
    }

    public AxisAlignedBB(BlockPos p_i45554_1_, BlockPos p_i45554_2_) {
        this(p_i45554_1_.getX(), p_i45554_1_.getY(), p_i45554_1_.getZ(), p_i45554_2_.getX(), p_i45554_2_.getY(), p_i45554_2_.getZ());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB(Vec3d p_i47144_1_, Vec3d p_i47144_2_) {
        this(p_i47144_1_.xCoord, p_i47144_1_.yCoord, p_i47144_1_.zCoord, p_i47144_2_.xCoord, p_i47144_2_.yCoord, p_i47144_2_.zCoord);
    }

    public AxisAlignedBB setMaxY(double p_setMaxY_1_) {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, p_setMaxY_1_, this.maxZ);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof AxisAlignedBB)) {
            return false;
        }
        AxisAlignedBB lvt_2_1_ = (AxisAlignedBB)p_equals_1_;
        if (Double.compare(lvt_2_1_.minX, this.minX) != 0) {
            return false;
        }
        if (Double.compare(lvt_2_1_.minY, this.minY) != 0) {
            return false;
        }
        if (Double.compare(lvt_2_1_.minZ, this.minZ) != 0) {
            return false;
        }
        if (Double.compare(lvt_2_1_.maxX, this.maxX) != 0) {
            return false;
        }
        if (Double.compare(lvt_2_1_.maxY, this.maxY) != 0) {
            return false;
        }
        return Double.compare(lvt_2_1_.maxZ, this.maxZ) == 0;
    }

    public int hashCode() {
        long lvt_1_1_ = Double.doubleToLongBits(this.minX);
        int lvt_3_1_ = (int)(lvt_1_1_ ^ lvt_1_1_ >>> 32);
        lvt_1_1_ = Double.doubleToLongBits(this.minY);
        lvt_3_1_ = 31 * lvt_3_1_ + (int)(lvt_1_1_ ^ lvt_1_1_ >>> 32);
        lvt_1_1_ = Double.doubleToLongBits(this.minZ);
        lvt_3_1_ = 31 * lvt_3_1_ + (int)(lvt_1_1_ ^ lvt_1_1_ >>> 32);
        lvt_1_1_ = Double.doubleToLongBits(this.maxX);
        lvt_3_1_ = 31 * lvt_3_1_ + (int)(lvt_1_1_ ^ lvt_1_1_ >>> 32);
        lvt_1_1_ = Double.doubleToLongBits(this.maxY);
        lvt_3_1_ = 31 * lvt_3_1_ + (int)(lvt_1_1_ ^ lvt_1_1_ >>> 32);
        lvt_1_1_ = Double.doubleToLongBits(this.maxZ);
        lvt_3_1_ = 31 * lvt_3_1_ + (int)(lvt_1_1_ ^ lvt_1_1_ >>> 32);
        return lvt_3_1_;
    }

    public AxisAlignedBB contract(double p_contract_1_, double p_contract_3_, double p_contract_5_) {
        double lvt_7_1_ = this.minX;
        double lvt_9_1_ = this.minY;
        double lvt_11_1_ = this.minZ;
        double lvt_13_1_ = this.maxX;
        double lvt_15_1_ = this.maxY;
        double lvt_17_1_ = this.maxZ;
        if (p_contract_1_ < 0.0) {
            lvt_7_1_ -= p_contract_1_;
        } else if (p_contract_1_ > 0.0) {
            lvt_13_1_ -= p_contract_1_;
        }
        if (p_contract_3_ < 0.0) {
            lvt_9_1_ -= p_contract_3_;
        } else if (p_contract_3_ > 0.0) {
            lvt_15_1_ -= p_contract_3_;
        }
        if (p_contract_5_ < 0.0) {
            lvt_11_1_ -= p_contract_5_;
        } else if (p_contract_5_ > 0.0) {
            lvt_17_1_ -= p_contract_5_;
        }
        return new AxisAlignedBB(lvt_7_1_, lvt_9_1_, lvt_11_1_, lvt_13_1_, lvt_15_1_, lvt_17_1_);
    }

    public AxisAlignedBB addCoord(double p_addCoord_1_, double p_addCoord_3_, double p_addCoord_5_) {
        double lvt_7_1_ = this.minX;
        double lvt_9_1_ = this.minY;
        double lvt_11_1_ = this.minZ;
        double lvt_13_1_ = this.maxX;
        double lvt_15_1_ = this.maxY;
        double lvt_17_1_ = this.maxZ;
        if (p_addCoord_1_ < 0.0) {
            lvt_7_1_ += p_addCoord_1_;
        } else if (p_addCoord_1_ > 0.0) {
            lvt_13_1_ += p_addCoord_1_;
        }
        if (p_addCoord_3_ < 0.0) {
            lvt_9_1_ += p_addCoord_3_;
        } else if (p_addCoord_3_ > 0.0) {
            lvt_15_1_ += p_addCoord_3_;
        }
        if (p_addCoord_5_ < 0.0) {
            lvt_11_1_ += p_addCoord_5_;
        } else if (p_addCoord_5_ > 0.0) {
            lvt_17_1_ += p_addCoord_5_;
        }
        return new AxisAlignedBB(lvt_7_1_, lvt_9_1_, lvt_11_1_, lvt_13_1_, lvt_15_1_, lvt_17_1_);
    }

    public AxisAlignedBB expand(double p_expand_1_, double p_expand_3_, double p_expand_5_) {
        double lvt_7_1_ = this.minX - p_expand_1_;
        double lvt_9_1_ = this.minY - p_expand_3_;
        double lvt_11_1_ = this.minZ - p_expand_5_;
        double lvt_13_1_ = this.maxX + p_expand_1_;
        double lvt_15_1_ = this.maxY + p_expand_3_;
        double lvt_17_1_ = this.maxZ + p_expand_5_;
        return new AxisAlignedBB(lvt_7_1_, lvt_9_1_, lvt_11_1_, lvt_13_1_, lvt_15_1_, lvt_17_1_);
    }

    public AxisAlignedBB expandXyz(double p_expandXyz_1_) {
        return this.expand(p_expandXyz_1_, p_expandXyz_1_, p_expandXyz_1_);
    }

    public AxisAlignedBB intersect(AxisAlignedBB p_intersect_1_) {
        double lvt_2_1_ = Math.max(this.minX, p_intersect_1_.minX);
        double lvt_4_1_ = Math.max(this.minY, p_intersect_1_.minY);
        double lvt_6_1_ = Math.max(this.minZ, p_intersect_1_.minZ);
        double lvt_8_1_ = Math.min(this.maxX, p_intersect_1_.maxX);
        double lvt_10_1_ = Math.min(this.maxY, p_intersect_1_.maxY);
        double lvt_12_1_ = Math.min(this.maxZ, p_intersect_1_.maxZ);
        return new AxisAlignedBB(lvt_2_1_, lvt_4_1_, lvt_6_1_, lvt_8_1_, lvt_10_1_, lvt_12_1_);
    }

    public AxisAlignedBB union(AxisAlignedBB p_union_1_) {
        double lvt_2_1_ = Math.min(this.minX, p_union_1_.minX);
        double lvt_4_1_ = Math.min(this.minY, p_union_1_.minY);
        double lvt_6_1_ = Math.min(this.minZ, p_union_1_.minZ);
        double lvt_8_1_ = Math.max(this.maxX, p_union_1_.maxX);
        double lvt_10_1_ = Math.max(this.maxY, p_union_1_.maxY);
        double lvt_12_1_ = Math.max(this.maxZ, p_union_1_.maxZ);
        return new AxisAlignedBB(lvt_2_1_, lvt_4_1_, lvt_6_1_, lvt_8_1_, lvt_10_1_, lvt_12_1_);
    }

    public AxisAlignedBB offset(double p_offset_1_, double p_offset_3_, double p_offset_5_) {
        return new AxisAlignedBB(this.minX + p_offset_1_, this.minY + p_offset_3_, this.minZ + p_offset_5_, this.maxX + p_offset_1_, this.maxY + p_offset_3_, this.maxZ + p_offset_5_);
    }

    public AxisAlignedBB offset(BlockPos p_offset_1_) {
        return new AxisAlignedBB(this.minX + (double)p_offset_1_.getX(), this.minY + (double)p_offset_1_.getY(), this.minZ + (double)p_offset_1_.getZ(), this.maxX + (double)p_offset_1_.getX(), this.maxY + (double)p_offset_1_.getY(), this.maxZ + (double)p_offset_1_.getZ());
    }

    public AxisAlignedBB move(Vec3d p_move_1_) {
        return this.offset(p_move_1_.xCoord, p_move_1_.yCoord, p_move_1_.zCoord);
    }

    public double calculateXOffset(AxisAlignedBB p_calculateXOffset_1_, double p_calculateXOffset_2_) {
        double lvt_4_2_;
        if (p_calculateXOffset_1_.maxY <= this.minY || p_calculateXOffset_1_.minY >= this.maxY || p_calculateXOffset_1_.maxZ <= this.minZ || p_calculateXOffset_1_.minZ >= this.maxZ) {
            return p_calculateXOffset_2_;
        }
        if (p_calculateXOffset_2_ > 0.0 && p_calculateXOffset_1_.maxX <= this.minX) {
            double lvt_4_1_ = this.minX - p_calculateXOffset_1_.maxX;
            if (lvt_4_1_ < p_calculateXOffset_2_) {
                p_calculateXOffset_2_ = lvt_4_1_;
            }
        } else if (p_calculateXOffset_2_ < 0.0 && p_calculateXOffset_1_.minX >= this.maxX && (lvt_4_2_ = this.maxX - p_calculateXOffset_1_.minX) > p_calculateXOffset_2_) {
            p_calculateXOffset_2_ = lvt_4_2_;
        }
        return p_calculateXOffset_2_;
    }

    public double calculateYOffset(AxisAlignedBB p_calculateYOffset_1_, double p_calculateYOffset_2_) {
        double lvt_4_2_;
        if (p_calculateYOffset_1_.maxX <= this.minX || p_calculateYOffset_1_.minX >= this.maxX || p_calculateYOffset_1_.maxZ <= this.minZ || p_calculateYOffset_1_.minZ >= this.maxZ) {
            return p_calculateYOffset_2_;
        }
        if (p_calculateYOffset_2_ > 0.0 && p_calculateYOffset_1_.maxY <= this.minY) {
            double lvt_4_1_ = this.minY - p_calculateYOffset_1_.maxY;
            if (lvt_4_1_ < p_calculateYOffset_2_) {
                p_calculateYOffset_2_ = lvt_4_1_;
            }
        } else if (p_calculateYOffset_2_ < 0.0 && p_calculateYOffset_1_.minY >= this.maxY && (lvt_4_2_ = this.maxY - p_calculateYOffset_1_.minY) > p_calculateYOffset_2_) {
            p_calculateYOffset_2_ = lvt_4_2_;
        }
        return p_calculateYOffset_2_;
    }

    public double calculateZOffset(AxisAlignedBB p_calculateZOffset_1_, double p_calculateZOffset_2_) {
        double lvt_4_2_;
        if (p_calculateZOffset_1_.maxX <= this.minX || p_calculateZOffset_1_.minX >= this.maxX || p_calculateZOffset_1_.maxY <= this.minY || p_calculateZOffset_1_.minY >= this.maxY) {
            return p_calculateZOffset_2_;
        }
        if (p_calculateZOffset_2_ > 0.0 && p_calculateZOffset_1_.maxZ <= this.minZ) {
            double lvt_4_1_ = this.minZ - p_calculateZOffset_1_.maxZ;
            if (lvt_4_1_ < p_calculateZOffset_2_) {
                p_calculateZOffset_2_ = lvt_4_1_;
            }
        } else if (p_calculateZOffset_2_ < 0.0 && p_calculateZOffset_1_.minZ >= this.maxZ && (lvt_4_2_ = this.maxZ - p_calculateZOffset_1_.minZ) > p_calculateZOffset_2_) {
            p_calculateZOffset_2_ = lvt_4_2_;
        }
        return p_calculateZOffset_2_;
    }

    public boolean intersectsWith(AxisAlignedBB p_intersectsWith_1_) {
        return this.intersects(p_intersectsWith_1_.minX, p_intersectsWith_1_.minY, p_intersectsWith_1_.minZ, p_intersectsWith_1_.maxX, p_intersectsWith_1_.maxY, p_intersectsWith_1_.maxZ);
    }

    public boolean intersects(double p_intersects_1_, double p_intersects_3_, double p_intersects_5_, double p_intersects_7_, double p_intersects_9_, double p_intersects_11_) {
        return this.minX < p_intersects_7_ && this.maxX > p_intersects_1_ && this.minY < p_intersects_9_ && this.maxY > p_intersects_3_ && this.minZ < p_intersects_11_ && this.maxZ > p_intersects_5_;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean intersects(Vec3d p_intersects_1_, Vec3d p_intersects_2_) {
        return this.intersects(Math.min(p_intersects_1_.xCoord, p_intersects_2_.xCoord), Math.min(p_intersects_1_.yCoord, p_intersects_2_.yCoord), Math.min(p_intersects_1_.zCoord, p_intersects_2_.zCoord), Math.max(p_intersects_1_.xCoord, p_intersects_2_.xCoord), Math.max(p_intersects_1_.yCoord, p_intersects_2_.yCoord), Math.max(p_intersects_1_.zCoord, p_intersects_2_.zCoord));
    }

    public boolean isVecInside(Vec3d p_isVecInside_1_) {
        if (p_isVecInside_1_.xCoord <= this.minX || p_isVecInside_1_.xCoord >= this.maxX) {
            return false;
        }
        if (p_isVecInside_1_.yCoord <= this.minY || p_isVecInside_1_.yCoord >= this.maxY) {
            return false;
        }
        return !(p_isVecInside_1_.zCoord <= this.minZ) && !(p_isVecInside_1_.zCoord >= this.maxZ);
    }

    public double getAverageEdgeLength() {
        double lvt_1_1_ = this.maxX - this.minX;
        double lvt_3_1_ = this.maxY - this.minY;
        double lvt_5_1_ = this.maxZ - this.minZ;
        return (lvt_1_1_ + lvt_3_1_ + lvt_5_1_) / 3.0;
    }

    public AxisAlignedBB contract(double p_contract_1_) {
        return this.expandXyz(-p_contract_1_);
    }

    @Nullable
    public RayTraceResult calculateIntercept(Vec3d p_calculateIntercept_1_, Vec3d p_calculateIntercept_2_) {
        Vec3d lvt_3_1_ = this.collideWithXPlane(this.minX, p_calculateIntercept_1_, p_calculateIntercept_2_);
        EnumFacing lvt_4_1_ = EnumFacing.WEST;
        Vec3d lvt_5_1_ = this.collideWithXPlane(this.maxX, p_calculateIntercept_1_, p_calculateIntercept_2_);
        if (lvt_5_1_ != null && this.isClosest(p_calculateIntercept_1_, lvt_3_1_, lvt_5_1_)) {
            lvt_3_1_ = lvt_5_1_;
            lvt_4_1_ = EnumFacing.EAST;
        }
        if ((lvt_5_1_ = this.collideWithYPlane(this.minY, p_calculateIntercept_1_, p_calculateIntercept_2_)) != null && this.isClosest(p_calculateIntercept_1_, lvt_3_1_, lvt_5_1_)) {
            lvt_3_1_ = lvt_5_1_;
            lvt_4_1_ = EnumFacing.DOWN;
        }
        if ((lvt_5_1_ = this.collideWithYPlane(this.maxY, p_calculateIntercept_1_, p_calculateIntercept_2_)) != null && this.isClosest(p_calculateIntercept_1_, lvt_3_1_, lvt_5_1_)) {
            lvt_3_1_ = lvt_5_1_;
            lvt_4_1_ = EnumFacing.UP;
        }
        if ((lvt_5_1_ = this.collideWithZPlane(this.minZ, p_calculateIntercept_1_, p_calculateIntercept_2_)) != null && this.isClosest(p_calculateIntercept_1_, lvt_3_1_, lvt_5_1_)) {
            lvt_3_1_ = lvt_5_1_;
            lvt_4_1_ = EnumFacing.NORTH;
        }
        if ((lvt_5_1_ = this.collideWithZPlane(this.maxZ, p_calculateIntercept_1_, p_calculateIntercept_2_)) != null && this.isClosest(p_calculateIntercept_1_, lvt_3_1_, lvt_5_1_)) {
            lvt_3_1_ = lvt_5_1_;
            lvt_4_1_ = EnumFacing.SOUTH;
        }
        return lvt_3_1_ == null ? null : new RayTraceResult(lvt_3_1_, lvt_4_1_);
    }

    @VisibleForTesting
    boolean isClosest(Vec3d p_isClosest_1_, Vec3d p_isClosest_2_, Vec3d p_isClosest_3_) {
        return p_isClosest_2_ == null || p_isClosest_1_.squareDistanceTo(p_isClosest_3_) < p_isClosest_1_.squareDistanceTo(p_isClosest_2_);
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithXPlane(double p_collideWithXPlane_1_, Vec3d p_collideWithXPlane_3_, Vec3d p_collideWithXPlane_4_) {
        Vec3d lvt_5_1_ = p_collideWithXPlane_3_.getIntermediateWithXValue(p_collideWithXPlane_4_, p_collideWithXPlane_1_);
        return lvt_5_1_ == null || !this.intersectsWithYZ(lvt_5_1_) ? null : lvt_5_1_;
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithYPlane(double p_collideWithYPlane_1_, Vec3d p_collideWithYPlane_3_, Vec3d p_collideWithYPlane_4_) {
        Vec3d lvt_5_1_ = p_collideWithYPlane_3_.getIntermediateWithYValue(p_collideWithYPlane_4_, p_collideWithYPlane_1_);
        return lvt_5_1_ == null || !this.intersectsWithXZ(lvt_5_1_) ? null : lvt_5_1_;
    }

    @Nullable
    @VisibleForTesting
    Vec3d collideWithZPlane(double p_collideWithZPlane_1_, Vec3d p_collideWithZPlane_3_, Vec3d p_collideWithZPlane_4_) {
        Vec3d lvt_5_1_ = p_collideWithZPlane_3_.getIntermediateWithZValue(p_collideWithZPlane_4_, p_collideWithZPlane_1_);
        return lvt_5_1_ == null || !this.intersectsWithXY(lvt_5_1_) ? null : lvt_5_1_;
    }

    @VisibleForTesting
    public boolean intersectsWithYZ(Vec3d p_intersectsWithYZ_1_) {
        return p_intersectsWithYZ_1_.yCoord >= this.minY && p_intersectsWithYZ_1_.yCoord <= this.maxY && p_intersectsWithYZ_1_.zCoord >= this.minZ && p_intersectsWithYZ_1_.zCoord <= this.maxZ;
    }

    @VisibleForTesting
    public boolean intersectsWithXZ(Vec3d p_intersectsWithXZ_1_) {
        return p_intersectsWithXZ_1_.xCoord >= this.minX && p_intersectsWithXZ_1_.xCoord <= this.maxX && p_intersectsWithXZ_1_.zCoord >= this.minZ && p_intersectsWithXZ_1_.zCoord <= this.maxZ;
    }

    @VisibleForTesting
    public boolean intersectsWithXY(Vec3d p_intersectsWithXY_1_) {
        return p_intersectsWithXY_1_.xCoord >= this.minX && p_intersectsWithXY_1_.xCoord <= this.maxX && p_intersectsWithXY_1_.yCoord >= this.minY && p_intersectsWithXY_1_.yCoord <= this.maxY;
    }

    public String toString() {
        return "box[" + this.minX + ", " + this.minY + ", " + this.minZ + " -> " + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasNaN() {
        return Double.isNaN(this.minX) || Double.isNaN(this.minY) || Double.isNaN(this.minZ) || Double.isNaN(this.maxX) || Double.isNaN(this.maxY) || Double.isNaN(this.maxZ);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCenter() {
        return new Vec3d(this.minX + (this.maxX - this.minX) * 0.5, this.minY + (this.maxY - this.minY) * 0.5, this.minZ + (this.maxZ - this.minZ) * 0.5);
    }
}

