/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Immutable
public class BlockPos
extends Vec3i {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final BlockPos ORIGIN = new BlockPos(0, 0, 0);
    private static final int NUM_X_BITS;
    private static final int NUM_Z_BITS;
    private static final int NUM_Y_BITS;
    private static final int Y_SHIFT;
    private static final int X_SHIFT;
    private static final long X_MASK;
    private static final long Y_MASK;
    private static final long Z_MASK;

    public BlockPos(int p_i46030_1_, int p_i46030_2_, int p_i46030_3_) {
        super(p_i46030_1_, p_i46030_2_, p_i46030_3_);
    }

    public BlockPos(double p_i46031_1_, double p_i46031_3_, double p_i46031_5_) {
        super(p_i46031_1_, p_i46031_3_, p_i46031_5_);
    }

    public BlockPos(Entity p_i46032_1_) {
        this(p_i46032_1_.posX, p_i46032_1_.posY, p_i46032_1_.posZ);
    }

    public BlockPos(Vec3d p_i47100_1_) {
        this(p_i47100_1_.xCoord, p_i47100_1_.yCoord, p_i47100_1_.zCoord);
    }

    public BlockPos(Vec3i p_i46034_1_) {
        this(p_i46034_1_.getX(), p_i46034_1_.getY(), p_i46034_1_.getZ());
    }

    public BlockPos add(double p_add_1_, double p_add_3_, double p_add_5_) {
        if (p_add_1_ == 0.0 && p_add_3_ == 0.0 && p_add_5_ == 0.0) {
            return this;
        }
        return new BlockPos((double)this.getX() + p_add_1_, (double)this.getY() + p_add_3_, (double)this.getZ() + p_add_5_);
    }

    public BlockPos add(int p_add_1_, int p_add_2_, int p_add_3_) {
        if (p_add_1_ == 0 && p_add_2_ == 0 && p_add_3_ == 0) {
            return this;
        }
        return new BlockPos(this.getX() + p_add_1_, this.getY() + p_add_2_, this.getZ() + p_add_3_);
    }

    public BlockPos add(Vec3i p_add_1_) {
        return this.add(p_add_1_.getX(), p_add_1_.getY(), p_add_1_.getZ());
    }

    public BlockPos subtract(Vec3i p_subtract_1_) {
        return this.add(-p_subtract_1_.getX(), -p_subtract_1_.getY(), -p_subtract_1_.getZ());
    }

    public BlockPos up() {
        return this.up(1);
    }

    public BlockPos up(int p_up_1_) {
        return this.offset(EnumFacing.UP, p_up_1_);
    }

    public BlockPos down() {
        return this.down(1);
    }

    public BlockPos down(int p_down_1_) {
        return this.offset(EnumFacing.DOWN, p_down_1_);
    }

    public BlockPos north() {
        return this.north(1);
    }

    public BlockPos north(int p_north_1_) {
        return this.offset(EnumFacing.NORTH, p_north_1_);
    }

    public BlockPos south() {
        return this.south(1);
    }

    public BlockPos south(int p_south_1_) {
        return this.offset(EnumFacing.SOUTH, p_south_1_);
    }

    public BlockPos west() {
        return this.west(1);
    }

    public BlockPos west(int p_west_1_) {
        return this.offset(EnumFacing.WEST, p_west_1_);
    }

    public BlockPos east() {
        return this.east(1);
    }

    public BlockPos east(int p_east_1_) {
        return this.offset(EnumFacing.EAST, p_east_1_);
    }

    public BlockPos offset(EnumFacing p_offset_1_) {
        return this.offset(p_offset_1_, 1);
    }

    public BlockPos offset(EnumFacing p_offset_1_, int p_offset_2_) {
        if (p_offset_2_ == 0) {
            return this;
        }
        return new BlockPos(this.getX() + p_offset_1_.getFrontOffsetX() * p_offset_2_, this.getY() + p_offset_1_.getFrontOffsetY() * p_offset_2_, this.getZ() + p_offset_1_.getFrontOffsetZ() * p_offset_2_);
    }

    public BlockPos rotate(Rotation p_rotate_1_) {
        switch (p_rotate_1_) {
            default: {
                return this;
            }
            case CLOCKWISE_90: {
                return new BlockPos(-this.getZ(), this.getY(), this.getX());
            }
            case CLOCKWISE_180: {
                return new BlockPos(-this.getX(), this.getY(), -this.getZ());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new BlockPos(this.getZ(), this.getY(), -this.getX());
    }

    @Override
    public BlockPos crossProduct(Vec3i p_crossProduct_1_) {
        return new BlockPos(this.getY() * p_crossProduct_1_.getZ() - this.getZ() * p_crossProduct_1_.getY(), this.getZ() * p_crossProduct_1_.getX() - this.getX() * p_crossProduct_1_.getZ(), this.getX() * p_crossProduct_1_.getY() - this.getY() * p_crossProduct_1_.getX());
    }

    public long toLong() {
        return ((long)this.getX() & X_MASK) << X_SHIFT | ((long)this.getY() & Y_MASK) << Y_SHIFT | ((long)this.getZ() & Z_MASK) << 0;
    }

    public static BlockPos fromLong(long p_fromLong_0_) {
        int lvt_2_1_ = (int)(p_fromLong_0_ << 64 - X_SHIFT - NUM_X_BITS >> 64 - NUM_X_BITS);
        int lvt_3_1_ = (int)(p_fromLong_0_ << 64 - Y_SHIFT - NUM_Y_BITS >> 64 - NUM_Y_BITS);
        int lvt_4_1_ = (int)(p_fromLong_0_ << 64 - NUM_Z_BITS >> 64 - NUM_Z_BITS);
        return new BlockPos(lvt_2_1_, lvt_3_1_, lvt_4_1_);
    }

    public static Iterable<BlockPos> getAllInBox(BlockPos p_getAllInBox_0_, BlockPos p_getAllInBox_1_) {
        return BlockPos.func_191532_a(Math.min(p_getAllInBox_0_.getX(), p_getAllInBox_1_.getX()), Math.min(p_getAllInBox_0_.getY(), p_getAllInBox_1_.getY()), Math.min(p_getAllInBox_0_.getZ(), p_getAllInBox_1_.getZ()), Math.max(p_getAllInBox_0_.getX(), p_getAllInBox_1_.getX()), Math.max(p_getAllInBox_0_.getY(), p_getAllInBox_1_.getY()), Math.max(p_getAllInBox_0_.getZ(), p_getAllInBox_1_.getZ()));
    }

    public static Iterable<BlockPos> func_191532_a(final int p_191532_0_, final int p_191532_1_, final int p_191532_2_, final int p_191532_3_, final int p_191532_4_, final int p_191532_5_) {
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private boolean field_191534_b = true;
                    private int field_191535_c;
                    private int field_191536_d;
                    private int field_191537_e;

                    protected BlockPos computeNext() {
                        if (this.field_191534_b) {
                            this.field_191534_b = false;
                            this.field_191535_c = p_191532_0_;
                            this.field_191536_d = p_191532_1_;
                            this.field_191537_e = p_191532_2_;
                            return new BlockPos(p_191532_0_, p_191532_1_, p_191532_2_);
                        }
                        if (this.field_191535_c == p_191532_3_ && this.field_191536_d == p_191532_4_ && this.field_191537_e == p_191532_5_) {
                            return (BlockPos)this.endOfData();
                        }
                        if (this.field_191535_c < p_191532_3_) {
                            ++this.field_191535_c;
                        } else if (this.field_191536_d < p_191532_4_) {
                            this.field_191535_c = p_191532_0_;
                            ++this.field_191536_d;
                        } else if (this.field_191537_e < p_191532_5_) {
                            this.field_191535_c = p_191532_0_;
                            this.field_191536_d = p_191532_1_;
                            ++this.field_191537_e;
                        }
                        return new BlockPos(this.field_191535_c, this.field_191536_d, this.field_191537_e);
                    }

                    protected /* synthetic */ Object computeNext() {
                        return this.computeNext();
                    }
                };
            }
        };
    }

    public BlockPos toImmutable() {
        return this;
    }

    public static Iterable<MutableBlockPos> getAllInBoxMutable(BlockPos p_getAllInBoxMutable_0_, BlockPos p_getAllInBoxMutable_1_) {
        return BlockPos.func_191531_b(Math.min(p_getAllInBoxMutable_0_.getX(), p_getAllInBoxMutable_1_.getX()), Math.min(p_getAllInBoxMutable_0_.getY(), p_getAllInBoxMutable_1_.getY()), Math.min(p_getAllInBoxMutable_0_.getZ(), p_getAllInBoxMutable_1_.getZ()), Math.max(p_getAllInBoxMutable_0_.getX(), p_getAllInBoxMutable_1_.getX()), Math.max(p_getAllInBoxMutable_0_.getY(), p_getAllInBoxMutable_1_.getY()), Math.max(p_getAllInBoxMutable_0_.getZ(), p_getAllInBoxMutable_1_.getZ()));
    }

    public static Iterable<MutableBlockPos> func_191531_b(final int p_191531_0_, final int p_191531_1_, final int p_191531_2_, final int p_191531_3_, final int p_191531_4_, final int p_191531_5_) {
        return new Iterable<MutableBlockPos>(){

            @Override
            public Iterator<MutableBlockPos> iterator() {
                return new AbstractIterator<MutableBlockPos>(){
                    private MutableBlockPos theBlockPos;

                    protected MutableBlockPos computeNext() {
                        if (this.theBlockPos == null) {
                            this.theBlockPos = new MutableBlockPos(p_191531_0_, p_191531_1_, p_191531_2_);
                            return this.theBlockPos;
                        }
                        if (this.theBlockPos.x == p_191531_3_ && this.theBlockPos.y == p_191531_4_ && this.theBlockPos.z == p_191531_5_) {
                            return (MutableBlockPos)this.endOfData();
                        }
                        if (this.theBlockPos.x < p_191531_3_) {
                            ++this.theBlockPos.x;
                        } else if (this.theBlockPos.y < p_191531_4_) {
                            this.theBlockPos.x = p_191531_0_;
                            ++this.theBlockPos.y;
                        } else if (this.theBlockPos.z < p_191531_5_) {
                            this.theBlockPos.x = p_191531_0_;
                            this.theBlockPos.y = p_191531_1_;
                            ++this.theBlockPos.z;
                        }
                        return this.theBlockPos;
                    }

                    protected /* synthetic */ Object computeNext() {
                        return this.computeNext();
                    }
                };
            }
        };
    }

    @Override
    public /* synthetic */ Vec3i crossProduct(Vec3i p_crossProduct_1_) {
        return this.crossProduct(p_crossProduct_1_);
    }

    static {
        NUM_Z_BITS = NUM_X_BITS = 1 + MathHelper.log2(MathHelper.smallestEncompassingPowerOfTwo(30000000));
        NUM_Y_BITS = 64 - NUM_X_BITS - NUM_Z_BITS;
        Y_SHIFT = 0 + NUM_Z_BITS;
        X_SHIFT = Y_SHIFT + NUM_Y_BITS;
        X_MASK = (1L << NUM_X_BITS) - 1L;
        Y_MASK = (1L << NUM_Y_BITS) - 1L;
        Z_MASK = (1L << NUM_Z_BITS) - 1L;
    }

    public static final class PooledMutableBlockPos
    extends MutableBlockPos {
        private boolean released;
        private static final List<PooledMutableBlockPos> POOL = Lists.newArrayList();

        private PooledMutableBlockPos(int p_i46586_1_, int p_i46586_2_, int p_i46586_3_) {
            super(p_i46586_1_, p_i46586_2_, p_i46586_3_);
        }

        public static PooledMutableBlockPos retain() {
            return PooledMutableBlockPos.retain(0, 0, 0);
        }

        public static PooledMutableBlockPos retain(double p_retain_0_, double p_retain_2_, double p_retain_4_) {
            return PooledMutableBlockPos.retain(MathHelper.floor(p_retain_0_), MathHelper.floor(p_retain_2_), MathHelper.floor(p_retain_4_));
        }

        @SideOnly(value=Side.CLIENT)
        public static PooledMutableBlockPos retain(Vec3i p_retain_0_) {
            return PooledMutableBlockPos.retain(p_retain_0_.getX(), p_retain_0_.getY(), p_retain_0_.getZ());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PooledMutableBlockPos retain(int p_retain_0_, int p_retain_1_, int p_retain_2_) {
            List<PooledMutableBlockPos> list = POOL;
            synchronized (list) {
                PooledMutableBlockPos lvt_4_1_;
                if (!POOL.isEmpty() && (lvt_4_1_ = POOL.remove(POOL.size() - 1)) != null && lvt_4_1_.released) {
                    lvt_4_1_.released = false;
                    lvt_4_1_.setPos(p_retain_0_, p_retain_1_, p_retain_2_);
                    return lvt_4_1_;
                }
            }
            return new PooledMutableBlockPos(p_retain_0_, p_retain_1_, p_retain_2_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            List<PooledMutableBlockPos> list = POOL;
            synchronized (list) {
                if (POOL.size() < 100) {
                    POOL.add(this);
                }
                this.released = true;
            }
        }

        @Override
        public PooledMutableBlockPos setPos(int p_setPos_1_, int p_setPos_2_, int p_setPos_3_) {
            if (this.released) {
                LOGGER.error("PooledMutableBlockPosition modified after it was released.", new Throwable());
                this.released = false;
            }
            return (PooledMutableBlockPos)super.setPos(p_setPos_1_, p_setPos_2_, p_setPos_3_);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public PooledMutableBlockPos setPos(Entity p_setPos_1_) {
            return (PooledMutableBlockPos)super.setPos(p_setPos_1_);
        }

        @Override
        public PooledMutableBlockPos setPos(double p_setPos_1_, double p_setPos_3_, double p_setPos_5_) {
            return (PooledMutableBlockPos)super.setPos(p_setPos_1_, p_setPos_3_, p_setPos_5_);
        }

        @Override
        public PooledMutableBlockPos setPos(Vec3i p_setPos_1_) {
            return (PooledMutableBlockPos)super.setPos(p_setPos_1_);
        }

        @Override
        public PooledMutableBlockPos move(EnumFacing p_move_1_) {
            return (PooledMutableBlockPos)super.move(p_move_1_);
        }

        @Override
        public PooledMutableBlockPos move(EnumFacing p_move_1_, int p_move_2_) {
            return (PooledMutableBlockPos)super.move(p_move_1_, p_move_2_);
        }

        @Override
        public /* synthetic */ MutableBlockPos move(EnumFacing p_move_1_, int p_move_2_) {
            return this.move(p_move_1_, p_move_2_);
        }

        @Override
        public /* synthetic */ MutableBlockPos move(EnumFacing p_move_1_) {
            return this.move(p_move_1_);
        }

        @Override
        public /* synthetic */ MutableBlockPos setPos(Vec3i p_setPos_1_) {
            return this.setPos(p_setPos_1_);
        }

        @Override
        public /* synthetic */ MutableBlockPos setPos(double p_setPos_1_, double p_setPos_3_, double p_setPos_5_) {
            return this.setPos(p_setPos_1_, p_setPos_3_, p_setPos_5_);
        }

        @Override
        public /* synthetic */ MutableBlockPos setPos(int p_setPos_1_, int p_setPos_2_, int p_setPos_3_) {
            return this.setPos(p_setPos_1_, p_setPos_2_, p_setPos_3_);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public /* synthetic */ MutableBlockPos setPos(Entity p_setPos_1_) {
            return this.setPos(p_setPos_1_);
        }
    }

    public static class MutableBlockPos
    extends BlockPos {
        protected int x;
        protected int y;
        protected int z;

        public MutableBlockPos() {
            this(0, 0, 0);
        }

        public MutableBlockPos(BlockPos p_i46587_1_) {
            this(p_i46587_1_.getX(), p_i46587_1_.getY(), p_i46587_1_.getZ());
        }

        public MutableBlockPos(int p_i46024_1_, int p_i46024_2_, int p_i46024_3_) {
            super(0, 0, 0);
            this.x = p_i46024_1_;
            this.y = p_i46024_2_;
            this.z = p_i46024_3_;
        }

        @Override
        public BlockPos add(double p_add_1_, double p_add_3_, double p_add_5_) {
            return super.add(p_add_1_, p_add_3_, p_add_5_).toImmutable();
        }

        @Override
        public BlockPos add(int p_add_1_, int p_add_2_, int p_add_3_) {
            return super.add(p_add_1_, p_add_2_, p_add_3_).toImmutable();
        }

        @Override
        public BlockPos offset(EnumFacing p_offset_1_, int p_offset_2_) {
            return super.offset(p_offset_1_, p_offset_2_).toImmutable();
        }

        @Override
        public BlockPos rotate(Rotation p_rotate_1_) {
            return super.rotate(p_rotate_1_).toImmutable();
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getZ() {
            return this.z;
        }

        public MutableBlockPos setPos(int p_setPos_1_, int p_setPos_2_, int p_setPos_3_) {
            this.x = p_setPos_1_;
            this.y = p_setPos_2_;
            this.z = p_setPos_3_;
            return this;
        }

        public MutableBlockPos setPos(double p_setPos_1_, double p_setPos_3_, double p_setPos_5_) {
            return this.setPos(MathHelper.floor(p_setPos_1_), MathHelper.floor(p_setPos_3_), MathHelper.floor(p_setPos_5_));
        }

        @SideOnly(value=Side.CLIENT)
        public MutableBlockPos setPos(Entity p_setPos_1_) {
            return this.setPos(p_setPos_1_.posX, p_setPos_1_.posY, p_setPos_1_.posZ);
        }

        public MutableBlockPos setPos(Vec3i p_setPos_1_) {
            return this.setPos(p_setPos_1_.getX(), p_setPos_1_.getY(), p_setPos_1_.getZ());
        }

        public MutableBlockPos move(EnumFacing p_move_1_) {
            return this.move(p_move_1_, 1);
        }

        public MutableBlockPos move(EnumFacing p_move_1_, int p_move_2_) {
            return this.setPos(this.x + p_move_1_.getFrontOffsetX() * p_move_2_, this.y + p_move_1_.getFrontOffsetY() * p_move_2_, this.z + p_move_1_.getFrontOffsetZ() * p_move_2_);
        }

        public void setY(int p_setY_1_) {
            this.y = p_setY_1_;
        }

        @Override
        public BlockPos toImmutable() {
            return new BlockPos(this);
        }

        @Override
        public /* synthetic */ Vec3i crossProduct(Vec3i p_crossProduct_1_) {
            return super.crossProduct(p_crossProduct_1_);
        }
    }
}

