/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Cartesian {
    public static <T> Iterable<T[]> cartesianProduct(Class<T> p_cartesianProduct_0_, Iterable<? extends Iterable<? extends T>> p_cartesianProduct_1_) {
        return new Product(p_cartesianProduct_0_, Cartesian.toArray(Iterable.class, p_cartesianProduct_1_));
    }

    public static <T> Iterable<List<T>> cartesianProduct(Iterable<? extends Iterable<? extends T>> p_cartesianProduct_0_) {
        return Cartesian.arraysAsLists(Cartesian.cartesianProduct(Object.class, p_cartesianProduct_0_));
    }

    private static <T> Iterable<List<T>> arraysAsLists(Iterable<Object[]> p_arraysAsLists_0_) {
        return Iterables.transform(p_arraysAsLists_0_, new GetList());
    }

    private static <T> T[] toArray(Class<? super T> p_toArray_0_, Iterable<? extends T> p_toArray_1_) {
        ArrayList lvt_2_1_ = Lists.newArrayList();
        for (T lvt_4_1_ : p_toArray_1_) {
            lvt_2_1_.add(lvt_4_1_);
        }
        return lvt_2_1_.toArray(Cartesian.createArray(p_toArray_0_, lvt_2_1_.size()));
    }

    private static <T> T[] createArray(Class<? super T> p_createArray_0_, int p_createArray_1_) {
        return (Object[])Array.newInstance(p_createArray_0_, p_createArray_1_);
    }

    static class Product<T>
    implements Iterable<T[]> {
        private final Class<T> clazz;
        private final Iterable<? extends T>[] iterables;

        private Product(Class<T> p_i46020_1_, Iterable<? extends T>[] p_i46020_2_) {
            this.clazz = p_i46020_1_;
            this.iterables = p_i46020_2_;
        }

        @Override
        public Iterator<T[]> iterator() {
            if (this.iterables.length <= 0) {
                return Collections.singletonList(Cartesian.createArray(this.clazz, 0)).iterator();
            }
            return new ProductIterator(this.clazz, this.iterables);
        }

        static class ProductIterator<T>
        extends UnmodifiableIterator<T[]> {
            private int index = -2;
            private final Iterable<? extends T>[] iterables;
            private final Iterator<? extends T>[] iterators;
            private final T[] results;

            private ProductIterator(Class<T> p_i46018_1_, Iterable<? extends T>[] p_i46018_2_) {
                this.iterables = p_i46018_2_;
                this.iterators = (Iterator[])Cartesian.createArray(Iterator.class, this.iterables.length);
                for (int lvt_3_1_ = 0; lvt_3_1_ < this.iterables.length; ++lvt_3_1_) {
                    this.iterators[lvt_3_1_] = p_i46018_2_[lvt_3_1_].iterator();
                }
                this.results = Cartesian.createArray(p_i46018_1_, this.iterators.length);
            }

            private void endOfData() {
                this.index = -1;
                Arrays.fill(this.iterators, null);
                Arrays.fill(this.results, null);
            }

            public boolean hasNext() {
                if (this.index == -2) {
                    this.index = 0;
                    for (Iterator<T> iterator : this.iterators) {
                        if (iterator.hasNext()) continue;
                        this.endOfData();
                        break;
                    }
                    return true;
                }
                if (this.index >= this.iterators.length) {
                    Iterator<T> lvt_1_1_;
                    this.index = this.iterators.length - 1;
                    while (this.index >= 0 && !(lvt_1_1_ = this.iterators[this.index]).hasNext()) {
                        if (this.index == 0) {
                            this.endOfData();
                            break;
                        }
                        lvt_1_1_ = this.iterables[this.index].iterator();
                        this.iterators[this.index] = lvt_1_1_;
                        if (!lvt_1_1_.hasNext()) {
                            this.endOfData();
                            break;
                        }
                        --this.index;
                    }
                }
                return this.index >= 0;
            }

            public T[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                while (this.index < this.iterators.length) {
                    this.results[this.index] = this.iterators[this.index].next();
                    ++this.index;
                }
                return (Object[])this.results.clone();
            }

            public /* synthetic */ Object next() {
                return this.next();
            }
        }
    }

    static class GetList<T>
    implements Function<Object[], List<T>> {
        private GetList() {
        }

        public List<T> apply(Object[] p_apply_1_) {
            return Arrays.asList(p_apply_1_);
        }

        public /* synthetic */ Object apply(Object p_apply_1_) {
            return this.apply((Object[])p_apply_1_);
        }
    }
}

