/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;

public class ChunkPos {
    public final int chunkXPos;
    public final int chunkZPos;

    public ChunkPos(int p_i1947_1_, int p_i1947_2_) {
        this.chunkXPos = p_i1947_1_;
        this.chunkZPos = p_i1947_2_;
    }

    public ChunkPos(BlockPos p_i46717_1_) {
        this.chunkXPos = p_i46717_1_.getX() >> 4;
        this.chunkZPos = p_i46717_1_.getZ() >> 4;
    }

    public static long asLong(int p_asLong_0_, int p_asLong_1_) {
        return (long)p_asLong_0_ & 0xFFFFFFFFL | ((long)p_asLong_1_ & 0xFFFFFFFFL) << 32;
    }

    public int hashCode() {
        int lvt_1_1_ = 1664525 * this.chunkXPos + 1013904223;
        int lvt_2_1_ = 1664525 * (this.chunkZPos ^ 0xDEADBEEF) + 1013904223;
        return lvt_1_1_ ^ lvt_2_1_;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof ChunkPos) {
            ChunkPos lvt_2_1_ = (ChunkPos)p_equals_1_;
            return this.chunkXPos == lvt_2_1_.chunkXPos && this.chunkZPos == lvt_2_1_.chunkZPos;
        }
        return false;
    }

    public double getDistanceSq(Entity p_getDistanceSq_1_) {
        double lvt_2_1_ = this.chunkXPos * 16 + 8;
        double lvt_4_1_ = this.chunkZPos * 16 + 8;
        double lvt_6_1_ = lvt_2_1_ - p_getDistanceSq_1_.posX;
        double lvt_8_1_ = lvt_4_1_ - p_getDistanceSq_1_.posZ;
        return lvt_6_1_ * lvt_6_1_ + lvt_8_1_ * lvt_8_1_;
    }

    public int getXStart() {
        return this.chunkXPos << 4;
    }

    public int getZStart() {
        return this.chunkZPos << 4;
    }

    public int getXEnd() {
        return (this.chunkXPos << 4) + 15;
    }

    public int getZEnd() {
        return (this.chunkZPos << 4) + 15;
    }

    public BlockPos getBlock(int p_getBlock_1_, int p_getBlock_2_, int p_getBlock_3_) {
        return new BlockPos((this.chunkXPos << 4) + p_getBlock_1_, p_getBlock_2_, (this.chunkZPos << 4) + p_getBlock_3_);
    }

    public String toString() {
        return "[" + this.chunkXPos + ", " + this.chunkZPos + "]";
    }
}

