/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3i;

public class Vec3d {
    public static final Vec3d ZERO = new Vec3d(0.0, 0.0, 0.0);
    public final double xCoord;
    public final double yCoord;
    public final double zCoord;

    public Vec3d(double p_i47092_1_, double p_i47092_3_, double p_i47092_5_) {
        if (p_i47092_1_ == -0.0) {
            p_i47092_1_ = 0.0;
        }
        if (p_i47092_3_ == -0.0) {
            p_i47092_3_ = 0.0;
        }
        if (p_i47092_5_ == -0.0) {
            p_i47092_5_ = 0.0;
        }
        this.xCoord = p_i47092_1_;
        this.yCoord = p_i47092_3_;
        this.zCoord = p_i47092_5_;
    }

    public Vec3d(Vec3i p_i47093_1_) {
        this(p_i47093_1_.getX(), p_i47093_1_.getY(), p_i47093_1_.getZ());
    }

    public Vec3d subtractReverse(Vec3d p_subtractReverse_1_) {
        return new Vec3d(p_subtractReverse_1_.xCoord - this.xCoord, p_subtractReverse_1_.yCoord - this.yCoord, p_subtractReverse_1_.zCoord - this.zCoord);
    }

    public Vec3d normalize() {
        double d0 = MathHelper.sqrt(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord);
        return d0 < 1.0E-4 ? ZERO : new Vec3d(this.xCoord / d0, this.yCoord / d0, this.zCoord / d0);
    }

    public double dotProduct(Vec3d p_dotProduct_1_) {
        return this.xCoord * p_dotProduct_1_.xCoord + this.yCoord * p_dotProduct_1_.yCoord + this.zCoord * p_dotProduct_1_.zCoord;
    }

    public Vec3d crossProduct(Vec3d p_crossProduct_1_) {
        return new Vec3d(this.yCoord * p_crossProduct_1_.zCoord - this.zCoord * p_crossProduct_1_.yCoord, this.zCoord * p_crossProduct_1_.xCoord - this.xCoord * p_crossProduct_1_.zCoord, this.xCoord * p_crossProduct_1_.yCoord - this.yCoord * p_crossProduct_1_.xCoord);
    }

    public Vec3d subtract(Vec3d p_subtract_1_) {
        return this.subtract(p_subtract_1_.xCoord, p_subtract_1_.yCoord, p_subtract_1_.zCoord);
    }

    public Vec3d subtract(double p_subtract_1_, double p_subtract_3_, double p_subtract_5_) {
        return this.addVector(-p_subtract_1_, -p_subtract_3_, -p_subtract_5_);
    }

    public Vec3d add(Vec3d p_add_1_) {
        return this.addVector(p_add_1_.xCoord, p_add_1_.yCoord, p_add_1_.zCoord);
    }

    public Vec3d addVector(double p_addVector_1_, double p_addVector_3_, double p_addVector_5_) {
        return new Vec3d(this.xCoord + p_addVector_1_, this.yCoord + p_addVector_3_, this.zCoord + p_addVector_5_);
    }

    public double distanceTo(Vec3d p_distanceTo_1_) {
        double d0 = p_distanceTo_1_.xCoord - this.xCoord;
        double d1 = p_distanceTo_1_.yCoord - this.yCoord;
        double d2 = p_distanceTo_1_.zCoord - this.zCoord;
        return MathHelper.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    public double squareDistanceTo(Vec3d p_squareDistanceTo_1_) {
        double d0 = p_squareDistanceTo_1_.xCoord - this.xCoord;
        double d1 = p_squareDistanceTo_1_.yCoord - this.yCoord;
        double d2 = p_squareDistanceTo_1_.zCoord - this.zCoord;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double squareDistanceTo(double p_squareDistanceTo_1_, double p_squareDistanceTo_3_, double p_squareDistanceTo_5_) {
        double d0 = p_squareDistanceTo_1_ - this.xCoord;
        double d1 = p_squareDistanceTo_3_ - this.yCoord;
        double d2 = p_squareDistanceTo_5_ - this.zCoord;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public Vec3d scale(double p_scale_1_) {
        return new Vec3d(this.xCoord * p_scale_1_, this.yCoord * p_scale_1_, this.zCoord * p_scale_1_);
    }

    public double lengthVector() {
        return MathHelper.sqrt(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord);
    }

    public double lengthSquared() {
        return this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord;
    }

    @Nullable
    public Vec3d getIntermediateWithXValue(Vec3d p_getIntermediateWithXValue_1_, double p_getIntermediateWithXValue_2_) {
        double d0 = p_getIntermediateWithXValue_1_.xCoord - this.xCoord;
        double d1 = p_getIntermediateWithXValue_1_.yCoord - this.yCoord;
        double d2 = p_getIntermediateWithXValue_1_.zCoord - this.zCoord;
        if (d0 * d0 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (p_getIntermediateWithXValue_2_ - this.xCoord) / d0;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vec3d(this.xCoord + d0 * d3, this.yCoord + d1 * d3, this.zCoord + d2 * d3) : null;
    }

    @Nullable
    public Vec3d getIntermediateWithYValue(Vec3d p_getIntermediateWithYValue_1_, double p_getIntermediateWithYValue_2_) {
        double d0 = p_getIntermediateWithYValue_1_.xCoord - this.xCoord;
        double d1 = p_getIntermediateWithYValue_1_.yCoord - this.yCoord;
        double d2 = p_getIntermediateWithYValue_1_.zCoord - this.zCoord;
        if (d1 * d1 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (p_getIntermediateWithYValue_2_ - this.yCoord) / d1;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vec3d(this.xCoord + d0 * d3, this.yCoord + d1 * d3, this.zCoord + d2 * d3) : null;
    }

    @Nullable
    public Vec3d getIntermediateWithZValue(Vec3d p_getIntermediateWithZValue_1_, double p_getIntermediateWithZValue_2_) {
        double d0 = p_getIntermediateWithZValue_1_.xCoord - this.xCoord;
        double d1 = p_getIntermediateWithZValue_1_.yCoord - this.yCoord;
        double d2 = p_getIntermediateWithZValue_1_.zCoord - this.zCoord;
        if (d2 * d2 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (p_getIntermediateWithZValue_2_ - this.zCoord) / d2;
        return d3 >= 0.0 && d3 <= 1.0 ? new Vec3d(this.xCoord + d0 * d3, this.yCoord + d1 * d3, this.zCoord + d2 * d3) : null;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Vec3d)) {
            return false;
        }
        Vec3d vec3d = (Vec3d)p_equals_1_;
        return Double.compare(vec3d.xCoord, this.xCoord) != 0 ? false : (Double.compare(vec3d.yCoord, this.yCoord) != 0 ? false : Double.compare(vec3d.zCoord, this.zCoord) == 0);
    }

    public int hashCode() {
        long j = Double.doubleToLongBits(this.xCoord);
        int i = (int)(j ^ j >>> 32);
        j = Double.doubleToLongBits(this.yCoord);
        i = 31 * i + (int)(j ^ j >>> 32);
        j = Double.doubleToLongBits(this.zCoord);
        i = 31 * i + (int)(j ^ j >>> 32);
        return i;
    }

    public String toString() {
        return "(" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + ")";
    }

    public Vec3d rotatePitch(float p_rotatePitch_1_) {
        float f = MathHelper.cos(p_rotatePitch_1_);
        float f1 = MathHelper.sin(p_rotatePitch_1_);
        double d0 = this.xCoord;
        double d1 = this.yCoord * (double)f + this.zCoord * (double)f1;
        double d2 = this.zCoord * (double)f - this.yCoord * (double)f1;
        return new Vec3d(d0, d1, d2);
    }

    public Vec3d rotateYaw(float p_rotateYaw_1_) {
        float f = MathHelper.cos(p_rotateYaw_1_);
        float f1 = MathHelper.sin(p_rotateYaw_1_);
        double d0 = this.xCoord * (double)f + this.zCoord * (double)f1;
        double d1 = this.yCoord;
        double d2 = this.zCoord * (double)f - this.xCoord * (double)f1;
        return new Vec3d(d0, d1, d2);
    }

    public static Vec3d fromPitchYawVector(Vec2f p_fromPitchYawVector_0_) {
        return Vec3d.fromPitchYaw(p_fromPitchYawVector_0_.x, p_fromPitchYawVector_0_.y);
    }

    public static Vec3d fromPitchYaw(float p_fromPitchYaw_0_, float p_fromPitchYaw_1_) {
        float f = MathHelper.cos(-p_fromPitchYaw_1_ * ((float)Math.PI / 180) - (float)Math.PI);
        float f1 = MathHelper.sin(-p_fromPitchYaw_1_ * ((float)Math.PI / 180) - (float)Math.PI);
        float f2 = -MathHelper.cos(-p_fromPitchYaw_0_ * ((float)Math.PI / 180));
        float f3 = MathHelper.sin(-p_fromPitchYaw_0_ * ((float)Math.PI / 180));
        return new Vec3d(f1 * f2, f3, f * f2);
    }
}

