/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import com.google.common.base.Objects;
import javax.annotation.concurrent.Immutable;
import net.minecraft.util.math.MathHelper;

@Immutable
public class Vec3i
implements Comparable<Vec3i> {
    public static final Vec3i NULL_VECTOR = new Vec3i(0, 0, 0);
    private final int x;
    private final int y;
    private final int z;

    public Vec3i(int p_i46007_1_, int p_i46007_2_, int p_i46007_3_) {
        this.x = p_i46007_1_;
        this.y = p_i46007_2_;
        this.z = p_i46007_3_;
    }

    public Vec3i(double p_i46008_1_, double p_i46008_3_, double p_i46008_5_) {
        this(MathHelper.floor(p_i46008_1_), MathHelper.floor(p_i46008_3_), MathHelper.floor(p_i46008_5_));
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Vec3i)) {
            return false;
        }
        Vec3i lvt_2_1_ = (Vec3i)p_equals_1_;
        if (this.getX() != lvt_2_1_.getX()) {
            return false;
        }
        if (this.getY() != lvt_2_1_.getY()) {
            return false;
        }
        return this.getZ() == lvt_2_1_.getZ();
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    @Override
    public int compareTo(Vec3i p_compareTo_1_) {
        if (this.getY() == p_compareTo_1_.getY()) {
            if (this.getZ() == p_compareTo_1_.getZ()) {
                return this.getX() - p_compareTo_1_.getX();
            }
            return this.getZ() - p_compareTo_1_.getZ();
        }
        return this.getY() - p_compareTo_1_.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Vec3i crossProduct(Vec3i p_crossProduct_1_) {
        return new Vec3i(this.getY() * p_crossProduct_1_.getZ() - this.getZ() * p_crossProduct_1_.getY(), this.getZ() * p_crossProduct_1_.getX() - this.getX() * p_crossProduct_1_.getZ(), this.getX() * p_crossProduct_1_.getY() - this.getY() * p_crossProduct_1_.getX());
    }

    public double getDistance(int p_getDistance_1_, int p_getDistance_2_, int p_getDistance_3_) {
        double lvt_4_1_ = this.getX() - p_getDistance_1_;
        double lvt_6_1_ = this.getY() - p_getDistance_2_;
        double lvt_8_1_ = this.getZ() - p_getDistance_3_;
        return Math.sqrt(lvt_4_1_ * lvt_4_1_ + lvt_6_1_ * lvt_6_1_ + lvt_8_1_ * lvt_8_1_);
    }

    public double distanceSq(double p_distanceSq_1_, double p_distanceSq_3_, double p_distanceSq_5_) {
        double lvt_7_1_ = (double)this.getX() - p_distanceSq_1_;
        double lvt_9_1_ = (double)this.getY() - p_distanceSq_3_;
        double lvt_11_1_ = (double)this.getZ() - p_distanceSq_5_;
        return lvt_7_1_ * lvt_7_1_ + lvt_9_1_ * lvt_9_1_ + lvt_11_1_ * lvt_11_1_;
    }

    public double distanceSqToCenter(double p_distanceSqToCenter_1_, double p_distanceSqToCenter_3_, double p_distanceSqToCenter_5_) {
        double lvt_7_1_ = (double)this.getX() + 0.5 - p_distanceSqToCenter_1_;
        double lvt_9_1_ = (double)this.getY() + 0.5 - p_distanceSqToCenter_3_;
        double lvt_11_1_ = (double)this.getZ() + 0.5 - p_distanceSqToCenter_5_;
        return lvt_7_1_ * lvt_7_1_ + lvt_9_1_ * lvt_9_1_ + lvt_11_1_ * lvt_11_1_;
    }

    public double distanceSq(Vec3i p_distanceSq_1_) {
        return this.distanceSq(p_distanceSq_1_.getX(), p_distanceSq_1_.getY(), p_distanceSq_1_.getZ());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("x", this.getX()).add("y", this.getY()).add("z", this.getZ()).toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object p_compareTo_1_) {
        return this.compareTo((Vec3i)p_compareTo_1_);
    }
}

