/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.registry.RegistrySimple;

public class RegistryNamespaced<K, V>
extends RegistrySimple<K, V>
implements IObjectIntIterable<V> {
    protected final IntIdentityHashBiMap<V> underlyingIntegerMap = new IntIdentityHashBiMap(256);
    protected final Map<V, K> inverseObjectRegistry = ((BiMap)this.registryObjects).inverse();

    public void register(int p_register_1_, K p_register_2_, V p_register_3_) {
        this.underlyingIntegerMap.put(p_register_3_, p_register_1_);
        this.putObject(p_register_2_, p_register_3_);
    }

    @Override
    protected Map<K, V> createUnderlyingMap() {
        return HashBiMap.create();
    }

    @Override
    @Nullable
    public V getObject(K p_getObject_1_) {
        return super.getObject(p_getObject_1_);
    }

    @Nullable
    public K getNameForObject(V p_getNameForObject_1_) {
        return this.inverseObjectRegistry.get(p_getNameForObject_1_);
    }

    @Override
    public boolean containsKey(K p_containsKey_1_) {
        return super.containsKey(p_containsKey_1_);
    }

    public int getIDForObject(V p_getIDForObject_1_) {
        return this.underlyingIntegerMap.getId(p_getIDForObject_1_);
    }

    @Nullable
    public V getObjectById(int p_getObjectById_1_) {
        return this.underlyingIntegerMap.get(p_getObjectById_1_);
    }

    @Override
    public Iterator<V> iterator() {
        return this.underlyingIntegerMap.iterator();
    }
}

