/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.registry.RegistryNamespaced;
import org.apache.commons.lang3.Validate;

public class RegistryNamespacedDefaultedByKey<K, V>
extends RegistryNamespaced<K, V> {
    private final K defaultValueKey;
    private V defaultValue;

    public RegistryNamespacedDefaultedByKey(K p_i46017_1_) {
        this.defaultValueKey = p_i46017_1_;
    }

    @Override
    public void register(int p_register_1_, K p_register_2_, V p_register_3_) {
        if (this.defaultValueKey.equals(p_register_2_)) {
            this.defaultValue = p_register_3_;
        }
        super.register(p_register_1_, p_register_2_, p_register_3_);
    }

    public void validateKey() {
        Validate.notNull(this.defaultValue, (String)("Missing default of DefaultedMappedRegistry: " + this.defaultValueKey), (Object[])new Object[0]);
    }

    @Override
    public int getIDForObject(V p_getIDForObject_1_) {
        int i = super.getIDForObject(p_getIDForObject_1_);
        return i == -1 ? super.getIDForObject(this.defaultValue) : i;
    }

    @Override
    @Nonnull
    public K getNameForObject(V p_getNameForObject_1_) {
        Object k = super.getNameForObject(p_getNameForObject_1_);
        return k == null ? this.defaultValueKey : k;
    }

    @Override
    @Nonnull
    public V getObject(K p_getObject_1_) {
        Object v = super.getObject(p_getObject_1_);
        return v == null ? this.defaultValue : v;
    }

    @Override
    @Nonnull
    public V getObjectById(int p_getObjectById_1_) {
        Object v = super.getObjectById(p_getObjectById_1_);
        return v == null ? this.defaultValue : v;
    }

    @Override
    @Nonnull
    public V getRandomObject(Random p_getRandomObject_1_) {
        Object v = super.getRandomObject(p_getRandomObject_1_);
        return v == null ? this.defaultValue : v;
    }

    public int getIDForObjectBypass(V p_getIDForObjectBypass_1_) {
        return super.getIDForObject(p_getIDForObjectBypass_1_);
    }

    @Nullable
    public K getNameForObjectBypass(V p_getNameForObjectBypass_1_) {
        return super.getNameForObject(p_getNameForObjectBypass_1_);
    }

    @Nullable
    public V getObjectBypass(K p_getObjectBypass_1_) {
        return super.getObject(p_getObjectBypass_1_);
    }

    @Nullable
    public V getObjectByIdBypass(int p_getObjectByIdBypass_1_) {
        return super.getObjectById(p_getObjectByIdBypass_1_);
    }
}

