/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.registry.IRegistry;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistrySimple<K, V>
implements IRegistry<K, V> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Map<K, V> registryObjects = this.createUnderlyingMap();
    private Object[] values;

    protected Map<K, V> createUnderlyingMap() {
        return Maps.newHashMap();
    }

    @Override
    @Nullable
    public V getObject(K p_getObject_1_) {
        return this.registryObjects.get(p_getObject_1_);
    }

    @Override
    public void putObject(K p_putObject_1_, V p_putObject_2_) {
        Validate.notNull(p_putObject_1_);
        Validate.notNull(p_putObject_2_);
        this.values = null;
        if (this.registryObjects.containsKey(p_putObject_1_)) {
            LOGGER.debug("Adding duplicate key '{}' to registry", new Object[]{p_putObject_1_});
        }
        this.registryObjects.put(p_putObject_1_, p_putObject_2_);
    }

    @Override
    public Set<K> getKeys() {
        return Collections.unmodifiableSet(this.registryObjects.keySet());
    }

    @Nullable
    public V getRandomObject(Random p_getRandomObject_1_) {
        if (this.values == null) {
            Collection<V> lvt_2_1_ = this.registryObjects.values();
            if (lvt_2_1_.isEmpty()) {
                return null;
            }
            this.values = lvt_2_1_.toArray(new Object[lvt_2_1_.size()]);
        }
        return (V)this.values[p_getRandomObject_1_.nextInt(this.values.length)];
    }

    public boolean containsKey(K p_containsKey_1_) {
        return this.registryObjects.containsKey(p_containsKey_1_);
    }

    @Override
    public Iterator<V> iterator() {
        return this.registryObjects.values().iterator();
    }
}

