/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import net.minecraft.command.ICommandSender;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentBase;

public class TextComponentScore
extends TextComponentBase {
    private final String name;
    private final String objective;
    private String value = "";

    public TextComponentScore(String p_i45997_1_, String p_i45997_2_) {
        this.name = p_i45997_1_;
        this.objective = p_i45997_2_;
    }

    public String getName() {
        return this.name;
    }

    public String getObjective() {
        return this.objective;
    }

    public void setValue(String p_setValue_1_) {
        this.value = p_setValue_1_;
    }

    @Override
    public String getUnformattedComponentText() {
        return this.value;
    }

    public void resolve(ICommandSender p_resolve_1_) {
        MinecraftServer lvt_2_1_ = p_resolve_1_.getServer();
        if (lvt_2_1_ != null && lvt_2_1_.isAnvilFileSet() && StringUtils.isNullOrEmpty(this.value)) {
            ScoreObjective lvt_4_1_;
            Scoreboard lvt_3_1_ = lvt_2_1_.worldServerForDimension(0).getScoreboard();
            if (lvt_3_1_.entityHasObjective(this.name, lvt_4_1_ = lvt_3_1_.getObjective(this.objective))) {
                Score lvt_5_1_ = lvt_3_1_.getOrCreateScore(this.name, lvt_4_1_);
                this.setValue(String.format("%d", lvt_5_1_.getScorePoints()));
            } else {
                this.value = "";
            }
        }
    }

    @Override
    public TextComponentScore createCopy() {
        TextComponentScore lvt_1_1_ = new TextComponentScore(this.name, this.objective);
        lvt_1_1_.setValue(this.value);
        lvt_1_1_.setStyle(this.getStyle().createShallowCopy());
        for (ITextComponent lvt_3_1_ : this.getSiblings()) {
            lvt_1_1_.appendSibling(lvt_3_1_.createCopy());
        }
        return lvt_1_1_;
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof TextComponentScore) {
            TextComponentScore lvt_2_1_ = (TextComponentScore)p_equals_1_;
            return this.name.equals(lvt_2_1_.name) && this.objective.equals(lvt_2_1_.objective) && super.equals(p_equals_1_);
        }
        return false;
    }

    @Override
    public String toString() {
        return "ScoreComponent{name='" + this.name + '\'' + "objective='" + this.objective + '\'' + ", siblings=" + this.siblings + ", style=" + this.getStyle() + '}';
    }

    @Override
    public /* synthetic */ ITextComponent createCopy() {
        return this.createCopy();
    }
}

