/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslationFormatException;
import net.minecraft.util.text.translation.I18n;

public class TextComponentTranslation
extends TextComponentBase {
    private final String key;
    private final Object[] formatArgs;
    private final Object syncLock = new Object();
    private long lastTranslationUpdateTimeInMilliseconds = -1L;
    @VisibleForTesting
    List<ITextComponent> children = Lists.newArrayList();
    public static final Pattern STRING_VARIABLE_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TextComponentTranslation(String p_i45160_1_, Object ... p_i45160_2_) {
        this.key = p_i45160_1_;
        this.formatArgs = p_i45160_2_;
        for (Object lvt_6_1_ : p_i45160_2_) {
            if (!(lvt_6_1_ instanceof ITextComponent)) continue;
            ((ITextComponent)lvt_6_1_).getStyle().setParentStyle(this.getStyle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    synchronized void ensureInitialized() {
        Object object = this.syncLock;
        synchronized (object) {
            long lvt_2_1_ = I18n.getLastTranslationUpdateTimeInMilliseconds();
            if (lvt_2_1_ == this.lastTranslationUpdateTimeInMilliseconds) {
                return;
            }
            this.lastTranslationUpdateTimeInMilliseconds = lvt_2_1_;
            this.children.clear();
        }
        try {
            this.initializeFromFormat(I18n.translateToLocal(this.key));
        }
        catch (TextComponentTranslationFormatException lvt_1_1_) {
            this.children.clear();
            try {
                this.initializeFromFormat(I18n.translateToFallback(this.key));
            }
            catch (TextComponentTranslationFormatException lvt_2_2_) {
                throw lvt_1_1_;
            }
        }
    }

    protected void initializeFromFormat(String p_initializeFromFormat_1_) {
        boolean lvt_2_1_ = false;
        Matcher lvt_3_1_ = STRING_VARIABLE_PATTERN.matcher(p_initializeFromFormat_1_);
        int lvt_4_1_ = 0;
        int lvt_5_1_ = 0;
        try {
            while (lvt_3_1_.find(lvt_5_1_)) {
                int lvt_6_1_ = lvt_3_1_.start();
                int lvt_7_1_ = lvt_3_1_.end();
                if (lvt_6_1_ > lvt_5_1_) {
                    TextComponentString lvt_8_1_ = new TextComponentString(String.format(p_initializeFromFormat_1_.substring(lvt_5_1_, lvt_6_1_), new Object[0]));
                    lvt_8_1_.getStyle().setParentStyle(this.getStyle());
                    this.children.add(lvt_8_1_);
                }
                String lvt_8_2_ = lvt_3_1_.group(2);
                String lvt_9_1_ = p_initializeFromFormat_1_.substring(lvt_6_1_, lvt_7_1_);
                if ("%".equals(lvt_8_2_) && "%%".equals(lvt_9_1_)) {
                    TextComponentString lvt_10_1_ = new TextComponentString("%");
                    lvt_10_1_.getStyle().setParentStyle(this.getStyle());
                    this.children.add(lvt_10_1_);
                } else if ("s".equals(lvt_8_2_)) {
                    int lvt_11_1_;
                    String lvt_10_2_ = lvt_3_1_.group(1);
                    int n = lvt_11_1_ = lvt_10_2_ != null ? Integer.parseInt(lvt_10_2_) - 1 : lvt_4_1_++;
                    if (lvt_11_1_ < this.formatArgs.length) {
                        this.children.add(this.getFormatArgumentAsComponent(lvt_11_1_));
                    }
                } else {
                    throw new TextComponentTranslationFormatException(this, "Unsupported format: '" + lvt_9_1_ + "'");
                }
                lvt_5_1_ = lvt_7_1_;
            }
            if (lvt_5_1_ < p_initializeFromFormat_1_.length()) {
                TextComponentString lvt_6_2_ = new TextComponentString(String.format(p_initializeFromFormat_1_.substring(lvt_5_1_), new Object[0]));
                lvt_6_2_.getStyle().setParentStyle(this.getStyle());
                this.children.add(lvt_6_2_);
            }
        }
        catch (IllegalFormatException lvt_6_3_) {
            throw new TextComponentTranslationFormatException(this, (Throwable)lvt_6_3_);
        }
    }

    private ITextComponent getFormatArgumentAsComponent(int p_getFormatArgumentAsComponent_1_) {
        TextComponentString lvt_3_2_;
        if (p_getFormatArgumentAsComponent_1_ >= this.formatArgs.length) {
            throw new TextComponentTranslationFormatException(this, p_getFormatArgumentAsComponent_1_);
        }
        Object lvt_2_1_ = this.formatArgs[p_getFormatArgumentAsComponent_1_];
        if (lvt_2_1_ instanceof ITextComponent) {
            ITextComponent lvt_3_1_ = (ITextComponent)lvt_2_1_;
        } else {
            lvt_3_2_ = new TextComponentString(lvt_2_1_ == null ? "null" : lvt_2_1_.toString());
            lvt_3_2_.getStyle().setParentStyle(this.getStyle());
        }
        return lvt_3_2_;
    }

    @Override
    public ITextComponent setStyle(Style p_setStyle_1_) {
        super.setStyle(p_setStyle_1_);
        for (Object lvt_5_1_ : this.formatArgs) {
            if (!(lvt_5_1_ instanceof ITextComponent)) continue;
            ((ITextComponent)lvt_5_1_).getStyle().setParentStyle(this.getStyle());
        }
        if (this.lastTranslationUpdateTimeInMilliseconds > -1L) {
            for (ITextComponent lvt_3_1_ : this.children) {
                lvt_3_1_.getStyle().setParentStyle(p_setStyle_1_);
            }
        }
        return this;
    }

    @Override
    public Iterator<ITextComponent> iterator() {
        this.ensureInitialized();
        return Iterators.concat(TextComponentTranslation.createDeepCopyIterator(this.children), TextComponentTranslation.createDeepCopyIterator(this.siblings));
    }

    @Override
    public String getUnformattedComponentText() {
        this.ensureInitialized();
        StringBuilder lvt_1_1_ = new StringBuilder();
        for (ITextComponent lvt_3_1_ : this.children) {
            lvt_1_1_.append(lvt_3_1_.getUnformattedComponentText());
        }
        return lvt_1_1_.toString();
    }

    @Override
    public TextComponentTranslation createCopy() {
        Object[] lvt_1_1_ = new Object[this.formatArgs.length];
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.formatArgs.length; ++lvt_2_1_) {
            lvt_1_1_[lvt_2_1_] = this.formatArgs[lvt_2_1_] instanceof ITextComponent ? ((ITextComponent)this.formatArgs[lvt_2_1_]).createCopy() : this.formatArgs[lvt_2_1_];
        }
        TextComponentTranslation lvt_2_2_ = new TextComponentTranslation(this.key, lvt_1_1_);
        lvt_2_2_.setStyle(this.getStyle().createShallowCopy());
        for (ITextComponent lvt_4_1_ : this.getSiblings()) {
            lvt_2_2_.appendSibling(lvt_4_1_.createCopy());
        }
        return lvt_2_2_;
    }

    @Override
    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof TextComponentTranslation) {
            TextComponentTranslation lvt_2_1_ = (TextComponentTranslation)p_equals_1_;
            return Arrays.equals(this.formatArgs, lvt_2_1_.formatArgs) && this.key.equals(lvt_2_1_.key) && super.equals(p_equals_1_);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int lvt_1_1_ = super.hashCode();
        lvt_1_1_ = 31 * lvt_1_1_ + this.key.hashCode();
        lvt_1_1_ = 31 * lvt_1_1_ + Arrays.hashCode(this.formatArgs);
        return lvt_1_1_;
    }

    @Override
    public String toString() {
        return "TranslatableComponent{key='" + this.key + '\'' + ", args=" + Arrays.toString(this.formatArgs) + ", siblings=" + this.siblings + ", style=" + this.getStyle() + '}';
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getFormatArgs() {
        return this.formatArgs;
    }

    @Override
    public /* synthetic */ ITextComponent createCopy() {
        return this.createCopy();
    }
}

