/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public enum TextFormatting {
    BLACK("BLACK", '0', 0),
    DARK_BLUE("DARK_BLUE", '1', 1),
    DARK_GREEN("DARK_GREEN", '2', 2),
    DARK_AQUA("DARK_AQUA", '3', 3),
    DARK_RED("DARK_RED", '4', 4),
    DARK_PURPLE("DARK_PURPLE", '5', 5),
    GOLD("GOLD", '6', 6),
    GRAY("GRAY", '7', 7),
    DARK_GRAY("DARK_GRAY", '8', 8),
    BLUE("BLUE", '9', 9),
    GREEN("GREEN", 'a', 10),
    AQUA("AQUA", 'b', 11),
    RED("RED", 'c', 12),
    LIGHT_PURPLE("LIGHT_PURPLE", 'd', 13),
    YELLOW("YELLOW", 'e', 14),
    WHITE("WHITE", 'f', 15),
    OBFUSCATED("OBFUSCATED", 'k', true),
    BOLD("BOLD", 'l', true),
    STRIKETHROUGH("STRIKETHROUGH", 'm', true),
    UNDERLINE("UNDERLINE", 'n', true),
    ITALIC("ITALIC", 'o', true),
    RESET("RESET", 'r', -1);

    private static final Map<String, TextFormatting> NAME_MAPPING;
    private static final Pattern FORMATTING_CODE_PATTERN;
    private final String name;
    private final char formattingCode;
    private final boolean fancyStyling;
    private final String controlString;
    private final int colorIndex;

    private static String lowercaseAlpha(String p_lowercaseAlpha_0_) {
        return p_lowercaseAlpha_0_.toLowerCase(Locale.ROOT).replaceAll("[^a-z]", "");
    }

    private TextFormatting(String p_i46291_3_, char p_i46291_4_, int p_i46291_5_) {
        this(p_i46291_3_, p_i46291_4_, false, p_i46291_5_);
    }

    private TextFormatting(String p_i46292_3_, char p_i46292_4_, boolean p_i46292_5_) {
        this(p_i46292_3_, p_i46292_4_, p_i46292_5_, -1);
    }

    private TextFormatting(String p_i46293_3_, char p_i46293_4_, boolean p_i46293_5_, int p_i46293_6_) {
        this.name = p_i46293_3_;
        this.formattingCode = p_i46293_4_;
        this.fancyStyling = p_i46293_5_;
        this.colorIndex = p_i46293_6_;
        this.controlString = "\u00a7" + p_i46293_4_;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public boolean isFancyStyling() {
        return this.fancyStyling;
    }

    public boolean isColor() {
        return !this.fancyStyling && this != RESET;
    }

    public String getFriendlyName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toString() {
        return this.controlString;
    }

    @Nullable
    public static String getTextWithoutFormattingCodes(String p_getTextWithoutFormattingCodes_0_) {
        return p_getTextWithoutFormattingCodes_0_ == null ? null : FORMATTING_CODE_PATTERN.matcher(p_getTextWithoutFormattingCodes_0_).replaceAll("");
    }

    @Nullable
    public static TextFormatting getValueByName(String p_getValueByName_0_) {
        if (p_getValueByName_0_ == null) {
            return null;
        }
        return NAME_MAPPING.get(TextFormatting.lowercaseAlpha(p_getValueByName_0_));
    }

    @Nullable
    public static TextFormatting fromColorIndex(int p_fromColorIndex_0_) {
        if (p_fromColorIndex_0_ < 0) {
            return RESET;
        }
        for (TextFormatting lvt_4_1_ : TextFormatting.values()) {
            if (lvt_4_1_.getColorIndex() != p_fromColorIndex_0_) continue;
            return lvt_4_1_;
        }
        return null;
    }

    public static Collection<String> getValidValues(boolean p_getValidValues_0_, boolean p_getValidValues_1_) {
        ArrayList lvt_2_1_ = Lists.newArrayList();
        for (TextFormatting lvt_6_1_ : TextFormatting.values()) {
            if (lvt_6_1_.isColor() && !p_getValidValues_0_ || lvt_6_1_.isFancyStyling() && !p_getValidValues_1_) continue;
            lvt_2_1_.add(lvt_6_1_.getFriendlyName());
        }
        return lvt_2_1_;
    }

    static {
        NAME_MAPPING = Maps.newHashMap();
        FORMATTING_CODE_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
        for (TextFormatting lvt_3_1_ : TextFormatting.values()) {
            NAME_MAPPING.put(TextFormatting.lowercaseAlpha(lvt_3_1_.name), lvt_3_1_);
        }
    }
}

