/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text.event;

import com.google.common.collect.Maps;
import java.util.Map;

public class ClickEvent {
    private final Action action;
    private final String value;

    public ClickEvent(Action p_i45156_1_, String p_i45156_2_) {
        this.action = p_i45156_1_;
        this.value = p_i45156_2_;
    }

    public Action getAction() {
        return this.action;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ == null || this.getClass() != p_equals_1_.getClass()) {
            return false;
        }
        ClickEvent lvt_2_1_ = (ClickEvent)p_equals_1_;
        if (this.action != lvt_2_1_.action) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(lvt_2_1_.value) : lvt_2_1_.value != null);
    }

    public String toString() {
        return "ClickEvent{action=" + (Object)((Object)this.action) + ", value='" + this.value + '\'' + '}';
    }

    public int hashCode() {
        int lvt_1_1_ = this.action.hashCode();
        lvt_1_1_ = 31 * lvt_1_1_ + (this.value != null ? this.value.hashCode() : 0);
        return lvt_1_1_;
    }

    public static enum Action {
        OPEN_URL("open_url", true),
        OPEN_FILE("open_file", false),
        RUN_COMMAND("run_command", true),
        SUGGEST_COMMAND("suggest_command", true),
        CHANGE_PAGE("change_page", true);

        private static final Map<String, Action> NAME_MAPPING;
        private final boolean allowedInChat;
        private final String canonicalName;

        private Action(String p_i45155_3_, boolean p_i45155_4_) {
            this.canonicalName = p_i45155_3_;
            this.allowedInChat = p_i45155_4_;
        }

        public boolean shouldAllowInChat() {
            return this.allowedInChat;
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public static Action getValueByCanonicalName(String p_getValueByCanonicalName_0_) {
            return NAME_MAPPING.get(p_getValueByCanonicalName_0_);
        }

        static {
            NAME_MAPPING = Maps.newHashMap();
            for (Action lvt_3_1_ : Action.values()) {
                NAME_MAPPING.put(lvt_3_1_.getCanonicalName(), lvt_3_1_);
            }
        }
    }
}

