/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text.event;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;

public class HoverEvent {
    private final Action action;
    private final ITextComponent value;

    public HoverEvent(Action p_i45158_1_, ITextComponent p_i45158_2_) {
        this.action = p_i45158_1_;
        this.value = p_i45158_2_;
    }

    public Action getAction() {
        return this.action;
    }

    public ITextComponent getValue() {
        return this.value;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ == null || this.getClass() != p_equals_1_.getClass()) {
            return false;
        }
        HoverEvent lvt_2_1_ = (HoverEvent)p_equals_1_;
        if (this.action != lvt_2_1_.action) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(lvt_2_1_.value) : lvt_2_1_.value != null);
    }

    public String toString() {
        return "HoverEvent{action=" + (Object)((Object)this.action) + ", value='" + this.value + '\'' + '}';
    }

    public int hashCode() {
        int lvt_1_1_ = this.action.hashCode();
        lvt_1_1_ = 31 * lvt_1_1_ + (this.value != null ? this.value.hashCode() : 0);
        return lvt_1_1_;
    }

    public static enum Action {
        SHOW_TEXT("show_text", true),
        SHOW_ACHIEVEMENT("show_achievement", true),
        SHOW_ITEM("show_item", true),
        SHOW_ENTITY("show_entity", true);

        private static final Map<String, Action> NAME_MAPPING;
        private final boolean allowedInChat;
        private final String canonicalName;

        private Action(String p_i45157_3_, boolean p_i45157_4_) {
            this.canonicalName = p_i45157_3_;
            this.allowedInChat = p_i45157_4_;
        }

        public boolean shouldAllowInChat() {
            return this.allowedInChat;
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public static Action getValueByCanonicalName(String p_getValueByCanonicalName_0_) {
            return NAME_MAPPING.get(p_getValueByCanonicalName_0_);
        }

        static {
            NAME_MAPPING = Maps.newHashMap();
            for (Action lvt_3_1_ : Action.values()) {
                NAME_MAPPING.put(lvt_3_1_.getCanonicalName(), lvt_3_1_);
            }
        }
    }
}

