/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text.translation;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class LanguageMap {
    private static final Pattern NUMERIC_VARIABLE_PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    private static final Splitter EQUAL_SIGN_SPLITTER = Splitter.on((char)'=').limit(2);
    private static final LanguageMap instance = new LanguageMap();
    private final Map<String, String> languageList = Maps.newHashMap();
    private long lastUpdateTimeInMilliseconds;

    public LanguageMap() {
        InputStream inputstream = LanguageMap.class.getResourceAsStream("/assets/minecraft/lang/en_us.lang");
        LanguageMap.inject(this, inputstream);
    }

    public static void inject(InputStream p_inject_0_) {
        LanguageMap.inject(instance, p_inject_0_);
    }

    private static void inject(LanguageMap p_inject_0_, InputStream p_inject_1_) {
        Map<String, String> map = LanguageMap.parseLangFile(p_inject_1_);
        p_inject_0_.languageList.putAll(map);
        p_inject_0_.lastUpdateTimeInMilliseconds = System.currentTimeMillis();
    }

    public static Map<String, String> parseLangFile(InputStream p_parseLangFile_0_) {
        HashMap table = Maps.newHashMap();
        try {
            p_parseLangFile_0_ = FMLCommonHandler.instance().loadLanguage(table, p_parseLangFile_0_);
            if (p_parseLangFile_0_ == null) {
                return table;
            }
            for (String s : IOUtils.readLines((InputStream)p_parseLangFile_0_, (Charset)Charsets.UTF_8)) {
                String[] astring;
                if (s.isEmpty() || s.charAt(0) == '#' || (astring = (String[])Iterables.toArray((Iterable)EQUAL_SIGN_SPLITTER.split((CharSequence)s), String.class)) == null || astring.length != 2) continue;
                String s1 = astring[0];
                String s2 = NUMERIC_VARIABLE_PATTERN.matcher(astring[1]).replaceAll("%$1s");
                table.put(s1, s2);
            }
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return table;
    }

    static LanguageMap getInstance() {
        return instance;
    }

    @SideOnly(value=Side.CLIENT)
    public static synchronized void replaceWith(Map<String, String> p_replaceWith_0_) {
        LanguageMap.instance.languageList.clear();
        LanguageMap.instance.languageList.putAll(p_replaceWith_0_);
        LanguageMap.instance.lastUpdateTimeInMilliseconds = System.currentTimeMillis();
    }

    public synchronized String translateKey(String p_translateKey_1_) {
        return this.tryTranslateKey(p_translateKey_1_);
    }

    public synchronized String translateKeyFormat(String p_translateKeyFormat_1_, Object ... p_translateKeyFormat_2_) {
        String s = this.tryTranslateKey(p_translateKeyFormat_1_);
        try {
            return String.format(s, p_translateKeyFormat_2_);
        }
        catch (IllegalFormatException var5) {
            return "Format error: " + s;
        }
    }

    private String tryTranslateKey(String p_tryTranslateKey_1_) {
        String s = this.languageList.get(p_tryTranslateKey_1_);
        return s == null ? p_tryTranslateKey_1_ : s;
    }

    public synchronized boolean isKeyTranslated(String p_isKeyTranslated_1_) {
        return this.languageList.containsKey(p_isKeyTranslated_1_);
    }

    public long getLastUpdateTimeInMilliseconds() {
        return this.lastUpdateTimeInMilliseconds;
    }
}

