/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MerchantRecipe {
    private ItemStack itemToBuy = ItemStack.EMPTY;
    private ItemStack secondItemToBuy = ItemStack.EMPTY;
    private ItemStack itemToSell = ItemStack.EMPTY;
    private int toolUses;
    private int maxTradeUses;
    private boolean rewardsExp;

    public MerchantRecipe(NBTTagCompound p_i1940_1_) {
        this.readFromTags(p_i1940_1_);
    }

    public MerchantRecipe(ItemStack p_i1941_1_, ItemStack p_i1941_2_, ItemStack p_i1941_3_) {
        this(p_i1941_1_, p_i1941_2_, p_i1941_3_, 0, 7);
    }

    public MerchantRecipe(ItemStack p_i45760_1_, ItemStack p_i45760_2_, ItemStack p_i45760_3_, int p_i45760_4_, int p_i45760_5_) {
        this.itemToBuy = p_i45760_1_;
        this.secondItemToBuy = p_i45760_2_;
        this.itemToSell = p_i45760_3_;
        this.toolUses = p_i45760_4_;
        this.maxTradeUses = p_i45760_5_;
        this.rewardsExp = true;
    }

    public MerchantRecipe(ItemStack p_i1942_1_, ItemStack p_i1942_2_) {
        this(p_i1942_1_, ItemStack.EMPTY, p_i1942_2_);
    }

    public MerchantRecipe(ItemStack p_i1943_1_, Item p_i1943_2_) {
        this(p_i1943_1_, new ItemStack(p_i1943_2_));
    }

    public ItemStack getItemToBuy() {
        return this.itemToBuy;
    }

    public ItemStack getSecondItemToBuy() {
        return this.secondItemToBuy;
    }

    public boolean hasSecondItemToBuy() {
        return !this.secondItemToBuy.isEmpty();
    }

    public ItemStack getItemToSell() {
        return this.itemToSell;
    }

    public int getToolUses() {
        return this.toolUses;
    }

    public int getMaxTradeUses() {
        return this.maxTradeUses;
    }

    public void incrementToolUses() {
        ++this.toolUses;
    }

    public void increaseMaxTradeUses(int p_increaseMaxTradeUses_1_) {
        this.maxTradeUses += p_increaseMaxTradeUses_1_;
    }

    public boolean isRecipeDisabled() {
        return this.toolUses >= this.maxTradeUses;
    }

    @SideOnly(value=Side.CLIENT)
    public void compensateToolUses() {
        this.toolUses = this.maxTradeUses;
    }

    public boolean getRewardsExp() {
        return this.rewardsExp;
    }

    public void readFromTags(NBTTagCompound p_readFromTags_1_) {
        NBTTagCompound lvt_2_1_ = p_readFromTags_1_.getCompoundTag("buy");
        this.itemToBuy = new ItemStack(lvt_2_1_);
        NBTTagCompound lvt_3_1_ = p_readFromTags_1_.getCompoundTag("sell");
        this.itemToSell = new ItemStack(lvt_3_1_);
        if (p_readFromTags_1_.hasKey("buyB", 10)) {
            this.secondItemToBuy = new ItemStack(p_readFromTags_1_.getCompoundTag("buyB"));
        }
        if (p_readFromTags_1_.hasKey("uses", 99)) {
            this.toolUses = p_readFromTags_1_.getInteger("uses");
        }
        this.maxTradeUses = p_readFromTags_1_.hasKey("maxUses", 99) ? p_readFromTags_1_.getInteger("maxUses") : 7;
        this.rewardsExp = p_readFromTags_1_.hasKey("rewardExp", 1) ? p_readFromTags_1_.getBoolean("rewardExp") : true;
    }

    public NBTTagCompound writeToTags() {
        NBTTagCompound lvt_1_1_ = new NBTTagCompound();
        lvt_1_1_.setTag("buy", this.itemToBuy.writeToNBT(new NBTTagCompound()));
        lvt_1_1_.setTag("sell", this.itemToSell.writeToNBT(new NBTTagCompound()));
        if (!this.secondItemToBuy.isEmpty()) {
            lvt_1_1_.setTag("buyB", this.secondItemToBuy.writeToNBT(new NBTTagCompound()));
        }
        lvt_1_1_.setInteger("uses", this.toolUses);
        lvt_1_1_.setInteger("maxUses", this.maxTradeUses);
        lvt_1_1_.setBoolean("rewardExp", this.rewardsExp);
        return lvt_1_1_;
    }
}

