/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.village.MerchantRecipe;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MerchantRecipeList
extends ArrayList<MerchantRecipe> {
    public MerchantRecipeList() {
    }

    public MerchantRecipeList(NBTTagCompound p_i1944_1_) {
        this.readRecipiesFromTags(p_i1944_1_);
    }

    @Nullable
    public MerchantRecipe canRecipeBeUsed(ItemStack p_canRecipeBeUsed_1_, ItemStack p_canRecipeBeUsed_2_, int p_canRecipeBeUsed_3_) {
        if (p_canRecipeBeUsed_3_ > 0 && p_canRecipeBeUsed_3_ < this.size()) {
            MerchantRecipe lvt_4_1_ = (MerchantRecipe)this.get(p_canRecipeBeUsed_3_);
            if (this.areItemStacksExactlyEqual(p_canRecipeBeUsed_1_, lvt_4_1_.getItemToBuy()) && (p_canRecipeBeUsed_2_.isEmpty() && !lvt_4_1_.hasSecondItemToBuy() || lvt_4_1_.hasSecondItemToBuy() && this.areItemStacksExactlyEqual(p_canRecipeBeUsed_2_, lvt_4_1_.getSecondItemToBuy())) && p_canRecipeBeUsed_1_.getCount() >= lvt_4_1_.getItemToBuy().getCount() && (!lvt_4_1_.hasSecondItemToBuy() || p_canRecipeBeUsed_2_.getCount() >= lvt_4_1_.getSecondItemToBuy().getCount())) {
                return lvt_4_1_;
            }
            return null;
        }
        for (int lvt_4_2_ = 0; lvt_4_2_ < this.size(); ++lvt_4_2_) {
            MerchantRecipe lvt_5_1_ = (MerchantRecipe)this.get(lvt_4_2_);
            if (!this.areItemStacksExactlyEqual(p_canRecipeBeUsed_1_, lvt_5_1_.getItemToBuy()) || p_canRecipeBeUsed_1_.getCount() < lvt_5_1_.getItemToBuy().getCount() || (lvt_5_1_.hasSecondItemToBuy() || !p_canRecipeBeUsed_2_.isEmpty()) && (!lvt_5_1_.hasSecondItemToBuy() || !this.areItemStacksExactlyEqual(p_canRecipeBeUsed_2_, lvt_5_1_.getSecondItemToBuy()) || p_canRecipeBeUsed_2_.getCount() < lvt_5_1_.getSecondItemToBuy().getCount())) continue;
            return lvt_5_1_;
        }
        return null;
    }

    private boolean areItemStacksExactlyEqual(ItemStack p_areItemStacksExactlyEqual_1_, ItemStack p_areItemStacksExactlyEqual_2_) {
        return ItemStack.areItemsEqual(p_areItemStacksExactlyEqual_1_, p_areItemStacksExactlyEqual_2_) && (!p_areItemStacksExactlyEqual_2_.hasTagCompound() || p_areItemStacksExactlyEqual_1_.hasTagCompound() && NBTUtil.areNBTEquals(p_areItemStacksExactlyEqual_2_.getTagCompound(), p_areItemStacksExactlyEqual_1_.getTagCompound(), false));
    }

    public void writeToBuf(PacketBuffer p_writeToBuf_1_) {
        p_writeToBuf_1_.writeByte((byte)(this.size() & 0xFF));
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.size(); ++lvt_2_1_) {
            MerchantRecipe lvt_3_1_ = (MerchantRecipe)this.get(lvt_2_1_);
            p_writeToBuf_1_.writeItemStack(lvt_3_1_.getItemToBuy());
            p_writeToBuf_1_.writeItemStack(lvt_3_1_.getItemToSell());
            ItemStack lvt_4_1_ = lvt_3_1_.getSecondItemToBuy();
            p_writeToBuf_1_.writeBoolean(!lvt_4_1_.isEmpty());
            if (!lvt_4_1_.isEmpty()) {
                p_writeToBuf_1_.writeItemStack(lvt_4_1_);
            }
            p_writeToBuf_1_.writeBoolean(lvt_3_1_.isRecipeDisabled());
            p_writeToBuf_1_.writeInt(lvt_3_1_.getToolUses());
            p_writeToBuf_1_.writeInt(lvt_3_1_.getMaxTradeUses());
        }
    }

    public void readRecipiesFromTags(NBTTagCompound p_readRecipiesFromTags_1_) {
        NBTTagList lvt_2_1_ = p_readRecipiesFromTags_1_.getTagList("Recipes", 10);
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_.tagCount(); ++lvt_3_1_) {
            NBTTagCompound lvt_4_1_ = lvt_2_1_.getCompoundTagAt(lvt_3_1_);
            this.add(new MerchantRecipe(lvt_4_1_));
        }
    }

    public NBTTagCompound getRecipiesAsTags() {
        NBTTagCompound lvt_1_1_ = new NBTTagCompound();
        NBTTagList lvt_2_1_ = new NBTTagList();
        for (int lvt_3_1_ = 0; lvt_3_1_ < this.size(); ++lvt_3_1_) {
            MerchantRecipe lvt_4_1_ = (MerchantRecipe)this.get(lvt_3_1_);
            lvt_2_1_.appendTag(lvt_4_1_.writeToTags());
        }
        lvt_1_1_.setTag("Recipes", lvt_2_1_);
        return lvt_1_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public static MerchantRecipeList readFromBuf(PacketBuffer p_readFromBuf_0_) throws IOException {
        MerchantRecipeList lvt_1_1_ = new MerchantRecipeList();
        int lvt_2_1_ = p_readFromBuf_0_.readByte() & 0xFF;
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_; ++lvt_3_1_) {
            ItemStack lvt_4_1_ = p_readFromBuf_0_.readItemStack();
            ItemStack lvt_5_1_ = p_readFromBuf_0_.readItemStack();
            ItemStack lvt_6_1_ = ItemStack.EMPTY;
            if (p_readFromBuf_0_.readBoolean()) {
                lvt_6_1_ = p_readFromBuf_0_.readItemStack();
            }
            boolean lvt_7_1_ = p_readFromBuf_0_.readBoolean();
            int lvt_8_1_ = p_readFromBuf_0_.readInt();
            int lvt_9_1_ = p_readFromBuf_0_.readInt();
            MerchantRecipe lvt_10_1_ = new MerchantRecipe(lvt_4_1_, lvt_6_1_, lvt_5_1_, lvt_8_1_, lvt_9_1_);
            if (lvt_7_1_) {
                lvt_10_1_.compensateToolUses();
            }
            lvt_1_1_.add(lvt_10_1_);
        }
        return lvt_1_1_;
    }
}

