/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;

public class Village {
    private World world;
    private final List<VillageDoorInfo> villageDoorInfoList = Lists.newArrayList();
    private BlockPos centerHelper = BlockPos.ORIGIN;
    private BlockPos center = BlockPos.ORIGIN;
    private int villageRadius;
    private int lastAddDoorTimestamp;
    private int tickCounter;
    private int numVillagers;
    private int noBreedTicks;
    private final Map<String, Integer> playerReputation = Maps.newHashMap();
    private final List<VillageAggressor> villageAgressors = Lists.newArrayList();
    private int numIronGolems;

    public Village() {
    }

    public Village(World p_i1675_1_) {
        this.world = p_i1675_1_;
    }

    public void setWorld(World p_setWorld_1_) {
        this.world = p_setWorld_1_;
    }

    public void tick(int p_tick_1_) {
        Vec3d lvt_3_1_;
        int lvt_2_1_;
        this.tickCounter = p_tick_1_;
        this.removeDeadAndOutOfRangeDoors();
        this.removeDeadAndOldAgressors();
        if (p_tick_1_ % 20 == 0) {
            this.updateNumVillagers();
        }
        if (p_tick_1_ % 30 == 0) {
            this.updateNumIronGolems();
        }
        if (this.numIronGolems < (lvt_2_1_ = this.numVillagers / 10) && this.villageDoorInfoList.size() > 20 && this.world.rand.nextInt(7000) == 0 && (lvt_3_1_ = this.findRandomSpawnPos(this.center, 2, 4, 2)) != null) {
            EntityIronGolem lvt_4_1_ = new EntityIronGolem(this.world);
            lvt_4_1_.setPosition(lvt_3_1_.xCoord, lvt_3_1_.yCoord, lvt_3_1_.zCoord);
            this.world.spawnEntity(lvt_4_1_);
            ++this.numIronGolems;
        }
    }

    private Vec3d findRandomSpawnPos(BlockPos p_findRandomSpawnPos_1_, int p_findRandomSpawnPos_2_, int p_findRandomSpawnPos_3_, int p_findRandomSpawnPos_4_) {
        for (int lvt_5_1_ = 0; lvt_5_1_ < 10; ++lvt_5_1_) {
            BlockPos lvt_6_1_ = p_findRandomSpawnPos_1_.add(this.world.rand.nextInt(16) - 8, this.world.rand.nextInt(6) - 3, this.world.rand.nextInt(16) - 8);
            if (!this.isBlockPosWithinSqVillageRadius(lvt_6_1_) || !this.isAreaClearAround(new BlockPos(p_findRandomSpawnPos_2_, p_findRandomSpawnPos_3_, p_findRandomSpawnPos_4_), lvt_6_1_)) continue;
            return new Vec3d(lvt_6_1_.getX(), lvt_6_1_.getY(), lvt_6_1_.getZ());
        }
        return null;
    }

    private boolean isAreaClearAround(BlockPos p_isAreaClearAround_1_, BlockPos p_isAreaClearAround_2_) {
        if (!this.world.getBlockState(p_isAreaClearAround_2_.down()).isFullyOpaque()) {
            return false;
        }
        int lvt_3_1_ = p_isAreaClearAround_2_.getX() - p_isAreaClearAround_1_.getX() / 2;
        int lvt_4_1_ = p_isAreaClearAround_2_.getZ() - p_isAreaClearAround_1_.getZ() / 2;
        for (int lvt_5_1_ = lvt_3_1_; lvt_5_1_ < lvt_3_1_ + p_isAreaClearAround_1_.getX(); ++lvt_5_1_) {
            for (int lvt_6_1_ = p_isAreaClearAround_2_.getY(); lvt_6_1_ < p_isAreaClearAround_2_.getY() + p_isAreaClearAround_1_.getY(); ++lvt_6_1_) {
                for (int lvt_7_1_ = lvt_4_1_; lvt_7_1_ < lvt_4_1_ + p_isAreaClearAround_1_.getZ(); ++lvt_7_1_) {
                    if (!this.world.getBlockState(new BlockPos(lvt_5_1_, lvt_6_1_, lvt_7_1_)).isNormalCube()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void updateNumIronGolems() {
        List<EntityIronGolem> lvt_1_1_ = this.world.getEntitiesWithinAABB(EntityIronGolem.class, new AxisAlignedBB(this.center.getX() - this.villageRadius, this.center.getY() - 4, this.center.getZ() - this.villageRadius, this.center.getX() + this.villageRadius, this.center.getY() + 4, this.center.getZ() + this.villageRadius));
        this.numIronGolems = lvt_1_1_.size();
    }

    private void updateNumVillagers() {
        List<EntityVillager> lvt_1_1_ = this.world.getEntitiesWithinAABB(EntityVillager.class, new AxisAlignedBB(this.center.getX() - this.villageRadius, this.center.getY() - 4, this.center.getZ() - this.villageRadius, this.center.getX() + this.villageRadius, this.center.getY() + 4, this.center.getZ() + this.villageRadius));
        this.numVillagers = lvt_1_1_.size();
        if (this.numVillagers == 0) {
            this.playerReputation.clear();
        }
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public int getVillageRadius() {
        return this.villageRadius;
    }

    public int getNumVillageDoors() {
        return this.villageDoorInfoList.size();
    }

    public int getTicksSinceLastDoorAdding() {
        return this.tickCounter - this.lastAddDoorTimestamp;
    }

    public int getNumVillagers() {
        return this.numVillagers;
    }

    public boolean isBlockPosWithinSqVillageRadius(BlockPos p_isBlockPosWithinSqVillageRadius_1_) {
        return this.center.distanceSq(p_isBlockPosWithinSqVillageRadius_1_) < (double)(this.villageRadius * this.villageRadius);
    }

    public List<VillageDoorInfo> getVillageDoorInfoList() {
        return this.villageDoorInfoList;
    }

    public VillageDoorInfo getNearestDoor(BlockPos p_getNearestDoor_1_) {
        VillageDoorInfo lvt_2_1_ = null;
        int lvt_3_1_ = Integer.MAX_VALUE;
        for (VillageDoorInfo lvt_5_1_ : this.villageDoorInfoList) {
            int lvt_6_1_ = lvt_5_1_.getDistanceToDoorBlockSq(p_getNearestDoor_1_);
            if (lvt_6_1_ >= lvt_3_1_) continue;
            lvt_2_1_ = lvt_5_1_;
            lvt_3_1_ = lvt_6_1_;
        }
        return lvt_2_1_;
    }

    public VillageDoorInfo getDoorInfo(BlockPos p_getDoorInfo_1_) {
        VillageDoorInfo lvt_2_1_ = null;
        int lvt_3_1_ = Integer.MAX_VALUE;
        for (VillageDoorInfo lvt_5_1_ : this.villageDoorInfoList) {
            EnumFacing lvt_8_1_;
            BlockPos lvt_7_1_;
            int lvt_6_1_ = lvt_5_1_.getDistanceToDoorBlockSq(p_getDoorInfo_1_);
            lvt_6_1_ = lvt_6_1_ > 256 ? (lvt_6_1_ *= 1000) : lvt_5_1_.getDoorOpeningRestrictionCounter();
            if (lvt_6_1_ >= lvt_3_1_ || !this.world.getBlockState((lvt_7_1_ = lvt_5_1_.getDoorBlockPos()).offset(lvt_8_1_ = lvt_5_1_.getInsideDirection(), 1)).getBlock().isPassable(this.world, lvt_7_1_.offset(lvt_8_1_, 1)) || !this.world.getBlockState(lvt_7_1_.offset(lvt_8_1_, -1)).getBlock().isPassable(this.world, lvt_7_1_.offset(lvt_8_1_, -1)) || !this.world.getBlockState(lvt_7_1_.up().offset(lvt_8_1_, 1)).getBlock().isPassable(this.world, lvt_7_1_.up().offset(lvt_8_1_, 1)) || !this.world.getBlockState(lvt_7_1_.up().offset(lvt_8_1_, -1)).getBlock().isPassable(this.world, lvt_7_1_.up().offset(lvt_8_1_, -1))) continue;
            lvt_2_1_ = lvt_5_1_;
            lvt_3_1_ = lvt_6_1_;
        }
        return lvt_2_1_;
    }

    @Nullable
    public VillageDoorInfo getExistedDoor(BlockPos p_getExistedDoor_1_) {
        if (this.center.distanceSq(p_getExistedDoor_1_) > (double)(this.villageRadius * this.villageRadius)) {
            return null;
        }
        for (VillageDoorInfo lvt_3_1_ : this.villageDoorInfoList) {
            if (lvt_3_1_.getDoorBlockPos().getX() != p_getExistedDoor_1_.getX() || lvt_3_1_.getDoorBlockPos().getZ() != p_getExistedDoor_1_.getZ() || Math.abs(lvt_3_1_.getDoorBlockPos().getY() - p_getExistedDoor_1_.getY()) > 1) continue;
            return lvt_3_1_;
        }
        return null;
    }

    public void addVillageDoorInfo(VillageDoorInfo p_addVillageDoorInfo_1_) {
        this.villageDoorInfoList.add(p_addVillageDoorInfo_1_);
        this.centerHelper = this.centerHelper.add(p_addVillageDoorInfo_1_.getDoorBlockPos());
        this.updateVillageRadiusAndCenter();
        this.lastAddDoorTimestamp = p_addVillageDoorInfo_1_.getInsidePosY();
    }

    public boolean isAnnihilated() {
        return this.villageDoorInfoList.isEmpty();
    }

    public void addOrRenewAgressor(EntityLivingBase p_addOrRenewAgressor_1_) {
        for (VillageAggressor lvt_3_1_ : this.villageAgressors) {
            if (lvt_3_1_.agressor != p_addOrRenewAgressor_1_) continue;
            lvt_3_1_.agressionTime = this.tickCounter;
            return;
        }
        this.villageAgressors.add(new VillageAggressor(p_addOrRenewAgressor_1_, this.tickCounter));
    }

    @Nullable
    public EntityLivingBase findNearestVillageAggressor(EntityLivingBase p_findNearestVillageAggressor_1_) {
        double lvt_2_1_ = Double.MAX_VALUE;
        VillageAggressor lvt_4_1_ = null;
        for (int lvt_5_1_ = 0; lvt_5_1_ < this.villageAgressors.size(); ++lvt_5_1_) {
            VillageAggressor lvt_6_1_ = this.villageAgressors.get(lvt_5_1_);
            double lvt_7_1_ = lvt_6_1_.agressor.getDistanceSqToEntity(p_findNearestVillageAggressor_1_);
            if (lvt_7_1_ > lvt_2_1_) continue;
            lvt_4_1_ = lvt_6_1_;
            lvt_2_1_ = lvt_7_1_;
        }
        return lvt_4_1_ == null ? null : lvt_4_1_.agressor;
    }

    public EntityPlayer getNearestTargetPlayer(EntityLivingBase p_getNearestTargetPlayer_1_) {
        double lvt_2_1_ = Double.MAX_VALUE;
        EntityPlayer lvt_4_1_ = null;
        for (String lvt_6_1_ : this.playerReputation.keySet()) {
            double lvt_8_1_;
            EntityPlayer lvt_7_1_;
            if (!this.isPlayerReputationTooLow(lvt_6_1_) || (lvt_7_1_ = this.world.getPlayerEntityByName(lvt_6_1_)) == null || (lvt_8_1_ = lvt_7_1_.getDistanceSqToEntity(p_getNearestTargetPlayer_1_)) > lvt_2_1_) continue;
            lvt_4_1_ = lvt_7_1_;
            lvt_2_1_ = lvt_8_1_;
        }
        return lvt_4_1_;
    }

    private void removeDeadAndOldAgressors() {
        Iterator<VillageAggressor> lvt_1_1_ = this.villageAgressors.iterator();
        while (lvt_1_1_.hasNext()) {
            VillageAggressor lvt_2_1_ = lvt_1_1_.next();
            if (lvt_2_1_.agressor.isEntityAlive() && Math.abs(this.tickCounter - lvt_2_1_.agressionTime) <= 300) continue;
            lvt_1_1_.remove();
        }
    }

    private void removeDeadAndOutOfRangeDoors() {
        boolean lvt_1_1_ = false;
        boolean lvt_2_1_ = this.world.rand.nextInt(50) == 0;
        Iterator<VillageDoorInfo> lvt_3_1_ = this.villageDoorInfoList.iterator();
        while (lvt_3_1_.hasNext()) {
            VillageDoorInfo lvt_4_1_ = lvt_3_1_.next();
            if (lvt_2_1_) {
                lvt_4_1_.resetDoorOpeningRestrictionCounter();
            }
            if (this.isWoodDoor(lvt_4_1_.getDoorBlockPos()) && Math.abs(this.tickCounter - lvt_4_1_.getInsidePosY()) <= 1200) continue;
            this.centerHelper = this.centerHelper.subtract(lvt_4_1_.getDoorBlockPos());
            lvt_1_1_ = true;
            lvt_4_1_.setIsDetachedFromVillageFlag(true);
            lvt_3_1_.remove();
        }
        if (lvt_1_1_) {
            this.updateVillageRadiusAndCenter();
        }
    }

    private boolean isWoodDoor(BlockPos p_isWoodDoor_1_) {
        IBlockState lvt_2_1_ = this.world.getBlockState(p_isWoodDoor_1_);
        Block lvt_3_1_ = lvt_2_1_.getBlock();
        if (lvt_3_1_ instanceof BlockDoor) {
            return lvt_2_1_.getMaterial() == Material.WOOD;
        }
        return false;
    }

    private void updateVillageRadiusAndCenter() {
        int lvt_1_1_ = this.villageDoorInfoList.size();
        if (lvt_1_1_ == 0) {
            this.center = BlockPos.ORIGIN;
            this.villageRadius = 0;
            return;
        }
        this.center = new BlockPos(this.centerHelper.getX() / lvt_1_1_, this.centerHelper.getY() / lvt_1_1_, this.centerHelper.getZ() / lvt_1_1_);
        int lvt_2_1_ = 0;
        for (VillageDoorInfo lvt_4_1_ : this.villageDoorInfoList) {
            lvt_2_1_ = Math.max(lvt_4_1_.getDistanceToDoorBlockSq(this.center), lvt_2_1_);
        }
        this.villageRadius = Math.max(32, (int)Math.sqrt(lvt_2_1_) + 1);
    }

    public int getPlayerReputation(String p_getPlayerReputation_1_) {
        Integer lvt_2_1_ = this.playerReputation.get(p_getPlayerReputation_1_);
        return lvt_2_1_ == null ? 0 : lvt_2_1_;
    }

    public int modifyPlayerReputation(String p_modifyPlayerReputation_1_, int p_modifyPlayerReputation_2_) {
        int lvt_3_1_ = this.getPlayerReputation(p_modifyPlayerReputation_1_);
        int lvt_4_1_ = MathHelper.clamp(lvt_3_1_ + p_modifyPlayerReputation_2_, -30, 10);
        this.playerReputation.put(p_modifyPlayerReputation_1_, lvt_4_1_);
        return lvt_4_1_;
    }

    public boolean isPlayerReputationTooLow(String p_isPlayerReputationTooLow_1_) {
        return this.getPlayerReputation(p_isPlayerReputationTooLow_1_) <= -15;
    }

    public void readVillageDataFromNBT(NBTTagCompound p_readVillageDataFromNBT_1_) {
        this.numVillagers = p_readVillageDataFromNBT_1_.getInteger("PopSize");
        this.villageRadius = p_readVillageDataFromNBT_1_.getInteger("Radius");
        this.numIronGolems = p_readVillageDataFromNBT_1_.getInteger("Golems");
        this.lastAddDoorTimestamp = p_readVillageDataFromNBT_1_.getInteger("Stable");
        this.tickCounter = p_readVillageDataFromNBT_1_.getInteger("Tick");
        this.noBreedTicks = p_readVillageDataFromNBT_1_.getInteger("MTick");
        this.center = new BlockPos(p_readVillageDataFromNBT_1_.getInteger("CX"), p_readVillageDataFromNBT_1_.getInteger("CY"), p_readVillageDataFromNBT_1_.getInteger("CZ"));
        this.centerHelper = new BlockPos(p_readVillageDataFromNBT_1_.getInteger("ACX"), p_readVillageDataFromNBT_1_.getInteger("ACY"), p_readVillageDataFromNBT_1_.getInteger("ACZ"));
        NBTTagList lvt_2_1_ = p_readVillageDataFromNBT_1_.getTagList("Doors", 10);
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_.tagCount(); ++lvt_3_1_) {
            NBTTagCompound lvt_4_1_ = lvt_2_1_.getCompoundTagAt(lvt_3_1_);
            VillageDoorInfo lvt_5_1_ = new VillageDoorInfo(new BlockPos(lvt_4_1_.getInteger("X"), lvt_4_1_.getInteger("Y"), lvt_4_1_.getInteger("Z")), lvt_4_1_.getInteger("IDX"), lvt_4_1_.getInteger("IDZ"), lvt_4_1_.getInteger("TS"));
            this.villageDoorInfoList.add(lvt_5_1_);
        }
        NBTTagList lvt_3_2_ = p_readVillageDataFromNBT_1_.getTagList("Players", 10);
        for (int lvt_4_2_ = 0; lvt_4_2_ < lvt_3_2_.tagCount(); ++lvt_4_2_) {
            NBTTagCompound lvt_5_2_ = lvt_3_2_.getCompoundTagAt(lvt_4_2_);
            if (lvt_5_2_.hasKey("UUID") && this.world != null && this.world.getMinecraftServer() != null) {
                PlayerProfileCache lvt_6_1_ = this.world.getMinecraftServer().getPlayerProfileCache();
                GameProfile lvt_7_1_ = lvt_6_1_.getProfileByUUID(UUID.fromString(lvt_5_2_.getString("UUID")));
                if (lvt_7_1_ == null) continue;
                this.playerReputation.put(lvt_7_1_.getName(), lvt_5_2_.getInteger("S"));
                continue;
            }
            this.playerReputation.put(lvt_5_2_.getString("Name"), lvt_5_2_.getInteger("S"));
        }
    }

    public void writeVillageDataToNBT(NBTTagCompound p_writeVillageDataToNBT_1_) {
        p_writeVillageDataToNBT_1_.setInteger("PopSize", this.numVillagers);
        p_writeVillageDataToNBT_1_.setInteger("Radius", this.villageRadius);
        p_writeVillageDataToNBT_1_.setInteger("Golems", this.numIronGolems);
        p_writeVillageDataToNBT_1_.setInteger("Stable", this.lastAddDoorTimestamp);
        p_writeVillageDataToNBT_1_.setInteger("Tick", this.tickCounter);
        p_writeVillageDataToNBT_1_.setInteger("MTick", this.noBreedTicks);
        p_writeVillageDataToNBT_1_.setInteger("CX", this.center.getX());
        p_writeVillageDataToNBT_1_.setInteger("CY", this.center.getY());
        p_writeVillageDataToNBT_1_.setInteger("CZ", this.center.getZ());
        p_writeVillageDataToNBT_1_.setInteger("ACX", this.centerHelper.getX());
        p_writeVillageDataToNBT_1_.setInteger("ACY", this.centerHelper.getY());
        p_writeVillageDataToNBT_1_.setInteger("ACZ", this.centerHelper.getZ());
        NBTTagList lvt_2_1_ = new NBTTagList();
        for (VillageDoorInfo lvt_4_1_ : this.villageDoorInfoList) {
            NBTTagCompound lvt_5_1_ = new NBTTagCompound();
            lvt_5_1_.setInteger("X", lvt_4_1_.getDoorBlockPos().getX());
            lvt_5_1_.setInteger("Y", lvt_4_1_.getDoorBlockPos().getY());
            lvt_5_1_.setInteger("Z", lvt_4_1_.getDoorBlockPos().getZ());
            lvt_5_1_.setInteger("IDX", lvt_4_1_.getInsideOffsetX());
            lvt_5_1_.setInteger("IDZ", lvt_4_1_.getInsideOffsetZ());
            lvt_5_1_.setInteger("TS", lvt_4_1_.getInsidePosY());
            lvt_2_1_.appendTag(lvt_5_1_);
        }
        p_writeVillageDataToNBT_1_.setTag("Doors", lvt_2_1_);
        NBTTagList lvt_3_1_ = new NBTTagList();
        for (String lvt_5_2_ : this.playerReputation.keySet()) {
            NBTTagCompound lvt_6_1_ = new NBTTagCompound();
            PlayerProfileCache lvt_7_1_ = this.world.getMinecraftServer().getPlayerProfileCache();
            try {
                GameProfile lvt_8_1_ = lvt_7_1_.getGameProfileForUsername(lvt_5_2_);
                if (lvt_8_1_ == null) continue;
                lvt_6_1_.setString("UUID", lvt_8_1_.getId().toString());
                lvt_6_1_.setInteger("S", this.playerReputation.get(lvt_5_2_));
                lvt_3_1_.appendTag(lvt_6_1_);
            }
            catch (RuntimeException runtimeException) {}
        }
        p_writeVillageDataToNBT_1_.setTag("Players", lvt_3_1_);
    }

    public void endMatingSeason() {
        this.noBreedTicks = this.tickCounter;
    }

    public boolean isMatingSeason() {
        return this.noBreedTicks == 0 || this.tickCounter - this.noBreedTicks >= 3600;
    }

    public void setDefaultPlayerReputation(int p_setDefaultPlayerReputation_1_) {
        for (String lvt_3_1_ : this.playerReputation.keySet()) {
            this.modifyPlayerReputation(lvt_3_1_, p_setDefaultPlayerReputation_1_);
        }
    }

    class VillageAggressor {
        public EntityLivingBase agressor;
        public int agressionTime;

        VillageAggressor(EntityLivingBase p_i1674_2_, int p_i1674_3_) {
            this.agressor = p_i1674_2_;
            this.agressionTime = p_i1674_3_;
        }
    }
}

