/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSavedData;

public class VillageCollection
extends WorldSavedData {
    private World world;
    private final List<BlockPos> villagerPositionsList = Lists.newArrayList();
    private final List<VillageDoorInfo> newDoors = Lists.newArrayList();
    private final List<Village> villageList = Lists.newArrayList();
    private int tickCounter;

    public VillageCollection(String p_i1677_1_) {
        super(p_i1677_1_);
    }

    public VillageCollection(World p_i1678_1_) {
        super(VillageCollection.fileNameForProvider(p_i1678_1_.provider));
        this.world = p_i1678_1_;
        this.markDirty();
    }

    public void setWorldsForAll(World p_setWorldsForAll_1_) {
        this.world = p_setWorldsForAll_1_;
        for (Village lvt_3_1_ : this.villageList) {
            lvt_3_1_.setWorld(p_setWorldsForAll_1_);
        }
    }

    public void addToVillagerPositionList(BlockPos p_addToVillagerPositionList_1_) {
        if (this.villagerPositionsList.size() > 64) {
            return;
        }
        if (!this.positionInList(p_addToVillagerPositionList_1_)) {
            this.villagerPositionsList.add(p_addToVillagerPositionList_1_);
        }
    }

    public void tick() {
        ++this.tickCounter;
        for (Village lvt_2_1_ : this.villageList) {
            lvt_2_1_.tick(this.tickCounter);
        }
        this.removeAnnihilatedVillages();
        this.dropOldestVillagerPosition();
        this.addNewDoorsToVillageOrCreateVillage();
        if (this.tickCounter % 400 == 0) {
            this.markDirty();
        }
    }

    private void removeAnnihilatedVillages() {
        Iterator<Village> lvt_1_1_ = this.villageList.iterator();
        while (lvt_1_1_.hasNext()) {
            Village lvt_2_1_ = lvt_1_1_.next();
            if (!lvt_2_1_.isAnnihilated()) continue;
            lvt_1_1_.remove();
            this.markDirty();
        }
    }

    public List<Village> getVillageList() {
        return this.villageList;
    }

    public Village getNearestVillage(BlockPos p_getNearestVillage_1_, int p_getNearestVillage_2_) {
        Village lvt_3_1_ = null;
        double lvt_4_1_ = 3.4028234663852886E38;
        for (Village lvt_7_1_ : this.villageList) {
            float lvt_10_1_;
            double lvt_8_1_ = lvt_7_1_.getCenter().distanceSq(p_getNearestVillage_1_);
            if (lvt_8_1_ >= lvt_4_1_ || lvt_8_1_ > (double)((lvt_10_1_ = (float)(p_getNearestVillage_2_ + lvt_7_1_.getVillageRadius())) * lvt_10_1_)) continue;
            lvt_3_1_ = lvt_7_1_;
            lvt_4_1_ = lvt_8_1_;
        }
        return lvt_3_1_;
    }

    private void dropOldestVillagerPosition() {
        if (this.villagerPositionsList.isEmpty()) {
            return;
        }
        this.addDoorsAround(this.villagerPositionsList.remove(0));
    }

    private void addNewDoorsToVillageOrCreateVillage() {
        for (int lvt_1_1_ = 0; lvt_1_1_ < this.newDoors.size(); ++lvt_1_1_) {
            VillageDoorInfo lvt_2_1_ = this.newDoors.get(lvt_1_1_);
            Village lvt_3_1_ = this.getNearestVillage(lvt_2_1_.getDoorBlockPos(), 32);
            if (lvt_3_1_ == null) {
                lvt_3_1_ = new Village(this.world);
                this.villageList.add(lvt_3_1_);
                this.markDirty();
            }
            lvt_3_1_.addVillageDoorInfo(lvt_2_1_);
        }
        this.newDoors.clear();
    }

    private void addDoorsAround(BlockPos p_addDoorsAround_1_) {
        int lvt_2_1_ = 16;
        int lvt_3_1_ = 4;
        int lvt_4_1_ = 16;
        for (int lvt_5_1_ = -16; lvt_5_1_ < 16; ++lvt_5_1_) {
            for (int lvt_6_1_ = -4; lvt_6_1_ < 4; ++lvt_6_1_) {
                for (int lvt_7_1_ = -16; lvt_7_1_ < 16; ++lvt_7_1_) {
                    BlockPos lvt_8_1_ = p_addDoorsAround_1_.add(lvt_5_1_, lvt_6_1_, lvt_7_1_);
                    if (!this.isWoodDoor(lvt_8_1_)) continue;
                    VillageDoorInfo lvt_9_1_ = this.checkDoorExistence(lvt_8_1_);
                    if (lvt_9_1_ == null) {
                        this.addToNewDoorsList(lvt_8_1_);
                        continue;
                    }
                    lvt_9_1_.setLastActivityTimestamp(this.tickCounter);
                }
            }
        }
    }

    @Nullable
    private VillageDoorInfo checkDoorExistence(BlockPos p_checkDoorExistence_1_) {
        for (VillageDoorInfo lvt_3_1_ : this.newDoors) {
            if (lvt_3_1_.getDoorBlockPos().getX() != p_checkDoorExistence_1_.getX() || lvt_3_1_.getDoorBlockPos().getZ() != p_checkDoorExistence_1_.getZ() || Math.abs(lvt_3_1_.getDoorBlockPos().getY() - p_checkDoorExistence_1_.getY()) > 1) continue;
            return lvt_3_1_;
        }
        for (Village lvt_3_2_ : this.villageList) {
            VillageDoorInfo lvt_4_1_ = lvt_3_2_.getExistedDoor(p_checkDoorExistence_1_);
            if (lvt_4_1_ == null) continue;
            return lvt_4_1_;
        }
        return null;
    }

    private void addToNewDoorsList(BlockPos p_addToNewDoorsList_1_) {
        int lvt_5_1_;
        EnumFacing lvt_2_1_ = BlockDoor.getFacing(this.world, p_addToNewDoorsList_1_);
        EnumFacing lvt_3_1_ = lvt_2_1_.getOpposite();
        int lvt_4_1_ = this.countBlocksCanSeeSky(p_addToNewDoorsList_1_, lvt_2_1_, 5);
        if (lvt_4_1_ != (lvt_5_1_ = this.countBlocksCanSeeSky(p_addToNewDoorsList_1_, lvt_3_1_, lvt_4_1_ + 1))) {
            this.newDoors.add(new VillageDoorInfo(p_addToNewDoorsList_1_, lvt_4_1_ < lvt_5_1_ ? lvt_2_1_ : lvt_3_1_, this.tickCounter));
        }
    }

    private int countBlocksCanSeeSky(BlockPos p_countBlocksCanSeeSky_1_, EnumFacing p_countBlocksCanSeeSky_2_, int p_countBlocksCanSeeSky_3_) {
        int lvt_4_1_ = 0;
        for (int lvt_5_1_ = 1; lvt_5_1_ <= 5; ++lvt_5_1_) {
            if (!this.world.canSeeSky(p_countBlocksCanSeeSky_1_.offset(p_countBlocksCanSeeSky_2_, lvt_5_1_)) || ++lvt_4_1_ < p_countBlocksCanSeeSky_3_) continue;
            return lvt_4_1_;
        }
        return lvt_4_1_;
    }

    private boolean positionInList(BlockPos p_positionInList_1_) {
        for (BlockPos lvt_3_1_ : this.villagerPositionsList) {
            if (!lvt_3_1_.equals(p_positionInList_1_)) continue;
            return true;
        }
        return false;
    }

    private boolean isWoodDoor(BlockPos p_isWoodDoor_1_) {
        IBlockState lvt_2_1_ = this.world.getBlockState(p_isWoodDoor_1_);
        Block lvt_3_1_ = lvt_2_1_.getBlock();
        if (lvt_3_1_ instanceof BlockDoor) {
            return lvt_2_1_.getMaterial() == Material.WOOD;
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        this.tickCounter = p_readFromNBT_1_.getInteger("Tick");
        NBTTagList lvt_2_1_ = p_readFromNBT_1_.getTagList("Villages", 10);
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_.tagCount(); ++lvt_3_1_) {
            NBTTagCompound lvt_4_1_ = lvt_2_1_.getCompoundTagAt(lvt_3_1_);
            Village lvt_5_1_ = new Village();
            lvt_5_1_.readVillageDataFromNBT(lvt_4_1_);
            this.villageList.add(lvt_5_1_);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
        p_writeToNBT_1_.setInteger("Tick", this.tickCounter);
        NBTTagList lvt_2_1_ = new NBTTagList();
        for (Village lvt_4_1_ : this.villageList) {
            NBTTagCompound lvt_5_1_ = new NBTTagCompound();
            lvt_4_1_.writeVillageDataToNBT(lvt_5_1_);
            lvt_2_1_.appendTag(lvt_5_1_);
        }
        p_writeToNBT_1_.setTag("Villages", lvt_2_1_);
        return p_writeToNBT_1_;
    }

    public static String fileNameForProvider(WorldProvider p_fileNameForProvider_0_) {
        return "villages" + p_fileNameForProvider_0_.getDimensionType().getSuffix();
    }
}

