/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class VillageDoorInfo {
    private final BlockPos doorBlockPos;
    private final BlockPos insideBlock;
    private final EnumFacing insideDirection;
    private int lastActivityTimestamp;
    private boolean isDetachedFromVillageFlag;
    private int doorOpeningRestrictionCounter;

    public VillageDoorInfo(BlockPos p_i45871_1_, int p_i45871_2_, int p_i45871_3_, int p_i45871_4_) {
        this(p_i45871_1_, VillageDoorInfo.getFaceDirection(p_i45871_2_, p_i45871_3_), p_i45871_4_);
    }

    private static EnumFacing getFaceDirection(int p_getFaceDirection_0_, int p_getFaceDirection_1_) {
        if (p_getFaceDirection_0_ < 0) {
            return EnumFacing.WEST;
        }
        if (p_getFaceDirection_0_ > 0) {
            return EnumFacing.EAST;
        }
        if (p_getFaceDirection_1_ < 0) {
            return EnumFacing.NORTH;
        }
        return EnumFacing.SOUTH;
    }

    public VillageDoorInfo(BlockPos p_i45872_1_, EnumFacing p_i45872_2_, int p_i45872_3_) {
        this.doorBlockPos = p_i45872_1_;
        this.insideDirection = p_i45872_2_;
        this.insideBlock = p_i45872_1_.offset(p_i45872_2_, 2);
        this.lastActivityTimestamp = p_i45872_3_;
    }

    public int getDistanceSquared(int p_getDistanceSquared_1_, int p_getDistanceSquared_2_, int p_getDistanceSquared_3_) {
        return (int)this.doorBlockPos.distanceSq(p_getDistanceSquared_1_, p_getDistanceSquared_2_, p_getDistanceSquared_3_);
    }

    public int getDistanceToDoorBlockSq(BlockPos p_getDistanceToDoorBlockSq_1_) {
        return (int)p_getDistanceToDoorBlockSq_1_.distanceSq(this.getDoorBlockPos());
    }

    public int getDistanceToInsideBlockSq(BlockPos p_getDistanceToInsideBlockSq_1_) {
        return (int)this.insideBlock.distanceSq(p_getDistanceToInsideBlockSq_1_);
    }

    public boolean isInsideSide(BlockPos p_isInsideSide_1_) {
        int lvt_2_1_ = p_isInsideSide_1_.getX() - this.doorBlockPos.getX();
        int lvt_3_1_ = p_isInsideSide_1_.getZ() - this.doorBlockPos.getY();
        return lvt_2_1_ * this.insideDirection.getFrontOffsetX() + lvt_3_1_ * this.insideDirection.getFrontOffsetZ() >= 0;
    }

    public void resetDoorOpeningRestrictionCounter() {
        this.doorOpeningRestrictionCounter = 0;
    }

    public void incrementDoorOpeningRestrictionCounter() {
        ++this.doorOpeningRestrictionCounter;
    }

    public int getDoorOpeningRestrictionCounter() {
        return this.doorOpeningRestrictionCounter;
    }

    public BlockPos getDoorBlockPos() {
        return this.doorBlockPos;
    }

    public BlockPos getInsideBlockPos() {
        return this.insideBlock;
    }

    public int getInsideOffsetX() {
        return this.insideDirection.getFrontOffsetX() * 2;
    }

    public int getInsideOffsetZ() {
        return this.insideDirection.getFrontOffsetZ() * 2;
    }

    public int getInsidePosY() {
        return this.lastActivityTimestamp;
    }

    public void setLastActivityTimestamp(int p_setLastActivityTimestamp_1_) {
        this.lastActivityTimestamp = p_setLastActivityTimestamp_1_;
    }

    public boolean getIsDetachedFromVillageFlag() {
        return this.isDetachedFromVillageFlag;
    }

    public void setIsDetachedFromVillageFlag(boolean p_setIsDetachedFromVillageFlag_1_) {
        this.isDetachedFromVillageFlag = p_setIsDetachedFromVillageFlag_1_;
    }

    public EnumFacing getInsideDirection() {
        return this.insideDirection;
    }
}

