/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;

public class VillageSiege {
    private final World world;
    private boolean hasSetupSiege;
    private int siegeState = -1;
    private int siegeCount;
    private int nextSpawnTime;
    private Village theVillage;
    private int spawnX;
    private int spawnY;
    private int spawnZ;

    public VillageSiege(World p_i1676_1_) {
        this.world = p_i1676_1_;
    }

    public void tick() {
        if (this.world.isDaytime()) {
            this.siegeState = 0;
            return;
        }
        if (this.siegeState == 2) {
            return;
        }
        if (this.siegeState == 0) {
            float lvt_1_1_ = this.world.getCelestialAngle(0.0f);
            if ((double)lvt_1_1_ < 0.5 || (double)lvt_1_1_ > 0.501) {
                return;
            }
            this.siegeState = this.world.rand.nextInt(10) == 0 ? 1 : 2;
            this.hasSetupSiege = false;
            if (this.siegeState == 2) {
                return;
            }
        }
        if (this.siegeState == -1) {
            return;
        }
        if (!this.hasSetupSiege) {
            if (this.trySetupSiege()) {
                this.hasSetupSiege = true;
            } else {
                return;
            }
        }
        if (this.nextSpawnTime > 0) {
            --this.nextSpawnTime;
            return;
        }
        this.nextSpawnTime = 2;
        if (this.siegeCount > 0) {
            this.spawnZombie();
            --this.siegeCount;
        } else {
            this.siegeState = 2;
        }
    }

    private boolean trySetupSiege() {
        List<EntityPlayer> lvt_1_1_ = this.world.playerEntities;
        for (EntityPlayer lvt_3_1_ : lvt_1_1_) {
            if (lvt_3_1_.isSpectator()) continue;
            this.theVillage = this.world.getVillageCollection().getNearestVillage(new BlockPos(lvt_3_1_), 1);
            if (this.theVillage == null || this.theVillage.getNumVillageDoors() < 10 || this.theVillage.getTicksSinceLastDoorAdding() < 20 || this.theVillage.getNumVillagers() < 20) continue;
            BlockPos lvt_4_1_ = this.theVillage.getCenter();
            float lvt_5_1_ = this.theVillage.getVillageRadius();
            boolean lvt_6_1_ = false;
            for (int lvt_7_1_ = 0; lvt_7_1_ < 10; ++lvt_7_1_) {
                float lvt_8_1_ = this.world.rand.nextFloat() * ((float)Math.PI * 2);
                this.spawnX = lvt_4_1_.getX() + (int)((double)(MathHelper.cos(lvt_8_1_) * lvt_5_1_) * 0.9);
                this.spawnY = lvt_4_1_.getY();
                this.spawnZ = lvt_4_1_.getZ() + (int)((double)(MathHelper.sin(lvt_8_1_) * lvt_5_1_) * 0.9);
                lvt_6_1_ = false;
                for (Village lvt_10_1_ : this.world.getVillageCollection().getVillageList()) {
                    if (lvt_10_1_ == this.theVillage || !lvt_10_1_.isBlockPosWithinSqVillageRadius(new BlockPos(this.spawnX, this.spawnY, this.spawnZ))) continue;
                    lvt_6_1_ = true;
                    break;
                }
                if (!lvt_6_1_) break;
            }
            if (lvt_6_1_) {
                return false;
            }
            Vec3d lvt_7_2_ = this.findRandomSpawnPos(new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
            if (lvt_7_2_ == null) continue;
            this.nextSpawnTime = 0;
            this.siegeCount = 20;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean spawnZombie() {
        void lvt_2_2_;
        Vec3d lvt_1_1_ = this.findRandomSpawnPos(new BlockPos(this.spawnX, this.spawnY, this.spawnZ));
        if (lvt_1_1_ == null) {
            return false;
        }
        try {
            EntityZombie lvt_2_1_ = new EntityZombie(this.world);
            lvt_2_1_.onInitialSpawn(this.world.getDifficultyForLocation(new BlockPos(lvt_2_1_)), null);
        }
        catch (Exception lvt_3_1_) {
            lvt_3_1_.printStackTrace();
            return false;
        }
        lvt_2_2_.setLocationAndAngles(lvt_1_1_.xCoord, lvt_1_1_.yCoord, lvt_1_1_.zCoord, this.world.rand.nextFloat() * 360.0f, 0.0f);
        this.world.spawnEntity((Entity)lvt_2_2_);
        BlockPos lvt_3_2_ = this.theVillage.getCenter();
        lvt_2_2_.setHomePosAndDistance(lvt_3_2_, this.theVillage.getVillageRadius());
        return true;
    }

    @Nullable
    private Vec3d findRandomSpawnPos(BlockPos p_findRandomSpawnPos_1_) {
        for (int lvt_2_1_ = 0; lvt_2_1_ < 10; ++lvt_2_1_) {
            BlockPos lvt_3_1_ = p_findRandomSpawnPos_1_.add(this.world.rand.nextInt(16) - 8, this.world.rand.nextInt(6) - 3, this.world.rand.nextInt(16) - 8);
            if (!this.theVillage.isBlockPosWithinSqVillageRadius(lvt_3_1_) || !WorldEntitySpawner.canCreatureTypeSpawnAtLocation(EntityLiving.SpawnPlacementType.ON_GROUND, this.world, lvt_3_1_)) continue;
            return new Vec3d(lvt_3_1_.getX(), lvt_3_1_.getY(), lvt_3_1_.getZ());
        }
        return null;
    }
}

