/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.client.Minecraft;
import net.minecraft.network.play.server.SPacketUpdateBossInfo;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BossInfoLerping
extends BossInfo {
    protected float rawPercent;
    protected long percentSetTime;

    public BossInfoLerping(SPacketUpdateBossInfo p_i46605_1_) {
        super(p_i46605_1_.getUniqueId(), p_i46605_1_.getName(), p_i46605_1_.getColor(), p_i46605_1_.getOverlay());
        this.rawPercent = p_i46605_1_.getPercent();
        this.percent = p_i46605_1_.getPercent();
        this.percentSetTime = Minecraft.getSystemTime();
        this.setDarkenSky(p_i46605_1_.shouldDarkenSky());
        this.setPlayEndBossMusic(p_i46605_1_.shouldPlayEndBossMusic());
        this.setCreateFog(p_i46605_1_.shouldCreateFog());
    }

    @Override
    public void setPercent(float p_setPercent_1_) {
        this.percent = this.getPercent();
        this.rawPercent = p_setPercent_1_;
        this.percentSetTime = Minecraft.getSystemTime();
    }

    @Override
    public float getPercent() {
        long lvt_1_1_ = Minecraft.getSystemTime() - this.percentSetTime;
        float lvt_3_1_ = MathHelper.clamp((float)lvt_1_1_ / 100.0f, 0.0f, 1.0f);
        return this.percent + (this.rawPercent - this.percent) * lvt_3_1_;
    }

    public void updateFromPacket(SPacketUpdateBossInfo p_updateFromPacket_1_) {
        switch (p_updateFromPacket_1_.getOperation()) {
            case UPDATE_NAME: {
                this.setName(p_updateFromPacket_1_.getName());
                break;
            }
            case UPDATE_PCT: {
                this.setPercent(p_updateFromPacket_1_.getPercent());
                break;
            }
            case UPDATE_STYLE: {
                this.setColor(p_updateFromPacket_1_.getColor());
                this.setOverlay(p_updateFromPacket_1_.getOverlay());
                break;
            }
            case UPDATE_PROPERTIES: {
                this.setDarkenSky(p_updateFromPacket_1_.shouldDarkenSky());
                this.setPlayEndBossMusic(p_updateFromPacket_1_.shouldPlayEndBossMusic());
            }
        }
    }
}

