/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketUpdateBossInfo;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;

public class BossInfoServer
extends BossInfo {
    private final Set<EntityPlayerMP> players = Sets.newHashSet();
    private final Set<EntityPlayerMP> readOnlyPlayers = Collections.unmodifiableSet(this.players);
    private boolean visible = true;

    public BossInfoServer(ITextComponent p_i46839_1_, BossInfo.Color p_i46839_2_, BossInfo.Overlay p_i46839_3_) {
        super(MathHelper.getRandomUUID(), p_i46839_1_, p_i46839_2_, p_i46839_3_);
    }

    @Override
    public void setPercent(float p_setPercent_1_) {
        if (p_setPercent_1_ != this.percent) {
            super.setPercent(p_setPercent_1_);
            this.sendUpdate(SPacketUpdateBossInfo.Operation.UPDATE_PCT);
        }
    }

    @Override
    public void setColor(BossInfo.Color p_setColor_1_) {
        if (p_setColor_1_ != this.color) {
            super.setColor(p_setColor_1_);
            this.sendUpdate(SPacketUpdateBossInfo.Operation.UPDATE_STYLE);
        }
    }

    @Override
    public void setOverlay(BossInfo.Overlay p_setOverlay_1_) {
        if (p_setOverlay_1_ != this.overlay) {
            super.setOverlay(p_setOverlay_1_);
            this.sendUpdate(SPacketUpdateBossInfo.Operation.UPDATE_STYLE);
        }
    }

    @Override
    public BossInfo setDarkenSky(boolean p_setDarkenSky_1_) {
        if (p_setDarkenSky_1_ != this.darkenSky) {
            super.setDarkenSky(p_setDarkenSky_1_);
            this.sendUpdate(SPacketUpdateBossInfo.Operation.UPDATE_PROPERTIES);
        }
        return this;
    }

    @Override
    public BossInfo setPlayEndBossMusic(boolean p_setPlayEndBossMusic_1_) {
        if (p_setPlayEndBossMusic_1_ != this.playEndBossMusic) {
            super.setPlayEndBossMusic(p_setPlayEndBossMusic_1_);
            this.sendUpdate(SPacketUpdateBossInfo.Operation.UPDATE_PROPERTIES);
        }
        return this;
    }

    @Override
    public BossInfo setCreateFog(boolean p_setCreateFog_1_) {
        if (p_setCreateFog_1_ != this.createFog) {
            super.setCreateFog(p_setCreateFog_1_);
            this.sendUpdate(SPacketUpdateBossInfo.Operation.UPDATE_PROPERTIES);
        }
        return this;
    }

    @Override
    public void setName(ITextComponent p_setName_1_) {
        if (!Objects.equal((Object)p_setName_1_, (Object)this.name)) {
            super.setName(p_setName_1_);
            this.sendUpdate(SPacketUpdateBossInfo.Operation.UPDATE_NAME);
        }
    }

    private void sendUpdate(SPacketUpdateBossInfo.Operation p_sendUpdate_1_) {
        if (this.visible) {
            SPacketUpdateBossInfo spacketupdatebossinfo = new SPacketUpdateBossInfo(p_sendUpdate_1_, this);
            for (EntityPlayerMP entityplayermp : this.players) {
                entityplayermp.connection.sendPacket(spacketupdatebossinfo);
            }
        }
    }

    public void addPlayer(EntityPlayerMP p_addPlayer_1_) {
        if (this.players.add(p_addPlayer_1_) && this.visible) {
            p_addPlayer_1_.connection.sendPacket(new SPacketUpdateBossInfo(SPacketUpdateBossInfo.Operation.ADD, this));
        }
    }

    public void removePlayer(EntityPlayerMP p_removePlayer_1_) {
        if (this.players.remove(p_removePlayer_1_) && this.visible) {
            p_removePlayer_1_.connection.sendPacket(new SPacketUpdateBossInfo(SPacketUpdateBossInfo.Operation.REMOVE, this));
        }
    }

    public void setVisible(boolean p_setVisible_1_) {
        if (p_setVisible_1_ != this.visible) {
            this.visible = p_setVisible_1_;
            for (EntityPlayerMP entityplayermp : this.players) {
                entityplayermp.connection.sendPacket(new SPacketUpdateBossInfo(p_setVisible_1_ ? SPacketUpdateBossInfo.Operation.ADD : SPacketUpdateBossInfo.Operation.REMOVE, this));
            }
        }
    }

    public Collection<EntityPlayerMP> getPlayers() {
        return this.readOnlyPlayers;
    }
}

