/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChunkCache
implements IBlockAccess {
    protected int chunkX;
    protected int chunkZ;
    protected Chunk[][] chunkArray;
    protected boolean hasExtendedLevels;
    protected World world;

    public ChunkCache(World p_i45746_1_, BlockPos p_i45746_2_, BlockPos p_i45746_3_, int p_i45746_4_) {
        this.world = p_i45746_1_;
        this.chunkX = p_i45746_2_.getX() - p_i45746_4_ >> 4;
        this.chunkZ = p_i45746_2_.getZ() - p_i45746_4_ >> 4;
        int i = p_i45746_3_.getX() + p_i45746_4_ >> 4;
        int j = p_i45746_3_.getZ() + p_i45746_4_ >> 4;
        this.chunkArray = new Chunk[i - this.chunkX + 1][j - this.chunkZ + 1];
        this.hasExtendedLevels = true;
        for (int k = this.chunkX; k <= i; ++k) {
            for (int l = this.chunkZ; l <= j; ++l) {
                this.chunkArray[k - this.chunkX][l - this.chunkZ] = p_i45746_1_.getChunkFromChunkCoords(k, l);
            }
        }
        for (int i1 = p_i45746_2_.getX() >> 4; i1 <= p_i45746_3_.getX() >> 4; ++i1) {
            for (int j1 = p_i45746_2_.getZ() >> 4; j1 <= p_i45746_3_.getZ() >> 4; ++j1) {
                Chunk chunk = this.chunkArray[i1 - this.chunkX][j1 - this.chunkZ];
                if (chunk == null || chunk.getAreLevelsEmpty(p_i45746_2_.getY(), p_i45746_3_.getY())) continue;
                this.hasExtendedLevels = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean extendedLevelsInChunkCache() {
        return this.hasExtendedLevels;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(BlockPos p_getTileEntity_1_) {
        return this.getTileEntity(p_getTileEntity_1_, Chunk.EnumCreateEntityType.IMMEDIATE);
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos p_getTileEntity_1_, Chunk.EnumCreateEntityType p_getTileEntity_2_) {
        int i = (p_getTileEntity_1_.getX() >> 4) - this.chunkX;
        int j = (p_getTileEntity_1_.getZ() >> 4) - this.chunkZ;
        if (i < 0 || i >= this.chunkArray.length || j < 0 || j >= this.chunkArray[i].length) {
            return null;
        }
        if (this.chunkArray[i][j] == null) {
            return null;
        }
        return this.chunkArray[i][j].getTileEntity(p_getTileEntity_1_, p_getTileEntity_2_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getCombinedLight(BlockPos p_getCombinedLight_1_, int p_getCombinedLight_2_) {
        int i = this.getLightForExt(EnumSkyBlock.SKY, p_getCombinedLight_1_);
        int j = this.getLightForExt(EnumSkyBlock.BLOCK, p_getCombinedLight_1_);
        if (j < p_getCombinedLight_2_) {
            j = p_getCombinedLight_2_;
        }
        return i << 20 | j << 4;
    }

    @Override
    public IBlockState getBlockState(BlockPos p_getBlockState_1_) {
        if (p_getBlockState_1_.getY() >= 0 && p_getBlockState_1_.getY() < 256) {
            Chunk chunk;
            int i = (p_getBlockState_1_.getX() >> 4) - this.chunkX;
            int j = (p_getBlockState_1_.getZ() >> 4) - this.chunkZ;
            if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
                return chunk.getBlockState(p_getBlockState_1_);
            }
        }
        return Blocks.AIR.getDefaultState();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Biome getBiome(BlockPos p_getBiome_1_) {
        int i = (p_getBiome_1_.getX() >> 4) - this.chunkX;
        int j = (p_getBiome_1_.getZ() >> 4) - this.chunkZ;
        return this.chunkArray[i][j].getBiome(p_getBiome_1_, this.world.getBiomeProvider());
    }

    @SideOnly(value=Side.CLIENT)
    private int getLightForExt(EnumSkyBlock p_getLightForExt_1_, BlockPos p_getLightForExt_2_) {
        if (p_getLightForExt_1_ == EnumSkyBlock.SKY && !this.world.provider.hasSkyLight()) {
            return 0;
        }
        if (p_getLightForExt_2_.getY() >= 0 && p_getLightForExt_2_.getY() < 256) {
            if (this.getBlockState(p_getLightForExt_2_).useNeighborBrightness()) {
                int l = 0;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int k = this.getLightFor(p_getLightForExt_1_, p_getLightForExt_2_.offset(enumfacing));
                    if (k > l) {
                        l = k;
                    }
                    if (l < 15) continue;
                    return l;
                }
                return l;
            }
            int i = (p_getLightForExt_2_.getX() >> 4) - this.chunkX;
            int j = (p_getLightForExt_2_.getZ() >> 4) - this.chunkZ;
            if (i < 0 || i >= this.chunkArray.length || j < 0 || j >= this.chunkArray[i].length) {
                return p_getLightForExt_1_.defaultLightValue;
            }
            if (this.chunkArray[i][j] == null) {
                return p_getLightForExt_1_.defaultLightValue;
            }
            return this.chunkArray[i][j].getLightFor(p_getLightForExt_1_, p_getLightForExt_2_);
        }
        return p_getLightForExt_1_.defaultLightValue;
    }

    @Override
    public boolean isAirBlock(BlockPos p_isAirBlock_1_) {
        IBlockState state = this.getBlockState(p_isAirBlock_1_);
        return state.getBlock().isAir(state, this, p_isAirBlock_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public int getLightFor(EnumSkyBlock p_getLightFor_1_, BlockPos p_getLightFor_2_) {
        if (p_getLightFor_2_.getY() >= 0 && p_getLightFor_2_.getY() < 256) {
            int i = (p_getLightFor_2_.getX() >> 4) - this.chunkX;
            int j = (p_getLightFor_2_.getZ() >> 4) - this.chunkZ;
            if (i < 0 || i >= this.chunkArray.length || j < 0 || j >= this.chunkArray[i].length) {
                return p_getLightFor_1_.defaultLightValue;
            }
            return this.chunkArray[i][j].getLightFor(p_getLightFor_1_, p_getLightFor_2_);
        }
        return p_getLightFor_1_.defaultLightValue;
    }

    @Override
    public int getStrongPower(BlockPos p_getStrongPower_1_, EnumFacing p_getStrongPower_2_) {
        return this.getBlockState(p_getStrongPower_1_).getStrongPower(this, p_getStrongPower_1_, p_getStrongPower_2_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WorldType getWorldType() {
        return this.world.getWorldType();
    }

    @Override
    public boolean isSideSolid(BlockPos p_isSideSolid_1_, EnumFacing p_isSideSolid_2_, boolean p_isSideSolid_3_) {
        int x = (p_isSideSolid_1_.getX() >> 4) - this.chunkX;
        int z = (p_isSideSolid_1_.getZ() >> 4) - this.chunkZ;
        if (p_isSideSolid_1_.getY() < 0 || p_isSideSolid_1_.getY() >= 256) {
            return p_isSideSolid_3_;
        }
        if (x < 0 || x >= this.chunkArray.length || z < 0 || z >= this.chunkArray[x].length) {
            return p_isSideSolid_3_;
        }
        if (this.chunkArray[x][z] == null) {
            return p_isSideSolid_3_;
        }
        IBlockState state = this.getBlockState(p_isSideSolid_1_);
        return state.getBlock().isSideSolid(state, this, p_isSideSolid_1_, p_isSideSolid_2_);
    }
}

