/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.concurrent.Immutable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;

@Immutable
public class DifficultyInstance {
    private final EnumDifficulty worldDifficulty;
    private final float additionalDifficulty;

    public DifficultyInstance(EnumDifficulty p_i45904_1_, long p_i45904_2_, long p_i45904_4_, float p_i45904_6_) {
        this.worldDifficulty = p_i45904_1_;
        this.additionalDifficulty = this.calculateAdditionalDifficulty(p_i45904_1_, p_i45904_2_, p_i45904_4_, p_i45904_6_);
    }

    public float getAdditionalDifficulty() {
        return this.additionalDifficulty;
    }

    public float getClampedAdditionalDifficulty() {
        if (this.additionalDifficulty < 2.0f) {
            return 0.0f;
        }
        if (this.additionalDifficulty > 4.0f) {
            return 1.0f;
        }
        return (this.additionalDifficulty - 2.0f) / 2.0f;
    }

    private float calculateAdditionalDifficulty(EnumDifficulty p_calculateAdditionalDifficulty_1_, long p_calculateAdditionalDifficulty_2_, long p_calculateAdditionalDifficulty_4_, float p_calculateAdditionalDifficulty_6_) {
        if (p_calculateAdditionalDifficulty_1_ == EnumDifficulty.PEACEFUL) {
            return 0.0f;
        }
        boolean lvt_7_1_ = p_calculateAdditionalDifficulty_1_ == EnumDifficulty.HARD;
        float lvt_8_1_ = 0.75f;
        float lvt_9_1_ = MathHelper.clamp(((float)p_calculateAdditionalDifficulty_2_ + -72000.0f) / 1440000.0f, 0.0f, 1.0f) * 0.25f;
        lvt_8_1_ += lvt_9_1_;
        float lvt_10_1_ = 0.0f;
        lvt_10_1_ += MathHelper.clamp((float)p_calculateAdditionalDifficulty_4_ / 3600000.0f, 0.0f, 1.0f) * (lvt_7_1_ ? 1.0f : 0.75f);
        lvt_10_1_ += MathHelper.clamp(p_calculateAdditionalDifficulty_6_ * 0.25f, 0.0f, lvt_9_1_);
        if (p_calculateAdditionalDifficulty_1_ == EnumDifficulty.EASY) {
            lvt_10_1_ *= 0.5f;
        }
        return (float)p_calculateAdditionalDifficulty_1_.getDifficultyId() * (lvt_8_1_ += lvt_10_1_);
    }
}

