/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import net.minecraftforge.common.util.EnumHelper;

public enum DimensionType {
    OVERWORLD(0, "Overworld", "", WorldProviderSurface.class),
    NETHER(-1, "Nether", "_nether", WorldProviderHell.class),
    THE_END(1, "The End", "_end", WorldProviderEnd.class);

    private final int id;
    private final String name;
    private final String suffix;
    private final Class<? extends WorldProvider> clazz;
    private boolean shouldLoadSpawn = false;
    private static Class<?>[] ENUM_ARGS;

    private DimensionType(int p_i46672_3_, String p_i46672_4_, String p_i46672_5_, Class<? extends WorldProvider> p_i46672_6_) {
        this.id = p_i46672_3_;
        this.name = p_i46672_4_;
        this.suffix = p_i46672_5_;
        this.clazz = p_i46672_6_;
        this.shouldLoadSpawn = p_i46672_3_ == 0;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public WorldProvider createDimension() {
        try {
            Constructor<? extends WorldProvider> constructor = this.clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException nosuchmethodexception) {
            throw new Error("Could not create new dimension", nosuchmethodexception);
        }
        catch (InvocationTargetException invocationtargetexception) {
            throw new Error("Could not create new dimension", invocationtargetexception);
        }
        catch (InstantiationException instantiationexception) {
            throw new Error("Could not create new dimension", instantiationexception);
        }
        catch (IllegalAccessException illegalaccessexception) {
            throw new Error("Could not create new dimension", illegalaccessexception);
        }
    }

    public static DimensionType getById(int p_getById_0_) {
        for (DimensionType dimensiontype : DimensionType.values()) {
            if (dimensiontype.getId() != p_getById_0_) continue;
            return dimensiontype;
        }
        throw new IllegalArgumentException("Invalid dimension id " + p_getById_0_);
    }

    public boolean shouldLoadSpawn() {
        return this.shouldLoadSpawn;
    }

    public DimensionType setLoadSpawn(boolean p_setLoadSpawn_1_) {
        this.shouldLoadSpawn = p_setLoadSpawn_1_;
        return this;
    }

    public static DimensionType register(String p_register_0_, String p_register_1_, int p_register_2_, Class<? extends WorldProvider> p_register_3_, boolean p_register_4_) {
        String enum_name = p_register_0_.replace(" ", "_").toLowerCase();
        DimensionType ret = EnumHelper.addEnum(DimensionType.class, enum_name, ENUM_ARGS, new Object[]{p_register_2_, p_register_0_, p_register_1_, p_register_3_});
        return ret.setLoadSpawn(p_register_4_);
    }

    static {
        ENUM_ARGS = new Class[]{Integer.TYPE, String.class, String.class, Class.class};
        EnumHelper.testEnum(DimensionType.class, ENUM_ARGS);
    }
}

