/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Set;
import java.util.TreeMap;
import net.minecraft.nbt.NBTTagCompound;

public class GameRules {
    private final TreeMap<String, Value> theGameRules = new TreeMap();

    public GameRules() {
        this.addGameRule("doFireTick", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("mobGriefing", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("keepInventory", "false", ValueType.BOOLEAN_VALUE);
        this.addGameRule("doMobSpawning", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("doMobLoot", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("doTileDrops", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("doEntityDrops", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("commandBlockOutput", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("naturalRegeneration", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("doDaylightCycle", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("logAdminCommands", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("showDeathMessages", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("randomTickSpeed", "3", ValueType.NUMERICAL_VALUE);
        this.addGameRule("sendCommandFeedback", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("reducedDebugInfo", "false", ValueType.BOOLEAN_VALUE);
        this.addGameRule("spectatorsGenerateChunks", "true", ValueType.BOOLEAN_VALUE);
        this.addGameRule("spawnRadius", "10", ValueType.NUMERICAL_VALUE);
        this.addGameRule("disableElytraMovementCheck", "false", ValueType.BOOLEAN_VALUE);
        this.addGameRule("maxEntityCramming", "24", ValueType.NUMERICAL_VALUE);
        this.addGameRule("doWeatherCycle", "true", ValueType.BOOLEAN_VALUE);
    }

    public void addGameRule(String p_addGameRule_1_, String p_addGameRule_2_, ValueType p_addGameRule_3_) {
        this.theGameRules.put(p_addGameRule_1_, new Value(p_addGameRule_2_, p_addGameRule_3_));
    }

    public void setOrCreateGameRule(String p_setOrCreateGameRule_1_, String p_setOrCreateGameRule_2_) {
        Value lvt_3_1_ = this.theGameRules.get(p_setOrCreateGameRule_1_);
        if (lvt_3_1_ != null) {
            lvt_3_1_.setValue(p_setOrCreateGameRule_2_);
        } else {
            this.addGameRule(p_setOrCreateGameRule_1_, p_setOrCreateGameRule_2_, ValueType.ANY_VALUE);
        }
    }

    public String getString(String p_getString_1_) {
        Value lvt_2_1_ = this.theGameRules.get(p_getString_1_);
        if (lvt_2_1_ != null) {
            return lvt_2_1_.getString();
        }
        return "";
    }

    public boolean getBoolean(String p_getBoolean_1_) {
        Value lvt_2_1_ = this.theGameRules.get(p_getBoolean_1_);
        if (lvt_2_1_ != null) {
            return lvt_2_1_.getBoolean();
        }
        return false;
    }

    public int getInt(String p_getInt_1_) {
        Value lvt_2_1_ = this.theGameRules.get(p_getInt_1_);
        if (lvt_2_1_ != null) {
            return lvt_2_1_.getInt();
        }
        return 0;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound lvt_1_1_ = new NBTTagCompound();
        for (String lvt_3_1_ : this.theGameRules.keySet()) {
            Value lvt_4_1_ = this.theGameRules.get(lvt_3_1_);
            lvt_1_1_.setString(lvt_3_1_, lvt_4_1_.getString());
        }
        return lvt_1_1_;
    }

    public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
        Set<String> lvt_2_1_ = p_readFromNBT_1_.getKeySet();
        for (String lvt_4_1_ : lvt_2_1_) {
            this.setOrCreateGameRule(lvt_4_1_, p_readFromNBT_1_.getString(lvt_4_1_));
        }
    }

    public String[] getRules() {
        Set<String> lvt_1_1_ = this.theGameRules.keySet();
        return lvt_1_1_.toArray(new String[lvt_1_1_.size()]);
    }

    public boolean hasRule(String p_hasRule_1_) {
        return this.theGameRules.containsKey(p_hasRule_1_);
    }

    public boolean areSameType(String p_areSameType_1_, ValueType p_areSameType_2_) {
        Value lvt_3_1_ = this.theGameRules.get(p_areSameType_1_);
        return lvt_3_1_ != null && (lvt_3_1_.getType() == p_areSameType_2_ || p_areSameType_2_ == ValueType.ANY_VALUE);
    }

    public static enum ValueType {
        ANY_VALUE,
        BOOLEAN_VALUE,
        NUMERICAL_VALUE;

    }

    static class Value {
        private String valueString;
        private boolean valueBoolean;
        private int valueInteger;
        private double valueDouble;
        private final ValueType type;

        public Value(String p_i45751_1_, ValueType p_i45751_2_) {
            this.type = p_i45751_2_;
            this.setValue(p_i45751_1_);
        }

        public void setValue(String p_setValue_1_) {
            this.valueString = p_setValue_1_;
            this.valueBoolean = Boolean.parseBoolean(p_setValue_1_);
            this.valueInteger = this.valueBoolean ? 1 : 0;
            try {
                this.valueInteger = Integer.parseInt(p_setValue_1_);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.valueDouble = Double.parseDouble(p_setValue_1_);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public String getString() {
            return this.valueString;
        }

        public boolean getBoolean() {
            return this.valueBoolean;
        }

        public int getInt() {
            return this.valueInteger;
        }

        public ValueType getType() {
            return this.type;
        }
    }
}

