/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum GameType {
    NOT_SET(-1, "", ""),
    SURVIVAL(0, "survival", "s"),
    CREATIVE(1, "creative", "c"),
    ADVENTURE(2, "adventure", "a"),
    SPECTATOR(3, "spectator", "sp");

    int id;
    String name;
    String shortName;

    private GameType(int p_i46718_3_, String p_i46718_4_, String p_i46718_5_) {
        this.id = p_i46718_3_;
        this.name = p_i46718_4_;
        this.shortName = p_i46718_5_;
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void configurePlayerCapabilities(PlayerCapabilities p_configurePlayerCapabilities_1_) {
        if (this == CREATIVE) {
            p_configurePlayerCapabilities_1_.allowFlying = true;
            p_configurePlayerCapabilities_1_.isCreativeMode = true;
            p_configurePlayerCapabilities_1_.disableDamage = true;
        } else if (this == SPECTATOR) {
            p_configurePlayerCapabilities_1_.allowFlying = true;
            p_configurePlayerCapabilities_1_.isCreativeMode = false;
            p_configurePlayerCapabilities_1_.disableDamage = true;
            p_configurePlayerCapabilities_1_.isFlying = true;
        } else {
            p_configurePlayerCapabilities_1_.allowFlying = false;
            p_configurePlayerCapabilities_1_.isCreativeMode = false;
            p_configurePlayerCapabilities_1_.disableDamage = false;
            p_configurePlayerCapabilities_1_.isFlying = false;
        }
        p_configurePlayerCapabilities_1_.allowEdit = !this.isAdventure();
    }

    public boolean isAdventure() {
        return this == ADVENTURE || this == SPECTATOR;
    }

    public boolean isCreative() {
        return this == CREATIVE;
    }

    public boolean isSurvivalOrAdventure() {
        return this == SURVIVAL || this == ADVENTURE;
    }

    public static GameType getByID(int p_getByID_0_) {
        return GameType.parseGameTypeWithDefault(p_getByID_0_, SURVIVAL);
    }

    public static GameType parseGameTypeWithDefault(int p_parseGameTypeWithDefault_0_, GameType p_parseGameTypeWithDefault_1_) {
        for (GameType lvt_5_1_ : GameType.values()) {
            if (lvt_5_1_.id != p_parseGameTypeWithDefault_0_) continue;
            return lvt_5_1_;
        }
        return p_parseGameTypeWithDefault_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public static GameType getByName(String p_getByName_0_) {
        return GameType.parseGameTypeWithDefault(p_getByName_0_, SURVIVAL);
    }

    public static GameType parseGameTypeWithDefault(String p_parseGameTypeWithDefault_0_, GameType p_parseGameTypeWithDefault_1_) {
        for (GameType lvt_5_1_ : GameType.values()) {
            if (!lvt_5_1_.name.equals(p_parseGameTypeWithDefault_0_) && !lvt_5_1_.shortName.equals(p_parseGameTypeWithDefault_0_)) continue;
            return lvt_5_1_;
        }
        return p_parseGameTypeWithDefault_1_;
    }
}

