/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.server.SPacketBlockBreakAnim;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ServerWorldEventHandler
implements IWorldEventListener {
    private final MinecraftServer mcServer;
    private final WorldServer world;

    public ServerWorldEventHandler(MinecraftServer p_i1517_1_, WorldServer p_i1517_2_) {
        this.mcServer = p_i1517_1_;
        this.world = p_i1517_2_;
    }

    @Override
    public void spawnParticle(int p_spawnParticle_1_, boolean p_spawnParticle_2_, double p_spawnParticle_3_, double p_spawnParticle_5_, double p_spawnParticle_7_, double p_spawnParticle_9_, double p_spawnParticle_11_, double p_spawnParticle_13_, int ... p_spawnParticle_15_) {
    }

    @Override
    public void spawnParticle(int p_spawnParticle_1_, boolean p_spawnParticle_2_, boolean p_spawnParticle_3_, double p_spawnParticle_4_, double p_spawnParticle_6_, double p_spawnParticle_8_, double p_spawnParticle_10_, double p_spawnParticle_12_, double p_spawnParticle_14_, int ... p_spawnParticle_16_) {
    }

    @Override
    public void onEntityAdded(Entity p_onEntityAdded_1_) {
        this.world.getEntityTracker().track(p_onEntityAdded_1_);
        if (p_onEntityAdded_1_ instanceof EntityPlayerMP) {
            this.world.provider.onPlayerAdded((EntityPlayerMP)p_onEntityAdded_1_);
        }
    }

    @Override
    public void onEntityRemoved(Entity p_onEntityRemoved_1_) {
        this.world.getEntityTracker().untrack(p_onEntityRemoved_1_);
        this.world.getScoreboard().removeEntity(p_onEntityRemoved_1_);
        if (p_onEntityRemoved_1_ instanceof EntityPlayerMP) {
            this.world.provider.onPlayerRemoved((EntityPlayerMP)p_onEntityRemoved_1_);
        }
    }

    @Override
    public void playSoundToAllNearExcept(EntityPlayer p_playSoundToAllNearExcept_1_, SoundEvent p_playSoundToAllNearExcept_2_, SoundCategory p_playSoundToAllNearExcept_3_, double p_playSoundToAllNearExcept_4_, double p_playSoundToAllNearExcept_6_, double p_playSoundToAllNearExcept_8_, float p_playSoundToAllNearExcept_10_, float p_playSoundToAllNearExcept_11_) {
        this.mcServer.getPlayerList().sendToAllNearExcept(p_playSoundToAllNearExcept_1_, p_playSoundToAllNearExcept_4_, p_playSoundToAllNearExcept_6_, p_playSoundToAllNearExcept_8_, p_playSoundToAllNearExcept_10_ > 1.0f ? (double)(16.0f * p_playSoundToAllNearExcept_10_) : 16.0, this.world.provider.getDimension(), new SPacketSoundEffect(p_playSoundToAllNearExcept_2_, p_playSoundToAllNearExcept_3_, p_playSoundToAllNearExcept_4_, p_playSoundToAllNearExcept_6_, p_playSoundToAllNearExcept_8_, p_playSoundToAllNearExcept_10_, p_playSoundToAllNearExcept_11_));
    }

    @Override
    public void markBlockRangeForRenderUpdate(int p_markBlockRangeForRenderUpdate_1_, int p_markBlockRangeForRenderUpdate_2_, int p_markBlockRangeForRenderUpdate_3_, int p_markBlockRangeForRenderUpdate_4_, int p_markBlockRangeForRenderUpdate_5_, int p_markBlockRangeForRenderUpdate_6_) {
    }

    @Override
    public void notifyBlockUpdate(World p_notifyBlockUpdate_1_, BlockPos p_notifyBlockUpdate_2_, IBlockState p_notifyBlockUpdate_3_, IBlockState p_notifyBlockUpdate_4_, int p_notifyBlockUpdate_5_) {
        this.world.getPlayerChunkMap().markBlockForUpdate(p_notifyBlockUpdate_2_);
    }

    @Override
    public void notifyLightSet(BlockPos p_notifyLightSet_1_) {
    }

    @Override
    public void playRecord(SoundEvent p_playRecord_1_, BlockPos p_playRecord_2_) {
    }

    @Override
    public void playEvent(EntityPlayer p_playEvent_1_, int p_playEvent_2_, BlockPos p_playEvent_3_, int p_playEvent_4_) {
        this.mcServer.getPlayerList().sendToAllNearExcept(p_playEvent_1_, p_playEvent_3_.getX(), p_playEvent_3_.getY(), p_playEvent_3_.getZ(), 64.0, this.world.provider.getDimension(), new SPacketEffect(p_playEvent_2_, p_playEvent_3_, p_playEvent_4_, false));
    }

    @Override
    public void broadcastSound(int p_broadcastSound_1_, BlockPos p_broadcastSound_2_, int p_broadcastSound_3_) {
        this.mcServer.getPlayerList().sendPacketToAllPlayers(new SPacketEffect(p_broadcastSound_1_, p_broadcastSound_2_, p_broadcastSound_3_, true));
    }

    @Override
    public void sendBlockBreakProgress(int p_sendBlockBreakProgress_1_, BlockPos p_sendBlockBreakProgress_2_, int p_sendBlockBreakProgress_3_) {
        for (EntityPlayerMP entityplayermp : this.mcServer.getPlayerList().getPlayers()) {
            double d2;
            double d1;
            double d0;
            if (entityplayermp == null || entityplayermp.world != this.world || entityplayermp.getEntityId() == p_sendBlockBreakProgress_1_ || !((d0 = (double)p_sendBlockBreakProgress_2_.getX() - entityplayermp.posX) * d0 + (d1 = (double)p_sendBlockBreakProgress_2_.getY() - entityplayermp.posY) * d1 + (d2 = (double)p_sendBlockBreakProgress_2_.getZ() - entityplayermp.posZ) * d2 < 1024.0)) continue;
            entityplayermp.connection.sendPacket(new SPacketBlockBreakAnim(p_sendBlockBreakProgress_1_, p_sendBlockBreakProgress_2_, p_sendBlockBreakProgress_3_));
        }
    }
}

