/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Random;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;

public class Teleporter {
    private final WorldServer worldServerInstance;
    private final Random random;
    private final Long2ObjectMap<PortalPosition> destinationCoordinateCache = new Long2ObjectOpenHashMap(4096);

    public Teleporter(WorldServer p_i1963_1_) {
        this.worldServerInstance = p_i1963_1_;
        this.random = new Random(p_i1963_1_.getSeed());
    }

    public void placeInPortal(Entity p_placeInPortal_1_, float p_placeInPortal_2_) {
        if (this.worldServerInstance.provider.getDimensionType().getId() == 1) {
            int lvt_3_1_ = MathHelper.floor(p_placeInPortal_1_.posX);
            int lvt_4_1_ = MathHelper.floor(p_placeInPortal_1_.posY) - 1;
            int lvt_5_1_ = MathHelper.floor(p_placeInPortal_1_.posZ);
            boolean lvt_6_1_ = true;
            boolean lvt_7_1_ = false;
            for (int lvt_8_1_ = -2; lvt_8_1_ <= 2; ++lvt_8_1_) {
                for (int lvt_9_1_ = -2; lvt_9_1_ <= 2; ++lvt_9_1_) {
                    for (int lvt_10_1_ = -1; lvt_10_1_ < 3; ++lvt_10_1_) {
                        int lvt_11_1_ = lvt_3_1_ + lvt_9_1_ * 1 + lvt_8_1_ * 0;
                        int lvt_12_1_ = lvt_4_1_ + lvt_10_1_;
                        int lvt_13_1_ = lvt_5_1_ + lvt_9_1_ * 0 - lvt_8_1_ * 1;
                        boolean lvt_14_1_ = lvt_10_1_ < 0;
                        this.worldServerInstance.setBlockState(new BlockPos(lvt_11_1_, lvt_12_1_, lvt_13_1_), lvt_14_1_ ? Blocks.OBSIDIAN.getDefaultState() : Blocks.AIR.getDefaultState());
                    }
                }
            }
            p_placeInPortal_1_.setLocationAndAngles(lvt_3_1_, lvt_4_1_, lvt_5_1_, p_placeInPortal_1_.rotationYaw, 0.0f);
            p_placeInPortal_1_.motionX = 0.0;
            p_placeInPortal_1_.motionY = 0.0;
            p_placeInPortal_1_.motionZ = 0.0;
            return;
        }
        if (this.placeInExistingPortal(p_placeInPortal_1_, p_placeInPortal_2_)) {
            return;
        }
        this.makePortal(p_placeInPortal_1_);
        this.placeInExistingPortal(p_placeInPortal_1_, p_placeInPortal_2_);
    }

    public boolean placeInExistingPortal(Entity p_placeInExistingPortal_1_, float p_placeInExistingPortal_2_) {
        int lvt_3_1_ = 128;
        double lvt_4_1_ = -1.0;
        int lvt_6_1_ = MathHelper.floor(p_placeInExistingPortal_1_.posX);
        int lvt_7_1_ = MathHelper.floor(p_placeInExistingPortal_1_.posZ);
        boolean lvt_8_1_ = true;
        BlockPos lvt_9_1_ = BlockPos.ORIGIN;
        long lvt_10_1_ = ChunkPos.asLong(lvt_6_1_, lvt_7_1_);
        if (this.destinationCoordinateCache.containsKey(lvt_10_1_)) {
            PortalPosition lvt_12_1_ = (PortalPosition)this.destinationCoordinateCache.get(lvt_10_1_);
            lvt_4_1_ = 0.0;
            lvt_9_1_ = lvt_12_1_;
            lvt_12_1_.lastUpdateTime = this.worldServerInstance.getTotalWorldTime();
            lvt_8_1_ = false;
        } else {
            BlockPos lvt_12_2_ = new BlockPos(p_placeInExistingPortal_1_);
            for (int lvt_13_1_ = -128; lvt_13_1_ <= 128; ++lvt_13_1_) {
                for (int lvt_14_1_ = -128; lvt_14_1_ <= 128; ++lvt_14_1_) {
                    BlockPos lvt_15_1_ = lvt_12_2_.add(lvt_13_1_, this.worldServerInstance.getActualHeight() - 1 - lvt_12_2_.getY(), lvt_14_1_);
                    while (lvt_15_1_.getY() >= 0) {
                        BlockPos lvt_16_1_ = lvt_15_1_.down();
                        if (this.worldServerInstance.getBlockState(lvt_15_1_).getBlock() == Blocks.PORTAL) {
                            lvt_16_1_ = lvt_15_1_.down();
                            while (this.worldServerInstance.getBlockState(lvt_16_1_).getBlock() == Blocks.PORTAL) {
                                lvt_15_1_ = lvt_16_1_;
                                lvt_16_1_ = lvt_15_1_.down();
                            }
                            double lvt_17_1_ = lvt_15_1_.distanceSq(lvt_12_2_);
                            if (lvt_4_1_ < 0.0 || lvt_17_1_ < lvt_4_1_) {
                                lvt_4_1_ = lvt_17_1_;
                                lvt_9_1_ = lvt_15_1_;
                            }
                        }
                        lvt_15_1_ = lvt_16_1_;
                    }
                }
            }
        }
        if (lvt_4_1_ >= 0.0) {
            if (lvt_8_1_) {
                this.destinationCoordinateCache.put(lvt_10_1_, (Object)new PortalPosition(lvt_9_1_, this.worldServerInstance.getTotalWorldTime()));
            }
            double lvt_12_3_ = (double)lvt_9_1_.getX() + 0.5;
            double lvt_16_2_ = (double)lvt_9_1_.getZ() + 0.5;
            BlockPattern.PatternHelper lvt_18_1_ = Blocks.PORTAL.createPatternHelper(this.worldServerInstance, lvt_9_1_);
            boolean lvt_19_1_ = lvt_18_1_.getForwards().rotateY().getAxisDirection() == EnumFacing.AxisDirection.NEGATIVE;
            double lvt_20_1_ = lvt_18_1_.getForwards().getAxis() == EnumFacing.Axis.X ? (double)lvt_18_1_.getFrontTopLeft().getZ() : (double)lvt_18_1_.getFrontTopLeft().getX();
            double lvt_14_2_ = (double)(lvt_18_1_.getFrontTopLeft().getY() + 1) - p_placeInExistingPortal_1_.getLastPortalVec().yCoord * (double)lvt_18_1_.getHeight();
            if (lvt_19_1_) {
                lvt_20_1_ += 1.0;
            }
            if (lvt_18_1_.getForwards().getAxis() == EnumFacing.Axis.X) {
                lvt_16_2_ = lvt_20_1_ + (1.0 - p_placeInExistingPortal_1_.getLastPortalVec().xCoord) * (double)lvt_18_1_.getWidth() * (double)lvt_18_1_.getForwards().rotateY().getAxisDirection().getOffset();
            } else {
                lvt_12_3_ = lvt_20_1_ + (1.0 - p_placeInExistingPortal_1_.getLastPortalVec().xCoord) * (double)lvt_18_1_.getWidth() * (double)lvt_18_1_.getForwards().rotateY().getAxisDirection().getOffset();
            }
            float lvt_22_1_ = 0.0f;
            float lvt_23_1_ = 0.0f;
            float lvt_24_1_ = 0.0f;
            float lvt_25_1_ = 0.0f;
            if (lvt_18_1_.getForwards().getOpposite() == p_placeInExistingPortal_1_.getTeleportDirection()) {
                lvt_22_1_ = 1.0f;
                lvt_23_1_ = 1.0f;
            } else if (lvt_18_1_.getForwards().getOpposite() == p_placeInExistingPortal_1_.getTeleportDirection().getOpposite()) {
                lvt_22_1_ = -1.0f;
                lvt_23_1_ = -1.0f;
            } else if (lvt_18_1_.getForwards().getOpposite() == p_placeInExistingPortal_1_.getTeleportDirection().rotateY()) {
                lvt_24_1_ = 1.0f;
                lvt_25_1_ = -1.0f;
            } else {
                lvt_24_1_ = -1.0f;
                lvt_25_1_ = 1.0f;
            }
            double lvt_26_1_ = p_placeInExistingPortal_1_.motionX;
            double lvt_28_1_ = p_placeInExistingPortal_1_.motionZ;
            p_placeInExistingPortal_1_.motionX = lvt_26_1_ * (double)lvt_22_1_ + lvt_28_1_ * (double)lvt_25_1_;
            p_placeInExistingPortal_1_.motionZ = lvt_26_1_ * (double)lvt_24_1_ + lvt_28_1_ * (double)lvt_23_1_;
            p_placeInExistingPortal_1_.rotationYaw = p_placeInExistingPortal_2_ - (float)(p_placeInExistingPortal_1_.getTeleportDirection().getOpposite().getHorizontalIndex() * 90) + (float)(lvt_18_1_.getForwards().getHorizontalIndex() * 90);
            if (p_placeInExistingPortal_1_ instanceof EntityPlayerMP) {
                ((EntityPlayerMP)p_placeInExistingPortal_1_).connection.setPlayerLocation(lvt_12_3_, lvt_14_2_, lvt_16_2_, p_placeInExistingPortal_1_.rotationYaw, p_placeInExistingPortal_1_.rotationPitch);
            } else {
                p_placeInExistingPortal_1_.setLocationAndAngles(lvt_12_3_, lvt_14_2_, lvt_16_2_, p_placeInExistingPortal_1_.rotationYaw, p_placeInExistingPortal_1_.rotationPitch);
            }
            return true;
        }
        return false;
    }

    public boolean makePortal(Entity p_makePortal_1_) {
        int lvt_2_1_ = 16;
        double lvt_3_1_ = -1.0;
        int lvt_5_1_ = MathHelper.floor(p_makePortal_1_.posX);
        int lvt_6_1_ = MathHelper.floor(p_makePortal_1_.posY);
        int lvt_7_1_ = MathHelper.floor(p_makePortal_1_.posZ);
        int lvt_8_1_ = lvt_5_1_;
        int lvt_9_1_ = lvt_6_1_;
        int lvt_10_1_ = lvt_7_1_;
        int lvt_11_1_ = 0;
        int lvt_12_1_ = this.random.nextInt(4);
        BlockPos.MutableBlockPos lvt_13_1_ = new BlockPos.MutableBlockPos();
        for (int lvt_14_1_ = lvt_5_1_ - 16; lvt_14_1_ <= lvt_5_1_ + 16; ++lvt_14_1_) {
            double lvt_15_1_ = (double)lvt_14_1_ + 0.5 - p_makePortal_1_.posX;
            for (int lvt_17_1_ = lvt_7_1_ - 16; lvt_17_1_ <= lvt_7_1_ + 16; ++lvt_17_1_) {
                double lvt_18_1_ = (double)lvt_17_1_ + 0.5 - p_makePortal_1_.posZ;
                block2: for (int lvt_20_1_ = this.worldServerInstance.getActualHeight() - 1; lvt_20_1_ >= 0; --lvt_20_1_) {
                    if (!this.worldServerInstance.isAirBlock(lvt_13_1_.setPos(lvt_14_1_, lvt_20_1_, lvt_17_1_))) continue;
                    while (lvt_20_1_ > 0 && this.worldServerInstance.isAirBlock(lvt_13_1_.setPos(lvt_14_1_, lvt_20_1_ - 1, lvt_17_1_))) {
                        --lvt_20_1_;
                    }
                    for (int lvt_21_1_ = lvt_12_1_; lvt_21_1_ < lvt_12_1_ + 4; ++lvt_21_1_) {
                        int lvt_22_1_ = lvt_21_1_ % 2;
                        int lvt_23_1_ = 1 - lvt_22_1_;
                        if (lvt_21_1_ % 4 >= 2) {
                            lvt_22_1_ = -lvt_22_1_;
                            lvt_23_1_ = -lvt_23_1_;
                        }
                        for (int lvt_24_1_ = 0; lvt_24_1_ < 3; ++lvt_24_1_) {
                            for (int lvt_25_1_ = 0; lvt_25_1_ < 4; ++lvt_25_1_) {
                                for (int lvt_26_1_ = -1; lvt_26_1_ < 4; ++lvt_26_1_) {
                                    int lvt_27_1_ = lvt_14_1_ + (lvt_25_1_ - 1) * lvt_22_1_ + lvt_24_1_ * lvt_23_1_;
                                    int lvt_28_1_ = lvt_20_1_ + lvt_26_1_;
                                    int lvt_29_1_ = lvt_17_1_ + (lvt_25_1_ - 1) * lvt_23_1_ - lvt_24_1_ * lvt_22_1_;
                                    lvt_13_1_.setPos(lvt_27_1_, lvt_28_1_, lvt_29_1_);
                                    if (lvt_26_1_ < 0 && !this.worldServerInstance.getBlockState(lvt_13_1_).getMaterial().isSolid() || lvt_26_1_ >= 0 && !this.worldServerInstance.isAirBlock(lvt_13_1_)) continue block2;
                                }
                            }
                        }
                        double lvt_24_2_ = (double)lvt_20_1_ + 0.5 - p_makePortal_1_.posY;
                        double lvt_26_2_ = lvt_15_1_ * lvt_15_1_ + lvt_24_2_ * lvt_24_2_ + lvt_18_1_ * lvt_18_1_;
                        if (!(lvt_3_1_ < 0.0) && !(lvt_26_2_ < lvt_3_1_)) continue;
                        lvt_3_1_ = lvt_26_2_;
                        lvt_8_1_ = lvt_14_1_;
                        lvt_9_1_ = lvt_20_1_;
                        lvt_10_1_ = lvt_17_1_;
                        lvt_11_1_ = lvt_21_1_ % 4;
                    }
                }
            }
        }
        if (lvt_3_1_ < 0.0) {
            for (int lvt_14_2_ = lvt_5_1_ - 16; lvt_14_2_ <= lvt_5_1_ + 16; ++lvt_14_2_) {
                double lvt_15_2_ = (double)lvt_14_2_ + 0.5 - p_makePortal_1_.posX;
                for (int lvt_17_2_ = lvt_7_1_ - 16; lvt_17_2_ <= lvt_7_1_ + 16; ++lvt_17_2_) {
                    double lvt_18_2_ = (double)lvt_17_2_ + 0.5 - p_makePortal_1_.posZ;
                    block10: for (int lvt_20_2_ = this.worldServerInstance.getActualHeight() - 1; lvt_20_2_ >= 0; --lvt_20_2_) {
                        if (!this.worldServerInstance.isAirBlock(lvt_13_1_.setPos(lvt_14_2_, lvt_20_2_, lvt_17_2_))) continue;
                        while (lvt_20_2_ > 0 && this.worldServerInstance.isAirBlock(lvt_13_1_.setPos(lvt_14_2_, lvt_20_2_ - 1, lvt_17_2_))) {
                            --lvt_20_2_;
                        }
                        for (int lvt_21_2_ = lvt_12_1_; lvt_21_2_ < lvt_12_1_ + 2; ++lvt_21_2_) {
                            int lvt_22_2_ = lvt_21_2_ % 2;
                            int lvt_23_2_ = 1 - lvt_22_2_;
                            for (int lvt_24_3_ = 0; lvt_24_3_ < 4; ++lvt_24_3_) {
                                for (int lvt_25_2_ = -1; lvt_25_2_ < 4; ++lvt_25_2_) {
                                    int lvt_26_3_ = lvt_14_2_ + (lvt_24_3_ - 1) * lvt_22_2_;
                                    int lvt_27_2_ = lvt_20_2_ + lvt_25_2_;
                                    int lvt_28_2_ = lvt_17_2_ + (lvt_24_3_ - 1) * lvt_23_2_;
                                    lvt_13_1_.setPos(lvt_26_3_, lvt_27_2_, lvt_28_2_);
                                    if (lvt_25_2_ < 0 && !this.worldServerInstance.getBlockState(lvt_13_1_).getMaterial().isSolid() || lvt_25_2_ >= 0 && !this.worldServerInstance.isAirBlock(lvt_13_1_)) continue block10;
                                }
                            }
                            double lvt_24_4_ = (double)lvt_20_2_ + 0.5 - p_makePortal_1_.posY;
                            double lvt_26_4_ = lvt_15_2_ * lvt_15_2_ + lvt_24_4_ * lvt_24_4_ + lvt_18_2_ * lvt_18_2_;
                            if (!(lvt_3_1_ < 0.0) && !(lvt_26_4_ < lvt_3_1_)) continue;
                            lvt_3_1_ = lvt_26_4_;
                            lvt_8_1_ = lvt_14_2_;
                            lvt_9_1_ = lvt_20_2_;
                            lvt_10_1_ = lvt_17_2_;
                            lvt_11_1_ = lvt_21_2_ % 2;
                        }
                    }
                }
            }
        }
        int lvt_14_3_ = lvt_11_1_;
        int lvt_15_3_ = lvt_8_1_;
        int lvt_16_1_ = lvt_9_1_;
        int lvt_17_3_ = lvt_10_1_;
        int lvt_18_3_ = lvt_14_3_ % 2;
        int lvt_19_1_ = 1 - lvt_18_3_;
        if (lvt_14_3_ % 4 >= 2) {
            lvt_18_3_ = -lvt_18_3_;
            lvt_19_1_ = -lvt_19_1_;
        }
        if (lvt_3_1_ < 0.0) {
            lvt_16_1_ = lvt_9_1_ = MathHelper.clamp(lvt_9_1_, 70, this.worldServerInstance.getActualHeight() - 10);
            for (int lvt_20_3_ = -1; lvt_20_3_ <= 1; ++lvt_20_3_) {
                for (int lvt_21_3_ = 1; lvt_21_3_ < 3; ++lvt_21_3_) {
                    for (int lvt_22_3_ = -1; lvt_22_3_ < 3; ++lvt_22_3_) {
                        int lvt_23_3_ = lvt_15_3_ + (lvt_21_3_ - 1) * lvt_18_3_ + lvt_20_3_ * lvt_19_1_;
                        int lvt_24_5_ = lvt_16_1_ + lvt_22_3_;
                        int lvt_25_3_ = lvt_17_3_ + (lvt_21_3_ - 1) * lvt_19_1_ - lvt_20_3_ * lvt_18_3_;
                        boolean lvt_26_5_ = lvt_22_3_ < 0;
                        this.worldServerInstance.setBlockState(new BlockPos(lvt_23_3_, lvt_24_5_, lvt_25_3_), lvt_26_5_ ? Blocks.OBSIDIAN.getDefaultState() : Blocks.AIR.getDefaultState());
                    }
                }
            }
        }
        IBlockState lvt_20_4_ = Blocks.PORTAL.getDefaultState().withProperty(BlockPortal.AXIS, lvt_18_3_ == 0 ? EnumFacing.Axis.Z : EnumFacing.Axis.X);
        for (int lvt_21_4_ = 0; lvt_21_4_ < 4; ++lvt_21_4_) {
            for (int lvt_22_4_ = 0; lvt_22_4_ < 4; ++lvt_22_4_) {
                for (int lvt_23_4_ = -1; lvt_23_4_ < 4; ++lvt_23_4_) {
                    int lvt_24_6_ = lvt_15_3_ + (lvt_22_4_ - 1) * lvt_18_3_;
                    int lvt_25_4_ = lvt_16_1_ + lvt_23_4_;
                    int lvt_26_6_ = lvt_17_3_ + (lvt_22_4_ - 1) * lvt_19_1_;
                    boolean lvt_27_3_ = lvt_22_4_ == 0 || lvt_22_4_ == 3 || lvt_23_4_ == -1 || lvt_23_4_ == 3;
                    this.worldServerInstance.setBlockState(new BlockPos(lvt_24_6_, lvt_25_4_, lvt_26_6_), lvt_27_3_ ? Blocks.OBSIDIAN.getDefaultState() : lvt_20_4_, 2);
                }
            }
            for (int lvt_22_5_ = 0; lvt_22_5_ < 4; ++lvt_22_5_) {
                for (int lvt_23_5_ = -1; lvt_23_5_ < 4; ++lvt_23_5_) {
                    int lvt_24_7_ = lvt_15_3_ + (lvt_22_5_ - 1) * lvt_18_3_;
                    int lvt_25_5_ = lvt_16_1_ + lvt_23_5_;
                    int lvt_26_7_ = lvt_17_3_ + (lvt_22_5_ - 1) * lvt_19_1_;
                    BlockPos lvt_27_4_ = new BlockPos(lvt_24_7_, lvt_25_5_, lvt_26_7_);
                    this.worldServerInstance.notifyNeighborsOfStateChange(lvt_27_4_, this.worldServerInstance.getBlockState(lvt_27_4_).getBlock(), false);
                }
            }
        }
        return true;
    }

    public void removeStalePortalLocations(long p_removeStalePortalLocations_1_) {
        if (p_removeStalePortalLocations_1_ % 100L == 0L) {
            long lvt_3_1_ = p_removeStalePortalLocations_1_ - 300L;
            ObjectIterator lvt_5_1_ = this.destinationCoordinateCache.values().iterator();
            while (lvt_5_1_.hasNext()) {
                PortalPosition lvt_6_1_ = (PortalPosition)lvt_5_1_.next();
                if (lvt_6_1_ != null && lvt_6_1_.lastUpdateTime >= lvt_3_1_) continue;
                lvt_5_1_.remove();
            }
        }
    }

    public class PortalPosition
    extends BlockPos {
        public long lastUpdateTime;

        public PortalPosition(BlockPos p_i45747_2_, long p_i45747_3_) {
            super(p_i45747_2_.getX(), p_i45747_2_.getY(), p_i45747_2_.getZ());
            this.lastUpdateTime = p_i45747_3_;
        }
    }
}

