/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.pathfinding.PathWorldListener;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.WorldCapabilityData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class World
implements IBlockAccess,
ICapabilityProvider {
    public static double MAX_ENTITY_RADIUS = 2.0;
    private int seaLevel = 63;
    protected boolean scheduledUpdatesAreImmediate;
    public final List<Entity> loadedEntityList = Lists.newArrayList();
    protected final List<Entity> unloadedEntityList = Lists.newArrayList();
    public final List<TileEntity> loadedTileEntityList = Lists.newArrayList();
    public final List<TileEntity> tickableTileEntities = Lists.newArrayList();
    private final List<TileEntity> addedTileEntityList = Lists.newArrayList();
    private final List<TileEntity> tileEntitiesToBeRemoved = Lists.newArrayList();
    public final List<EntityPlayer> playerEntities = Lists.newArrayList();
    public final List<Entity> weatherEffects = Lists.newArrayList();
    protected final IntHashMap<Entity> entitiesById = new IntHashMap();
    private final long cloudColour = 0xFFFFFFL;
    private int skylightSubtracted;
    protected int updateLCG = new Random().nextInt();
    protected final int DIST_HASH_MAGIC = 1013904223;
    public float prevRainingStrength;
    public float rainingStrength;
    public float prevThunderingStrength;
    public float thunderingStrength;
    private int lastLightningBolt;
    public final Random rand = new Random();
    public final WorldProvider provider;
    protected PathWorldListener pathListener = new PathWorldListener();
    protected List<IWorldEventListener> eventListeners;
    protected IChunkProvider chunkProvider;
    protected final ISaveHandler saveHandler;
    protected WorldInfo worldInfo;
    protected boolean findingSpawnPoint;
    protected MapStorage mapStorage;
    public VillageCollection villageCollectionObj;
    protected LootTableManager lootTable;
    public final Profiler theProfiler;
    private final Calendar theCalendar;
    protected Scoreboard worldScoreboard;
    public final boolean isRemote;
    protected boolean spawnHostileMobs = true;
    protected boolean spawnPeacefulMobs = true;
    private boolean processingLoadedTiles;
    private final WorldBorder worldBorder;
    int[] lightUpdateBlockList;
    public boolean restoringBlockSnapshots = false;
    public boolean captureBlockSnapshots = false;
    public ArrayList<BlockSnapshot> capturedBlockSnapshots = new ArrayList();
    private CapabilityDispatcher capabilities;
    private WorldCapabilityData capabilityData;
    protected MapStorage perWorldStorage;

    protected World(ISaveHandler p_i45749_1_, WorldInfo p_i45749_2_, WorldProvider p_i45749_3_, Profiler p_i45749_4_, boolean p_i45749_5_) {
        this.eventListeners = Lists.newArrayList((Object[])new IWorldEventListener[]{this.pathListener});
        this.theCalendar = Calendar.getInstance();
        this.worldScoreboard = new Scoreboard();
        this.lightUpdateBlockList = new int[32768];
        this.saveHandler = p_i45749_1_;
        this.theProfiler = p_i45749_4_;
        this.worldInfo = p_i45749_2_;
        this.provider = p_i45749_3_;
        this.isRemote = p_i45749_5_;
        this.worldBorder = p_i45749_3_.createWorldBorder();
        this.perWorldStorage = new MapStorage(null);
    }

    public World init() {
        return this;
    }

    @Override
    public Biome getBiome(BlockPos p_getBiome_1_) {
        return this.provider.getBiomeForCoords(p_getBiome_1_);
    }

    public Biome getBiomeForCoordsBody(final BlockPos p_getBiomeForCoordsBody_1_) {
        if (this.isBlockLoaded(p_getBiomeForCoordsBody_1_)) {
            Chunk chunk = this.getChunkFromBlockCoords(p_getBiomeForCoordsBody_1_);
            try {
                return chunk.getBiome(p_getBiomeForCoordsBody_1_, this.provider.getBiomeProvider());
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Getting biome");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Coordinates of biome request");
                crashreportcategory.setDetail("Location", new ICrashReportDetail<String>(){

                    @Override
                    public String call() throws Exception {
                        return CrashReportCategory.getCoordinateInfo(p_getBiomeForCoordsBody_1_);
                    }
                });
                throw new ReportedException(crashreport);
            }
        }
        return this.provider.getBiomeProvider().getBiome(p_getBiomeForCoordsBody_1_, Biomes.PLAINS);
    }

    public BiomeProvider getBiomeProvider() {
        return this.provider.getBiomeProvider();
    }

    protected abstract IChunkProvider createChunkProvider();

    public void initialize(WorldSettings p_initialize_1_) {
        this.worldInfo.setServerInitialized(true);
    }

    @Nullable
    public MinecraftServer getMinecraftServer() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void setInitialSpawnLocation() {
        this.setSpawnPoint(new BlockPos(8, 64, 8));
    }

    public IBlockState getGroundAboveSeaLevel(BlockPos p_getGroundAboveSeaLevel_1_) {
        BlockPos blockpos = new BlockPos(p_getGroundAboveSeaLevel_1_.getX(), this.getSeaLevel(), p_getGroundAboveSeaLevel_1_.getZ());
        while (!this.isAirBlock(blockpos.up())) {
            blockpos = blockpos.up();
        }
        return this.getBlockState(blockpos);
    }

    private boolean isValid(BlockPos p_isValid_1_) {
        return !this.isOutsideBuildHeight(p_isValid_1_) && p_isValid_1_.getX() >= -30000000 && p_isValid_1_.getZ() >= -30000000 && p_isValid_1_.getX() < 30000000 && p_isValid_1_.getZ() < 30000000;
    }

    private boolean isOutsideBuildHeight(BlockPos p_isOutsideBuildHeight_1_) {
        return p_isOutsideBuildHeight_1_.getY() < 0 || p_isOutsideBuildHeight_1_.getY() >= 256;
    }

    @Override
    public boolean isAirBlock(BlockPos p_isAirBlock_1_) {
        return this.getBlockState(p_isAirBlock_1_).getBlock().isAir(this.getBlockState(p_isAirBlock_1_), this, p_isAirBlock_1_);
    }

    public boolean isBlockLoaded(BlockPos p_isBlockLoaded_1_) {
        return this.isBlockLoaded(p_isBlockLoaded_1_, true);
    }

    public boolean isBlockLoaded(BlockPos p_isBlockLoaded_1_, boolean p_isBlockLoaded_2_) {
        return this.isChunkLoaded(p_isBlockLoaded_1_.getX() >> 4, p_isBlockLoaded_1_.getZ() >> 4, p_isBlockLoaded_2_);
    }

    public boolean isAreaLoaded(BlockPos p_isAreaLoaded_1_, int p_isAreaLoaded_2_) {
        return this.isAreaLoaded(p_isAreaLoaded_1_, p_isAreaLoaded_2_, true);
    }

    public boolean isAreaLoaded(BlockPos p_isAreaLoaded_1_, int p_isAreaLoaded_2_, boolean p_isAreaLoaded_3_) {
        return this.isAreaLoaded(p_isAreaLoaded_1_.getX() - p_isAreaLoaded_2_, p_isAreaLoaded_1_.getY() - p_isAreaLoaded_2_, p_isAreaLoaded_1_.getZ() - p_isAreaLoaded_2_, p_isAreaLoaded_1_.getX() + p_isAreaLoaded_2_, p_isAreaLoaded_1_.getY() + p_isAreaLoaded_2_, p_isAreaLoaded_1_.getZ() + p_isAreaLoaded_2_, p_isAreaLoaded_3_);
    }

    public boolean isAreaLoaded(BlockPos p_isAreaLoaded_1_, BlockPos p_isAreaLoaded_2_) {
        return this.isAreaLoaded(p_isAreaLoaded_1_, p_isAreaLoaded_2_, true);
    }

    public boolean isAreaLoaded(BlockPos p_isAreaLoaded_1_, BlockPos p_isAreaLoaded_2_, boolean p_isAreaLoaded_3_) {
        return this.isAreaLoaded(p_isAreaLoaded_1_.getX(), p_isAreaLoaded_1_.getY(), p_isAreaLoaded_1_.getZ(), p_isAreaLoaded_2_.getX(), p_isAreaLoaded_2_.getY(), p_isAreaLoaded_2_.getZ(), p_isAreaLoaded_3_);
    }

    public boolean isAreaLoaded(StructureBoundingBox p_isAreaLoaded_1_) {
        return this.isAreaLoaded(p_isAreaLoaded_1_, true);
    }

    public boolean isAreaLoaded(StructureBoundingBox p_isAreaLoaded_1_, boolean p_isAreaLoaded_2_) {
        return this.isAreaLoaded(p_isAreaLoaded_1_.minX, p_isAreaLoaded_1_.minY, p_isAreaLoaded_1_.minZ, p_isAreaLoaded_1_.maxX, p_isAreaLoaded_1_.maxY, p_isAreaLoaded_1_.maxZ, p_isAreaLoaded_2_);
    }

    private boolean isAreaLoaded(int p_isAreaLoaded_1_, int p_isAreaLoaded_2_, int p_isAreaLoaded_3_, int p_isAreaLoaded_4_, int p_isAreaLoaded_5_, int p_isAreaLoaded_6_, boolean p_isAreaLoaded_7_) {
        if (p_isAreaLoaded_5_ >= 0 && p_isAreaLoaded_2_ < 256) {
            p_isAreaLoaded_3_ >>= 4;
            p_isAreaLoaded_4_ >>= 4;
            p_isAreaLoaded_6_ >>= 4;
            for (int i = p_isAreaLoaded_1_ >>= 4; i <= p_isAreaLoaded_4_; ++i) {
                for (int j = p_isAreaLoaded_3_; j <= p_isAreaLoaded_6_; ++j) {
                    if (this.isChunkLoaded(i, j, p_isAreaLoaded_7_)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected abstract boolean isChunkLoaded(int var1, int var2, boolean var3);

    public Chunk getChunkFromBlockCoords(BlockPos p_getChunkFromBlockCoords_1_) {
        return this.getChunkFromChunkCoords(p_getChunkFromBlockCoords_1_.getX() >> 4, p_getChunkFromBlockCoords_1_.getZ() >> 4);
    }

    public Chunk getChunkFromChunkCoords(int p_getChunkFromChunkCoords_1_, int p_getChunkFromChunkCoords_2_) {
        return this.chunkProvider.provideChunk(p_getChunkFromChunkCoords_1_, p_getChunkFromChunkCoords_2_);
    }

    public boolean isChunkGeneratedAt(int p_isChunkGeneratedAt_1_, int p_isChunkGeneratedAt_2_) {
        return this.isChunkLoaded(p_isChunkGeneratedAt_1_, p_isChunkGeneratedAt_2_, false) ? true : this.chunkProvider.isChunkGeneratedAt(p_isChunkGeneratedAt_1_, p_isChunkGeneratedAt_2_);
    }

    public boolean setBlockState(BlockPos p_setBlockState_1_, IBlockState p_setBlockState_2_, int p_setBlockState_3_) {
        if (this.isOutsideBuildHeight(p_setBlockState_1_)) {
            return false;
        }
        if (!this.isRemote && this.worldInfo.getTerrainType() == WorldType.DEBUG_WORLD) {
            return false;
        }
        Chunk chunk = this.getChunkFromBlockCoords(p_setBlockState_1_);
        BlockSnapshot blockSnapshot = null;
        if (this.captureBlockSnapshots && !this.isRemote) {
            blockSnapshot = BlockSnapshot.getBlockSnapshot(this, p_setBlockState_1_, p_setBlockState_3_);
            this.capturedBlockSnapshots.add(blockSnapshot);
        }
        IBlockState oldState = this.getBlockState(p_setBlockState_1_);
        int oldLight = oldState.getLightValue(this, p_setBlockState_1_);
        int oldOpacity = oldState.getLightOpacity(this, p_setBlockState_1_);
        IBlockState iblockstate = chunk.setBlockState(p_setBlockState_1_, p_setBlockState_2_);
        if (iblockstate == null) {
            if (blockSnapshot != null) {
                this.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        if (p_setBlockState_2_.getLightOpacity(this, p_setBlockState_1_) != oldOpacity || p_setBlockState_2_.getLightValue(this, p_setBlockState_1_) != oldLight) {
            this.theProfiler.startSection("checkLight");
            this.checkLight(p_setBlockState_1_);
            this.theProfiler.endSection();
        }
        if (blockSnapshot == null) {
            this.markAndNotifyBlock(p_setBlockState_1_, chunk, iblockstate, p_setBlockState_2_, p_setBlockState_3_);
        }
        return true;
    }

    public void markAndNotifyBlock(BlockPos p_markAndNotifyBlock_1_, Chunk p_markAndNotifyBlock_2_, IBlockState p_markAndNotifyBlock_3_, IBlockState p_markAndNotifyBlock_4_, int p_markAndNotifyBlock_5_) {
        Block block = p_markAndNotifyBlock_4_.getBlock();
        if (!((p_markAndNotifyBlock_5_ & 2) == 0 || this.isRemote && (p_markAndNotifyBlock_5_ & 4) != 0 || p_markAndNotifyBlock_2_ != null && !p_markAndNotifyBlock_2_.isPopulated())) {
            this.notifyBlockUpdate(p_markAndNotifyBlock_1_, p_markAndNotifyBlock_3_, p_markAndNotifyBlock_4_, p_markAndNotifyBlock_5_);
        }
        if (!this.isRemote && (p_markAndNotifyBlock_5_ & 1) != 0) {
            this.notifyNeighborsRespectDebug(p_markAndNotifyBlock_1_, p_markAndNotifyBlock_3_.getBlock(), true);
            if (p_markAndNotifyBlock_4_.hasComparatorInputOverride()) {
                this.updateComparatorOutputLevel(p_markAndNotifyBlock_1_, block);
            }
        } else if (!this.isRemote && (p_markAndNotifyBlock_5_ & 0x10) == 0) {
            this.updateObservingBlocksAt(p_markAndNotifyBlock_1_, block);
        }
    }

    public boolean setBlockToAir(BlockPos p_setBlockToAir_1_) {
        return this.setBlockState(p_setBlockToAir_1_, Blocks.AIR.getDefaultState(), 3);
    }

    public boolean destroyBlock(BlockPos p_destroyBlock_1_, boolean p_destroyBlock_2_) {
        IBlockState iblockstate = this.getBlockState(p_destroyBlock_1_);
        Block block = iblockstate.getBlock();
        if (block.isAir(iblockstate, this, p_destroyBlock_1_)) {
            return false;
        }
        this.playEvent(2001, p_destroyBlock_1_, Block.getStateId(iblockstate));
        if (p_destroyBlock_2_) {
            block.dropBlockAsItem(this, p_destroyBlock_1_, iblockstate, 0);
        }
        return this.setBlockState(p_destroyBlock_1_, Blocks.AIR.getDefaultState(), 3);
    }

    public boolean setBlockState(BlockPos p_setBlockState_1_, IBlockState p_setBlockState_2_) {
        return this.setBlockState(p_setBlockState_1_, p_setBlockState_2_, 3);
    }

    public void notifyBlockUpdate(BlockPos p_notifyBlockUpdate_1_, IBlockState p_notifyBlockUpdate_2_, IBlockState p_notifyBlockUpdate_3_, int p_notifyBlockUpdate_4_) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).notifyBlockUpdate(this, p_notifyBlockUpdate_1_, p_notifyBlockUpdate_2_, p_notifyBlockUpdate_3_, p_notifyBlockUpdate_4_);
        }
    }

    public void notifyNeighborsRespectDebug(BlockPos p_notifyNeighborsRespectDebug_1_, Block p_notifyNeighborsRespectDebug_2_, boolean p_notifyNeighborsRespectDebug_3_) {
        if (this.worldInfo.getTerrainType() != WorldType.DEBUG_WORLD) {
            this.notifyNeighborsOfStateChange(p_notifyNeighborsRespectDebug_1_, p_notifyNeighborsRespectDebug_2_, p_notifyNeighborsRespectDebug_3_);
        }
    }

    public void markBlocksDirtyVertical(int p_markBlocksDirtyVertical_1_, int p_markBlocksDirtyVertical_2_, int p_markBlocksDirtyVertical_3_, int p_markBlocksDirtyVertical_4_) {
        if (p_markBlocksDirtyVertical_3_ > p_markBlocksDirtyVertical_4_) {
            int i = p_markBlocksDirtyVertical_4_;
            p_markBlocksDirtyVertical_4_ = p_markBlocksDirtyVertical_3_;
            p_markBlocksDirtyVertical_3_ = i;
        }
        if (this.provider.hasSkyLight()) {
            for (int j = p_markBlocksDirtyVertical_3_; j <= p_markBlocksDirtyVertical_4_; ++j) {
                this.checkLightFor(EnumSkyBlock.SKY, new BlockPos(p_markBlocksDirtyVertical_1_, j, p_markBlocksDirtyVertical_2_));
            }
        }
        this.markBlockRangeForRenderUpdate(p_markBlocksDirtyVertical_1_, p_markBlocksDirtyVertical_3_, p_markBlocksDirtyVertical_2_, p_markBlocksDirtyVertical_1_, p_markBlocksDirtyVertical_4_, p_markBlocksDirtyVertical_2_);
    }

    public void markBlockRangeForRenderUpdate(BlockPos p_markBlockRangeForRenderUpdate_1_, BlockPos p_markBlockRangeForRenderUpdate_2_) {
        this.markBlockRangeForRenderUpdate(p_markBlockRangeForRenderUpdate_1_.getX(), p_markBlockRangeForRenderUpdate_1_.getY(), p_markBlockRangeForRenderUpdate_1_.getZ(), p_markBlockRangeForRenderUpdate_2_.getX(), p_markBlockRangeForRenderUpdate_2_.getY(), p_markBlockRangeForRenderUpdate_2_.getZ());
    }

    public void markBlockRangeForRenderUpdate(int p_markBlockRangeForRenderUpdate_1_, int p_markBlockRangeForRenderUpdate_2_, int p_markBlockRangeForRenderUpdate_3_, int p_markBlockRangeForRenderUpdate_4_, int p_markBlockRangeForRenderUpdate_5_, int p_markBlockRangeForRenderUpdate_6_) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).markBlockRangeForRenderUpdate(p_markBlockRangeForRenderUpdate_1_, p_markBlockRangeForRenderUpdate_2_, p_markBlockRangeForRenderUpdate_3_, p_markBlockRangeForRenderUpdate_4_, p_markBlockRangeForRenderUpdate_5_, p_markBlockRangeForRenderUpdate_6_);
        }
    }

    public void updateObservingBlocksAt(BlockPos p_updateObservingBlocksAt_1_, Block p_updateObservingBlocksAt_2_) {
        this.observedNeighborChanged(p_updateObservingBlocksAt_1_.west(), p_updateObservingBlocksAt_2_, p_updateObservingBlocksAt_1_);
        this.observedNeighborChanged(p_updateObservingBlocksAt_1_.east(), p_updateObservingBlocksAt_2_, p_updateObservingBlocksAt_1_);
        this.observedNeighborChanged(p_updateObservingBlocksAt_1_.down(), p_updateObservingBlocksAt_2_, p_updateObservingBlocksAt_1_);
        this.observedNeighborChanged(p_updateObservingBlocksAt_1_.up(), p_updateObservingBlocksAt_2_, p_updateObservingBlocksAt_1_);
        this.observedNeighborChanged(p_updateObservingBlocksAt_1_.north(), p_updateObservingBlocksAt_2_, p_updateObservingBlocksAt_1_);
        this.observedNeighborChanged(p_updateObservingBlocksAt_1_.south(), p_updateObservingBlocksAt_2_, p_updateObservingBlocksAt_1_);
    }

    public void notifyNeighborsOfStateChange(BlockPos p_notifyNeighborsOfStateChange_1_, Block p_notifyNeighborsOfStateChange_2_, boolean p_notifyNeighborsOfStateChange_3_) {
        if (ForgeEventFactory.onNeighborNotify(this, p_notifyNeighborsOfStateChange_1_, this.getBlockState(p_notifyNeighborsOfStateChange_1_), EnumSet.allOf(EnumFacing.class), p_notifyNeighborsOfStateChange_3_).isCanceled()) {
            return;
        }
        this.neighborChanged(p_notifyNeighborsOfStateChange_1_.west(), p_notifyNeighborsOfStateChange_2_, p_notifyNeighborsOfStateChange_1_);
        this.neighborChanged(p_notifyNeighborsOfStateChange_1_.east(), p_notifyNeighborsOfStateChange_2_, p_notifyNeighborsOfStateChange_1_);
        this.neighborChanged(p_notifyNeighborsOfStateChange_1_.down(), p_notifyNeighborsOfStateChange_2_, p_notifyNeighborsOfStateChange_1_);
        this.neighborChanged(p_notifyNeighborsOfStateChange_1_.up(), p_notifyNeighborsOfStateChange_2_, p_notifyNeighborsOfStateChange_1_);
        this.neighborChanged(p_notifyNeighborsOfStateChange_1_.north(), p_notifyNeighborsOfStateChange_2_, p_notifyNeighborsOfStateChange_1_);
        this.neighborChanged(p_notifyNeighborsOfStateChange_1_.south(), p_notifyNeighborsOfStateChange_2_, p_notifyNeighborsOfStateChange_1_);
        if (p_notifyNeighborsOfStateChange_3_) {
            this.updateObservingBlocksAt(p_notifyNeighborsOfStateChange_1_, p_notifyNeighborsOfStateChange_2_);
        }
    }

    public void notifyNeighborsOfStateExcept(BlockPos p_notifyNeighborsOfStateExcept_1_, Block p_notifyNeighborsOfStateExcept_2_, EnumFacing p_notifyNeighborsOfStateExcept_3_) {
        EnumSet<EnumFacing> directions = EnumSet.allOf(EnumFacing.class);
        directions.remove(p_notifyNeighborsOfStateExcept_3_);
        if (ForgeEventFactory.onNeighborNotify(this, p_notifyNeighborsOfStateExcept_1_, this.getBlockState(p_notifyNeighborsOfStateExcept_1_), directions, false).isCanceled()) {
            return;
        }
        if (p_notifyNeighborsOfStateExcept_3_ != EnumFacing.WEST) {
            this.neighborChanged(p_notifyNeighborsOfStateExcept_1_.west(), p_notifyNeighborsOfStateExcept_2_, p_notifyNeighborsOfStateExcept_1_);
        }
        if (p_notifyNeighborsOfStateExcept_3_ != EnumFacing.EAST) {
            this.neighborChanged(p_notifyNeighborsOfStateExcept_1_.east(), p_notifyNeighborsOfStateExcept_2_, p_notifyNeighborsOfStateExcept_1_);
        }
        if (p_notifyNeighborsOfStateExcept_3_ != EnumFacing.DOWN) {
            this.neighborChanged(p_notifyNeighborsOfStateExcept_1_.down(), p_notifyNeighborsOfStateExcept_2_, p_notifyNeighborsOfStateExcept_1_);
        }
        if (p_notifyNeighborsOfStateExcept_3_ != EnumFacing.UP) {
            this.neighborChanged(p_notifyNeighborsOfStateExcept_1_.up(), p_notifyNeighborsOfStateExcept_2_, p_notifyNeighborsOfStateExcept_1_);
        }
        if (p_notifyNeighborsOfStateExcept_3_ != EnumFacing.NORTH) {
            this.neighborChanged(p_notifyNeighborsOfStateExcept_1_.north(), p_notifyNeighborsOfStateExcept_2_, p_notifyNeighborsOfStateExcept_1_);
        }
        if (p_notifyNeighborsOfStateExcept_3_ != EnumFacing.SOUTH) {
            this.neighborChanged(p_notifyNeighborsOfStateExcept_1_.south(), p_notifyNeighborsOfStateExcept_2_, p_notifyNeighborsOfStateExcept_1_);
        }
    }

    public void neighborChanged(BlockPos p_neighborChanged_1_, final Block p_neighborChanged_2_, BlockPos p_neighborChanged_3_) {
        if (!this.isRemote) {
            IBlockState iblockstate = this.getBlockState(p_neighborChanged_1_);
            try {
                iblockstate.neighborChanged(this, p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Block being updated");
                crashreportcategory.setDetail("Source block type", new ICrashReportDetail<String>(){

                    @Override
                    public String call() throws Exception {
                        try {
                            return String.format("ID #%d (%s // %s)", Block.getIdFromBlock(p_neighborChanged_2_), p_neighborChanged_2_.getUnlocalizedName(), p_neighborChanged_2_.getClass().getCanonicalName());
                        }
                        catch (Throwable var2) {
                            return "ID #" + Block.getIdFromBlock(p_neighborChanged_2_);
                        }
                    }
                });
                CrashReportCategory.addBlockInfo(crashreportcategory, p_neighborChanged_1_, iblockstate);
                throw new ReportedException(crashreport);
            }
        }
    }

    public void observedNeighborChanged(BlockPos p_observedNeighborChanged_1_, final Block p_observedNeighborChanged_2_, BlockPos p_observedNeighborChanged_3_) {
        if (!this.isRemote) {
            IBlockState iblockstate = this.getBlockState(p_observedNeighborChanged_1_);
            try {
                iblockstate.getBlock().observedNeighborChange(iblockstate, this, p_observedNeighborChanged_1_, p_observedNeighborChanged_2_, p_observedNeighborChanged_3_);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Block being updated");
                crashreportcategory.setDetail("Source block type", new ICrashReportDetail<String>(){

                    @Override
                    public String call() throws Exception {
                        try {
                            return String.format("ID #%d (%s // %s)", Block.getIdFromBlock(p_observedNeighborChanged_2_), p_observedNeighborChanged_2_.getUnlocalizedName(), p_observedNeighborChanged_2_.getClass().getCanonicalName());
                        }
                        catch (Throwable var2) {
                            return "ID #" + Block.getIdFromBlock(p_observedNeighborChanged_2_);
                        }
                    }
                });
                CrashReportCategory.addBlockInfo(crashreportcategory, p_observedNeighborChanged_1_, iblockstate);
                throw new ReportedException(crashreport);
            }
        }
    }

    public boolean isBlockTickPending(BlockPos p_isBlockTickPending_1_, Block p_isBlockTickPending_2_) {
        return false;
    }

    public boolean canSeeSky(BlockPos p_canSeeSky_1_) {
        return this.getChunkFromBlockCoords(p_canSeeSky_1_).canSeeSky(p_canSeeSky_1_);
    }

    public boolean canBlockSeeSky(BlockPos p_canBlockSeeSky_1_) {
        if (p_canBlockSeeSky_1_.getY() >= this.getSeaLevel()) {
            return this.canSeeSky(p_canBlockSeeSky_1_);
        }
        BlockPos blockpos = new BlockPos(p_canBlockSeeSky_1_.getX(), this.getSeaLevel(), p_canBlockSeeSky_1_.getZ());
        if (!this.canSeeSky(blockpos)) {
            return false;
        }
        blockpos = blockpos.down();
        while (blockpos.getY() > p_canBlockSeeSky_1_.getY()) {
            IBlockState iblockstate = this.getBlockState(blockpos);
            if (iblockstate.getBlock().getLightOpacity(iblockstate, this, blockpos) > 0 && !iblockstate.getMaterial().isLiquid()) {
                return false;
            }
            blockpos = blockpos.down();
        }
        return true;
    }

    public int getLight(BlockPos p_getLight_1_) {
        if (p_getLight_1_.getY() < 0) {
            return 0;
        }
        if (p_getLight_1_.getY() >= 256) {
            p_getLight_1_ = new BlockPos(p_getLight_1_.getX(), 255, p_getLight_1_.getZ());
        }
        return this.getChunkFromBlockCoords(p_getLight_1_).getLightSubtracted(p_getLight_1_, 0);
    }

    public int getLightFromNeighbors(BlockPos p_getLightFromNeighbors_1_) {
        return this.getLight(p_getLightFromNeighbors_1_, true);
    }

    public int getLight(BlockPos p_getLight_1_, boolean p_getLight_2_) {
        if (p_getLight_1_.getX() >= -30000000 && p_getLight_1_.getZ() >= -30000000 && p_getLight_1_.getX() < 30000000 && p_getLight_1_.getZ() < 30000000) {
            if (p_getLight_2_ && this.getBlockState(p_getLight_1_).useNeighborBrightness()) {
                int i1 = this.getLight(p_getLight_1_.up(), false);
                int i = this.getLight(p_getLight_1_.east(), false);
                int j = this.getLight(p_getLight_1_.west(), false);
                int k = this.getLight(p_getLight_1_.south(), false);
                int l = this.getLight(p_getLight_1_.north(), false);
                if (i > i1) {
                    i1 = i;
                }
                if (j > i1) {
                    i1 = j;
                }
                if (k > i1) {
                    i1 = k;
                }
                if (l > i1) {
                    i1 = l;
                }
                return i1;
            }
            if (p_getLight_1_.getY() < 0) {
                return 0;
            }
            if (p_getLight_1_.getY() >= 256) {
                p_getLight_1_ = new BlockPos(p_getLight_1_.getX(), 255, p_getLight_1_.getZ());
            }
            Chunk chunk = this.getChunkFromBlockCoords(p_getLight_1_);
            return chunk.getLightSubtracted(p_getLight_1_, this.skylightSubtracted);
        }
        return 15;
    }

    public BlockPos getHeight(BlockPos p_getHeight_1_) {
        return new BlockPos(p_getHeight_1_.getX(), this.getHeight(p_getHeight_1_.getX(), p_getHeight_1_.getZ()), p_getHeight_1_.getZ());
    }

    public int getHeight(int p_getHeight_1_, int p_getHeight_2_) {
        int i = p_getHeight_1_ >= -30000000 && p_getHeight_2_ >= -30000000 && p_getHeight_1_ < 30000000 && p_getHeight_2_ < 30000000 ? (this.isChunkLoaded(p_getHeight_1_ >> 4, p_getHeight_2_ >> 4, true) ? this.getChunkFromChunkCoords(p_getHeight_1_ >> 4, p_getHeight_2_ >> 4).getHeightValue(p_getHeight_1_ & 0xF, p_getHeight_2_ & 0xF) : 0) : this.getSeaLevel() + 1;
        return i;
    }

    @Deprecated
    public int getChunksLowestHorizon(int p_getChunksLowestHorizon_1_, int p_getChunksLowestHorizon_2_) {
        if (p_getChunksLowestHorizon_1_ >= -30000000 && p_getChunksLowestHorizon_2_ >= -30000000 && p_getChunksLowestHorizon_1_ < 30000000 && p_getChunksLowestHorizon_2_ < 30000000) {
            if (!this.isChunkLoaded(p_getChunksLowestHorizon_1_ >> 4, p_getChunksLowestHorizon_2_ >> 4, true)) {
                return 0;
            }
            Chunk chunk = this.getChunkFromChunkCoords(p_getChunksLowestHorizon_1_ >> 4, p_getChunksLowestHorizon_2_ >> 4);
            return chunk.getLowestHeight();
        }
        return this.getSeaLevel() + 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLightFromNeighborsFor(EnumSkyBlock p_getLightFromNeighborsFor_1_, BlockPos p_getLightFromNeighborsFor_2_) {
        if (!this.provider.hasSkyLight() && p_getLightFromNeighborsFor_1_ == EnumSkyBlock.SKY) {
            return 0;
        }
        if (p_getLightFromNeighborsFor_2_.getY() < 0) {
            p_getLightFromNeighborsFor_2_ = new BlockPos(p_getLightFromNeighborsFor_2_.getX(), 0, p_getLightFromNeighborsFor_2_.getZ());
        }
        if (!this.isValid(p_getLightFromNeighborsFor_2_)) {
            return p_getLightFromNeighborsFor_1_.defaultLightValue;
        }
        if (!this.isBlockLoaded(p_getLightFromNeighborsFor_2_)) {
            return p_getLightFromNeighborsFor_1_.defaultLightValue;
        }
        if (this.getBlockState(p_getLightFromNeighborsFor_2_).useNeighborBrightness()) {
            int i1 = this.getLightFor(p_getLightFromNeighborsFor_1_, p_getLightFromNeighborsFor_2_.up());
            int i = this.getLightFor(p_getLightFromNeighborsFor_1_, p_getLightFromNeighborsFor_2_.east());
            int j = this.getLightFor(p_getLightFromNeighborsFor_1_, p_getLightFromNeighborsFor_2_.west());
            int k = this.getLightFor(p_getLightFromNeighborsFor_1_, p_getLightFromNeighborsFor_2_.south());
            int l = this.getLightFor(p_getLightFromNeighborsFor_1_, p_getLightFromNeighborsFor_2_.north());
            if (i > i1) {
                i1 = i;
            }
            if (j > i1) {
                i1 = j;
            }
            if (k > i1) {
                i1 = k;
            }
            if (l > i1) {
                i1 = l;
            }
            return i1;
        }
        Chunk chunk = this.getChunkFromBlockCoords(p_getLightFromNeighborsFor_2_);
        return chunk.getLightFor(p_getLightFromNeighborsFor_1_, p_getLightFromNeighborsFor_2_);
    }

    public int getLightFor(EnumSkyBlock p_getLightFor_1_, BlockPos p_getLightFor_2_) {
        if (p_getLightFor_2_.getY() < 0) {
            p_getLightFor_2_ = new BlockPos(p_getLightFor_2_.getX(), 0, p_getLightFor_2_.getZ());
        }
        if (!this.isValid(p_getLightFor_2_)) {
            return p_getLightFor_1_.defaultLightValue;
        }
        if (!this.isBlockLoaded(p_getLightFor_2_)) {
            return p_getLightFor_1_.defaultLightValue;
        }
        Chunk chunk = this.getChunkFromBlockCoords(p_getLightFor_2_);
        return chunk.getLightFor(p_getLightFor_1_, p_getLightFor_2_);
    }

    public void setLightFor(EnumSkyBlock p_setLightFor_1_, BlockPos p_setLightFor_2_, int p_setLightFor_3_) {
        if (this.isValid(p_setLightFor_2_) && this.isBlockLoaded(p_setLightFor_2_)) {
            Chunk chunk = this.getChunkFromBlockCoords(p_setLightFor_2_);
            chunk.setLightFor(p_setLightFor_1_, p_setLightFor_2_, p_setLightFor_3_);
            this.notifyLightSet(p_setLightFor_2_);
        }
    }

    public void notifyLightSet(BlockPos p_notifyLightSet_1_) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).notifyLightSet(p_notifyLightSet_1_);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getCombinedLight(BlockPos p_getCombinedLight_1_, int p_getCombinedLight_2_) {
        int i = this.getLightFromNeighborsFor(EnumSkyBlock.SKY, p_getCombinedLight_1_);
        int j = this.getLightFromNeighborsFor(EnumSkyBlock.BLOCK, p_getCombinedLight_1_);
        if (j < p_getCombinedLight_2_) {
            j = p_getCombinedLight_2_;
        }
        return i << 20 | j << 4;
    }

    public float getLightBrightness(BlockPos p_getLightBrightness_1_) {
        return this.provider.getLightBrightnessTable()[this.getLightFromNeighbors(p_getLightBrightness_1_)];
    }

    @Override
    public IBlockState getBlockState(BlockPos p_getBlockState_1_) {
        if (this.isOutsideBuildHeight(p_getBlockState_1_)) {
            return Blocks.AIR.getDefaultState();
        }
        Chunk chunk = this.getChunkFromBlockCoords(p_getBlockState_1_);
        return chunk.getBlockState(p_getBlockState_1_);
    }

    public boolean isDaytime() {
        return this.provider.isDaytime();
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(Vec3d p_rayTraceBlocks_1_, Vec3d p_rayTraceBlocks_2_) {
        return this.rayTraceBlocks(p_rayTraceBlocks_1_, p_rayTraceBlocks_2_, false, false, false);
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(Vec3d p_rayTraceBlocks_1_, Vec3d p_rayTraceBlocks_2_, boolean p_rayTraceBlocks_3_) {
        return this.rayTraceBlocks(p_rayTraceBlocks_1_, p_rayTraceBlocks_2_, p_rayTraceBlocks_3_, false, false);
    }

    @Nullable
    public RayTraceResult rayTraceBlocks(Vec3d p_rayTraceBlocks_1_, Vec3d p_rayTraceBlocks_2_, boolean p_rayTraceBlocks_3_, boolean p_rayTraceBlocks_4_, boolean p_rayTraceBlocks_5_) {
        if (!(Double.isNaN(p_rayTraceBlocks_1_.xCoord) || Double.isNaN(p_rayTraceBlocks_1_.yCoord) || Double.isNaN(p_rayTraceBlocks_1_.zCoord))) {
            if (!(Double.isNaN(p_rayTraceBlocks_2_.xCoord) || Double.isNaN(p_rayTraceBlocks_2_.yCoord) || Double.isNaN(p_rayTraceBlocks_2_.zCoord))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.floor(p_rayTraceBlocks_2_.xCoord);
                int j = MathHelper.floor(p_rayTraceBlocks_2_.yCoord);
                int k = MathHelper.floor(p_rayTraceBlocks_2_.zCoord);
                int l = MathHelper.floor(p_rayTraceBlocks_1_.xCoord);
                int i1 = MathHelper.floor(p_rayTraceBlocks_1_.yCoord);
                int j1 = MathHelper.floor(p_rayTraceBlocks_1_.zCoord);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = this.getBlockState(blockpos);
                Block block = iblockstate.getBlock();
                if ((!p_rayTraceBlocks_4_ || iblockstate.getCollisionBoundingBox(this, blockpos) != Block.NULL_AABB) && block.canCollideCheck(iblockstate, p_rayTraceBlocks_3_) && (raytraceresult = iblockstate.collisionRayTrace(this, blockpos, p_rayTraceBlocks_1_, p_rayTraceBlocks_2_)) != null) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(p_rayTraceBlocks_1_.xCoord) || Double.isNaN(p_rayTraceBlocks_1_.yCoord) || Double.isNaN(p_rayTraceBlocks_1_.zCoord)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return p_rayTraceBlocks_5_ ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = p_rayTraceBlocks_2_.xCoord - p_rayTraceBlocks_1_.xCoord;
                    double d7 = p_rayTraceBlocks_2_.yCoord - p_rayTraceBlocks_1_.yCoord;
                    double d8 = p_rayTraceBlocks_2_.zCoord - p_rayTraceBlocks_1_.zCoord;
                    if (flag2) {
                        d3 = (d0 - p_rayTraceBlocks_1_.xCoord) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - p_rayTraceBlocks_1_.yCoord) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - p_rayTraceBlocks_1_.zCoord) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        p_rayTraceBlocks_1_ = new Vec3d(d0, p_rayTraceBlocks_1_.yCoord + d7 * d3, p_rayTraceBlocks_1_.zCoord + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        p_rayTraceBlocks_1_ = new Vec3d(p_rayTraceBlocks_1_.xCoord + d6 * d4, d1, p_rayTraceBlocks_1_.zCoord + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        p_rayTraceBlocks_1_ = new Vec3d(p_rayTraceBlocks_1_.xCoord + d6 * d5, p_rayTraceBlocks_1_.yCoord + d7 * d5, d2);
                    }
                    l = MathHelper.floor(p_rayTraceBlocks_1_.xCoord) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.floor(p_rayTraceBlocks_1_.yCoord) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.floor(p_rayTraceBlocks_1_.zCoord) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = this.getBlockState(blockpos);
                    Block block1 = iblockstate1.getBlock();
                    if (p_rayTraceBlocks_4_ && iblockstate1.getMaterial() != Material.PORTAL && iblockstate1.getCollisionBoundingBox(this, blockpos) == Block.NULL_AABB) continue;
                    if (block1.canCollideCheck(iblockstate1, p_rayTraceBlocks_3_)) {
                        RayTraceResult raytraceresult1 = iblockstate1.collisionRayTrace(this, blockpos, p_rayTraceBlocks_1_, p_rayTraceBlocks_2_);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, p_rayTraceBlocks_1_, enumfacing, blockpos);
                }
                return p_rayTraceBlocks_5_ ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    public void playSound(EntityPlayer p_playSound_1_, BlockPos p_playSound_2_, SoundEvent p_playSound_3_, SoundCategory p_playSound_4_, float p_playSound_5_, float p_playSound_6_) {
        this.playSound(p_playSound_1_, (double)p_playSound_2_.getX() + 0.5, (double)p_playSound_2_.getY() + 0.5, (double)p_playSound_2_.getZ() + 0.5, p_playSound_3_, p_playSound_4_, p_playSound_5_, p_playSound_6_);
    }

    public void playSound(EntityPlayer p_playSound_1_, double p_playSound_2_, double p_playSound_4_, double p_playSound_6_, SoundEvent p_playSound_8_, SoundCategory p_playSound_9_, float p_playSound_10_, float p_playSound_11_) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity(p_playSound_1_, p_playSound_8_, p_playSound_9_, p_playSound_10_, p_playSound_11_);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        p_playSound_8_ = event.getSound();
        p_playSound_9_ = event.getCategory();
        p_playSound_10_ = event.getVolume();
        p_playSound_11_ = event.getPitch();
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).playSoundToAllNearExcept(p_playSound_1_, p_playSound_8_, p_playSound_9_, p_playSound_2_, p_playSound_4_, p_playSound_6_, p_playSound_10_, p_playSound_11_);
        }
    }

    public void playSound(double p_playSound_1_, double p_playSound_3_, double p_playSound_5_, SoundEvent p_playSound_7_, SoundCategory p_playSound_8_, float p_playSound_9_, float p_playSound_10_, boolean p_playSound_11_) {
    }

    public void playRecord(BlockPos p_playRecord_1_, SoundEvent p_playRecord_2_) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).playRecord(p_playRecord_2_, p_playRecord_1_);
        }
    }

    public void spawnParticle(EnumParticleTypes p_spawnParticle_1_, double p_spawnParticle_2_, double p_spawnParticle_4_, double p_spawnParticle_6_, double p_spawnParticle_8_, double p_spawnParticle_10_, double p_spawnParticle_12_, int ... p_spawnParticle_14_) {
        this.spawnParticle(p_spawnParticle_1_.getParticleID(), p_spawnParticle_1_.getShouldIgnoreRange(), p_spawnParticle_2_, p_spawnParticle_4_, p_spawnParticle_6_, p_spawnParticle_8_, p_spawnParticle_10_, p_spawnParticle_12_, p_spawnParticle_14_);
    }

    public void spawnAlwaysVisibleParticle(int p_spawnAlwaysVisibleParticle_1_, double p_spawnAlwaysVisibleParticle_2_, double p_spawnAlwaysVisibleParticle_4_, double p_spawnAlwaysVisibleParticle_6_, double p_spawnAlwaysVisibleParticle_8_, double p_spawnAlwaysVisibleParticle_10_, double p_spawnAlwaysVisibleParticle_12_, int ... p_spawnAlwaysVisibleParticle_14_) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).spawnParticle(p_spawnAlwaysVisibleParticle_1_, false, true, p_spawnAlwaysVisibleParticle_2_, p_spawnAlwaysVisibleParticle_4_, p_spawnAlwaysVisibleParticle_6_, p_spawnAlwaysVisibleParticle_8_, p_spawnAlwaysVisibleParticle_10_, p_spawnAlwaysVisibleParticle_12_, p_spawnAlwaysVisibleParticle_14_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(EnumParticleTypes p_spawnParticle_1_, boolean p_spawnParticle_2_, double p_spawnParticle_3_, double p_spawnParticle_5_, double p_spawnParticle_7_, double p_spawnParticle_9_, double p_spawnParticle_11_, double p_spawnParticle_13_, int ... p_spawnParticle_15_) {
        this.spawnParticle(p_spawnParticle_1_.getParticleID(), p_spawnParticle_1_.getShouldIgnoreRange() || p_spawnParticle_2_, p_spawnParticle_3_, p_spawnParticle_5_, p_spawnParticle_7_, p_spawnParticle_9_, p_spawnParticle_11_, p_spawnParticle_13_, p_spawnParticle_15_);
    }

    private void spawnParticle(int p_spawnParticle_1_, boolean p_spawnParticle_2_, double p_spawnParticle_3_, double p_spawnParticle_5_, double p_spawnParticle_7_, double p_spawnParticle_9_, double p_spawnParticle_11_, double p_spawnParticle_13_, int ... p_spawnParticle_15_) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).spawnParticle(p_spawnParticle_1_, p_spawnParticle_2_, p_spawnParticle_3_, p_spawnParticle_5_, p_spawnParticle_7_, p_spawnParticle_9_, p_spawnParticle_11_, p_spawnParticle_13_, p_spawnParticle_15_);
        }
    }

    public boolean addWeatherEffect(Entity p_addWeatherEffect_1_) {
        this.weatherEffects.add(p_addWeatherEffect_1_);
        return true;
    }

    public boolean spawnEntity(Entity p_spawnEntity_1_) {
        if (!this.isRemote && (p_spawnEntity_1_ == null || p_spawnEntity_1_ instanceof EntityItem && this.restoringBlockSnapshots)) {
            return false;
        }
        int i = MathHelper.floor(p_spawnEntity_1_.posX / 16.0);
        int j = MathHelper.floor(p_spawnEntity_1_.posZ / 16.0);
        boolean flag = p_spawnEntity_1_.forceSpawn;
        if (p_spawnEntity_1_ instanceof EntityPlayer) {
            flag = true;
        }
        if (!flag && !this.isChunkLoaded(i, j, false)) {
            return false;
        }
        if (p_spawnEntity_1_ instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)p_spawnEntity_1_;
            this.playerEntities.add(entityplayer);
            this.updateAllPlayersSleepingFlag();
        }
        if (MinecraftForge.EVENT_BUS.post(new EntityJoinWorldEvent(p_spawnEntity_1_, this)) && !flag) {
            return false;
        }
        this.getChunkFromChunkCoords(i, j).addEntity(p_spawnEntity_1_);
        this.loadedEntityList.add(p_spawnEntity_1_);
        this.onEntityAdded(p_spawnEntity_1_);
        return true;
    }

    public void onEntityAdded(Entity p_onEntityAdded_1_) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).onEntityAdded(p_onEntityAdded_1_);
        }
    }

    public void onEntityRemoved(Entity p_onEntityRemoved_1_) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).onEntityRemoved(p_onEntityRemoved_1_);
        }
    }

    public void removeEntity(Entity p_removeEntity_1_) {
        if (p_removeEntity_1_.isBeingRidden()) {
            p_removeEntity_1_.removePassengers();
        }
        if (p_removeEntity_1_.isRiding()) {
            p_removeEntity_1_.dismountRidingEntity();
        }
        p_removeEntity_1_.setDead();
        if (p_removeEntity_1_ instanceof EntityPlayer) {
            this.playerEntities.remove(p_removeEntity_1_);
            this.updateAllPlayersSleepingFlag();
            this.onEntityRemoved(p_removeEntity_1_);
        }
    }

    public void removeEntityDangerously(Entity p_removeEntityDangerously_1_) {
        p_removeEntityDangerously_1_.setDropItemsWhenDead(false);
        p_removeEntityDangerously_1_.setDead();
        if (p_removeEntityDangerously_1_ instanceof EntityPlayer) {
            this.playerEntities.remove(p_removeEntityDangerously_1_);
            this.updateAllPlayersSleepingFlag();
        }
        int i = p_removeEntityDangerously_1_.chunkCoordX;
        int j = p_removeEntityDangerously_1_.chunkCoordZ;
        if (p_removeEntityDangerously_1_.addedToChunk && this.isChunkLoaded(i, j, true)) {
            this.getChunkFromChunkCoords(i, j).removeEntity(p_removeEntityDangerously_1_);
        }
        this.loadedEntityList.remove(p_removeEntityDangerously_1_);
        this.onEntityRemoved(p_removeEntityDangerously_1_);
    }

    public void addEventListener(IWorldEventListener p_addEventListener_1_) {
        this.eventListeners.add(p_addEventListener_1_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean func_191504_a(Entity p_191504_1_, AxisAlignedBB p_191504_2_, boolean p_191504_3_, List<AxisAlignedBB> p_191504_4_) {
        int i = MathHelper.floor(p_191504_2_.minX) - 1;
        int j = MathHelper.ceil(p_191504_2_.maxX) + 1;
        int k = MathHelper.floor(p_191504_2_.minY) - 1;
        int l = MathHelper.ceil(p_191504_2_.maxY) + 1;
        int i1 = MathHelper.floor(p_191504_2_.minZ) - 1;
        int j1 = MathHelper.ceil(p_191504_2_.maxZ) + 1;
        WorldBorder worldborder = this.getWorldBorder();
        boolean flag = p_191504_1_ != null && p_191504_1_.isOutsideBorder();
        boolean flag1 = p_191504_1_ != null && this.func_191503_g(p_191504_1_);
        IBlockState iblockstate = Blocks.STONE.getDefaultState();
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = i1; l1 < j1; ++l1) {
                    boolean flag3;
                    boolean flag2 = k1 == i || k1 == j - 1;
                    boolean bl = flag3 = l1 == i1 || l1 == j1 - 1;
                    if (flag2 && flag3 || !this.isBlockLoaded(blockpos$pooledmutableblockpos.setPos(k1, 64, l1))) continue;
                    for (int i2 = k; i2 < l; ++i2) {
                        boolean flag5;
                        if ((flag2 || flag3) && i2 == l - 1) continue;
                        if (p_191504_3_) {
                            if (k1 < -30000000 || k1 >= 30000000 || l1 < -30000000 || l1 >= 30000000) {
                                boolean lvt_21_1_;
                                boolean bl2 = lvt_21_1_ = true;
                                return bl2;
                            }
                        } else if (p_191504_1_ != null && flag == flag1) {
                            p_191504_1_.setOutsideBorder(!flag1);
                        }
                        blockpos$pooledmutableblockpos.setPos(k1, i2, l1);
                        IBlockState iblockstate1 = !p_191504_3_ && !worldborder.contains(blockpos$pooledmutableblockpos) && flag1 ? iblockstate : this.getBlockState(blockpos$pooledmutableblockpos);
                        iblockstate1.addCollisionBoxToList(this, blockpos$pooledmutableblockpos, p_191504_2_, p_191504_4_, p_191504_1_, false);
                        MinecraftForge.EVENT_BUS.post(new GetCollisionBoxesEvent(this, null, p_191504_2_, p_191504_4_));
                        if (!p_191504_3_ || p_191504_4_.isEmpty()) continue;
                        boolean bl3 = flag5 = true;
                        return bl3;
                    }
                }
            }
        }
        finally {
            blockpos$pooledmutableblockpos.release();
        }
        return !p_191504_4_.isEmpty();
    }

    public List<AxisAlignedBB> getCollisionBoxes(Entity p_getCollisionBoxes_1_, AxisAlignedBB p_getCollisionBoxes_2_) {
        ArrayList list = Lists.newArrayList();
        this.func_191504_a(p_getCollisionBoxes_1_, p_getCollisionBoxes_2_, false, list);
        if (p_getCollisionBoxes_1_ != null) {
            List<Entity> list1 = this.getEntitiesWithinAABBExcludingEntity(p_getCollisionBoxes_1_, p_getCollisionBoxes_2_.expandXyz(0.25));
            for (int i = 0; i < list1.size(); ++i) {
                Entity entity = list1.get(i);
                if (p_getCollisionBoxes_1_.isRidingSameEntity(entity)) continue;
                AxisAlignedBB axisalignedbb = entity.getCollisionBoundingBox();
                if (axisalignedbb != null && axisalignedbb.intersectsWith(p_getCollisionBoxes_2_)) {
                    list.add(axisalignedbb);
                }
                if ((axisalignedbb = p_getCollisionBoxes_1_.getCollisionBox(entity)) == null || !axisalignedbb.intersectsWith(p_getCollisionBoxes_2_)) continue;
                list.add(axisalignedbb);
            }
        }
        MinecraftForge.EVENT_BUS.post(new GetCollisionBoxesEvent(this, p_getCollisionBoxes_1_, p_getCollisionBoxes_2_, list));
        return list;
    }

    public void removeEventListener(IWorldEventListener p_removeEventListener_1_) {
        this.eventListeners.remove(p_removeEventListener_1_);
    }

    public boolean func_191503_g(Entity p_191503_1_) {
        double d0 = this.worldBorder.minX();
        double d1 = this.worldBorder.minZ();
        double d2 = this.worldBorder.maxX();
        double d3 = this.worldBorder.maxZ();
        if (p_191503_1_.isOutsideBorder()) {
            d0 += 1.0;
            d1 += 1.0;
            d2 -= 1.0;
            d3 -= 1.0;
        } else {
            d0 -= 1.0;
            d1 -= 1.0;
            d2 += 1.0;
            d3 += 1.0;
        }
        return p_191503_1_.posX > d0 && p_191503_1_.posX < d2 && p_191503_1_.posZ > d1 && p_191503_1_.posZ < d3;
    }

    public boolean collidesWithAnyBlock(AxisAlignedBB p_collidesWithAnyBlock_1_) {
        return this.func_191504_a(null, p_collidesWithAnyBlock_1_, true, Lists.newArrayList());
    }

    public int calculateSkylightSubtracted(float p_calculateSkylightSubtracted_1_) {
        float f = this.provider.getSunBrightnessFactor(p_calculateSkylightSubtracted_1_);
        f = 1.0f - f;
        return (int)(f * 11.0f);
    }

    public float getSunBrightnessFactor(float p_getSunBrightnessFactor_1_) {
        float f = this.getCelestialAngle(p_getSunBrightnessFactor_1_);
        float f1 = 1.0f - (MathHelper.cos(f * ((float)Math.PI * 2)) * 2.0f + 0.5f);
        f1 = MathHelper.clamp(f1, 0.0f, 1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.getRainStrength(p_getSunBrightnessFactor_1_) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.getThunderStrength(p_getSunBrightnessFactor_1_) * 5.0f) / 16.0));
        return f1;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float p_getSunBrightness_1_) {
        return this.provider.getSunBrightness(p_getSunBrightness_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightnessBody(float p_getSunBrightnessBody_1_) {
        float f = this.getCelestialAngle(p_getSunBrightnessBody_1_);
        float f1 = 1.0f - (MathHelper.cos(f * ((float)Math.PI * 2)) * 2.0f + 0.2f);
        f1 = MathHelper.clamp(f1, 0.0f, 1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.getRainStrength(p_getSunBrightnessBody_1_) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.getThunderStrength(p_getSunBrightnessBody_1_) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity p_getSkyColor_1_, float p_getSkyColor_2_) {
        return this.provider.getSkyColor(p_getSkyColor_1_, p_getSkyColor_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColorBody(Entity p_getSkyColorBody_1_, float p_getSkyColorBody_2_) {
        float f10;
        float f = this.getCelestialAngle(p_getSkyColorBody_2_);
        float f1 = MathHelper.cos(f * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        f1 = MathHelper.clamp(f1, 0.0f, 1.0f);
        int i = MathHelper.floor(p_getSkyColorBody_1_.posX);
        int j = MathHelper.floor(p_getSkyColorBody_1_.posY);
        int k = MathHelper.floor(p_getSkyColorBody_1_.posZ);
        BlockPos blockpos = new BlockPos(i, j, k);
        int l = ForgeHooksClient.getSkyBlendColour(this, blockpos);
        float f3 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f4 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f5 = (float)(l & 0xFF) / 255.0f;
        f3 *= f1;
        f4 *= f1;
        f5 *= f1;
        float f6 = this.getRainStrength(p_getSkyColorBody_2_);
        if (f6 > 0.0f) {
            float f7 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.6f;
            float f8 = 1.0f - f6 * 0.75f;
            f3 = f3 * f8 + f7 * (1.0f - f8);
            f4 = f4 * f8 + f7 * (1.0f - f8);
            f5 = f5 * f8 + f7 * (1.0f - f8);
        }
        if ((f10 = this.getThunderStrength(p_getSkyColorBody_2_)) > 0.0f) {
            float f11 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.2f;
            float f9 = 1.0f - f10 * 0.75f;
            f3 = f3 * f9 + f11 * (1.0f - f9);
            f4 = f4 * f9 + f11 * (1.0f - f9);
            f5 = f5 * f9 + f11 * (1.0f - f9);
        }
        if (this.lastLightningBolt > 0) {
            float f12 = (float)this.lastLightningBolt - p_getSkyColorBody_2_;
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            f3 = f3 * (1.0f - (f12 *= 0.45f)) + 0.8f * f12;
            f4 = f4 * (1.0f - f12) + 0.8f * f12;
            f5 = f5 * (1.0f - f12) + 1.0f * f12;
        }
        return new Vec3d(f3, f4, f5);
    }

    public float getCelestialAngle(float p_getCelestialAngle_1_) {
        return this.provider.calculateCelestialAngle(this.getWorldTime(), p_getCelestialAngle_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public int getMoonPhase() {
        return this.provider.getMoonPhase(this.getWorldTime());
    }

    public float getCurrentMoonPhaseFactor() {
        return this.provider.getCurrentMoonPhaseFactor();
    }

    public float getCurrentMoonPhaseFactorBody() {
        return WorldProvider.MOON_PHASE_FACTORS[this.provider.getMoonPhase(this.getWorldTime())];
    }

    public float getCelestialAngleRadians(float p_getCelestialAngleRadians_1_) {
        float f = this.getCelestialAngle(p_getCelestialAngleRadians_1_);
        return f * ((float)Math.PI * 2);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColour(float p_getCloudColour_1_) {
        return this.provider.getCloudColor(p_getCloudColour_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColorBody(float p_getCloudColorBody_1_) {
        float f = this.getCelestialAngle(p_getCloudColorBody_1_);
        float f1 = MathHelper.cos(f * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        f1 = MathHelper.clamp(f1, 0.0f, 1.0f);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = this.getRainStrength(p_getCloudColorBody_1_);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f7 = 1.0f - f5 * 0.95f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        f2 *= f1 * 0.9f + 0.1f;
        f3 *= f1 * 0.9f + 0.1f;
        f4 *= f1 * 0.85f + 0.15f;
        float f9 = this.getThunderStrength(p_getCloudColorBody_1_);
        if (f9 > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.95f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        return new Vec3d(f2, f3, f4);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(float p_getFogColor_1_) {
        float f = this.getCelestialAngle(p_getFogColor_1_);
        return this.provider.getFogColor(f, p_getFogColor_1_);
    }

    public BlockPos getPrecipitationHeight(BlockPos p_getPrecipitationHeight_1_) {
        return this.getChunkFromBlockCoords(p_getPrecipitationHeight_1_).getPrecipitationHeight(p_getPrecipitationHeight_1_);
    }

    public BlockPos getTopSolidOrLiquidBlock(BlockPos p_getTopSolidOrLiquidBlock_1_) {
        BlockPos blockpos1;
        IBlockState state;
        Chunk chunk = this.getChunkFromBlockCoords(p_getTopSolidOrLiquidBlock_1_);
        BlockPos blockpos = new BlockPos(p_getTopSolidOrLiquidBlock_1_.getX(), chunk.getTopFilledSegment() + 16, p_getTopSolidOrLiquidBlock_1_.getZ());
        while (blockpos.getY() >= 0 && (!(state = chunk.getBlockState(blockpos1 = blockpos.down())).getMaterial().blocksMovement() || state.getBlock().isLeaves(state, this, blockpos1) || state.getBlock().isFoliage(this, blockpos1))) {
            blockpos = blockpos1;
        }
        return blockpos;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float p_getStarBrightness_1_) {
        return this.provider.getStarBrightness(p_getStarBrightness_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightnessBody(float p_getStarBrightnessBody_1_) {
        float f = this.getCelestialAngle(p_getStarBrightnessBody_1_);
        float f1 = 1.0f - (MathHelper.cos(f * ((float)Math.PI * 2)) * 2.0f + 0.25f);
        f1 = MathHelper.clamp(f1, 0.0f, 1.0f);
        return f1 * f1 * 0.5f;
    }

    public boolean isUpdateScheduled(BlockPos p_isUpdateScheduled_1_, Block p_isUpdateScheduled_2_) {
        return true;
    }

    public void scheduleUpdate(BlockPos p_scheduleUpdate_1_, Block p_scheduleUpdate_2_, int p_scheduleUpdate_3_) {
    }

    public void updateBlockTick(BlockPos p_updateBlockTick_1_, Block p_updateBlockTick_2_, int p_updateBlockTick_3_, int p_updateBlockTick_4_) {
    }

    public void scheduleBlockUpdate(BlockPos p_scheduleBlockUpdate_1_, Block p_scheduleBlockUpdate_2_, int p_scheduleBlockUpdate_3_, int p_scheduleBlockUpdate_4_) {
    }

    public void updateEntities() {
        this.theProfiler.startSection("entities");
        this.theProfiler.startSection("global");
        for (int i = 0; i < this.weatherEffects.size(); ++i) {
            Entity entity = this.weatherEffects.get(i);
            try {
                ++entity.ticksExisted;
                entity.onUpdate();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Ticking entity");
                CrashReportCategory crashreportcategory = crashreport.makeCategory("Entity being ticked");
                if (entity == null) {
                    crashreportcategory.addCrashSection("Entity", "~~NULL~~");
                } else {
                    entity.addEntityCrashInfo(crashreportcategory);
                }
                if (ForgeModContainer.removeErroringEntities) {
                    FMLLog.severe(crashreport.getCompleteReport(), new Object[0]);
                    this.removeEntity(entity);
                }
                throw new ReportedException(crashreport);
            }
            if (!entity.isDead) continue;
            this.weatherEffects.remove(i--);
        }
        this.theProfiler.endStartSection("remove");
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        for (int k = 0; k < this.unloadedEntityList.size(); ++k) {
            Entity entity1 = this.unloadedEntityList.get(k);
            int n = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (!entity1.addedToChunk || !this.isChunkLoaded(n, k1, true)) continue;
            this.getChunkFromChunkCoords(n, k1).removeEntity(entity1);
        }
        for (int l = 0; l < this.unloadedEntityList.size(); ++l) {
            this.onEntityRemoved(this.unloadedEntityList.get(l));
        }
        this.unloadedEntityList.clear();
        this.tickPlayers();
        this.theProfiler.endStartSection("regular");
        for (int i1 = 0; i1 < this.loadedEntityList.size(); ++i1) {
            Entity entity2 = this.loadedEntityList.get(i1);
            Entity entity = entity2.getRidingEntity();
            if (entity != null) {
                if (!entity.isDead && entity.isPassenger(entity2)) continue;
                entity2.dismountRidingEntity();
            }
            this.theProfiler.startSection("tick");
            if (!entity2.isDead && !(entity2 instanceof EntityPlayerMP)) {
                try {
                    this.updateEntity(entity2);
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport1 = CrashReport.makeCrashReport(throwable1, "Ticking entity");
                    CrashReportCategory crashreportcategory1 = crashreport1.makeCategory("Entity being ticked");
                    entity2.addEntityCrashInfo(crashreportcategory1);
                    if (ForgeModContainer.removeErroringEntities) {
                        FMLLog.severe(crashreport1.getCompleteReport(), new Object[0]);
                        this.removeEntity(entity2);
                    }
                    throw new ReportedException(crashreport1);
                }
            }
            this.theProfiler.endSection();
            this.theProfiler.startSection("remove");
            if (entity2.isDead) {
                int l1 = entity2.chunkCoordX;
                int i2 = entity2.chunkCoordZ;
                if (entity2.addedToChunk && this.isChunkLoaded(l1, i2, true)) {
                    this.getChunkFromChunkCoords(l1, i2).removeEntity(entity2);
                }
                this.loadedEntityList.remove(i1--);
                this.onEntityRemoved(entity2);
            }
            this.theProfiler.endSection();
        }
        this.theProfiler.endStartSection("blockEntities");
        this.processingLoadedTiles = true;
        Iterator<TileEntity> iterator = this.tickableTileEntities.iterator();
        while (iterator.hasNext()) {
            Chunk chunk;
            BlockPos blockPos;
            TileEntity tileentity = iterator.next();
            if (!tileentity.isInvalid() && tileentity.hasWorld() && this.isBlockLoaded(blockPos = tileentity.getPos(), false) && this.worldBorder.contains(blockPos)) {
                try {
                    this.theProfiler.startSection(tileentity.getClass().getSimpleName());
                    ((ITickable)((Object)tileentity)).update();
                    this.theProfiler.endSection();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport2 = CrashReport.makeCrashReport(throwable, "Ticking block entity");
                    CrashReportCategory crashreportcategory2 = crashreport2.makeCategory("Block entity being ticked");
                    tileentity.addInfoToCrashReport(crashreportcategory2);
                    if (ForgeModContainer.removeErroringTileEntities) {
                        FMLLog.severe(crashreport2.getCompleteReport(), new Object[0]);
                        tileentity.invalidate();
                        this.removeTileEntity(tileentity.getPos());
                    }
                    throw new ReportedException(crashreport2);
                }
            }
            if (!tileentity.isInvalid()) continue;
            iterator.remove();
            this.loadedTileEntityList.remove(tileentity);
            if (!this.isBlockLoaded(tileentity.getPos()) || (chunk = this.getChunkFromBlockCoords(tileentity.getPos())).getTileEntity(tileentity.getPos(), Chunk.EnumCreateEntityType.CHECK) != tileentity) continue;
            chunk.removeTileEntity(tileentity.getPos());
        }
        if (!this.tileEntitiesToBeRemoved.isEmpty()) {
            for (Object e : this.tileEntitiesToBeRemoved) {
                ((TileEntity)e).onChunkUnload();
            }
            this.tickableTileEntities.removeAll(this.tileEntitiesToBeRemoved);
            this.loadedTileEntityList.removeAll(this.tileEntitiesToBeRemoved);
            this.tileEntitiesToBeRemoved.clear();
        }
        this.processingLoadedTiles = false;
        this.theProfiler.endStartSection("pendingBlockEntities");
        if (!this.addedTileEntityList.isEmpty()) {
            for (int j1 = 0; j1 < this.addedTileEntityList.size(); ++j1) {
                TileEntity tileEntity = this.addedTileEntityList.get(j1);
                if (tileEntity.isInvalid()) continue;
                if (!this.loadedTileEntityList.contains(tileEntity)) {
                    this.addTileEntity(tileEntity);
                }
                if (!this.isBlockLoaded(tileEntity.getPos())) continue;
                Chunk chunk = this.getChunkFromBlockCoords(tileEntity.getPos());
                IBlockState iblockstate = chunk.getBlockState(tileEntity.getPos());
                chunk.addTileEntity(tileEntity.getPos(), tileEntity);
                this.notifyBlockUpdate(tileEntity.getPos(), iblockstate, iblockstate, 3);
            }
            this.addedTileEntityList.clear();
        }
        this.theProfiler.endSection();
        this.theProfiler.endSection();
    }

    protected void tickPlayers() {
    }

    public boolean addTileEntity(TileEntity p_addTileEntity_1_) {
        List<TileEntity> dest;
        boolean flag;
        if (p_addTileEntity_1_.getWorld() != this) {
            p_addTileEntity_1_.setWorld(this);
        }
        if ((flag = (dest = this.processingLoadedTiles ? this.addedTileEntityList : this.loadedTileEntityList).add(p_addTileEntity_1_)) && p_addTileEntity_1_ instanceof ITickable) {
            this.tickableTileEntities.add(p_addTileEntity_1_);
        }
        if (this.isRemote) {
            BlockPos blockpos = p_addTileEntity_1_.getPos();
            IBlockState iblockstate = this.getBlockState(blockpos);
            this.notifyBlockUpdate(blockpos, iblockstate, iblockstate, 2);
        }
        return flag;
    }

    public void addTileEntities(Collection<TileEntity> p_addTileEntities_1_) {
        if (this.processingLoadedTiles) {
            for (TileEntity te : p_addTileEntities_1_) {
                if (te.getWorld() == this) continue;
                te.setWorld(this);
            }
            this.addedTileEntityList.addAll(p_addTileEntities_1_);
        } else {
            for (TileEntity tileentity : p_addTileEntities_1_) {
                this.addTileEntity(tileentity);
            }
        }
    }

    public void updateEntity(Entity p_updateEntity_1_) {
        this.updateEntityWithOptionalForce(p_updateEntity_1_, true);
    }

    public void updateEntityWithOptionalForce(Entity p_updateEntityWithOptionalForce_1_, boolean p_updateEntityWithOptionalForce_2_) {
        boolean canUpdate;
        int i = MathHelper.floor(p_updateEntityWithOptionalForce_1_.posX);
        int j = MathHelper.floor(p_updateEntityWithOptionalForce_1_.posZ);
        boolean isForced = this.getPersistentChunks().containsKey((Object)new ChunkPos(i >> 4, j >> 4));
        int k = isForced ? 0 : 32;
        boolean bl = canUpdate = !p_updateEntityWithOptionalForce_2_ || this.isAreaLoaded(i - k, 0, j - k, i + k, 0, j + k, true);
        if (!canUpdate) {
            canUpdate = ForgeEventFactory.canEntityUpdate(p_updateEntityWithOptionalForce_1_);
        }
        if (canUpdate) {
            p_updateEntityWithOptionalForce_1_.lastTickPosX = p_updateEntityWithOptionalForce_1_.posX;
            p_updateEntityWithOptionalForce_1_.lastTickPosY = p_updateEntityWithOptionalForce_1_.posY;
            p_updateEntityWithOptionalForce_1_.lastTickPosZ = p_updateEntityWithOptionalForce_1_.posZ;
            p_updateEntityWithOptionalForce_1_.prevRotationYaw = p_updateEntityWithOptionalForce_1_.rotationYaw;
            p_updateEntityWithOptionalForce_1_.prevRotationPitch = p_updateEntityWithOptionalForce_1_.rotationPitch;
            if (p_updateEntityWithOptionalForce_2_ && p_updateEntityWithOptionalForce_1_.addedToChunk) {
                ++p_updateEntityWithOptionalForce_1_.ticksExisted;
                if (p_updateEntityWithOptionalForce_1_.isRiding()) {
                    p_updateEntityWithOptionalForce_1_.updateRidden();
                } else {
                    p_updateEntityWithOptionalForce_1_.onUpdate();
                }
            }
            this.theProfiler.startSection("chunkCheck");
            if (Double.isNaN(p_updateEntityWithOptionalForce_1_.posX) || Double.isInfinite(p_updateEntityWithOptionalForce_1_.posX)) {
                p_updateEntityWithOptionalForce_1_.posX = p_updateEntityWithOptionalForce_1_.lastTickPosX;
            }
            if (Double.isNaN(p_updateEntityWithOptionalForce_1_.posY) || Double.isInfinite(p_updateEntityWithOptionalForce_1_.posY)) {
                p_updateEntityWithOptionalForce_1_.posY = p_updateEntityWithOptionalForce_1_.lastTickPosY;
            }
            if (Double.isNaN(p_updateEntityWithOptionalForce_1_.posZ) || Double.isInfinite(p_updateEntityWithOptionalForce_1_.posZ)) {
                p_updateEntityWithOptionalForce_1_.posZ = p_updateEntityWithOptionalForce_1_.lastTickPosZ;
            }
            if (Double.isNaN(p_updateEntityWithOptionalForce_1_.rotationPitch) || Double.isInfinite(p_updateEntityWithOptionalForce_1_.rotationPitch)) {
                p_updateEntityWithOptionalForce_1_.rotationPitch = p_updateEntityWithOptionalForce_1_.prevRotationPitch;
            }
            if (Double.isNaN(p_updateEntityWithOptionalForce_1_.rotationYaw) || Double.isInfinite(p_updateEntityWithOptionalForce_1_.rotationYaw)) {
                p_updateEntityWithOptionalForce_1_.rotationYaw = p_updateEntityWithOptionalForce_1_.prevRotationYaw;
            }
            int l = MathHelper.floor(p_updateEntityWithOptionalForce_1_.posX / 16.0);
            int i1 = MathHelper.floor(p_updateEntityWithOptionalForce_1_.posY / 16.0);
            int j1 = MathHelper.floor(p_updateEntityWithOptionalForce_1_.posZ / 16.0);
            if (!p_updateEntityWithOptionalForce_1_.addedToChunk || p_updateEntityWithOptionalForce_1_.chunkCoordX != l || p_updateEntityWithOptionalForce_1_.chunkCoordY != i1 || p_updateEntityWithOptionalForce_1_.chunkCoordZ != j1) {
                if (p_updateEntityWithOptionalForce_1_.addedToChunk && this.isChunkLoaded(p_updateEntityWithOptionalForce_1_.chunkCoordX, p_updateEntityWithOptionalForce_1_.chunkCoordZ, true)) {
                    this.getChunkFromChunkCoords(p_updateEntityWithOptionalForce_1_.chunkCoordX, p_updateEntityWithOptionalForce_1_.chunkCoordZ).removeEntityAtIndex(p_updateEntityWithOptionalForce_1_, p_updateEntityWithOptionalForce_1_.chunkCoordY);
                }
                if (!p_updateEntityWithOptionalForce_1_.setPositionNonDirty() && !this.isChunkLoaded(l, j1, true)) {
                    p_updateEntityWithOptionalForce_1_.addedToChunk = false;
                } else {
                    this.getChunkFromChunkCoords(l, j1).addEntity(p_updateEntityWithOptionalForce_1_);
                }
            }
            this.theProfiler.endSection();
            if (p_updateEntityWithOptionalForce_2_ && p_updateEntityWithOptionalForce_1_.addedToChunk) {
                for (Entity entity : p_updateEntityWithOptionalForce_1_.getPassengers()) {
                    if (!entity.isDead && entity.getRidingEntity() == p_updateEntityWithOptionalForce_1_) {
                        this.updateEntity(entity);
                        continue;
                    }
                    entity.dismountRidingEntity();
                }
            }
        }
    }

    public boolean checkNoEntityCollision(AxisAlignedBB p_checkNoEntityCollision_1_) {
        return this.checkNoEntityCollision(p_checkNoEntityCollision_1_, null);
    }

    public boolean checkNoEntityCollision(AxisAlignedBB p_checkNoEntityCollision_1_, Entity p_checkNoEntityCollision_2_) {
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(null, p_checkNoEntityCollision_1_);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (entity.isDead || !entity.preventEntitySpawning || entity == p_checkNoEntityCollision_2_ || p_checkNoEntityCollision_2_ != null && !entity.isRidingSameEntity(p_checkNoEntityCollision_2_)) continue;
            return false;
        }
        return true;
    }

    public boolean checkBlockCollision(AxisAlignedBB p_checkBlockCollision_1_) {
        int i = MathHelper.floor(p_checkBlockCollision_1_.minX);
        int j = MathHelper.ceil(p_checkBlockCollision_1_.maxX);
        int k = MathHelper.floor(p_checkBlockCollision_1_.minY);
        int l = MathHelper.ceil(p_checkBlockCollision_1_.maxY);
        int i1 = MathHelper.floor(p_checkBlockCollision_1_.minZ);
        int j1 = MathHelper.ceil(p_checkBlockCollision_1_.maxZ);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    IBlockState iblockstate = this.getBlockState(blockpos$pooledmutableblockpos.setPos(k1, l1, i2));
                    if (iblockstate.getMaterial() == Material.AIR) continue;
                    blockpos$pooledmutableblockpos.release();
                    return true;
                }
            }
        }
        blockpos$pooledmutableblockpos.release();
        return false;
    }

    public boolean containsAnyLiquid(AxisAlignedBB p_containsAnyLiquid_1_) {
        int i = MathHelper.floor(p_containsAnyLiquid_1_.minX);
        int j = MathHelper.ceil(p_containsAnyLiquid_1_.maxX);
        int k = MathHelper.floor(p_containsAnyLiquid_1_.minY);
        int l = MathHelper.ceil(p_containsAnyLiquid_1_.maxY);
        int i1 = MathHelper.floor(p_containsAnyLiquid_1_.minZ);
        int j1 = MathHelper.ceil(p_containsAnyLiquid_1_.maxZ);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    IBlockState iblockstate = this.getBlockState(blockpos$pooledmutableblockpos.setPos(k1, l1, i2));
                    if (!iblockstate.getMaterial().isLiquid()) continue;
                    blockpos$pooledmutableblockpos.release();
                    return true;
                }
            }
        }
        blockpos$pooledmutableblockpos.release();
        return false;
    }

    public boolean isFlammableWithin(AxisAlignedBB p_isFlammableWithin_1_) {
        int j1;
        int i = MathHelper.floor(p_isFlammableWithin_1_.minX);
        int j = MathHelper.ceil(p_isFlammableWithin_1_.maxX);
        int k = MathHelper.floor(p_isFlammableWithin_1_.minY);
        int l = MathHelper.ceil(p_isFlammableWithin_1_.maxY);
        int i1 = MathHelper.floor(p_isFlammableWithin_1_.minZ);
        if (this.isAreaLoaded(i, k, i1, j, l, j1 = MathHelper.ceil(p_isFlammableWithin_1_.maxZ), true)) {
            BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        Block block = this.getBlockState(blockpos$pooledmutableblockpos.setPos(k1, l1, i2)).getBlock();
                        if (block == Blocks.FIRE || block == Blocks.FLOWING_LAVA || block == Blocks.LAVA) {
                            blockpos$pooledmutableblockpos.release();
                            return true;
                        }
                        if (!block.isBurning(this, new BlockPos(k1, l1, i2))) continue;
                        blockpos$pooledmutableblockpos.release();
                        return true;
                    }
                }
            }
            blockpos$pooledmutableblockpos.release();
        }
        return false;
    }

    public boolean handleMaterialAcceleration(AxisAlignedBB p_handleMaterialAcceleration_1_, Material p_handleMaterialAcceleration_2_, Entity p_handleMaterialAcceleration_3_) {
        int j1;
        int i = MathHelper.floor(p_handleMaterialAcceleration_1_.minX);
        int j = MathHelper.ceil(p_handleMaterialAcceleration_1_.maxX);
        int k = MathHelper.floor(p_handleMaterialAcceleration_1_.minY);
        int l = MathHelper.ceil(p_handleMaterialAcceleration_1_.maxY);
        int i1 = MathHelper.floor(p_handleMaterialAcceleration_1_.minZ);
        if (!this.isAreaLoaded(i, k, i1, j, l, j1 = MathHelper.ceil(p_handleMaterialAcceleration_1_.maxZ), true)) {
            return false;
        }
        boolean flag = false;
        Vec3d vec3d = Vec3d.ZERO;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double d0;
                    blockpos$pooledmutableblockpos.setPos(k1, l1, i2);
                    IBlockState iblockstate = this.getBlockState(blockpos$pooledmutableblockpos);
                    Block block = iblockstate.getBlock();
                    Boolean result = block.isEntityInsideMaterial(this, blockpos$pooledmutableblockpos, iblockstate, p_handleMaterialAcceleration_3_, l, p_handleMaterialAcceleration_2_, false);
                    if (result != null && result.booleanValue()) {
                        flag = true;
                        vec3d = block.modifyAcceleration(this, blockpos$pooledmutableblockpos, p_handleMaterialAcceleration_3_, vec3d);
                        continue;
                    }
                    if (result != null && !result.booleanValue() || iblockstate.getMaterial() != p_handleMaterialAcceleration_2_ || !((double)l >= (d0 = (double)((float)(l1 + 1) - BlockLiquid.getLiquidHeightPercent(iblockstate.getValue(BlockLiquid.LEVEL)))))) continue;
                    flag = true;
                    vec3d = block.modifyAcceleration(this, blockpos$pooledmutableblockpos, p_handleMaterialAcceleration_3_, vec3d);
                }
            }
        }
        blockpos$pooledmutableblockpos.release();
        if (vec3d.lengthVector() > 0.0 && p_handleMaterialAcceleration_3_.isPushedByWater()) {
            vec3d = vec3d.normalize();
            double d1 = 0.014;
            p_handleMaterialAcceleration_3_.motionX += vec3d.xCoord * 0.014;
            p_handleMaterialAcceleration_3_.motionY += vec3d.yCoord * 0.014;
            p_handleMaterialAcceleration_3_.motionZ += vec3d.zCoord * 0.014;
        }
        return flag;
    }

    public boolean isMaterialInBB(AxisAlignedBB p_isMaterialInBB_1_, Material p_isMaterialInBB_2_) {
        int i = MathHelper.floor(p_isMaterialInBB_1_.minX);
        int j = MathHelper.ceil(p_isMaterialInBB_1_.maxX);
        int k = MathHelper.floor(p_isMaterialInBB_1_.minY);
        int l = MathHelper.ceil(p_isMaterialInBB_1_.maxY);
        int i1 = MathHelper.floor(p_isMaterialInBB_1_.minZ);
        int j1 = MathHelper.ceil(p_isMaterialInBB_1_.maxZ);
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    if (this.getBlockState(blockpos$pooledmutableblockpos.setPos(k1, l1, i2)).getMaterial() != p_isMaterialInBB_2_) continue;
                    blockpos$pooledmutableblockpos.release();
                    return true;
                }
            }
        }
        blockpos$pooledmutableblockpos.release();
        return false;
    }

    public Explosion createExplosion(Entity p_createExplosion_1_, double p_createExplosion_2_, double p_createExplosion_4_, double p_createExplosion_6_, float p_createExplosion_8_, boolean p_createExplosion_9_) {
        return this.newExplosion(p_createExplosion_1_, p_createExplosion_2_, p_createExplosion_4_, p_createExplosion_6_, p_createExplosion_8_, false, p_createExplosion_9_);
    }

    public Explosion newExplosion(Entity p_newExplosion_1_, double p_newExplosion_2_, double p_newExplosion_4_, double p_newExplosion_6_, float p_newExplosion_8_, boolean p_newExplosion_9_, boolean p_newExplosion_10_) {
        Explosion explosion = new Explosion(this, p_newExplosion_1_, p_newExplosion_2_, p_newExplosion_4_, p_newExplosion_6_, p_newExplosion_8_, p_newExplosion_9_, p_newExplosion_10_);
        if (ForgeEventFactory.onExplosionStart(this, explosion)) {
            return explosion;
        }
        explosion.doExplosionA();
        explosion.doExplosionB(true);
        return explosion;
    }

    public float getBlockDensity(Vec3d p_getBlockDensity_1_, AxisAlignedBB p_getBlockDensity_2_) {
        double d0 = 1.0 / ((p_getBlockDensity_2_.maxX - p_getBlockDensity_2_.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((p_getBlockDensity_2_.maxY - p_getBlockDensity_2_.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((p_getBlockDensity_2_.maxZ - p_getBlockDensity_2_.minZ) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d5 = p_getBlockDensity_2_.minX + (p_getBlockDensity_2_.maxX - p_getBlockDensity_2_.minX) * (double)f;
                        double d6 = p_getBlockDensity_2_.minY + (p_getBlockDensity_2_.maxY - p_getBlockDensity_2_.minY) * (double)f1;
                        double d7 = p_getBlockDensity_2_.minZ + (p_getBlockDensity_2_.maxZ - p_getBlockDensity_2_.minZ) * (double)f2;
                        if (this.rayTraceBlocks(new Vec3d(d5 + d3, d6, d7 + d4), p_getBlockDensity_1_) == null) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public boolean extinguishFire(EntityPlayer p_extinguishFire_1_, BlockPos p_extinguishFire_2_, EnumFacing p_extinguishFire_3_) {
        if (this.getBlockState(p_extinguishFire_2_ = p_extinguishFire_2_.offset(p_extinguishFire_3_)).getBlock() == Blocks.FIRE) {
            this.playEvent(p_extinguishFire_1_, 1009, p_extinguishFire_2_, 0);
            this.setBlockToAir(p_extinguishFire_2_);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDebugLoadedEntities() {
        return "All: " + this.loadedEntityList.size();
    }

    @SideOnly(value=Side.CLIENT)
    public String getProviderName() {
        return this.chunkProvider.makeString();
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(BlockPos p_getTileEntity_1_) {
        if (this.isOutsideBuildHeight(p_getTileEntity_1_)) {
            return null;
        }
        TileEntity tileentity = null;
        if (this.processingLoadedTiles) {
            tileentity = this.getPendingTileEntityAt(p_getTileEntity_1_);
        }
        if (tileentity == null) {
            tileentity = this.getChunkFromBlockCoords(p_getTileEntity_1_).getTileEntity(p_getTileEntity_1_, Chunk.EnumCreateEntityType.IMMEDIATE);
        }
        if (tileentity == null) {
            tileentity = this.getPendingTileEntityAt(p_getTileEntity_1_);
        }
        return tileentity;
    }

    @Nullable
    private TileEntity getPendingTileEntityAt(BlockPos p_getPendingTileEntityAt_1_) {
        for (int i = 0; i < this.addedTileEntityList.size(); ++i) {
            TileEntity tileentity = this.addedTileEntityList.get(i);
            if (tileentity.isInvalid() || !tileentity.getPos().equals(p_getPendingTileEntityAt_1_)) continue;
            return tileentity;
        }
        return null;
    }

    public void setTileEntity(BlockPos p_setTileEntity_1_, TileEntity p_setTileEntity_2_) {
        if (!this.isOutsideBuildHeight(p_setTileEntity_1_ = p_setTileEntity_1_.toImmutable()) && p_setTileEntity_2_ != null && !p_setTileEntity_2_.isInvalid()) {
            if (this.processingLoadedTiles) {
                p_setTileEntity_2_.setPos(p_setTileEntity_1_);
                if (p_setTileEntity_2_.getWorld() != this) {
                    p_setTileEntity_2_.setWorld(this);
                }
                Iterator<TileEntity> iterator = this.addedTileEntityList.iterator();
                while (iterator.hasNext()) {
                    TileEntity tileentity = iterator.next();
                    if (!tileentity.getPos().equals(p_setTileEntity_1_)) continue;
                    tileentity.invalidate();
                    iterator.remove();
                }
                this.addedTileEntityList.add(p_setTileEntity_2_);
            } else {
                Chunk chunk = this.getChunkFromBlockCoords(p_setTileEntity_1_);
                if (chunk != null) {
                    chunk.addTileEntity(p_setTileEntity_1_, p_setTileEntity_2_);
                }
                this.addTileEntity(p_setTileEntity_2_);
            }
        }
    }

    public void removeTileEntity(BlockPos p_removeTileEntity_1_) {
        TileEntity tileentity = this.getTileEntity(p_removeTileEntity_1_);
        if (tileentity != null && this.processingLoadedTiles) {
            tileentity.invalidate();
            this.addedTileEntityList.remove(tileentity);
            if (!(tileentity instanceof ITickable)) {
                this.loadedTileEntityList.remove(tileentity);
            }
        } else {
            if (tileentity != null) {
                this.addedTileEntityList.remove(tileentity);
                this.loadedTileEntityList.remove(tileentity);
                this.tickableTileEntities.remove(tileentity);
            }
            this.getChunkFromBlockCoords(p_removeTileEntity_1_).removeTileEntity(p_removeTileEntity_1_);
        }
        this.updateComparatorOutputLevel(p_removeTileEntity_1_, this.getBlockState(p_removeTileEntity_1_).getBlock());
    }

    public void markTileEntityForRemoval(TileEntity p_markTileEntityForRemoval_1_) {
        this.tileEntitiesToBeRemoved.add(p_markTileEntityForRemoval_1_);
    }

    public boolean isBlockFullCube(BlockPos p_isBlockFullCube_1_) {
        AxisAlignedBB axisalignedbb = this.getBlockState(p_isBlockFullCube_1_).getCollisionBoundingBox(this, p_isBlockFullCube_1_);
        return axisalignedbb != Block.NULL_AABB && axisalignedbb.getAverageEdgeLength() >= 1.0;
    }

    public boolean isBlockNormalCube(BlockPos p_isBlockNormalCube_1_, boolean p_isBlockNormalCube_2_) {
        if (this.isOutsideBuildHeight(p_isBlockNormalCube_1_)) {
            return false;
        }
        Chunk chunk = this.chunkProvider.getLoadedChunk(p_isBlockNormalCube_1_.getX() >> 4, p_isBlockNormalCube_1_.getZ() >> 4);
        if (chunk != null && !chunk.isEmpty()) {
            IBlockState iblockstate = this.getBlockState(p_isBlockNormalCube_1_);
            return iblockstate.getBlock().isNormalCube(iblockstate, this, p_isBlockNormalCube_1_);
        }
        return p_isBlockNormalCube_2_;
    }

    public void calculateInitialSkylight() {
        int i = this.calculateSkylightSubtracted(1.0f);
        if (i != this.skylightSubtracted) {
            this.skylightSubtracted = i;
        }
    }

    public void setAllowedSpawnTypes(boolean p_setAllowedSpawnTypes_1_, boolean p_setAllowedSpawnTypes_2_) {
        this.spawnHostileMobs = p_setAllowedSpawnTypes_1_;
        this.spawnPeacefulMobs = p_setAllowedSpawnTypes_2_;
        this.provider.setAllowedSpawnTypes(p_setAllowedSpawnTypes_1_, p_setAllowedSpawnTypes_2_);
    }

    public void tick() {
        this.updateWeather();
    }

    protected void calculateInitialWeather() {
        this.provider.calculateInitialWeather();
    }

    public void calculateInitialWeatherBody() {
        if (this.worldInfo.isRaining()) {
            this.rainingStrength = 1.0f;
            if (this.worldInfo.isThundering()) {
                this.thunderingStrength = 1.0f;
            }
        }
    }

    protected void updateWeather() {
        this.provider.updateWeather();
    }

    public void updateWeatherBody() {
        if (this.provider.hasSkyLight() && !this.isRemote) {
            boolean flag = this.getGameRules().getBoolean("doWeatherCycle");
            if (flag) {
                int j;
                int i = this.worldInfo.getCleanWeatherTime();
                if (i > 0) {
                    this.worldInfo.setCleanWeatherTime(--i);
                    this.worldInfo.setThunderTime(this.worldInfo.isThundering() ? 1 : 2);
                    this.worldInfo.setRainTime(this.worldInfo.isRaining() ? 1 : 2);
                }
                if ((j = this.worldInfo.getThunderTime()) <= 0) {
                    if (this.worldInfo.isThundering()) {
                        this.worldInfo.setThunderTime(this.rand.nextInt(12000) + 3600);
                    } else {
                        this.worldInfo.setThunderTime(this.rand.nextInt(168000) + 12000);
                    }
                } else {
                    this.worldInfo.setThunderTime(--j);
                    if (j <= 0) {
                        this.worldInfo.setThundering(!this.worldInfo.isThundering());
                    }
                }
                int k = this.worldInfo.getRainTime();
                if (k <= 0) {
                    if (this.worldInfo.isRaining()) {
                        this.worldInfo.setRainTime(this.rand.nextInt(12000) + 12000);
                    } else {
                        this.worldInfo.setRainTime(this.rand.nextInt(168000) + 12000);
                    }
                } else {
                    this.worldInfo.setRainTime(--k);
                    if (k <= 0) {
                        this.worldInfo.setRaining(!this.worldInfo.isRaining());
                    }
                }
            }
            this.prevThunderingStrength = this.thunderingStrength;
            this.thunderingStrength = this.worldInfo.isThundering() ? (float)((double)this.thunderingStrength + 0.01) : (float)((double)this.thunderingStrength - 0.01);
            this.thunderingStrength = MathHelper.clamp(this.thunderingStrength, 0.0f, 1.0f);
            this.prevRainingStrength = this.rainingStrength;
            this.rainingStrength = this.worldInfo.isRaining() ? (float)((double)this.rainingStrength + 0.01) : (float)((double)this.rainingStrength - 0.01);
            this.rainingStrength = MathHelper.clamp(this.rainingStrength, 0.0f, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void playMoodSoundAndCheckLight(int p_playMoodSoundAndCheckLight_1_, int p_playMoodSoundAndCheckLight_2_, Chunk p_playMoodSoundAndCheckLight_3_) {
        p_playMoodSoundAndCheckLight_3_.enqueueRelightChecks();
    }

    protected void updateBlocks() {
    }

    public void immediateBlockTick(BlockPos p_immediateBlockTick_1_, IBlockState p_immediateBlockTick_2_, Random p_immediateBlockTick_3_) {
        this.scheduledUpdatesAreImmediate = true;
        p_immediateBlockTick_2_.getBlock().updateTick(this, p_immediateBlockTick_1_, p_immediateBlockTick_2_, p_immediateBlockTick_3_);
        this.scheduledUpdatesAreImmediate = false;
    }

    public boolean canBlockFreezeWater(BlockPos p_canBlockFreezeWater_1_) {
        return this.canBlockFreeze(p_canBlockFreezeWater_1_, false);
    }

    public boolean canBlockFreezeNoWater(BlockPos p_canBlockFreezeNoWater_1_) {
        return this.canBlockFreeze(p_canBlockFreezeNoWater_1_, true);
    }

    public boolean canBlockFreeze(BlockPos p_canBlockFreeze_1_, boolean p_canBlockFreeze_2_) {
        return this.provider.canBlockFreeze(p_canBlockFreeze_1_, p_canBlockFreeze_2_);
    }

    public boolean canBlockFreezeBody(BlockPos p_canBlockFreezeBody_1_, boolean p_canBlockFreezeBody_2_) {
        IBlockState iblockstate;
        Block block;
        Biome biome = this.getBiome(p_canBlockFreezeBody_1_);
        float f = biome.getFloatTemperature(p_canBlockFreezeBody_1_);
        if (f >= 0.15f) {
            return false;
        }
        if (p_canBlockFreezeBody_1_.getY() >= 0 && p_canBlockFreezeBody_1_.getY() < 256 && this.getLightFor(EnumSkyBlock.BLOCK, p_canBlockFreezeBody_1_) < 10 && ((block = (iblockstate = this.getBlockState(p_canBlockFreezeBody_1_)).getBlock()) == Blocks.WATER || block == Blocks.FLOWING_WATER) && iblockstate.getValue(BlockLiquid.LEVEL) == 0) {
            boolean flag;
            if (!p_canBlockFreezeBody_2_) {
                return true;
            }
            boolean bl = flag = this.isWater(p_canBlockFreezeBody_1_.west()) && this.isWater(p_canBlockFreezeBody_1_.east()) && this.isWater(p_canBlockFreezeBody_1_.north()) && this.isWater(p_canBlockFreezeBody_1_.south());
            if (!flag) {
                return true;
            }
        }
        return false;
    }

    private boolean isWater(BlockPos p_isWater_1_) {
        return this.getBlockState(p_isWater_1_).getMaterial() == Material.WATER;
    }

    public boolean canSnowAt(BlockPos p_canSnowAt_1_, boolean p_canSnowAt_2_) {
        return this.provider.canSnowAt(p_canSnowAt_1_, p_canSnowAt_2_);
    }

    public boolean canSnowAtBody(BlockPos p_canSnowAtBody_1_, boolean p_canSnowAtBody_2_) {
        IBlockState iblockstate;
        Biome biome = this.getBiome(p_canSnowAtBody_1_);
        float f = biome.getFloatTemperature(p_canSnowAtBody_1_);
        if (f >= 0.15f) {
            return false;
        }
        if (!p_canSnowAtBody_2_) {
            return true;
        }
        return p_canSnowAtBody_1_.getY() >= 0 && p_canSnowAtBody_1_.getY() < 256 && this.getLightFor(EnumSkyBlock.BLOCK, p_canSnowAtBody_1_) < 10 && (iblockstate = this.getBlockState(p_canSnowAtBody_1_)).getBlock().isAir(iblockstate, this, p_canSnowAtBody_1_) && Blocks.SNOW_LAYER.canPlaceBlockAt(this, p_canSnowAtBody_1_);
    }

    public boolean checkLight(BlockPos p_checkLight_1_) {
        boolean flag = false;
        if (this.provider.hasSkyLight()) {
            flag |= this.checkLightFor(EnumSkyBlock.SKY, p_checkLight_1_);
        }
        return flag |= this.checkLightFor(EnumSkyBlock.BLOCK, p_checkLight_1_);
    }

    private int getRawLight(BlockPos p_getRawLight_1_, EnumSkyBlock p_getRawLight_2_) {
        if (p_getRawLight_2_ == EnumSkyBlock.SKY && this.canSeeSky(p_getRawLight_1_)) {
            return 15;
        }
        IBlockState iblockstate = this.getBlockState(p_getRawLight_1_);
        int blockLight = iblockstate.getBlock().getLightValue(iblockstate, this, p_getRawLight_1_);
        int i = p_getRawLight_2_ == EnumSkyBlock.SKY ? 0 : blockLight;
        int j = iblockstate.getBlock().getLightOpacity(iblockstate, this, p_getRawLight_1_);
        if (j >= 15 && blockLight > 0) {
            j = 1;
        }
        if (j < 1) {
            j = 1;
        }
        if (j >= 15) {
            return 0;
        }
        if (i >= 14) {
            return i;
        }
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
        for (EnumFacing enumfacing : EnumFacing.values()) {
            blockpos$pooledmutableblockpos.setPos(p_getRawLight_1_).move(enumfacing);
            int k = this.getLightFor(p_getRawLight_2_, blockpos$pooledmutableblockpos) - j;
            if (k > i) {
                i = k;
            }
            if (i < 14) continue;
            return i;
        }
        blockpos$pooledmutableblockpos.release();
        return i;
    }

    public boolean checkLightFor(EnumSkyBlock p_checkLightFor_1_, BlockPos p_checkLightFor_2_) {
        if (!this.isAreaLoaded(p_checkLightFor_2_, 17, false)) {
            return false;
        }
        int i = 0;
        int j = 0;
        this.theProfiler.startSection("getBrightness");
        int k = this.getLightFor(p_checkLightFor_1_, p_checkLightFor_2_);
        int l = this.getRawLight(p_checkLightFor_2_, p_checkLightFor_1_);
        int i1 = p_checkLightFor_2_.getX();
        int j1 = p_checkLightFor_2_.getY();
        int k1 = p_checkLightFor_2_.getZ();
        if (l > k) {
            this.lightUpdateBlockList[j++] = 133152;
        } else if (l < k) {
            this.lightUpdateBlockList[j++] = 0x20820 | k << 18;
            while (i < j) {
                int l3;
                int k3;
                int j3;
                int l1 = this.lightUpdateBlockList[i++];
                int i2 = (l1 & 0x3F) - 32 + i1;
                int j2 = (l1 >> 6 & 0x3F) - 32 + j1;
                int k2 = (l1 >> 12 & 0x3F) - 32 + k1;
                int l2 = l1 >> 18 & 0xF;
                BlockPos blockpos = new BlockPos(i2, j2, k2);
                int i3 = this.getLightFor(p_checkLightFor_1_, blockpos);
                if (i3 != l2) continue;
                this.setLightFor(p_checkLightFor_1_, blockpos, 0);
                if (l2 <= 0 || (j3 = MathHelper.abs(i2 - i1)) + (k3 = MathHelper.abs(j2 - j1)) + (l3 = MathHelper.abs(k2 - k1)) >= 17) continue;
                BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int i4 = i2 + enumfacing.getFrontOffsetX();
                    int j4 = j2 + enumfacing.getFrontOffsetY();
                    int k4 = k2 + enumfacing.getFrontOffsetZ();
                    blockpos$pooledmutableblockpos.setPos(i4, j4, k4);
                    int l4 = Math.max(1, this.getBlockState(blockpos$pooledmutableblockpos).getBlock().getLightOpacity(this.getBlockState(blockpos$pooledmutableblockpos), this, blockpos$pooledmutableblockpos));
                    i3 = this.getLightFor(p_checkLightFor_1_, blockpos$pooledmutableblockpos);
                    if (i3 != l2 - l4 || j >= this.lightUpdateBlockList.length) continue;
                    this.lightUpdateBlockList[j++] = i4 - i1 + 32 | j4 - j1 + 32 << 6 | k4 - k1 + 32 << 12 | l2 - l4 << 18;
                }
                blockpos$pooledmutableblockpos.release();
            }
            i = 0;
        }
        this.theProfiler.endSection();
        this.theProfiler.startSection("checkedPosition < toCheckCount");
        while (i < j) {
            boolean flag;
            int i5 = this.lightUpdateBlockList[i++];
            int j5 = (i5 & 0x3F) - 32 + i1;
            int k5 = (i5 >> 6 & 0x3F) - 32 + j1;
            int l5 = (i5 >> 12 & 0x3F) - 32 + k1;
            BlockPos blockpos1 = new BlockPos(j5, k5, l5);
            int i6 = this.getLightFor(p_checkLightFor_1_, blockpos1);
            int j6 = this.getRawLight(blockpos1, p_checkLightFor_1_);
            if (j6 == i6) continue;
            this.setLightFor(p_checkLightFor_1_, blockpos1, j6);
            if (j6 <= i6) continue;
            int k6 = Math.abs(j5 - i1);
            int l6 = Math.abs(k5 - j1);
            int i7 = Math.abs(l5 - k1);
            boolean bl = flag = j < this.lightUpdateBlockList.length - 6;
            if (k6 + l6 + i7 >= 17 || !flag) continue;
            if (this.getLightFor(p_checkLightFor_1_, blockpos1.west()) < j6) {
                this.lightUpdateBlockList[j++] = j5 - 1 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.getLightFor(p_checkLightFor_1_, blockpos1.east()) < j6) {
                this.lightUpdateBlockList[j++] = j5 + 1 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.getLightFor(p_checkLightFor_1_, blockpos1.down()) < j6) {
                this.lightUpdateBlockList[j++] = j5 - i1 + 32 + (k5 - 1 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.getLightFor(p_checkLightFor_1_, blockpos1.up()) < j6) {
                this.lightUpdateBlockList[j++] = j5 - i1 + 32 + (k5 + 1 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.getLightFor(p_checkLightFor_1_, blockpos1.north()) < j6) {
                this.lightUpdateBlockList[j++] = j5 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - 1 - k1 + 32 << 12);
            }
            if (this.getLightFor(p_checkLightFor_1_, blockpos1.south()) >= j6) continue;
            this.lightUpdateBlockList[j++] = j5 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 + 1 - k1 + 32 << 12);
        }
        this.theProfiler.endSection();
        return true;
    }

    public boolean tickUpdates(boolean p_tickUpdates_1_) {
        return false;
    }

    @Nullable
    public List<NextTickListEntry> getPendingBlockUpdates(Chunk p_getPendingBlockUpdates_1_, boolean p_getPendingBlockUpdates_2_) {
        return null;
    }

    @Nullable
    public List<NextTickListEntry> getPendingBlockUpdates(StructureBoundingBox p_getPendingBlockUpdates_1_, boolean p_getPendingBlockUpdates_2_) {
        return null;
    }

    public List<Entity> getEntitiesWithinAABBExcludingEntity(Entity p_getEntitiesWithinAABBExcludingEntity_1_, AxisAlignedBB p_getEntitiesWithinAABBExcludingEntity_2_) {
        return this.getEntitiesInAABBexcluding(p_getEntitiesWithinAABBExcludingEntity_1_, p_getEntitiesWithinAABBExcludingEntity_2_, EntitySelectors.NOT_SPECTATING);
    }

    public List<Entity> getEntitiesInAABBexcluding(Entity p_getEntitiesInAABBexcluding_1_, AxisAlignedBB p_getEntitiesInAABBexcluding_2_, Predicate<? super Entity> p_getEntitiesInAABBexcluding_3_) {
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.floor((p_getEntitiesInAABBexcluding_2_.minX - MAX_ENTITY_RADIUS) / 16.0);
        int j = MathHelper.floor((p_getEntitiesInAABBexcluding_2_.maxX + MAX_ENTITY_RADIUS) / 16.0);
        int k = MathHelper.floor((p_getEntitiesInAABBexcluding_2_.minZ - MAX_ENTITY_RADIUS) / 16.0);
        int l = MathHelper.floor((p_getEntitiesInAABBexcluding_2_.maxZ + MAX_ENTITY_RADIUS) / 16.0);
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.isChunkLoaded(i1, j1, true)) continue;
                this.getChunkFromChunkCoords(i1, j1).getEntitiesWithinAABBForEntity(p_getEntitiesInAABBexcluding_1_, p_getEntitiesInAABBexcluding_2_, list, p_getEntitiesInAABBexcluding_3_);
            }
        }
        return list;
    }

    public <T extends Entity> List<T> getEntities(Class<? extends T> p_getEntities_1_, Predicate<? super T> p_getEntities_2_) {
        ArrayList list = Lists.newArrayList();
        for (Entity entity : this.loadedEntityList) {
            if (!p_getEntities_1_.isAssignableFrom(entity.getClass()) || !p_getEntities_2_.apply((Object)entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public <T extends Entity> List<T> getPlayers(Class<? extends T> p_getPlayers_1_, Predicate<? super T> p_getPlayers_2_) {
        ArrayList list = Lists.newArrayList();
        for (Entity entity : this.playerEntities) {
            if (!p_getPlayers_1_.isAssignableFrom(entity.getClass()) || !p_getPlayers_2_.apply((Object)entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public <T extends Entity> List<T> getEntitiesWithinAABB(Class<? extends T> p_getEntitiesWithinAABB_1_, AxisAlignedBB p_getEntitiesWithinAABB_2_) {
        return this.getEntitiesWithinAABB(p_getEntitiesWithinAABB_1_, p_getEntitiesWithinAABB_2_, EntitySelectors.NOT_SPECTATING);
    }

    public <T extends Entity> List<T> getEntitiesWithinAABB(Class<? extends T> p_getEntitiesWithinAABB_1_, AxisAlignedBB p_getEntitiesWithinAABB_2_, Predicate<? super T> p_getEntitiesWithinAABB_3_) {
        int i = MathHelper.floor((p_getEntitiesWithinAABB_2_.minX - MAX_ENTITY_RADIUS) / 16.0);
        int j = MathHelper.ceil((p_getEntitiesWithinAABB_2_.maxX + MAX_ENTITY_RADIUS) / 16.0);
        int k = MathHelper.floor((p_getEntitiesWithinAABB_2_.minZ - MAX_ENTITY_RADIUS) / 16.0);
        int l = MathHelper.ceil((p_getEntitiesWithinAABB_2_.maxZ + MAX_ENTITY_RADIUS) / 16.0);
        ArrayList list = Lists.newArrayList();
        for (int i1 = i; i1 < j; ++i1) {
            for (int j1 = k; j1 < l; ++j1) {
                if (!this.isChunkLoaded(i1, j1, true)) continue;
                this.getChunkFromChunkCoords(i1, j1).getEntitiesOfTypeWithinAAAB(p_getEntitiesWithinAABB_1_, p_getEntitiesWithinAABB_2_, list, p_getEntitiesWithinAABB_3_);
            }
        }
        return list;
    }

    @Nullable
    public <T extends Entity> T findNearestEntityWithinAABB(Class<? extends T> p_findNearestEntityWithinAABB_1_, AxisAlignedBB p_findNearestEntityWithinAABB_2_, T p_findNearestEntityWithinAABB_3_) {
        List<T> list = this.getEntitiesWithinAABB(p_findNearestEntityWithinAABB_1_, p_findNearestEntityWithinAABB_2_);
        Entity t = null;
        double d0 = Double.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            Entity t1 = (Entity)list.get(i);
            if (t1 == p_findNearestEntityWithinAABB_3_ || !EntitySelectors.NOT_SPECTATING.apply((Object)t1) || !((d1 = p_findNearestEntityWithinAABB_3_.getDistanceSqToEntity(t1)) <= d0)) continue;
            t = t1;
            d0 = d1;
        }
        return (T)t;
    }

    @Nullable
    public Entity getEntityByID(int p_getEntityByID_1_) {
        return this.entitiesById.lookup(p_getEntityByID_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public List<Entity> getLoadedEntityList() {
        return this.loadedEntityList;
    }

    public void markChunkDirty(BlockPos p_markChunkDirty_1_, TileEntity p_markChunkDirty_2_) {
        if (this.isBlockLoaded(p_markChunkDirty_1_)) {
            this.getChunkFromBlockCoords(p_markChunkDirty_1_).setChunkModified();
        }
    }

    public int countEntities(Class<?> p_countEntities_1_) {
        int i = 0;
        for (Entity entity : this.loadedEntityList) {
            if (entity instanceof EntityLiving && ((EntityLiving)entity).isNoDespawnRequired() || !p_countEntities_1_.isAssignableFrom(entity.getClass())) continue;
            ++i;
        }
        return i;
    }

    public void loadEntities(Collection<Entity> p_loadEntities_1_) {
        for (Entity entity : p_loadEntities_1_) {
            if (MinecraftForge.EVENT_BUS.post(new EntityJoinWorldEvent(entity, this))) continue;
            this.loadedEntityList.add(entity);
            this.onEntityAdded(entity);
        }
    }

    public void unloadEntities(Collection<Entity> p_unloadEntities_1_) {
        this.unloadedEntityList.addAll(p_unloadEntities_1_);
    }

    public boolean mayPlace(Block p_mayPlace_1_, BlockPos p_mayPlace_2_, boolean p_mayPlace_3_, EnumFacing p_mayPlace_4_, Entity p_mayPlace_5_) {
        AxisAlignedBB axisalignedbb;
        IBlockState iblockstate = this.getBlockState(p_mayPlace_2_);
        AxisAlignedBB axisAlignedBB = axisalignedbb = p_mayPlace_3_ ? null : p_mayPlace_1_.getDefaultState().getCollisionBoundingBox(this, p_mayPlace_2_);
        return axisalignedbb != Block.NULL_AABB && !this.checkNoEntityCollision(axisalignedbb.offset(p_mayPlace_2_), p_mayPlace_5_) ? false : (iblockstate.getMaterial() == Material.CIRCUITS && p_mayPlace_1_ == Blocks.ANVIL ? true : iblockstate.getBlock().isReplaceable(this, p_mayPlace_2_) && p_mayPlace_1_.canPlaceBlockOnSide(this, p_mayPlace_2_, p_mayPlace_4_));
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public void setSeaLevel(int p_setSeaLevel_1_) {
        this.seaLevel = p_setSeaLevel_1_;
    }

    @Override
    public int getStrongPower(BlockPos p_getStrongPower_1_, EnumFacing p_getStrongPower_2_) {
        return this.getBlockState(p_getStrongPower_1_).getStrongPower(this, p_getStrongPower_1_, p_getStrongPower_2_);
    }

    @Override
    public WorldType getWorldType() {
        return this.worldInfo.getTerrainType();
    }

    public int getStrongPower(BlockPos p_getStrongPower_1_) {
        int i = 0;
        if ((i = Math.max(i, this.getStrongPower(p_getStrongPower_1_.down(), EnumFacing.DOWN))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getStrongPower(p_getStrongPower_1_.up(), EnumFacing.UP))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getStrongPower(p_getStrongPower_1_.north(), EnumFacing.NORTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getStrongPower(p_getStrongPower_1_.south(), EnumFacing.SOUTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getStrongPower(p_getStrongPower_1_.west(), EnumFacing.WEST))) >= 15) {
            return i;
        }
        return (i = Math.max(i, this.getStrongPower(p_getStrongPower_1_.east(), EnumFacing.EAST))) >= 15 ? i : i;
    }

    public boolean isSidePowered(BlockPos p_isSidePowered_1_, EnumFacing p_isSidePowered_2_) {
        return this.getRedstonePower(p_isSidePowered_1_, p_isSidePowered_2_) > 0;
    }

    public int getRedstonePower(BlockPos p_getRedstonePower_1_, EnumFacing p_getRedstonePower_2_) {
        IBlockState iblockstate = this.getBlockState(p_getRedstonePower_1_);
        return iblockstate.getBlock().shouldCheckWeakPower(iblockstate, this, p_getRedstonePower_1_, p_getRedstonePower_2_) ? this.getStrongPower(p_getRedstonePower_1_) : iblockstate.getWeakPower(this, p_getRedstonePower_1_, p_getRedstonePower_2_);
    }

    public boolean isBlockPowered(BlockPos p_isBlockPowered_1_) {
        return this.getRedstonePower(p_isBlockPowered_1_.down(), EnumFacing.DOWN) > 0 ? true : (this.getRedstonePower(p_isBlockPowered_1_.up(), EnumFacing.UP) > 0 ? true : (this.getRedstonePower(p_isBlockPowered_1_.north(), EnumFacing.NORTH) > 0 ? true : (this.getRedstonePower(p_isBlockPowered_1_.south(), EnumFacing.SOUTH) > 0 ? true : (this.getRedstonePower(p_isBlockPowered_1_.west(), EnumFacing.WEST) > 0 ? true : this.getRedstonePower(p_isBlockPowered_1_.east(), EnumFacing.EAST) > 0))));
    }

    public int isBlockIndirectlyGettingPowered(BlockPos p_isBlockIndirectlyGettingPowered_1_) {
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            int j = this.getRedstonePower(p_isBlockIndirectlyGettingPowered_1_.offset(enumfacing), enumfacing);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    @Nullable
    public EntityPlayer getClosestPlayerToEntity(Entity p_getClosestPlayerToEntity_1_, double p_getClosestPlayerToEntity_2_) {
        return this.getClosestPlayer(p_getClosestPlayerToEntity_1_.posX, p_getClosestPlayerToEntity_1_.posY, p_getClosestPlayerToEntity_1_.posZ, p_getClosestPlayerToEntity_2_, false);
    }

    @Nullable
    public EntityPlayer getNearestPlayerNotCreative(Entity p_getNearestPlayerNotCreative_1_, double p_getNearestPlayerNotCreative_2_) {
        return this.getClosestPlayer(p_getNearestPlayerNotCreative_1_.posX, p_getNearestPlayerNotCreative_1_.posY, p_getNearestPlayerNotCreative_1_.posZ, p_getNearestPlayerNotCreative_2_, true);
    }

    @Nullable
    public EntityPlayer getClosestPlayer(double p_getClosestPlayer_1_, double p_getClosestPlayer_3_, double p_getClosestPlayer_5_, double p_getClosestPlayer_7_, boolean p_getClosestPlayer_9_) {
        Predicate<Entity> predicate = p_getClosestPlayer_9_ ? EntitySelectors.CAN_AI_TARGET : EntitySelectors.NOT_SPECTATING;
        return this.getClosestPlayer(p_getClosestPlayer_1_, p_getClosestPlayer_3_, p_getClosestPlayer_5_, p_getClosestPlayer_7_, predicate);
    }

    @Nullable
    public EntityPlayer getClosestPlayer(double p_getClosestPlayer_1_, double p_getClosestPlayer_3_, double p_getClosestPlayer_5_, double p_getClosestPlayer_7_, Predicate<Entity> p_getClosestPlayer_9_) {
        double d0 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            EntityPlayer entityplayer1 = this.playerEntities.get(i);
            if (!p_getClosestPlayer_9_.apply((Object)entityplayer1)) continue;
            double d1 = entityplayer1.getDistanceSq(p_getClosestPlayer_1_, p_getClosestPlayer_3_, p_getClosestPlayer_5_);
            if (!(p_getClosestPlayer_7_ < 0.0) && !(d1 < p_getClosestPlayer_7_ * p_getClosestPlayer_7_) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public boolean isAnyPlayerWithinRangeAt(double p_isAnyPlayerWithinRangeAt_1_, double p_isAnyPlayerWithinRangeAt_3_, double p_isAnyPlayerWithinRangeAt_5_, double p_isAnyPlayerWithinRangeAt_7_) {
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            EntityPlayer entityplayer = this.playerEntities.get(i);
            if (!EntitySelectors.NOT_SPECTATING.apply((Object)entityplayer)) continue;
            double d0 = entityplayer.getDistanceSq(p_isAnyPlayerWithinRangeAt_1_, p_isAnyPlayerWithinRangeAt_3_, p_isAnyPlayerWithinRangeAt_5_);
            if (!(p_isAnyPlayerWithinRangeAt_7_ < 0.0) && !(d0 < p_isAnyPlayerWithinRangeAt_7_ * p_isAnyPlayerWithinRangeAt_7_)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public EntityPlayer getNearestAttackablePlayer(Entity p_getNearestAttackablePlayer_1_, double p_getNearestAttackablePlayer_2_, double p_getNearestAttackablePlayer_4_) {
        return this.getNearestAttackablePlayer(p_getNearestAttackablePlayer_1_.posX, p_getNearestAttackablePlayer_1_.posY, p_getNearestAttackablePlayer_1_.posZ, p_getNearestAttackablePlayer_2_, p_getNearestAttackablePlayer_4_, (Function<EntityPlayer, Double>)((Function)null), (Predicate<EntityPlayer>)((Predicate)null));
    }

    @Nullable
    public EntityPlayer getNearestAttackablePlayer(BlockPos p_getNearestAttackablePlayer_1_, double p_getNearestAttackablePlayer_2_, double p_getNearestAttackablePlayer_4_) {
        return this.getNearestAttackablePlayer((float)p_getNearestAttackablePlayer_1_.getX() + 0.5f, (float)p_getNearestAttackablePlayer_1_.getY() + 0.5f, (float)p_getNearestAttackablePlayer_1_.getZ() + 0.5f, p_getNearestAttackablePlayer_2_, p_getNearestAttackablePlayer_4_, (Function<EntityPlayer, Double>)((Function)null), (Predicate<EntityPlayer>)((Predicate)null));
    }

    @Nullable
    public EntityPlayer getNearestAttackablePlayer(double p_getNearestAttackablePlayer_1_, double p_getNearestAttackablePlayer_3_, double p_getNearestAttackablePlayer_5_, double p_getNearestAttackablePlayer_7_, double p_getNearestAttackablePlayer_9_, Function<EntityPlayer, Double> p_getNearestAttackablePlayer_11_, Predicate<EntityPlayer> p_getNearestAttackablePlayer_12_) {
        double d0 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            EntityPlayer entityplayer1 = this.playerEntities.get(i);
            if (entityplayer1.capabilities.disableDamage || !entityplayer1.isEntityAlive() || entityplayer1.isSpectator() || p_getNearestAttackablePlayer_12_ != null && !p_getNearestAttackablePlayer_12_.apply((Object)entityplayer1)) continue;
            double d1 = entityplayer1.getDistanceSq(p_getNearestAttackablePlayer_1_, entityplayer1.posY, p_getNearestAttackablePlayer_5_);
            double d2 = p_getNearestAttackablePlayer_7_;
            if (entityplayer1.isSneaking()) {
                d2 = p_getNearestAttackablePlayer_7_ * (double)0.8f;
            }
            if (entityplayer1.isInvisible()) {
                float f = entityplayer1.getArmorVisibility();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d2 *= (double)(0.7f * f);
            }
            if (p_getNearestAttackablePlayer_11_ != null) {
                d2 *= ((Double)Objects.firstNonNull((Object)p_getNearestAttackablePlayer_11_.apply((Object)entityplayer1), (Object)1.0)).doubleValue();
            }
            d2 = ForgeHooks.getPlayerVisibilityDistance(entityplayer1, d2, p_getNearestAttackablePlayer_9_);
            if (!(p_getNearestAttackablePlayer_9_ < 0.0) && !(Math.abs(entityplayer1.posY - p_getNearestAttackablePlayer_3_) < p_getNearestAttackablePlayer_9_ * p_getNearestAttackablePlayer_9_) || !(p_getNearestAttackablePlayer_7_ < 0.0) && !(d1 < d2 * d2) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    @Nullable
    public EntityPlayer getPlayerEntityByName(String p_getPlayerEntityByName_1_) {
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            EntityPlayer entityplayer = this.playerEntities.get(i);
            if (!p_getPlayerEntityByName_1_.equals(entityplayer.getName())) continue;
            return entityplayer;
        }
        return null;
    }

    @Nullable
    public EntityPlayer getPlayerEntityByUUID(UUID p_getPlayerEntityByUUID_1_) {
        for (int i = 0; i < this.playerEntities.size(); ++i) {
            EntityPlayer entityplayer = this.playerEntities.get(i);
            if (!p_getPlayerEntityByUUID_1_.equals(entityplayer.getUniqueID())) continue;
            return entityplayer;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void sendQuittingDisconnectingPacket() {
    }

    public void checkSessionLock() throws MinecraftException {
        this.saveHandler.checkSessionLock();
    }

    @SideOnly(value=Side.CLIENT)
    public void setTotalWorldTime(long p_setTotalWorldTime_1_) {
        this.worldInfo.setWorldTotalTime(p_setTotalWorldTime_1_);
    }

    public long getSeed() {
        return this.provider.getSeed();
    }

    public long getTotalWorldTime() {
        return this.worldInfo.getWorldTotalTime();
    }

    public long getWorldTime() {
        return this.provider.getWorldTime();
    }

    public void setWorldTime(long p_setWorldTime_1_) {
        this.provider.setWorldTime(p_setWorldTime_1_);
    }

    public BlockPos getSpawnPoint() {
        BlockPos blockpos = this.provider.getSpawnPoint();
        if (!this.getWorldBorder().contains(blockpos)) {
            blockpos = this.getHeight(new BlockPos(this.getWorldBorder().getCenterX(), 0.0, this.getWorldBorder().getCenterZ()));
        }
        return blockpos;
    }

    public void setSpawnPoint(BlockPos p_setSpawnPoint_1_) {
        this.provider.setSpawnPoint(p_setSpawnPoint_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public void joinEntityInSurroundings(Entity p_joinEntityInSurroundings_1_) {
        int i = MathHelper.floor(p_joinEntityInSurroundings_1_.posX / 16.0);
        int j = MathHelper.floor(p_joinEntityInSurroundings_1_.posZ / 16.0);
        int k = 2;
        for (int l = -2; l <= 2; ++l) {
            for (int i1 = -2; i1 <= 2; ++i1) {
                this.getChunkFromChunkCoords(i + l, j + i1);
            }
        }
        if (!this.loadedEntityList.contains(p_joinEntityInSurroundings_1_) && !MinecraftForge.EVENT_BUS.post(new EntityJoinWorldEvent(p_joinEntityInSurroundings_1_, this))) {
            this.loadedEntityList.add(p_joinEntityInSurroundings_1_);
        }
    }

    public boolean isBlockModifiable(EntityPlayer p_isBlockModifiable_1_, BlockPos p_isBlockModifiable_2_) {
        return this.provider.canMineBlock(p_isBlockModifiable_1_, p_isBlockModifiable_2_);
    }

    public boolean canMineBlockBody(EntityPlayer p_canMineBlockBody_1_, BlockPos p_canMineBlockBody_2_) {
        return true;
    }

    public void setEntityState(Entity p_setEntityState_1_, byte p_setEntityState_2_) {
    }

    public IChunkProvider getChunkProvider() {
        return this.chunkProvider;
    }

    public void addBlockEvent(BlockPos p_addBlockEvent_1_, Block p_addBlockEvent_2_, int p_addBlockEvent_3_, int p_addBlockEvent_4_) {
        this.getBlockState(p_addBlockEvent_1_).onBlockEventReceived(this, p_addBlockEvent_1_, p_addBlockEvent_3_, p_addBlockEvent_4_);
    }

    public ISaveHandler getSaveHandler() {
        return this.saveHandler;
    }

    public WorldInfo getWorldInfo() {
        return this.worldInfo;
    }

    public GameRules getGameRules() {
        return this.worldInfo.getGameRulesInstance();
    }

    public void updateAllPlayersSleepingFlag() {
    }

    public float getThunderStrength(float p_getThunderStrength_1_) {
        return (this.prevThunderingStrength + (this.thunderingStrength - this.prevThunderingStrength) * p_getThunderStrength_1_) * this.getRainStrength(p_getThunderStrength_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public void setThunderStrength(float p_setThunderStrength_1_) {
        this.prevThunderingStrength = p_setThunderStrength_1_;
        this.thunderingStrength = p_setThunderStrength_1_;
    }

    public float getRainStrength(float p_getRainStrength_1_) {
        return this.prevRainingStrength + (this.rainingStrength - this.prevRainingStrength) * p_getRainStrength_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRainStrength(float p_setRainStrength_1_) {
        this.prevRainingStrength = p_setRainStrength_1_;
        this.rainingStrength = p_setRainStrength_1_;
    }

    public boolean isThundering() {
        return (double)this.getThunderStrength(1.0f) > 0.9;
    }

    public boolean isRaining() {
        return (double)this.getRainStrength(1.0f) > 0.2;
    }

    public boolean isRainingAt(BlockPos p_isRainingAt_1_) {
        if (!this.isRaining()) {
            return false;
        }
        if (!this.canSeeSky(p_isRainingAt_1_)) {
            return false;
        }
        if (this.getPrecipitationHeight(p_isRainingAt_1_).getY() > p_isRainingAt_1_.getY()) {
            return false;
        }
        Biome biome = this.getBiome(p_isRainingAt_1_);
        return biome.getEnableSnow() ? false : (this.canSnowAt(p_isRainingAt_1_, false) ? false : biome.canRain());
    }

    public boolean isBlockinHighHumidity(BlockPos p_isBlockinHighHumidity_1_) {
        return this.provider.isBlockHighHumidity(p_isBlockinHighHumidity_1_);
    }

    @Nullable
    public MapStorage getMapStorage() {
        return this.mapStorage;
    }

    public void setData(String p_setData_1_, WorldSavedData p_setData_2_) {
        this.mapStorage.setData(p_setData_1_, p_setData_2_);
    }

    @Nullable
    public WorldSavedData loadData(Class<? extends WorldSavedData> p_loadData_1_, String p_loadData_2_) {
        return this.mapStorage.getOrLoadData(p_loadData_1_, p_loadData_2_);
    }

    public int getUniqueDataId(String p_getUniqueDataId_1_) {
        return this.mapStorage.getUniqueDataId(p_getUniqueDataId_1_);
    }

    public void playBroadcastSound(int p_playBroadcastSound_1_, BlockPos p_playBroadcastSound_2_, int p_playBroadcastSound_3_) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            this.eventListeners.get(i).broadcastSound(p_playBroadcastSound_1_, p_playBroadcastSound_2_, p_playBroadcastSound_3_);
        }
    }

    public void playEvent(int p_playEvent_1_, BlockPos p_playEvent_2_, int p_playEvent_3_) {
        this.playEvent(null, p_playEvent_1_, p_playEvent_2_, p_playEvent_3_);
    }

    public void playEvent(EntityPlayer p_playEvent_1_, int p_playEvent_2_, BlockPos p_playEvent_3_, int p_playEvent_4_) {
        try {
            for (int i = 0; i < this.eventListeners.size(); ++i) {
                this.eventListeners.get(i).playEvent(p_playEvent_1_, p_playEvent_2_, p_playEvent_3_, p_playEvent_4_);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Playing level event");
            CrashReportCategory crashreportcategory = crashreport.makeCategory("Level event being played");
            crashreportcategory.addCrashSection("Block coordinates", CrashReportCategory.getCoordinateInfo(p_playEvent_3_));
            crashreportcategory.addCrashSection("Event source", p_playEvent_1_);
            crashreportcategory.addCrashSection("Event type", p_playEvent_2_);
            crashreportcategory.addCrashSection("Event data", p_playEvent_4_);
            throw new ReportedException(crashreport);
        }
    }

    public int getHeight() {
        return this.provider.getHeight();
    }

    public int getActualHeight() {
        return this.provider.getActualHeight();
    }

    public Random setRandomSeed(int p_setRandomSeed_1_, int p_setRandomSeed_2_, int p_setRandomSeed_3_) {
        long i = (long)p_setRandomSeed_1_ * 341873128712L + (long)p_setRandomSeed_2_ * 132897987541L + this.getWorldInfo().getSeed() + (long)p_setRandomSeed_3_;
        this.rand.setSeed(i);
        return this.rand;
    }

    public CrashReportCategory addWorldInfoToCrashReport(CrashReport p_addWorldInfoToCrashReport_1_) {
        CrashReportCategory crashreportcategory = p_addWorldInfoToCrashReport_1_.makeCategoryDepth("Affected level", 1);
        crashreportcategory.addCrashSection("Level name", this.worldInfo == null ? "????" : this.worldInfo.getWorldName());
        crashreportcategory.setDetail("All players", new ICrashReportDetail<String>(){

            @Override
            public String call() {
                return World.this.playerEntities.size() + " total; " + World.this.playerEntities;
            }
        });
        crashreportcategory.setDetail("Chunk stats", new ICrashReportDetail<String>(){

            @Override
            public String call() {
                return World.this.chunkProvider.makeString();
            }
        });
        try {
            this.worldInfo.addToCrashReport(crashreportcategory);
        }
        catch (Throwable throwable) {
            crashreportcategory.addCrashSectionThrowable("Level Data Unobtainable", throwable);
        }
        return crashreportcategory;
    }

    @SideOnly(value=Side.CLIENT)
    public double getHorizon() {
        return this.provider.getHorizon();
    }

    public void sendBlockBreakProgress(int p_sendBlockBreakProgress_1_, BlockPos p_sendBlockBreakProgress_2_, int p_sendBlockBreakProgress_3_) {
        for (int i = 0; i < this.eventListeners.size(); ++i) {
            IWorldEventListener iworldeventlistener = this.eventListeners.get(i);
            iworldeventlistener.sendBlockBreakProgress(p_sendBlockBreakProgress_1_, p_sendBlockBreakProgress_2_, p_sendBlockBreakProgress_3_);
        }
    }

    public Calendar getCurrentDate() {
        if (this.getTotalWorldTime() % 600L == 0L) {
            this.theCalendar.setTimeInMillis(MinecraftServer.getCurrentTimeMillis());
        }
        return this.theCalendar;
    }

    @SideOnly(value=Side.CLIENT)
    public void makeFireworks(double p_makeFireworks_1_, double p_makeFireworks_3_, double p_makeFireworks_5_, double p_makeFireworks_7_, double p_makeFireworks_9_, double p_makeFireworks_11_, NBTTagCompound p_makeFireworks_13_) {
    }

    public Scoreboard getScoreboard() {
        return this.worldScoreboard;
    }

    public void updateComparatorOutputLevel(BlockPos p_updateComparatorOutputLevel_1_, Block p_updateComparatorOutputLevel_2_) {
        for (EnumFacing enumfacing : EnumFacing.VALUES) {
            BlockPos blockpos = p_updateComparatorOutputLevel_1_.offset(enumfacing);
            if (!this.isBlockLoaded(blockpos)) continue;
            IBlockState iblockstate = this.getBlockState(blockpos);
            iblockstate.getBlock().onNeighborChange(this, blockpos, p_updateComparatorOutputLevel_1_);
            if (!iblockstate.getBlock().isNormalCube(iblockstate, this, blockpos) || !(iblockstate = this.getBlockState(blockpos = blockpos.offset(enumfacing))).getBlock().getWeakChanges(this, blockpos)) continue;
            iblockstate.getBlock().onNeighborChange(this, blockpos, p_updateComparatorOutputLevel_1_);
        }
    }

    public DifficultyInstance getDifficultyForLocation(BlockPos p_getDifficultyForLocation_1_) {
        long i = 0L;
        float f = 0.0f;
        if (this.isBlockLoaded(p_getDifficultyForLocation_1_)) {
            f = this.getCurrentMoonPhaseFactor();
            i = this.getChunkFromBlockCoords(p_getDifficultyForLocation_1_).getInhabitedTime();
        }
        return new DifficultyInstance(this.getDifficulty(), this.getWorldTime(), i, f);
    }

    public EnumDifficulty getDifficulty() {
        return this.getWorldInfo().getDifficulty();
    }

    public int getSkylightSubtracted() {
        return this.skylightSubtracted;
    }

    public void setSkylightSubtracted(int p_setSkylightSubtracted_1_) {
        this.skylightSubtracted = p_setSkylightSubtracted_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLastLightningBolt() {
        return this.lastLightningBolt;
    }

    public void setLastLightningBolt(int p_setLastLightningBolt_1_) {
        this.lastLightningBolt = p_setLastLightningBolt_1_;
    }

    public VillageCollection getVillageCollection() {
        return this.villageCollectionObj;
    }

    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public boolean isSpawnChunk(int p_isSpawnChunk_1_, int p_isSpawnChunk_2_) {
        BlockPos blockpos = this.getSpawnPoint();
        int i = p_isSpawnChunk_1_ * 16 + 8 - blockpos.getX();
        int j = p_isSpawnChunk_2_ * 16 + 8 - blockpos.getZ();
        int k = 128;
        return i >= -128 && i <= 128 && j >= -128 && j <= 128;
    }

    public boolean isSideSolid(BlockPos p_isSideSolid_1_, EnumFacing p_isSideSolid_2_) {
        return this.isSideSolid(p_isSideSolid_1_, p_isSideSolid_2_, false);
    }

    @Override
    public boolean isSideSolid(BlockPos p_isSideSolid_1_, EnumFacing p_isSideSolid_2_, boolean p_isSideSolid_3_) {
        if (!this.isValid(p_isSideSolid_1_)) {
            return p_isSideSolid_3_;
        }
        Chunk chunk = this.getChunkFromBlockCoords(p_isSideSolid_1_);
        if (chunk == null || chunk.isEmpty()) {
            return p_isSideSolid_3_;
        }
        return this.getBlockState(p_isSideSolid_1_).isSideSolid(this, p_isSideSolid_1_, p_isSideSolid_2_);
    }

    public ImmutableSetMultimap<ChunkPos, ForgeChunkManager.Ticket> getPersistentChunks() {
        return ForgeChunkManager.getPersistentChunksFor(this);
    }

    public Iterator<Chunk> getPersistentChunkIterable(Iterator<Chunk> p_getPersistentChunkIterable_1_) {
        return ForgeChunkManager.getPersistentChunksIterableFor(this, p_getPersistentChunkIterable_1_);
    }

    public int getBlockLightOpacity(BlockPos p_getBlockLightOpacity_1_) {
        if (!this.isValid(p_getBlockLightOpacity_1_)) {
            return 0;
        }
        return this.getChunkFromBlockCoords(p_getBlockLightOpacity_1_).getBlockLightOpacity(p_getBlockLightOpacity_1_);
    }

    public int countEntities(EnumCreatureType p_countEntities_1_, boolean p_countEntities_2_) {
        int count = 0;
        for (int x = 0; x < this.loadedEntityList.size(); ++x) {
            if (!this.loadedEntityList.get(x).isCreatureType(p_countEntities_1_, p_countEntities_2_)) continue;
            ++count;
        }
        return count;
    }

    protected void initCapabilities() {
        ICapabilityProvider parent = this.provider.initCapabilities();
        this.capabilities = ForgeEventFactory.gatherCapabilities(this, parent);
        WorldCapabilityData data = (WorldCapabilityData)this.perWorldStorage.getOrLoadData(WorldCapabilityData.class, "capabilities");
        if (data == null) {
            this.capabilityData = new WorldCapabilityData(this.capabilities);
            this.perWorldStorage.setData(this.capabilityData.mapName, this.capabilityData);
        } else {
            this.capabilityData = data;
            this.capabilityData.setCapabilities(this.provider, this.capabilities);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> p_hasCapability_1_, EnumFacing p_hasCapability_2_) {
        return this.capabilities == null ? false : this.capabilities.hasCapability(p_hasCapability_1_, p_hasCapability_2_);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> p_getCapability_1_, EnumFacing p_getCapability_2_) {
        return this.capabilities == null ? null : (T)this.capabilities.getCapability(p_getCapability_1_, p_getCapability_2_);
    }

    public MapStorage getPerWorldStorage() {
        return this.perWorldStorage;
    }

    public void sendPacketToServer(Packet<?> p_sendPacketToServer_1_) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    public LootTableManager getLootTableManager() {
        return this.lootTable;
    }

    @Nullable
    public BlockPos findNearestStructure(String p_findNearestStructure_1_, BlockPos p_findNearestStructure_2_, boolean p_findNearestStructure_3_) {
        return null;
    }
}

