/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class WorldEntitySpawner {
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    private final Set<ChunkPos> eligibleChunksForSpawning = Sets.newHashSet();

    public int findChunksForSpawning(WorldServer p_findChunksForSpawning_1_, boolean p_findChunksForSpawning_2_, boolean p_findChunksForSpawning_3_, boolean p_findChunksForSpawning_4_) {
        if (!p_findChunksForSpawning_2_ && !p_findChunksForSpawning_3_) {
            return 0;
        }
        this.eligibleChunksForSpawning.clear();
        int i = 0;
        for (EntityPlayer entityplayer : p_findChunksForSpawning_1_.playerEntities) {
            if (entityplayer.isSpectator()) continue;
            int j = MathHelper.floor(entityplayer.posX / 16.0);
            int k = MathHelper.floor(entityplayer.posZ / 16.0);
            int l = 8;
            for (int i1 = -8; i1 <= 8; ++i1) {
                for (int j1 = -8; j1 <= 8; ++j1) {
                    PlayerChunkMapEntry playerchunkmapentry;
                    boolean flag = i1 == -8 || i1 == 8 || j1 == -8 || j1 == 8;
                    ChunkPos chunkpos = new ChunkPos(i1 + j, j1 + k);
                    if (this.eligibleChunksForSpawning.contains(chunkpos)) continue;
                    ++i;
                    if (flag || !p_findChunksForSpawning_1_.getWorldBorder().contains(chunkpos) || (playerchunkmapentry = p_findChunksForSpawning_1_.getPlayerChunkMap().getEntry(chunkpos.chunkXPos, chunkpos.chunkZPos)) == null || !playerchunkmapentry.isSentToPlayers()) continue;
                    this.eligibleChunksForSpawning.add(chunkpos);
                }
            }
        }
        int j4 = 0;
        BlockPos blockpos1 = p_findChunksForSpawning_1_.getSpawnPoint();
        for (EnumCreatureType enumcreaturetype : EnumCreatureType.values()) {
            int l4;
            int k4;
            if (enumcreaturetype.getPeacefulCreature() && !p_findChunksForSpawning_3_ || !enumcreaturetype.getPeacefulCreature() && !p_findChunksForSpawning_2_ || enumcreaturetype.getAnimal() && !p_findChunksForSpawning_4_ || (k4 = p_findChunksForSpawning_1_.countEntities(enumcreaturetype, true)) > (l4 = enumcreaturetype.getMaxNumberOfCreature() * i / MOB_COUNT_DIV)) continue;
            ArrayList shuffled = Lists.newArrayList(this.eligibleChunksForSpawning);
            Collections.shuffle(shuffled);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            block6: for (ChunkPos chunkpos1 : shuffled) {
                BlockPos blockpos = WorldEntitySpawner.getRandomChunkPosition(p_findChunksForSpawning_1_, chunkpos1.chunkXPos, chunkpos1.chunkZPos);
                int k1 = blockpos.getX();
                int l1 = blockpos.getY();
                int i2 = blockpos.getZ();
                IBlockState iblockstate = p_findChunksForSpawning_1_.getBlockState(blockpos);
                if (iblockstate.isNormalCube()) continue;
                int j2 = 0;
                block7: for (int k2 = 0; k2 < 3; ++k2) {
                    int l2 = k1;
                    int i3 = l1;
                    int j3 = i2;
                    int k3 = 6;
                    Biome.SpawnListEntry biome$spawnlistentry = null;
                    IEntityLivingData ientitylivingdata = null;
                    int l3 = MathHelper.ceil(Math.random() * 4.0);
                    for (int i4 = 0; i4 < l3; ++i4) {
                        EntityLiving entityliving;
                        blockpos$mutableblockpos.setPos(l2 += p_findChunksForSpawning_1_.rand.nextInt(6) - p_findChunksForSpawning_1_.rand.nextInt(6), i3 += p_findChunksForSpawning_1_.rand.nextInt(1) - p_findChunksForSpawning_1_.rand.nextInt(1), j3 += p_findChunksForSpawning_1_.rand.nextInt(6) - p_findChunksForSpawning_1_.rand.nextInt(6));
                        float f = (float)l2 + 0.5f;
                        float f1 = (float)j3 + 0.5f;
                        if (p_findChunksForSpawning_1_.isAnyPlayerWithinRangeAt(f, i3, f1, 24.0) || !(blockpos1.distanceSq(f, i3, f1) >= 576.0)) continue;
                        if (biome$spawnlistentry == null && (biome$spawnlistentry = p_findChunksForSpawning_1_.getSpawnListEntryForTypeAt(enumcreaturetype, blockpos$mutableblockpos)) == null) continue block7;
                        if (!p_findChunksForSpawning_1_.canCreatureTypeSpawnHere(enumcreaturetype, biome$spawnlistentry, blockpos$mutableblockpos) || !WorldEntitySpawner.canCreatureTypeSpawnAtLocation(EntitySpawnPlacementRegistry.getPlacementForEntity(biome$spawnlistentry.entityClass), p_findChunksForSpawning_1_, blockpos$mutableblockpos)) continue;
                        try {
                            entityliving = biome$spawnlistentry.newInstance(p_findChunksForSpawning_1_);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return j4;
                        }
                        entityliving.setLocationAndAngles(f, i3, f1, p_findChunksForSpawning_1_.rand.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn(entityliving, p_findChunksForSpawning_1_, f, i3, f1);
                        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityliving.getCanSpawnHere() && entityliving.isNotColliding()) {
                            if (!ForgeEventFactory.doSpecialSpawn(entityliving, p_findChunksForSpawning_1_, f, i3, f1)) {
                                ientitylivingdata = entityliving.onInitialSpawn(p_findChunksForSpawning_1_.getDifficultyForLocation(new BlockPos(entityliving)), ientitylivingdata);
                            }
                            if (entityliving.isNotColliding()) {
                                ++j2;
                                p_findChunksForSpawning_1_.spawnEntity(entityliving);
                            } else {
                                entityliving.setDead();
                            }
                            if (j2 >= ForgeEventFactory.getMaxSpawnPackSize(entityliving)) continue block6;
                        }
                        j4 += j2;
                    }
                }
            }
        }
        return j4;
    }

    private static BlockPos getRandomChunkPosition(World p_getRandomChunkPosition_0_, int p_getRandomChunkPosition_1_, int p_getRandomChunkPosition_2_) {
        Chunk chunk = p_getRandomChunkPosition_0_.getChunkFromChunkCoords(p_getRandomChunkPosition_1_, p_getRandomChunkPosition_2_);
        int i = p_getRandomChunkPosition_1_ * 16 + p_getRandomChunkPosition_0_.rand.nextInt(16);
        int j = p_getRandomChunkPosition_2_ * 16 + p_getRandomChunkPosition_0_.rand.nextInt(16);
        int k = MathHelper.roundUp(chunk.getHeight(new BlockPos(i, 0, j)) + 1, 16);
        int l = p_getRandomChunkPosition_0_.rand.nextInt(k > 0 ? k : chunk.getTopFilledSegment() + 16 - 1);
        return new BlockPos(i, l, j);
    }

    public static boolean isValidEmptySpawnBlock(IBlockState p_isValidEmptySpawnBlock_0_) {
        return p_isValidEmptySpawnBlock_0_.isBlockNormalCube() ? false : (p_isValidEmptySpawnBlock_0_.canProvidePower() ? false : (p_isValidEmptySpawnBlock_0_.getMaterial().isLiquid() ? false : !BlockRailBase.isRailBlock(p_isValidEmptySpawnBlock_0_)));
    }

    public static boolean canCreatureTypeSpawnAtLocation(EntityLiving.SpawnPlacementType p_canCreatureTypeSpawnAtLocation_0_, World p_canCreatureTypeSpawnAtLocation_1_, BlockPos p_canCreatureTypeSpawnAtLocation_2_) {
        if (!p_canCreatureTypeSpawnAtLocation_1_.getWorldBorder().contains(p_canCreatureTypeSpawnAtLocation_2_)) {
            return false;
        }
        IBlockState iblockstate = p_canCreatureTypeSpawnAtLocation_1_.getBlockState(p_canCreatureTypeSpawnAtLocation_2_);
        if (p_canCreatureTypeSpawnAtLocation_0_ == EntityLiving.SpawnPlacementType.IN_WATER) {
            return iblockstate.getMaterial() == Material.WATER && p_canCreatureTypeSpawnAtLocation_1_.getBlockState(p_canCreatureTypeSpawnAtLocation_2_.down()).getMaterial() == Material.WATER && !p_canCreatureTypeSpawnAtLocation_1_.getBlockState(p_canCreatureTypeSpawnAtLocation_2_.up()).isNormalCube();
        }
        BlockPos blockpos = p_canCreatureTypeSpawnAtLocation_2_.down();
        IBlockState state = p_canCreatureTypeSpawnAtLocation_1_.getBlockState(blockpos);
        if (!state.getBlock().canCreatureSpawn(state, p_canCreatureTypeSpawnAtLocation_1_, blockpos, p_canCreatureTypeSpawnAtLocation_0_)) {
            return false;
        }
        Block block = p_canCreatureTypeSpawnAtLocation_1_.getBlockState(blockpos).getBlock();
        boolean flag = block != Blocks.BEDROCK && block != Blocks.BARRIER;
        return flag && WorldEntitySpawner.isValidEmptySpawnBlock(iblockstate) && WorldEntitySpawner.isValidEmptySpawnBlock(p_canCreatureTypeSpawnAtLocation_1_.getBlockState(p_canCreatureTypeSpawnAtLocation_2_.up()));
    }

    public static void performWorldGenSpawning(World p_performWorldGenSpawning_0_, Biome p_performWorldGenSpawning_1_, int p_performWorldGenSpawning_2_, int p_performWorldGenSpawning_3_, int p_performWorldGenSpawning_4_, int p_performWorldGenSpawning_5_, Random p_performWorldGenSpawning_6_) {
        List<Biome.SpawnListEntry> list = p_performWorldGenSpawning_1_.getSpawnableList(EnumCreatureType.CREATURE);
        if (!list.isEmpty()) {
            while (p_performWorldGenSpawning_6_.nextFloat() < p_performWorldGenSpawning_1_.getSpawningChance()) {
                Biome.SpawnListEntry biome$spawnlistentry = WeightedRandom.getRandomItem(p_performWorldGenSpawning_0_.rand, list);
                int i = biome$spawnlistentry.minGroupCount + p_performWorldGenSpawning_6_.nextInt(1 + biome$spawnlistentry.maxGroupCount - biome$spawnlistentry.minGroupCount);
                IEntityLivingData ientitylivingdata = null;
                int j = p_performWorldGenSpawning_2_ + p_performWorldGenSpawning_6_.nextInt(p_performWorldGenSpawning_4_);
                int k = p_performWorldGenSpawning_3_ + p_performWorldGenSpawning_6_.nextInt(p_performWorldGenSpawning_5_);
                int l = j;
                int i1 = k;
                for (int j1 = 0; j1 < i; ++j1) {
                    boolean flag = false;
                    for (int k1 = 0; !flag && k1 < 4; ++k1) {
                        BlockPos blockpos = p_performWorldGenSpawning_0_.getTopSolidOrLiquidBlock(new BlockPos(j, 0, k));
                        if (WorldEntitySpawner.canCreatureTypeSpawnAtLocation(EntityLiving.SpawnPlacementType.ON_GROUND, p_performWorldGenSpawning_0_, blockpos)) {
                            EntityLiving entityliving;
                            try {
                                entityliving = biome$spawnlistentry.newInstance(p_performWorldGenSpawning_0_);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                continue;
                            }
                            entityliving.setLocationAndAngles((float)j + 0.5f, blockpos.getY(), (float)k + 0.5f, p_performWorldGenSpawning_6_.nextFloat() * 360.0f, 0.0f);
                            p_performWorldGenSpawning_0_.spawnEntity(entityliving);
                            ientitylivingdata = entityliving.onInitialSpawn(p_performWorldGenSpawning_0_.getDifficultyForLocation(new BlockPos(entityliving)), ientitylivingdata);
                            flag = true;
                        }
                        j += p_performWorldGenSpawning_6_.nextInt(5) - p_performWorldGenSpawning_6_.nextInt(5);
                        k += p_performWorldGenSpawning_6_.nextInt(5) - p_performWorldGenSpawning_6_.nextInt(5);
                        while (j < p_performWorldGenSpawning_2_ || j >= p_performWorldGenSpawning_2_ + p_performWorldGenSpawning_4_ || k < p_performWorldGenSpawning_3_ || k >= p_performWorldGenSpawning_3_ + p_performWorldGenSpawning_4_) {
                            j = l + p_performWorldGenSpawning_6_.nextInt(5) - p_performWorldGenSpawning_6_.nextInt(5);
                            k = i1 + p_performWorldGenSpawning_6_.nextInt(5) - p_performWorldGenSpawning_6_.nextInt(5);
                        }
                    }
                }
            }
        }
    }
}

