/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WorldProvider {
    public static final float[] MOON_PHASE_FACTORS = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    protected World world;
    private WorldType terrainType;
    private String generatorSettings;
    protected BiomeProvider biomeProvider;
    protected boolean doesWaterVaporize;
    protected boolean hasNoSky;
    protected boolean hasSkyLight;
    protected final float[] lightBrightnessTable = new float[16];
    private final float[] colorsSunriseSunset = new float[4];
    private IRenderHandler skyRenderer = null;
    private IRenderHandler cloudRenderer = null;
    private IRenderHandler weatherRenderer = null;
    private int dimensionId;

    public final void setWorld(World p_setWorld_1_) {
        this.world = p_setWorld_1_;
        this.terrainType = p_setWorld_1_.getWorldInfo().getTerrainType();
        this.generatorSettings = p_setWorld_1_.getWorldInfo().getGeneratorOptions();
        this.init();
        this.generateLightBrightnessTable();
    }

    protected void generateLightBrightnessTable() {
        float f = 0.0f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.lightBrightnessTable[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * 1.0f + 0.0f;
        }
    }

    protected void init() {
        this.hasSkyLight = true;
        this.biomeProvider = this.terrainType.getBiomeProvider(this.world);
    }

    public IChunkGenerator createChunkGenerator() {
        return this.terrainType.getChunkGenerator(this.world, this.generatorSettings);
    }

    public boolean canCoordinateBeSpawn(int p_canCoordinateBeSpawn_1_, int p_canCoordinateBeSpawn_2_) {
        BlockPos blockpos = new BlockPos(p_canCoordinateBeSpawn_1_, 0, p_canCoordinateBeSpawn_2_);
        return this.world.getBiome(blockpos).ignorePlayerSpawnSuitability() ? true : this.world.getGroundAboveSeaLevel(blockpos).getBlock() == Blocks.GRASS;
    }

    public float calculateCelestialAngle(long p_calculateCelestialAngle_1_, float p_calculateCelestialAngle_3_) {
        int i = (int)(p_calculateCelestialAngle_1_ % 24000L);
        float f = ((float)i + p_calculateCelestialAngle_3_) / 24000.0f - 0.25f;
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f += (f1 - f) / 3.0f;
        return f;
    }

    public int getMoonPhase(long p_getMoonPhase_1_) {
        return (int)(p_getMoonPhase_1_ / 24000L % 8L + 8L) % 8;
    }

    public boolean isSurfaceWorld() {
        return true;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public float[] calcSunriseSunsetColors(float p_calcSunriseSunsetColors_1_, float p_calcSunriseSunsetColors_2_) {
        float f = 0.4f;
        float f1 = MathHelper.cos(p_calcSunriseSunsetColors_1_ * ((float)Math.PI * 2)) - 0.0f;
        float f2 = -0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - MathHelper.sin(f3 * (float)Math.PI)) * 0.99f;
            f4 *= f4;
            this.colorsSunriseSunset[0] = f3 * 0.3f + 0.7f;
            this.colorsSunriseSunset[1] = f3 * f3 * 0.7f + 0.2f;
            this.colorsSunriseSunset[2] = f3 * f3 * 0.0f + 0.2f;
            this.colorsSunriseSunset[3] = f4;
            return this.colorsSunriseSunset;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(float p_getFogColor_1_, float p_getFogColor_2_) {
        float f = MathHelper.cos(p_getFogColor_1_ * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        f = MathHelper.clamp(f, 0.0f, 1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d(f1 *= f * 0.94f + 0.06f, f2 *= f * 0.94f + 0.06f, f3 *= f * 0.91f + 0.09f);
    }

    public boolean canRespawnHere() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCloudHeight() {
        return this.terrainType.getCloudHeight();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSkyColored() {
        return true;
    }

    @Nullable
    public BlockPos getSpawnCoordinate() {
        return null;
    }

    public int getAverageGroundLevel() {
        return this.terrainType.getMinimumSpawnHeight(this.world);
    }

    @SideOnly(value=Side.CLIENT)
    public double getVoidFogYFactor() {
        return this.terrainType.voidFadeMagnitude();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesXZShowFog(int p_doesXZShowFog_1_, int p_doesXZShowFog_2_) {
        return false;
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public boolean doesWaterVaporize() {
        return this.doesWaterVaporize;
    }

    public boolean hasSkyLight() {
        return this.hasSkyLight;
    }

    public boolean hasNoSky() {
        return this.hasNoSky;
    }

    public float[] getLightBrightnessTable() {
        return this.lightBrightnessTable;
    }

    public WorldBorder createWorldBorder() {
        return new WorldBorder();
    }

    public void setDimension(int p_setDimension_1_) {
        this.dimensionId = p_setDimension_1_;
    }

    public int getDimension() {
        return this.dimensionId;
    }

    public String getSaveFolder() {
        return this.dimensionId == 0 ? null : "DIM" + this.dimensionId;
    }

    public String getWelcomeMessage() {
        if (this instanceof WorldProviderEnd) {
            return "Entering the End";
        }
        if (this instanceof WorldProviderHell) {
            return "Entering the Nether";
        }
        return null;
    }

    public String getDepartMessage() {
        if (this instanceof WorldProviderEnd) {
            return "Leaving the End";
        }
        if (this instanceof WorldProviderHell) {
            return "Leaving the Nether";
        }
        return null;
    }

    public double getMovementFactor() {
        if (this instanceof WorldProviderHell) {
            return 8.0;
        }
        return 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return this.skyRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSkyRenderer(IRenderHandler p_setSkyRenderer_1_) {
        this.skyRenderer = p_setSkyRenderer_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        return this.cloudRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public void setCloudRenderer(IRenderHandler p_setCloudRenderer_1_) {
        this.cloudRenderer = p_setCloudRenderer_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        return this.weatherRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public void setWeatherRenderer(IRenderHandler p_setWeatherRenderer_1_) {
        this.weatherRenderer = p_setWeatherRenderer_1_;
    }

    public BlockPos getRandomizedSpawnPoint() {
        BlockPos ret = this.world.getSpawnPoint();
        boolean isAdventure = this.world.getWorldInfo().getGameType() == GameType.ADVENTURE;
        int spawnFuzz = this.world instanceof WorldServer ? this.terrainType.getSpawnFuzz((WorldServer)this.world, this.world.getMinecraftServer()) : 1;
        int border = MathHelper.floor(this.world.getWorldBorder().getClosestDistance(ret.getX(), ret.getZ()));
        if (border < spawnFuzz) {
            spawnFuzz = border;
        }
        if (!this.hasNoSky() && !isAdventure && spawnFuzz != 0) {
            if (spawnFuzz < 2) {
                spawnFuzz = 2;
            }
            int spawnFuzzHalf = spawnFuzz / 2;
            ret = this.world.getTopSolidOrLiquidBlock(ret.add(this.world.rand.nextInt(spawnFuzzHalf) - spawnFuzz, 0, this.world.rand.nextInt(spawnFuzzHalf) - spawnFuzz));
        }
        return ret;
    }

    public boolean shouldMapSpin(String p_shouldMapSpin_1_, double p_shouldMapSpin_2_, double p_shouldMapSpin_4_, double p_shouldMapSpin_6_) {
        return this.dimensionId < 0;
    }

    public int getRespawnDimension(EntityPlayerMP p_getRespawnDimension_1_) {
        return 0;
    }

    public ICapabilityProvider initCapabilities() {
        return null;
    }

    public Biome getBiomeForCoords(BlockPos p_getBiomeForCoords_1_) {
        return this.world.getBiomeForCoordsBody(p_getBiomeForCoords_1_);
    }

    public boolean isDaytime() {
        return this.world.getSkylightSubtracted() < 4;
    }

    public float getSunBrightnessFactor(float p_getSunBrightnessFactor_1_) {
        return this.world.getSunBrightnessFactor(p_getSunBrightnessFactor_1_);
    }

    public float getCurrentMoonPhaseFactor() {
        return this.world.getCurrentMoonPhaseFactorBody();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity p_getSkyColor_1_, float p_getSkyColor_2_) {
        return this.world.getSkyColorBody(p_getSkyColor_1_, p_getSkyColor_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColor(float p_getCloudColor_1_) {
        return this.world.getCloudColorBody(p_getCloudColor_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float p_getSunBrightness_1_) {
        return this.world.getSunBrightnessBody(p_getSunBrightness_1_);
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float p_getStarBrightness_1_) {
        return this.world.getStarBrightnessBody(p_getStarBrightness_1_);
    }

    public void setAllowedSpawnTypes(boolean p_setAllowedSpawnTypes_1_, boolean p_setAllowedSpawnTypes_2_) {
        this.world.spawnHostileMobs = p_setAllowedSpawnTypes_1_;
        this.world.spawnPeacefulMobs = p_setAllowedSpawnTypes_2_;
    }

    public void calculateInitialWeather() {
        this.world.calculateInitialWeatherBody();
    }

    public void updateWeather() {
        this.world.updateWeatherBody();
    }

    public boolean canBlockFreeze(BlockPos p_canBlockFreeze_1_, boolean p_canBlockFreeze_2_) {
        return this.world.canBlockFreezeBody(p_canBlockFreeze_1_, p_canBlockFreeze_2_);
    }

    public boolean canSnowAt(BlockPos p_canSnowAt_1_, boolean p_canSnowAt_2_) {
        return this.world.canSnowAtBody(p_canSnowAt_1_, p_canSnowAt_2_);
    }

    public void setWorldTime(long p_setWorldTime_1_) {
        this.world.worldInfo.setWorldTime(p_setWorldTime_1_);
    }

    public long getSeed() {
        return this.world.worldInfo.getSeed();
    }

    public long getWorldTime() {
        return this.world.worldInfo.getWorldTime();
    }

    public BlockPos getSpawnPoint() {
        WorldInfo info = this.world.worldInfo;
        return new BlockPos(info.getSpawnX(), info.getSpawnY(), info.getSpawnZ());
    }

    public void setSpawnPoint(BlockPos p_setSpawnPoint_1_) {
        this.world.worldInfo.setSpawn(p_setSpawnPoint_1_);
    }

    public boolean canMineBlock(EntityPlayer p_canMineBlock_1_, BlockPos p_canMineBlock_2_) {
        return this.world.canMineBlockBody(p_canMineBlock_1_, p_canMineBlock_2_);
    }

    public boolean isBlockHighHumidity(BlockPos p_isBlockHighHumidity_1_) {
        return this.world.getBiome(p_isBlockHighHumidity_1_).isHighHumidity();
    }

    public int getHeight() {
        return 256;
    }

    public int getActualHeight() {
        return this.hasNoSky ? 128 : 256;
    }

    public double getHorizon() {
        return this.world.worldInfo.getTerrainType().getHorizon(this.world);
    }

    public void resetRainAndThunder() {
        this.world.worldInfo.setRainTime(0);
        this.world.worldInfo.setRaining(false);
        this.world.worldInfo.setThunderTime(0);
        this.world.worldInfo.setThundering(false);
    }

    public boolean canDoLightning(Chunk p_canDoLightning_1_) {
        return true;
    }

    public boolean canDoRainSnowIce(Chunk p_canDoRainSnowIce_1_) {
        return true;
    }

    public void onPlayerAdded(EntityPlayerMP p_onPlayerAdded_1_) {
    }

    public void onPlayerRemoved(EntityPlayerMP p_onPlayerRemoved_1_) {
    }

    public abstract DimensionType getDimensionType();

    public void onWorldSave() {
    }

    public void onWorldUpdateEntities() {
    }

    public boolean canDropChunk(int p_canDropChunk_1_, int p_canDropChunk_2_) {
        return true;
    }
}

