/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderEnd
extends WorldProvider {
    private DragonFightManager dragonFightManager;

    @Override
    public void init() {
        this.biomeProvider = new BiomeProviderSingle(Biomes.SKY);
        NBTTagCompound lvt_1_1_ = this.world.getWorldInfo().getDimensionData(DimensionType.THE_END);
        this.dragonFightManager = this.world instanceof WorldServer ? new DragonFightManager((WorldServer)this.world, lvt_1_1_.getCompoundTag("DragonFight")) : null;
    }

    @Override
    public IChunkGenerator createChunkGenerator() {
        return new ChunkProviderEnd(this.world, this.world.getWorldInfo().isMapFeaturesEnabled(), this.world.getSeed(), this.getSpawnCoordinate());
    }

    @Override
    public float calculateCelestialAngle(long p_calculateCelestialAngle_1_, float p_calculateCelestialAngle_3_) {
        return 0.0f;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public float[] calcSunriseSunsetColors(float p_calcSunriseSunsetColors_1_, float p_calcSunriseSunsetColors_2_) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(float p_getFogColor_1_, float p_getFogColor_2_) {
        int lvt_3_1_ = 0xA080A0;
        float lvt_4_1_ = MathHelper.cos(p_getFogColor_1_ * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        lvt_4_1_ = MathHelper.clamp(lvt_4_1_, 0.0f, 1.0f);
        float lvt_5_1_ = 0.627451f;
        float lvt_6_1_ = 0.5019608f;
        float lvt_7_1_ = 0.627451f;
        return new Vec3d(lvt_5_1_ *= lvt_4_1_ * 0.0f + 0.15f, lvt_6_1_ *= lvt_4_1_ * 0.0f + 0.15f, lvt_7_1_ *= lvt_4_1_ * 0.0f + 0.15f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isSkyColored() {
        return false;
    }

    @Override
    public boolean canRespawnHere() {
        return false;
    }

    @Override
    public boolean isSurfaceWorld() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getCloudHeight() {
        return 8.0f;
    }

    @Override
    public boolean canCoordinateBeSpawn(int p_canCoordinateBeSpawn_1_, int p_canCoordinateBeSpawn_2_) {
        return this.world.getGroundAboveSeaLevel(new BlockPos(p_canCoordinateBeSpawn_1_, 0, p_canCoordinateBeSpawn_2_)).getMaterial().blocksMovement();
    }

    @Override
    public BlockPos getSpawnCoordinate() {
        return new BlockPos(100, 50, 0);
    }

    @Override
    public int getAverageGroundLevel() {
        return 50;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean doesXZShowFog(int p_doesXZShowFog_1_, int p_doesXZShowFog_2_) {
        return false;
    }

    @Override
    public DimensionType getDimensionType() {
        return DimensionType.THE_END;
    }

    @Override
    public void onWorldSave() {
        NBTTagCompound lvt_1_1_ = new NBTTagCompound();
        if (this.dragonFightManager != null) {
            lvt_1_1_.setTag("DragonFight", this.dragonFightManager.getCompound());
        }
        this.world.getWorldInfo().setDimensionData(DimensionType.THE_END, lvt_1_1_);
    }

    @Override
    public void onWorldUpdateEntities() {
        if (this.dragonFightManager != null) {
            this.dragonFightManager.tick();
        }
    }

    @Nullable
    public DragonFightManager getDragonFightManager() {
        return this.dragonFightManager;
    }
}

